/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.serverprop;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.LocalizableNamedObjectInterface;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.serverprop.Category;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.metadata.serverprop.FunctionSignature;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.util.LocalizableString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@SubjectToChange
@ThreadSafe
public class Function
implements LocalizableNamedObjectInterface {
    @SASScope
    protected static final String DOT = ".";
    private final String _serverId;
    private final String _id;
    private final String _fullID;
    private final Category _category;
    private final int _argumentCount;
    private final List<FunctionSignature> _signatures;
    private final String _syntaxToken;
    private final LocalizableString _visualDisplayName = new LocalizableString();
    private final LocalizableString _visualToolTip = new LocalizableString();
    private LocalizableString _visualDescription = new LocalizableString();
    private final boolean _distinct;
    private final boolean _isIndependentEval;
    private final IQMetadataResourceBundle _resourceBundle;
    private static final Logger _logger = LogManager.getLogger(Function.class);
    @SASScope
    protected static final String EMPTY_STRING = "";

    Function(String serverId, String id, String syntaxToken, boolean distinct, Category category, List<FunctionSignature> signatures, IQMetadataResourceBundle resourceBundle, boolean independentEval) {
        this._serverId = serverId;
        this._id = id;
        this._fullID = serverId + DOT + id;
        this._syntaxToken = syntaxToken;
        this._distinct = distinct;
        this._category = category;
        this._resourceBundle = resourceBundle;
        this._isIndependentEval = independentEval;
        this._visualDisplayName.setDefaultLocale(resourceBundle.getResourceBundle().getLocale());
        this._visualToolTip.setDefaultLocale(resourceBundle.getResourceBundle().getLocale());
        this._visualDescription.setDefaultLocale(resourceBundle.getResourceBundle().getLocale());
        this._signatures = signatures == null ? new ArrayList<FunctionSignature>(0) : new ArrayList<FunctionSignature>(signatures);
        int argC = Integer.MIN_VALUE;
        for (FunctionSignature fs : this._signatures) {
            int fsArgCount = fs.getArgumentCount();
            if (argC == Integer.MIN_VALUE) {
                argC = fsArgCount;
                continue;
            }
            if (fsArgCount == argC) continue;
            argC = -1;
        }
        this._argumentCount = argC;
    }

    @SASScope
    public Function(String id) {
        this._id = id;
        this._fullID = id;
        this._signatures = new ArrayList<FunctionSignature>();
        this._serverId = null;
        this._category = null;
        this._argumentCount = 0;
        this._syntaxToken = null;
        this._distinct = false;
        this._isIndependentEval = false;
        this._resourceBundle = null;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getSyntaxToken() {
        return this._syntaxToken;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isDistinct() {
        return this._distinct;
    }

    @SASScope
    public boolean isIndependentlyEvaluatable() {
        return this._isIndependentEval;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public Category getCategory() {
        return this._category;
    }

    @SASScope
    public String getDisplayName() {
        return this.getLabel();
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public String getLabel() {
        return this.getLabel(null);
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public String getLabel(Locale locale) {
        return this.getText(this._visualDisplayName, ".displayName.txt", locale);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getToolTip() {
        return this.getToolTip(null);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getToolTip(Locale locale) {
        return this.getText(this._visualToolTip, ".toolTip.txt", locale);
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public String getDescription() {
        return this.getDescription(null);
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public String getDescription(Locale locale) {
        return this.getText(this._visualDescription, ".description.txt", locale);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<FunctionSignature> getSignatures() {
        return new ArrayList<FunctionSignature>(this._signatures);
    }

    List<FunctionSignature> trustedGetSignatures() {
        return Collections.unmodifiableList(this._signatures);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public int getArgumentCount() {
        return this._argumentCount;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getID() {
        return this._fullID;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getNameID() {
        return this._id;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public FunctionNameID getFunctionNameID() {
        FunctionNameID fnid = FunctionNameID.get(this._id);
        return fnid;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isInCategory(Category cat) {
        return cat == this._category;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getSyntaxTemplateFor(int numberOfArguments) {
        String template = null;
        int fntArgCount = this.getArgumentCount();
        if (fntArgCount != -1) {
            if (numberOfArguments == fntArgCount && this._signatures.size() > 0) {
                FunctionSignature signature = this._signatures.get(0);
                template = signature.getDefaultSyntaxTemplate();
            } else {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Invalid argument count for function " + this.getNameID());
                }
                template = EMPTY_STRING;
            }
        } else if (fntArgCount == -1) {
            for (FunctionSignature fs : this._signatures) {
                int fsArgCount = fs.getArgumentCount();
                if (fsArgCount == numberOfArguments) {
                    template = fs.getDefaultSyntaxTemplate();
                    break;
                }
                if (fsArgCount != -1) continue;
                template = fs.resizeTemplate(template, numberOfArguments);
                break;
            }
            if (template == null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Invalid argument count for function " + this.getNameID());
                }
                template = EMPTY_STRING;
            }
        }
        return template;
    }

    public FunctionSignature getCompatibleSignature(List<? extends ExpressionInterface> args) {
        FunctionSignature outSig = null;
        if (args != null) {
            for (FunctionSignature fs : this._signatures) {
                if (!fs.isCompatibleWith(args)) continue;
                outSig = fs;
                break;
            }
        }
        return outSig;
    }

    @SASScope
    public String toString() {
        return this.getLabel();
    }

    @SASScope
    public String toString(Locale locale) {
        return this.getLabel(locale);
    }

    @SASScope
    public int hashCode() {
        int result = 167;
        result = 37 * result + (this._serverId == null ? 0 : this._serverId.hashCode());
        result = 37 * result + (this._id == null ? 0 : this._id.hashCode());
        result = 37 * result + (this._category == null ? 0 : this._category.hashCode());
        result = 37 * result + 7;
        return result;
    }

    @SASScope
    public boolean equals(Object obj) {
        Function objFunction;
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Function && IQModelImplUtilities.same((objFunction = (Function)obj).getID(), this.getID());
    }

    private String getText(LocalizableString localizableString, String key, Locale locale) {
        String text = null;
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        if (localizableString.getLocales().contains(locale)) {
            text = localizableString.getText(locale);
        } else if (this._resourceBundle != null) {
            text = this._resourceBundle.getString(this._id + key, locale);
            localizableString.setText(text, locale);
        } else {
            text = this.getID();
        }
        return text;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public LocalizableString getLabels() {
        throw new UnsupportedOperationException(IQModelImplUtilities.getMessage("LocalizableToString.LocalizableCollectionNotUnsupported.fmt.txt", this, this.getClass().getName()));
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public LocalizableString getDescriptions() {
        throw new UnsupportedOperationException(IQModelImplUtilities.getMessage("LocalizableToString.LocalizableCollectionNotUnsupported.fmt.txt", this, this.getClass().getName()));
    }
}

