/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.physical;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.resourceutil.BasicResource;
import com.sas.iquery.metadata.resourceutil.BasicResourceRelationshipUtility2;
import com.sas.iquery.metadata.resourceutil.physical.GlobalMappingChangedListener;
import com.sas.iquery.metadata.resourceutil.physical.MappingChangedEvent;
import com.sas.iquery.metadata.resourceutil.physical.MappingChangedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ReplacementMediator2 {
    BasicResourceRelationshipUtility2 _relationships = null;
    List _listenerList;
    private List _globalSyncListenerList;
    boolean _listnersEnabled = true;
    private static final Logger _logger = LogManager.getLogger(ReplacementMediator2.class);

    ReplacementMediator2(BasicResourceRelationshipUtility2 relationships) {
        this._relationships = relationships;
    }

    public abstract BasicResource getReplacementObject() throws MetadataException;

    public void addGlobalSyncListener(GlobalMappingChangedListener listener) {
        if (this._globalSyncListenerList == null) {
            this._globalSyncListenerList = new ArrayList();
        }
        if (!this._globalSyncListenerList.contains(listener)) {
            this._globalSyncListenerList.add(listener);
        }
    }

    public void removeGlobalSyncListener(GlobalMappingChangedListener listener) {
        if (this._globalSyncListenerList != null) {
            this._globalSyncListenerList.remove(listener);
        }
    }

    public void fireUpdateGlobalMappingChange() throws MetadataException {
        if (this._listnersEnabled) {
            MappingChangedEvent event = new MappingChangedEvent(this);
            if (this._globalSyncListenerList != null) {
                GlobalMappingChangedListener listener;
                int i;
                int listenerCount = this._globalSyncListenerList.size();
                for (i = 0; i < listenerCount; ++i) {
                    listener = (GlobalMappingChangedListener)this._globalSyncListenerList.get(i);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("\t\t(updateFromGlobalChange) Fired global event to child: " + listener);
                    }
                    listener.updateFromGlobalChange(event);
                }
                for (i = 0; i < listenerCount; ++i) {
                    listener = (GlobalMappingChangedListener)this._globalSyncListenerList.get(i);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("\t\t(updateLocalChildren) Fired global event to child: " + listener);
                    }
                    listener.updateLocalChildren(event);
                }
            }
            Collection logicalListeners = this._relationships.getLogicalMappingListeners();
            for (GlobalMappingChangedListener gmcListener : logicalListeners) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("\t\t(updateFromGlobalChange/updateLocalChildren) Fired global event to logical child: " + gmcListener);
                }
                gmcListener.updateFromGlobalChange(event);
                gmcListener.updateLocalChildren(event);
            }
        }
    }

    public void addMappingChangedListener(MappingChangedListener listener) {
        if (this._listenerList == null) {
            this._listenerList = new ArrayList();
        }
        if (!this._listenerList.contains(listener)) {
            this._listenerList.add(listener);
        }
    }

    public void removeMappingChangedListener(MappingChangedListener listener) {
        if (this._listenerList != null) {
            this._listenerList.remove(listener);
        }
    }

    public void fireUpdateChildMappingFromParent() throws MetadataException {
        if (this._listnersEnabled && this._listenerList != null) {
            MappingChangedEvent event = null;
            if (_logger.isDebugEnabled()) {
                _logger.debug("\t\tFired event to children: " + this._listenerList);
            }
            int listenerCount = this._listenerList.size();
            for (int i = 0; i < listenerCount; ++i) {
                if (event == null) {
                    event = new MappingChangedEvent(this);
                }
                ((MappingChangedListener)this._listenerList.get(i)).updateChildMappingFromParent(event);
            }
        }
    }

    protected void enableListeners() {
        this._listnersEnabled = true;
    }

    protected void disableListeners() {
        this._listnersEnabled = false;
    }

    public BasicResourceRelationshipUtility2 getRelationships() {
        return this._relationships;
    }
}

