/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.memberRepair.util;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.resourceutil.memberRepair.FilterType;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OLAPMemberRemovalElement {
    private Object _businessItem = null;
    private List _memberValues = new ArrayList();
    private boolean _isUnresolved = false;
    private FilterType _filterType = null;
    private BusinessModel _businessModel = null;

    protected OLAPMemberRemovalElement(List memberValues, Object businessItem, boolean isUnresolved, FilterType filterType, BusinessModel businessModel) {
        this._memberValues.addAll(memberValues);
        this._businessItem = businessItem == null ? businessModel : businessItem;
        this._isUnresolved = isUnresolved;
        this._businessModel = businessModel;
        this._filterType = filterType;
    }

    public boolean isUnresolved() {
        return this._isUnresolved;
    }

    public BusinessItem getBusinessItem() {
        if (this._businessItem == null) {
            return null;
        }
        return (BusinessItem)this._businessItem;
    }

    public String getDescription() {
        StringBuilder buffer = new StringBuilder();
        Iterator iter = this._memberValues.iterator();
        int ct = 0;
        while (iter.hasNext()) {
            Object object = iter.next();
            buffer.append((String)object);
            if (ct > 0) {
                buffer.append(",").append(MDXGenerationUtil.NEWLINE);
            }
            ++ct;
        }
        String mapName = "No Map";
        if (this._businessModel instanceof InformationMap) {
            mapName = ((InformationMap)this._businessModel).getLabel();
        } else {
            BusinessModel base = this._businessModel.getBaseModel();
            if (base instanceof InformationMap) {
                mapName = ((InformationMap)base).getLabel();
            }
        }
        String isUnresolved = "false";
        if (this.isUnresolved()) {
            isUnresolved = "true";
        }
        String id = "No id";
        id = this._businessItem == null ? this._businessModel.getIdentityString() : (this._businessItem instanceof DataSelection ? ((DataSelection)this._businessItem).getIdentityString() : ((BusinessItem)this._businessItem).getIdentityString());
        MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("OrphanedItemDescriptionRemove.fmt.txt", id, mapName, this._filterType.toString(), isUnresolved, buffer.toString());
        return formatter.toString();
    }

    public String getMembers() {
        StringBuilder buffer = new StringBuilder();
        Iterator iter = this._memberValues.iterator();
        int ct = 0;
        while (iter.hasNext()) {
            Object object = iter.next();
            buffer.append((String)object);
            if (ct > 0) {
                buffer.append(",").append(MDXGenerationUtil.NEWLINE);
            }
            ++ct;
        }
        return buffer.toString();
    }

    protected void release() {
        this._memberValues.clear();
    }
}

