/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.memberRepair.impl;

import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OrphanToolGenericInterface;
import com.sas.iquery.util.impl.MessageFormatter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ToolsUtility {
    private static ToolsUtility _instance;
    private static final String[] toolsClasses;
    private static final String[] toolsClassesMnems;
    private static final Logger _logger;
    private Map _supportedToolsList = new HashMap();

    public static ToolsUtility getInstance() {
        if (_instance == null) {
            _instance = new ToolsUtility();
        }
        return _instance;
    }

    private ToolsUtility() {
        for (int i = 0; i < toolsClasses.length; ++i) {
            this._supportedToolsList.put(toolsClassesMnems[i], toolsClasses[i]);
        }
        _instance = this;
    }

    public OrphanToolGenericInterface getRequestTool(Class tool) throws IQueryServicesException {
        return this.getToolInstance(tool);
    }

    private OrphanToolGenericInterface getToolInstance(Class toolClass) throws IQueryServicesException {
        OrphanToolGenericInterface tool = null;
        if (toolClass != null) {
            try {
                Method m = toolClass.getMethod("getInstance", new Class[0]);
                tool = (OrphanToolGenericInterface)m.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerNoTool.fmt.txt", toolClass.getName());
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage());
                }
                throw new IQueryServicesException(formatter, (Throwable)e);
            }
        }
        return tool;
    }

    static {
        toolsClasses = new String[]{"OrphanMapMembers", "OrphanReportMembers"};
        toolsClassesMnems = new String[]{"OrphanMapMembers", "OrphanReportMembers"};
        _logger = LogManager.getLogger(ToolsUtility.class);
    }
}

