/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.memberRepair.impl;

import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFirstLastPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNParallelPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.NonCalculatedValue;
import com.sas.iquery.metadata.expr.OLAPResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.metadata.impl.AbstractExpression;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerMember;
import com.sas.iquery.metadata.resourceutil.memberRepair.FilterType;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OLAPMemberRepairElement;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OrphanToolGenericInterface;
import com.sas.iquery.strategies.sas.oma.olap.step.NavigationFilter;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeFirstLastPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeNParallelPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeNPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeRangeFilter;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.TupleElement;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class OrphanToolBase
implements OrphanToolGenericInterface {
    private boolean _batchOn = false;
    private DataSourceCube _cube = null;
    private FolderInterface _folderInterface = null;
    private boolean _hasBeenAnzlyzed = false;
    private boolean _isRepairForMap = false;
    protected IdentityHashMap _orphanedElementKeys = new IdentityHashMap();
    protected BusinessModel _toRepairObject = null;
    private static final Logger _logger = LogManager.getLogger(OrphanToolBase.class);

    OrphanToolBase() {
    }

    protected void addRepairElement(Object key, Object businessObject, String memberValue, String filterId, FilterType action) throws IQueryServicesException {
        if (!this._orphanedElementKeys.containsKey(key)) {
            OLAPMemberRepairElement repairElement = new OLAPMemberRepairElement(action, filterId, memberValue, businessObject, this, this._folderInterface, this._toRepairObject);
            this._orphanedElementKeys.put(key, repairElement);
        } else if (this._orphanedElementKeys.containsKey(key)) {
            OLAPMemberRepairElement repairElement = (OLAPMemberRepairElement)this._orphanedElementKeys.get(key);
            repairElement.addMemberInfo(memberValue);
        } else {
            throw new IQueryServicesException(IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerCorruptKey.fmt.txt", filterId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeMemberStep(DataItem dataItem, DataItemMemberFilter memberFilter) throws IQueryServicesException, MetadataException {
        for (NonCalculatedValue object : memberFilter.getMemberNames()) {
            String memberValue = this.getMemberValue(dataItem, object);
            String query = this.buildMDXSetPhrase(memberValue);
            OLAPDataSet olapDataSet = null;
            try {
                olapDataSet = this.executeQuery(query);
                if (olapDataSet != null) continue;
                this.addRepairElement(memberFilter, dataItem, memberValue, dataItem.getID(), FilterType.CHILD_FILTER);
            }
            finally {
                if (olapDataSet == null) continue;
                this.releaseOLAPResource(olapDataSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyseNavigationStep(DataItem dataItem, DataItemNavigationFilter navigator) throws GenerationException, MetadataException, IQueryServicesException {
        String navName = navigator.getNavigationName();
        if (navName != null && navName.length() > 0) {
            String memberValue = this.getMemberValueInNavigationStep(dataItem, navigator);
            String query = this.buildMDXSetPhrase(memberValue);
            OLAPDataSet olapDataSet = null;
            try {
                olapDataSet = this.executeQuery(query);
                if (olapDataSet == null) {
                    this.addRepairElement(navigator, dataItem, navName, dataItem.getID(), FilterType.CHILD_FILTER);
                }
            }
            finally {
                if (olapDataSet != null) {
                    this.releaseOLAPResource(olapDataSet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyseFirstLastTimeStep(DataItem dataItem, DataItemTimeFirstLastPeriodsFilter timFil) throws GenerationException, MetadataException, IQueryServicesException {
        ExpressionInterface level = timFil.getLevel();
        if (!(level instanceof Prompt)) {
            String expression = TimeFirstLastPeriodsFilter.getMDXExpression(timFil, null);
            String query = this.buildMDXSetPhrase(expression);
            OLAPDataSet olapDataSet = null;
            try {
                olapDataSet = this.executeQuery(query);
                if (olapDataSet == null) {
                    String expressionValue = this.getMemberValueInStep(timFil, level);
                    this.addRepairElement(timFil, dataItem, expressionValue, dataItem.getID(), FilterType.CHILD_FILTER);
                }
            }
            finally {
                if (olapDataSet != null) {
                    this.releaseOLAPResource(olapDataSet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyseParellelTimeStep(DataItem dataItem, DataItemTimeNParallelPeriodsFilter timFil) throws GenerationException, MetadataException, IQueryServicesException {
        boolean ignore;
        ExpressionInterface member = timFil.getMember();
        ExpressionInterface level = timFil.getLevel();
        boolean bl = ignore = member instanceof Prompt && level instanceof Prompt;
        if (!ignore) {
            String expression = TimeNParallelPeriodsFilter.getMDXExpression(timFil, null);
            String query = this.buildMDXSetPhrase(expression);
            OLAPDataSet olapDataSet = null;
            try {
                olapDataSet = this.executeQuery(query);
                if (olapDataSet == null) {
                    if (!(member instanceof Prompt)) {
                        String memberValue = this.getMemberValueInStep(timFil, member);
                        this.addRepairElement(timFil, dataItem, memberValue, dataItem.getID(), FilterType.CHILD_FILTER);
                    }
                    if (!(level instanceof Prompt)) {
                        String expressionValue = this.getMemberValueInStep(timFil, level);
                        this.addRepairElement(timFil, dataItem, expressionValue, dataItem.getID(), FilterType.CHILD_FILTER);
                    }
                }
            }
            finally {
                if (olapDataSet != null) {
                    this.releaseOLAPResource(olapDataSet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysePeriodTimeStep(DataItem dataItem, DataItemTimeNPeriodsFilter timFil) throws GenerationException, MetadataException, IQueryServicesException {
        ExpressionInterface member = timFil.getMember();
        if (!(member instanceof Prompt)) {
            String expression = TimeNPeriodsFilter.getMDXExpression(timFil, null);
            String query = this.buildMDXSetPhrase(expression);
            OLAPDataSet olapDataSet = null;
            try {
                olapDataSet = this.executeQuery(query);
                if (olapDataSet == null) {
                    String memberValue = this.getMemberValueInStep(timFil, member);
                    this.addRepairElement(timFil, dataItem, memberValue, dataItem.getID(), FilterType.CHILD_FILTER);
                }
            }
            finally {
                if (olapDataSet != null) {
                    this.releaseOLAPResource(olapDataSet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyseTimeRangeStep(DataItem dataItem, DataItemTimeRangeFilter timeRange) throws GenerationException, MetadataException, IQueryServicesException {
        boolean ignore;
        ExpressionInterface endMember = timeRange.getEndMember();
        ExpressionInterface startMember = timeRange.getStartMember();
        ExpressionInterface level = timeRange.getLevelName();
        boolean bl = ignore = endMember instanceof Prompt && startMember instanceof Prompt && level instanceof Prompt;
        if (!ignore) {
            String expression = TimeRangeFilter.getMDXExpression(timeRange, null);
            String query = this.buildMDXSetPhrase(expression);
            OLAPDataSet olapDataSet = null;
            try {
                olapDataSet = this.executeQuery(query);
                if (olapDataSet == null) {
                    String memberValue;
                    String filterId = dataItem.getID();
                    FilterType action = FilterType.CHILD_FILTER;
                    if (!(endMember instanceof Prompt)) {
                        memberValue = this.getMemberValueInStep(timeRange, endMember);
                        this.addRepairElement(timeRange, dataItem, memberValue, filterId, action);
                    }
                    if (!(startMember instanceof Prompt)) {
                        memberValue = this.getMemberValueInStep(timeRange, startMember);
                        this.addRepairElement(timeRange, dataItem, memberValue, filterId, action);
                    }
                    if (!(level instanceof Prompt)) {
                        memberValue = this.getMemberValueInStep(timeRange, level);
                        this.addRepairElement(timeRange, dataItem, memberValue, filterId, action);
                    }
                }
            }
            finally {
                if (olapDataSet != null) {
                    this.releaseOLAPResource(olapDataSet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void analyseCustomizedDataItem(DataItem dataItem, OLAPResourceAwareStringExpression olapRase) throws GenerationException, MetadataException, IQueryServicesException {
        OLAPDataSet olapDataSet = null;
        try {
            String memberValue = this.getMemberValueInCustomizedDataItem(dataItem, olapRase);
            StructureOfDataItem structure = dataItem.getStructure();
            String setValue = null;
            setValue = !structure.equals(StructureOfDataItem.STRUCTURE_MEASURE) ? this.buildMDXSetPhrase(memberValue) : this.buildMDXMemberPhrase(memberValue);
            olapDataSet = this.executeQuery(setValue);
            if (olapDataSet == null) {
                this.addRepairElement(olapRase, dataItem, memberValue, dataItem.getID(), FilterType.CUSTOMIZED_ITEM);
            }
            if (olapDataSet == null) return;
        }
        catch (Throwable throwable) {
            if (olapDataSet == null) throw throwable;
            this.releaseOLAPResource(olapDataSet);
            throw throwable;
        }
        this.releaseOLAPResource(olapDataSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void analyseTimeMeasure(DataItem dataItem, TimeExpressionMeasure timeExpressionMeasure) throws MetadataException, IQueryServicesException {
        if (timeExpressionMeasure.getPeriod() == null) return;
        String memberValue = this.getMemberValueInTimeMeasureExpression(dataItem, timeExpressionMeasure);
        OLAPDataSet olapDataSet = null;
        try {
            String setValue = this.buildMDXMemberPhrase(memberValue);
            olapDataSet = this.executeQuery(setValue);
            if (olapDataSet == null) {
                this.addRepairElement(timeExpressionMeasure, dataItem, memberValue, dataItem.getID(), FilterType.CUSTOMIZED_ITEM);
            }
            if (olapDataSet == null) return;
        }
        catch (Throwable throwable) {
            if (olapDataSet == null) throw throwable;
            this.releaseOLAPResource(olapDataSet);
            throw throwable;
        }
        this.releaseOLAPResource(olapDataSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyseMemberFilterExpression(FilterItem filterItem, MemberFilterExpression memFil) throws IQueryServicesException, MetadataException {
        ExpressionInterface whatToCompare = memFil.getWhatToCompare();
        if (whatToCompare instanceof DataItem) {
            List memberNames = memFil.getMemberNames(true);
            for (Object object : memberNames) {
                String memberValue = this.getMemberValueInFilter(filterItem, object);
                String setValue = this.buildMDXSetPhrase(memberValue);
                OLAPDataSet olapDataSet = null;
                try {
                    olapDataSet = this.executeQuery(setValue);
                    if (olapDataSet != null) continue;
                    this.addRepairElement(filterItem, filterItem, memberValue, filterItem.getID(), FilterType.PARENT_FILTER);
                }
                finally {
                    if (olapDataSet != null) {
                        this.releaseOLAPResource(olapDataSet);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyseFirstLastTimeExpression(FilterItem filterItem, TimeFilterFirstLastPeriodsExpression timFil) throws GenerationException, MetadataException, IQueryServicesException {
        ExpressionInterface level;
        ExpressionInterface whatToCompare = timFil.getWhatToCompare();
        if (whatToCompare instanceof DataItem && !((level = timFil.getLevel()) instanceof Prompt)) {
            String expression = TimeFirstLastPeriodsFilter.getMDXExpression(timFil, null);
            String setValue = this.buildMDXSetPhrase(expression);
            String memberValue = this.getMemberValueInFilterExpression(filterItem, level);
            OLAPDataSet olapDataSet = null;
            try {
                olapDataSet = this.executeQuery(setValue);
                if (olapDataSet == null) {
                    this.addRepairElement(filterItem, filterItem, memberValue, filterItem.getID(), FilterType.PARENT_FILTER);
                }
            }
            finally {
                if (olapDataSet != null) {
                    this.releaseOLAPResource(olapDataSet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyseParellelTimeExpression(FilterItem filterItem, TimeFilterNParallelPeriodsExpression timFil) throws GenerationException, MetadataException, IQueryServicesException {
        ExpressionInterface whatToCompare = timFil.getWhatToCompare();
        if (whatToCompare instanceof DataItem) {
            boolean ignore;
            ExpressionInterface date = timFil.getDate();
            ExpressionInterface level = timFil.getLevel();
            boolean bl = ignore = date instanceof Prompt && level instanceof Prompt;
            if (!ignore) {
                String expression = TimeNParallelPeriodsFilter.getMDXExpression(timFil, null);
                String setValue = this.buildMDXSetPhrase(expression);
                OLAPDataSet olapDataSet = null;
                try {
                    olapDataSet = this.executeQuery(setValue);
                    if (olapDataSet == null) {
                        String memberValue;
                        if (!(date instanceof Prompt)) {
                            memberValue = this.getMemberValueInFilterExpression(filterItem, date);
                            this.addRepairElement(filterItem, filterItem, memberValue, filterItem.getID(), FilterType.PARENT_FILTER);
                        }
                        if (!(level instanceof Prompt)) {
                            memberValue = this.getMemberValueInFilterExpression(filterItem, level);
                            this.addRepairElement(filterItem, filterItem, memberValue, filterItem.getID(), FilterType.PARENT_FILTER);
                        }
                    }
                }
                finally {
                    if (olapDataSet != null) {
                        this.releaseOLAPResource(olapDataSet);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysePeriodTimeExpression(FilterItem filterItem, TimeFilterNPeriodsExpression timFil) throws GenerationException, MetadataException, IQueryServicesException {
        ExpressionInterface date;
        ExpressionInterface whatToCompare = timFil.getWhatToCompare();
        if (whatToCompare instanceof DataItem && !((date = timFil.getDate()) instanceof Prompt)) {
            String expression = TimeNPeriodsFilter.getMDXExpression(timFil, null);
            String setValue = this.buildMDXSetPhrase(expression);
            OLAPDataSet olapDataSet = null;
            try {
                olapDataSet = this.executeQuery(setValue);
                if (olapDataSet == null) {
                    String memberValue = this.getMemberValueInFilterExpression(filterItem, date);
                    this.addRepairElement(filterItem, filterItem, memberValue, filterItem.getID(), FilterType.PARENT_FILTER);
                }
            }
            finally {
                if (olapDataSet != null) {
                    this.releaseOLAPResource(olapDataSet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyseTimeRangeExpression(FilterItem filterItem, TimeRangeFilterExpression timFil) throws GenerationException, MetadataException, IQueryServicesException {
        ExpressionInterface whatToCompare = timFil.getWhatToCompare();
        if (whatToCompare instanceof DataItem) {
            boolean ignore;
            ExpressionInterface endMember = timFil.getEndMember();
            ExpressionInterface startMember = timFil.getStartMember();
            ExpressionInterface level = timFil.getLevelName();
            boolean bl = ignore = endMember instanceof Prompt && startMember instanceof Prompt && level instanceof Prompt;
            if (!ignore) {
                String expression = TimeRangeFilter.getMDXExpression(timFil, null);
                String setValue = this.buildMDXSetPhrase(expression);
                OLAPDataSet olapDataSet = null;
                try {
                    olapDataSet = this.executeQuery(setValue);
                    if (olapDataSet == null) {
                        String memberValue;
                        if (!(endMember instanceof Prompt)) {
                            memberValue = this.getMemberValueInFilterExpression(filterItem, endMember);
                            this.addRepairElement(filterItem, filterItem, memberValue, filterItem.getID(), FilterType.PARENT_FILTER);
                        }
                        if (!(startMember instanceof Prompt)) {
                            memberValue = this.getMemberValueInFilterExpression(filterItem, startMember);
                            this.addRepairElement(filterItem, filterItem, memberValue, filterItem.getID(), FilterType.PARENT_FILTER);
                        }
                        if (!(level instanceof Prompt)) {
                            memberValue = this.getMemberValueInFilterExpression(filterItem, level);
                            this.addRepairElement(filterItem, filterItem, memberValue, filterItem.getID(), FilterType.PARENT_FILTER);
                        }
                    }
                }
                finally {
                    if (olapDataSet != null) {
                        this.releaseOLAPResource(olapDataSet);
                    }
                }
            }
        }
    }

    public void analyze(BusinessModel model) throws IQueryServicesException {
        if (!model.getStructure().isOLAP()) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerOnlyOLAPNow.txt", new Object[0]);
            throw new IQueryServicesException(formatter);
        }
        this._hasBeenAnzlyzed = true;
        this._toRepairObject = model;
        this._cube = OLAPConnectionInfoUtil.getCube(model);
        try {
            this.analyzeOLAP(model);
        }
        catch (RemoteException e) {
            throw new IQueryServicesException(e);
        }
        catch (OLAPException e) {
            throw new IQueryServicesException(e);
        }
    }

    private void analyzeOLAP(BusinessModel businessModel) throws IQueryServicesException, RemoteException, OLAPException {
        List<BusinessItem> businessObjects = businessModel.getObjects(0, BusinessItem.class);
        for (BusinessItem objInIter : businessObjects) {
            if (objInIter instanceof DataItem) {
                this.checkMemberDataItems((DataItem)objInIter);
                continue;
            }
            if (!(objInIter instanceof FilterItem)) continue;
            this.checkMemberFilters((FilterItem)objInIter);
        }
        this.analyzeSteps(businessModel);
        this.analyzeDataItemSorts(businessModel);
        this.analyzeSort(businessModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeSort(BusinessModel businessModel) throws IQueryServicesException {
        if (businessModel instanceof DataSelection) {
            DataSelection dataSelection = (DataSelection)businessModel;
            Role[] roles = new Role[]{Role.ROW, Role.COLUMN};
            for (int i = 0; i < roles.length; ++i) {
                Role role = roles[i];
                List<Object> sortCriteria = dataSelection.getSortCriteria(role);
                for (int count = 0; count < sortCriteria.size(); ++count) {
                    OLAPDataSet olapDataSet;
                    String memberValue;
                    Object obj = sortCriteria.get(count);
                    if (obj instanceof List) {
                        List listObj = (List)obj;
                        for (int xx = 0; xx < listObj.size(); ++xx) {
                            Object objectInList = listObj.get(xx);
                            if (!(objectInList instanceof String)) continue;
                            memberValue = this.getMemberValue((String)objectInList);
                            olapDataSet = null;
                            try {
                                olapDataSet = this.executeQuery(memberValue);
                                if (olapDataSet != null) continue;
                                this.addRepairElement(businessModel, businessModel, memberValue, businessModel.getID(), FilterType.SORT_ITEM);
                                continue;
                            }
                            finally {
                                if (olapDataSet != null) {
                                    this.releaseOLAPResource(olapDataSet);
                                }
                            }
                        }
                    }
                    if (!(obj instanceof String[])) continue;
                    String[] members = (String[])sortCriteria.get(i);
                    for (int x = 0; x < members.length; ++x) {
                        String ob = members[x];
                        if (!(ob instanceof String)) continue;
                        memberValue = this.getMemberValue(ob);
                        olapDataSet = null;
                        try {
                            olapDataSet = this.executeQuery(memberValue);
                            if (olapDataSet != null) continue;
                            this.addRepairElement(businessModel, businessModel, memberValue, businessModel.getID(), FilterType.SORT_ITEM);
                            continue;
                        }
                        finally {
                            if (olapDataSet != null) {
                                this.releaseOLAPResource(olapDataSet);
                            }
                        }
                    }
                }
            }
        }
    }

    protected void analyzeSteps(BusinessModel businessModel) throws IQueryServicesException {
        List<DataItem> dataItems = businessModel.getObjects(65535, DataItem.class);
        for (DataItem dataItem : dataItems) {
            if (dataItem.isUnresolved()) continue;
            for (StepInterface step : dataItem.getSteps()) {
                if (step instanceof DataItemMemberFilter) {
                    this.analyzeMemberStep(dataItem, (DataItemMemberFilter)step);
                    continue;
                }
                if (step instanceof DataItemNavigationFilter) {
                    this.analyseNavigationStep(dataItem, (DataItemNavigationFilter)step);
                    continue;
                }
                if (step instanceof DataItemTimeRangeFilter) {
                    this.analyseTimeRangeStep(dataItem, (DataItemTimeRangeFilter)step);
                    continue;
                }
                if (step instanceof DataItemTimeNPeriodsFilter) {
                    this.analysePeriodTimeStep(dataItem, (DataItemTimeNPeriodsFilter)step);
                    continue;
                }
                if (step instanceof DataItemTimeNParallelPeriodsFilter) {
                    this.analyseParellelTimeStep(dataItem, (DataItemTimeNParallelPeriodsFilter)step);
                    continue;
                }
                if (!(step instanceof DataItemTimeFirstLastPeriodsFilter)) continue;
                this.analyseFirstLastTimeStep(dataItem, (DataItemTimeFirstLastPeriodsFilter)step);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeDataItemSorts(BusinessModel businessModel) throws IQueryServicesException {
        List<DataItem> dataItems = businessModel.getObjects(65535, DataItem.class);
        for (DataItem dataItem : dataItems) {
            if (dataItem.isUnresolved()) continue;
            for (String[] sortObject : dataItem.getSortCriteria()) {
                if (!(sortObject instanceof String[])) continue;
                String[] memberNames = sortObject;
                int end4 = memberNames.length;
                for (int i = 0; i < end4; ++i) {
                    String memberValue = this.getMemberValue(dataItem, memberNames[i]);
                    OLAPDataSet olapDataSet = null;
                    try {
                        olapDataSet = this.executeQuery(memberValue);
                        if (olapDataSet != null) continue;
                        this.addRepairElement(dataItem, dataItem, memberValue, dataItem.getID(), FilterType.SORT_ITEM);
                        continue;
                    }
                    finally {
                        if (olapDataSet != null) {
                            this.releaseOLAPResource(olapDataSet);
                        }
                    }
                }
            }
        }
    }

    protected String buildSetQuery(String exprText, String cubeName, boolean members) throws GenerationException {
        StringBuilder mdx = new StringBuilder();
        mdx.append(" Select ");
        if (members) {
            mdx.append("{" + exprText + ".MEMBERS}");
        } else {
            mdx.append("{" + exprText + "}");
        }
        mdx.append(" on columns From ").append("[" + cubeName + "]");
        return mdx.toString();
    }

    protected void checkMemberDataItems(DataItem dataItem) throws GenerationException, MetadataException, IQueryServicesException {
        if (!dataItem.isUnresolved()) {
            ExpressionInterface expression = dataItem.getExpression();
            if (expression instanceof OLAPResourceAwareStringExpression) {
                this.analyseCustomizedDataItem(dataItem, (OLAPResourceAwareStringExpression)expression);
            } else if (expression instanceof TimeExpressionMeasure) {
                this.analyseTimeMeasure(dataItem, (TimeExpressionMeasure)expression);
            }
        }
    }

    protected void checkMemberFilters(FilterItem filterItem) throws IQueryServicesException {
        if (!filterItem.isUnresolved()) {
            ExpressionInterface exp = filterItem.getExpression();
            if (exp instanceof MemberFilterExpression) {
                this.analyseMemberFilterExpression(filterItem, (MemberFilterExpression)exp);
            } else if (exp instanceof TimeRangeFilterExpression) {
                this.analyseTimeRangeExpression(filterItem, (TimeRangeFilterExpression)exp);
            } else if (exp instanceof TimeFilterNParallelPeriodsExpression) {
                this.analyseParellelTimeExpression(filterItem, (TimeFilterNParallelPeriodsExpression)exp);
            } else if (exp instanceof TimeFilterNPeriodsExpression) {
                this.analysePeriodTimeExpression(filterItem, (TimeFilterNPeriodsExpression)exp);
            } else if (exp instanceof TimeFilterFirstLastPeriodsExpression) {
                this.analyseFirstLastTimeExpression(filterItem, (TimeFilterFirstLastPeriodsExpression)exp);
            }
        }
    }

    protected void clearResolvedItems() {
        for (Object key : this._orphanedElementKeys.keySet()) {
            OLAPMemberRepairElement repairElement;
            Object value = this._orphanedElementKeys.get(key);
            if (!(value instanceof OLAPMemberRepairElement) || !(repairElement = (OLAPMemberRepairElement)value).isResolved()) continue;
            repairElement.dispose();
            this._orphanedElementKeys.remove(key);
        }
    }

    protected List createTupleReturnList(OLAPDataSet olapDS) throws IQueryServicesException {
        ArrayList<TupleElement> returnList = new ArrayList<TupleElement>();
        if (olapDS != null) {
            try {
                ResultSetMetadataInterface rs = olapDS.getResultSetMetadata();
                TupleInterface[] tuples = rs.getTuples(0, 0, -1);
                for (int i = 0; i < tuples.length; ++i) {
                    TupleElementInterface[] tupleElement = tuples[i].getElements(0, 1);
                    TupleElement emTupleElement = new TupleElement();
                    emTupleElement.setChildCount(tupleElement[0].getChildCount());
                    emTupleElement.setContinued(tupleElement[0].isContinued());
                    emTupleElement.setDrilledDown(tupleElement[0].isDrilledDown());
                    emTupleElement.setLabel(tupleElement[0].getLabel());
                    emTupleElement.setLevelDepth(tupleElement[0].getLevelDepth());
                    emTupleElement.setMaximumCoordinate(tupleElement[0].getMaximumCoordinate());
                    emTupleElement.setMinimumCoordinate(tupleElement[0].getMinimumCoordinate());
                    emTupleElement.setName(tupleElement[0].getName());
                    emTupleElement.setProperties(tupleElement[0].getProperties());
                    emTupleElement.setUniqueLevelName(tupleElement[0].getUniqueLevelName());
                    returnList.add(emTupleElement);
                }
            }
            catch (OLAPException oe) {
                throw new IQueryServicesException(oe);
            }
        }
        return returnList;
    }

    protected OLAPDataSet executeQuery(String query) throws IQueryServicesException {
        OLAPDataSet olapDataSet;
        block2: {
            olapDataSet = null;
            try {
                olapDataSet = OLAPConnectionInfoUtil.executeQuery(this._toRepairObject, query);
            }
            catch (IQueryServicesException e) {
                Throwable t = e.getCause();
                if (!(t instanceof OLAPException) || !_logger.isDebugEnabled()) break block2;
                _logger.debug("Query generated from the check of the member string " + query + " " + t.getLocalizedMessage(), t);
            }
        }
        return olapDataSet;
    }

    protected Object fixDateOrLevelExpression(ExpressionInterface expressionDateLevel, OLAPMemberRepairElement repairElement, Object timeFilter) throws IQueryServicesException {
        AbstractExpression returnObject = null;
        if (expressionDateLevel instanceof ConstantExpression) {
            Object newValue;
            String date = ((ConstantExpression)expressionDateLevel).getValue();
            if (repairElement.isMemberValueResolved(date) && !(newValue = repairElement.getResolvedValue(date)).equals("##REMOVE#")) {
                ConstantExpression dateExpression = new ConstantExpression();
                dateExpression.setValue((String)newValue);
                returnObject = dateExpression;
            }
        } else if (expressionDateLevel instanceof StringExpression) {
            Object newValue;
            String date = ((StringExpression)expressionDateLevel).getText();
            if (repairElement.isMemberValueResolved(date) && !(newValue = repairElement.getResolvedValue(date)).equals("##REMOVE#")) {
                StringExpression dateExpression = new StringExpression();
                dateExpression.setText((String)newValue);
                returnObject = dateExpression;
            }
        } else {
            new IQueryServicesException("Date expression is not a string or constant. " + expressionDateLevel.getClass().getSimpleName());
        }
        return returnObject;
    }

    private Object fixDateOrLevelPartOfStep(ExpressionInterface expressionDataLevel, OLAPMemberRepairElement repairElement) throws MetadataException {
        AbstractExpression returnObject = null;
        if (expressionDataLevel instanceof ConstantExpression) {
            Object newValue;
            String date = ((ConstantExpression)expressionDataLevel).getValue();
            if (repairElement.isMemberValueResolved(date) && !(newValue = repairElement.getResolvedValue(date)).equals("##REMOVE#")) {
                ConstantExpression dateExpression = new ConstantExpression();
                dateExpression.setValue((String)newValue);
                returnObject = dateExpression;
            }
        } else if (expressionDataLevel instanceof StringExpression) {
            Object newValue;
            String date = ((StringExpression)expressionDataLevel).getText();
            if (repairElement.isMemberValueResolved(date) && !(newValue = repairElement.getResolvedValue(date)).equals("##REMOVE#")) {
                StringExpression dateExpression = new StringExpression();
                dateExpression.setText((String)newValue);
                returnObject = dateExpression;
            }
        } else if (_logger.isEnabled(Level.ERROR)) {
            _logger.error("Expression can not be fixed: " + repairElement.getType().toString() + expressionDataLevel.toString());
        }
        return returnObject;
    }

    protected boolean fixFilterExpression(ExpressionInterface filterExpression, OLAPMemberRepairElement repairElement) throws IQueryServicesException {
        boolean returnValue = false;
        if (filterExpression instanceof MemberFilterExpression) {
            MemberFilterExpression memberFilter = (MemberFilterExpression)filterExpression;
            List<ExpressionInterface> memberList = memberFilter.getMemberNames();
            ArrayList<Object> newMemberList = new ArrayList<Object>();
            for (ExpressionInterface oldValue : memberList) {
                Object newValue;
                String valueOld = null;
                valueOld = oldValue instanceof String ? (String)((Object)oldValue) : (oldValue instanceof StringExpression ? ((StringExpression)oldValue).getText() : (oldValue instanceof ConstantExpression ? ((ConstantExpression)oldValue).getValue() : oldValue.toString()));
                if (oldValue == null) continue;
                if (!repairElement.isMemberOrphaned(valueOld)) {
                    newMemberList.add(valueOld);
                    continue;
                }
                if (!repairElement.isMemberValueResolved(valueOld) || (newValue = repairElement.getResolvedValue(oldValue)).equals("##REMOVE#")) continue;
                if (newValue instanceof String) {
                    StringExpression memberExpression = new StringExpression();
                    memberExpression.setText((String)newValue);
                    memberExpression.setExpressionType(3);
                    newValue = memberExpression;
                }
                newMemberList.add(newValue);
            }
            if (newMemberList.isEmpty()) {
                returnValue = true;
            } else {
                memberFilter.setMemberNames(newMemberList);
            }
        } else if (filterExpression instanceof TimeRangeFilterExpression) {
            TimeRangeFilterExpression timeFilter = (TimeRangeFilterExpression)filterExpression;
            ExpressionInterface oldStartDate = timeFilter.getStartMember();
            ExpressionInterface oldEndDate = timeFilter.getEndMember();
            ExpressionInterface oldLevel = timeFilter.getLevelName();
            try {
                timeFilter.setStartMember((ExpressionInterface)this.fixDateOrLevelExpression(oldStartDate, repairElement, timeFilter));
                timeFilter.setEndMember((ExpressionInterface)this.fixDateOrLevelExpression(oldEndDate, repairElement, timeFilter));
                timeFilter.setLevelName((ExpressionInterface)this.fixDateOrLevelExpression(oldLevel, repairElement, timeFilter));
            }
            catch (IllegalArgumentException e) {
                returnValue = true;
            }
        } else if (filterExpression instanceof TimeFilterNParallelPeriodsExpression) {
            TimeFilterNParallelPeriodsExpression timeFilter = (TimeFilterNParallelPeriodsExpression)filterExpression;
            ExpressionInterface oldDate = timeFilter.getDate();
            ExpressionInterface oldLevel = timeFilter.getLevel();
            try {
                timeFilter.setDate((ExpressionInterface)this.fixDateOrLevelExpression(oldDate, repairElement, timeFilter));
                timeFilter.setLevel((ExpressionInterface)this.fixDateOrLevelExpression(oldLevel, repairElement, timeFilter));
            }
            catch (IllegalArgumentException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage());
                }
                returnValue = true;
            }
        } else if (filterExpression instanceof TimeFilterNPeriodsExpression) {
            TimeFilterNPeriodsExpression timeFilter = (TimeFilterNPeriodsExpression)filterExpression;
            ExpressionInterface oldDate = timeFilter.getDate();
            try {
                timeFilter.setDate((ExpressionInterface)this.fixDateOrLevelExpression(oldDate, repairElement, timeFilter));
            }
            catch (IllegalArgumentException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage());
                }
                returnValue = true;
            }
        } else if (filterExpression instanceof TimeFilterFirstLastPeriodsExpression) {
            TimeFilterFirstLastPeriodsExpression timeFilter = (TimeFilterFirstLastPeriodsExpression)filterExpression;
            ExpressionInterface oldLevel = timeFilter.getLevel();
            try {
                timeFilter.setLevel((ExpressionInterface)this.fixDateOrLevelExpression(oldLevel, repairElement, timeFilter));
            }
            catch (IllegalArgumentException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage());
                }
                returnValue = true;
            }
        } else if (_logger.isEnabled(Level.ERROR)) {
            _logger.error("Filter expression does not match criteria " + filterExpression.toString());
        }
        return returnValue;
    }

    protected String buildMDXMemberPhrase(String memberNamesString) throws MetadataException {
        String mdxMember = "";
        if (memberNamesString != null && memberNamesString.length() > 0) {
            String cubeName = this._cube.getCubeName();
            StringBuilder mdxExpression = new StringBuilder(100000);
            String memberName = "[Measure].[BIQTempMem]";
            mdxExpression.append("Member ").append(memberName).append(" as '").append(memberNamesString).append("' ");
            StringBuilder mdx = new StringBuilder(1000);
            mdx.append("With ").append(mdxExpression.toString()).append(" Select ").append("{" + memberName + "}").append(" on columns From ").append("[" + cubeName + "]");
            mdxMember = mdx.toString();
            if (null == mdxMember || mdxMember.length() == 0) {
                mdxMember = null;
            }
        }
        return mdxMember;
    }

    protected String buildMDXSetPhrase(String memberNamesString) throws MetadataException {
        String mdxSet = "";
        if (memberNamesString != null && memberNamesString.length() > 0) {
            String cubeName = this._cube.getCubeName();
            mdxSet = MDXGenerationUtil.buildSetQuery("{" + memberNamesString + "}", cubeName);
            if (null == mdxSet || mdxSet.length() == 0) {
                mdxSet = null;
            }
        }
        return mdxSet;
    }

    protected String buildMDXStringFromMemberString(Object member) throws IQueryServicesException {
        String returnvalue = null;
        if (member instanceof ExpressionInterface) {
            returnvalue = MDXGenerationUtil.getExpressionValue((ExpressionInterface)member);
        } else if (member instanceof OlapServerMember) {
            OlapServerMember olapmember = (OlapServerMember)member;
            returnvalue = olapmember.getMemberUniqueName();
        } else {
            returnvalue = member instanceof String ? (String)member : member.toString();
        }
        return returnvalue;
    }

    private String getMemberValueInNavigationStep(DataItem dataItem, DataItemNavigationFilter navFil) throws GenerationException, IQueryServicesException {
        String current = MDXGenerationUtil.buildMDXOnFlyExpression(dataItem);
        String memberValue = NavigationFilter.getMDXExpression(current, navFil);
        if (memberValue == null || memberValue.length() == 0) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerMemberFilterEmptyOrNull.txt", new Object[0]);
            String navName = navFil.getNavigationName();
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error("DataItem " + dataItem.getIdentityString() + ", Navigation " + navFil.getIdentityString() + ", navName=" + navName + ": " + formatter.toString());
            }
            throw new IQueryServicesException(formatter);
        }
        return memberValue;
    }

    private String getMemberValue(String object) throws IQueryServicesException {
        String memberValue = this.buildMDXStringFromMemberString(object);
        if (memberValue == null || memberValue.length() == 0) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerMemberFilterEmptyOrNull.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error("Object=" + (object == null ? "" : "(" + object.getClass().getSimpleName() + ")") + object + ": " + formatter.toString());
            }
            throw new IQueryServicesException(formatter);
        }
        return memberValue;
    }

    private String getMemberValue(DataItem dataItem, Object object) throws IQueryServicesException {
        String memberValue = this.buildMDXStringFromMemberString(object);
        if (memberValue == null || memberValue.length() == 0) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerMemberFilterEmptyOrNull.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error("DataItem " + dataItem.getLabel() + ", object=" + (object == null ? "" : "(" + object.getClass().getSimpleName() + ")") + object + ": " + formatter.toString());
            }
            throw new IQueryServicesException(formatter);
        }
        return memberValue;
    }

    private String getMemberValueInCustomizedDataItem(DataItem dataItem, OLAPResourceAwareStringExpression expr) throws GenerationException, IQueryServicesException {
        String memberValue = MDXGenerationUtil.buildMDXOnFlyExpression(dataItem);
        if (memberValue == null || memberValue.length() == 0) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerMemberFilterEmptyOrNull.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error("DataItem " + dataItem.getLabel() + ", expr=" + (expr == null ? "" : "(" + expr.getClass().getSimpleName() + ")") + expr + ": " + formatter.toString());
            }
            throw new IQueryServicesException(formatter);
        }
        return memberValue;
    }

    private String getMemberValueInTimeMeasureExpression(DataItem dataItem, TimeExpressionMeasure expr) throws IQueryServicesException {
        String memberValue = expr.getPeriod();
        if (memberValue.length() == 0 || memberValue.length() == 0) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerMemberFilterEmptyOrNull.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error("DataItem " + dataItem.getIdentityString() + ", expr=" + (expr == null ? "" : "(" + expr.getClass().getSimpleName() + ")") + expr + ": " + formatter.toString());
            }
            throw new IQueryServicesException(formatter);
        }
        return memberValue;
    }

    private String getMemberValueInFilterExpression(FilterItem filterItem, ExpressionInterface expr) throws GenerationException, IQueryServicesException {
        String memberValue = MDXGenerationUtil.getExpressionValue(expr);
        if (memberValue == null || memberValue.length() == 0) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerMemberFilterEmptyOrNull.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error("Filter " + filterItem.getLabel() + ", expr=" + (expr == null ? "" : "(" + expr.getClass().getSimpleName() + ")") + expr + ": " + formatter.toString());
            }
            throw new IQueryServicesException(formatter);
        }
        return memberValue;
    }

    private String getMemberValueInFilter(FilterItem filterItem, Object object) throws IQueryServicesException {
        String memberValue = this.buildMDXStringFromMemberString(object);
        if (memberValue == null || memberValue.length() == 0) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerMemberFilterEmptyOrNull.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error("Filter " + filterItem.getLabel() + ", object=" + (object == null ? "" : "(" + object.getClass().getSimpleName() + ")") + object + ": " + formatter.toString());
            }
            throw new IQueryServicesException(formatter);
        }
        return memberValue;
    }

    private String getMemberValueInStep(StepInterface step, ExpressionInterface expr) throws GenerationException, IQueryServicesException {
        String expressionValue = MDXGenerationUtil.getExpressionValue(expr);
        if (expressionValue == null || expressionValue.length() == 0) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerMemberFilterEmptyOrNull.txt", new Object[0]);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error("Step " + step.toString() + ", expr=" + (expr == null ? "" : "(" + expr.getClass().getSimpleName() + ")") + expr + ": " + formatter.toString());
            }
            throw new IQueryServicesException(formatter);
        }
        return expressionValue;
    }

    public List getOrphans() {
        return ListUtils.newList(this._orphanedElementKeys.values());
    }

    protected TupleInterface[] getUniqueNameOfLastValidMember(OLAPDataSet olapDataSet, String mdx) throws IQueryServicesException {
        TupleInterface[] tuples = null;
        try {
            ResultSetMetadataInterface resultSetMeta = olapDataSet.getResultSetMetadata();
            if (resultSetMeta == null) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationUtilNoOLAPDataSet.txt", new Object[0]);
                throw new IQueryServicesException(formatter);
            }
            tuples = resultSetMeta.getTuples(0, 0, -1);
        }
        catch (OLAPException oe) {
            _logger.error(mdx);
            throw new IQueryServicesException(oe);
        }
        catch (MetadataException oe) {
            _logger.error(mdx);
            throw new IQueryServicesException(oe);
        }
        return tuples;
    }

    public boolean hasOrphans() {
        boolean returnValue = false;
        if (!this._orphanedElementKeys.values().isEmpty()) {
            returnValue = true;
        }
        return returnValue;
    }

    public boolean isBatchModeOn() {
        return this._batchOn;
    }

    protected boolean isRepairFileTypeMap() {
        return this._isRepairForMap;
    }

    public boolean isRepairNeeded() {
        boolean returnValue = false;
        for (Object obj : this._orphanedElementKeys.values()) {
            if (obj instanceof OLAPMemberRepairElement) {
                OLAPMemberRepairElement filRepair = (OLAPMemberRepairElement)obj;
                if (filRepair.isResolved()) continue;
                returnValue = true;
                continue;
            }
            if (!_logger.isEnabled(Level.ERROR)) continue;
            _logger.error("The orphaned element key is the wrong type. " + obj.getClass().getSimpleName());
        }
        return returnValue;
    }

    private void memberFilterRepair(DataItemMemberFilter memberFilter, OLAPMemberRepairElement repairElement, DataItem dataItem) throws MetadataException {
        List<StepInterface> dataItemSteps;
        List<NonCalculatedValue> memberList = memberFilter.getMemberNames();
        ArrayList<Object> newMemberList = new ArrayList<Object>();
        for (NonCalculatedValue oldValue : memberList) {
            Object newValue;
            String valueOld = null;
            valueOld = oldValue instanceof String ? (String)((Object)oldValue) : (oldValue instanceof StringExpression ? ((StringExpression)oldValue).getText() : (oldValue instanceof ConstantExpression ? ((ConstantExpression)oldValue).getValue() : oldValue.toString()));
            if (!repairElement.isMemberOrphaned(valueOld)) {
                newMemberList.add(oldValue);
                continue;
            }
            if (!repairElement.isMemberValueResolved(valueOld) || (newValue = repairElement.getResolvedValue(oldValue)).equals("##REMOVE#")) continue;
            if (newValue instanceof String) {
                StringExpression memberExpression = new StringExpression();
                memberExpression.setText((String)newValue);
                memberExpression.setExpressionType(3);
                newValue = memberExpression;
            }
            newMemberList.add(newValue);
        }
        memberFilter.setMemberNames(newMemberList);
        if (memberFilter.getMemberNames().isEmpty() && (dataItemSteps = dataItem.getSteps()).contains(memberFilter)) {
            dataItemSteps.remove(memberFilter);
            dataItem.setSteps(dataItemSteps);
        }
    }

    private void navigationFilterRepair(DataItemNavigationFilter navFilter, OLAPMemberRepairElement repairElement, DataItem dataItem) throws MetadataException {
        if (navFilter.getNavigationFilterType() == 8 || navFilter.getNavigationFilterType() == 4) {
            List<StepInterface> dataItemSteps;
            String oldNavName = navFilter.getNavigationName();
            if (repairElement.isMemberValueResolved(oldNavName)) {
                Object newValue = repairElement.getResolvedValue(oldNavName);
                if (!newValue.equals("##REMOVE#")) {
                    navFilter.setNavigationMemberName(newValue.toString());
                } else {
                    navFilter.setNavigationMemberName(null);
                }
            }
            if (navFilter.getNavigationName() == null && (dataItemSteps = dataItem.getSteps()).contains(navFilter)) {
                dataItemSteps.remove(navFilter);
                dataItem.setSteps(dataItemSteps);
            }
        }
    }

    public void release() {
        ArrayList releaseList = new ArrayList();
        Collection col = this._orphanedElementKeys.values();
        releaseList.addAll(col);
        for (OLAPMemberRepairElement memberElement : releaseList) {
            memberElement.dispose();
        }
        this._orphanedElementKeys.clear();
    }

    protected void releaseOLAPResource(OLAPDataSet olapDataSet) throws IQueryServicesException {
        try {
            olapDataSet.close();
            Object connection = olapDataSet.getConnection();
            Metadata.clearCache((Object)connection, (int)2);
        }
        catch (OLAPException e) {
            throw new IQueryServicesException(e);
        }
    }

    public void repair() throws IQueryServicesException {
        if (this._toRepairObject instanceof InformationMap) {
            BusinessModel model = this._toRepairObject;
            for (Object obj : this._orphanedElementKeys.values()) {
                OLAPMemberRepairElement repairElement = (OLAPMemberRepairElement)obj;
                BusinessModelResourceReferencer busItem = repairElement.getBusinessItem();
                if (busItem == null) {
                    busItem = repairElement.getBusinessModel();
                }
                if (repairElement.getType().equals(FilterType.CHILD_FILTER)) {
                    this.buildChildFilterRepairSteps(repairElement, busItem);
                    continue;
                }
                if (repairElement.getType().equals(FilterType.PARENT_FILTER)) {
                    this.repairParentFilter(model, repairElement, busItem);
                    continue;
                }
                if (repairElement.getType().equals(FilterType.CUSTOMIZED_ITEM)) {
                    this.repairCustomizedItem(model, repairElement, busItem);
                    continue;
                }
                if (repairElement.getType().equals(FilterType.SORT_ITEM)) {
                    this.repairSort(model, repairElement, busItem);
                    continue;
                }
                if (!_logger.isEnabled(Level.ERROR)) continue;
                _logger.error("Repair is corrupted: " + repairElement.getType().toString() + busItem.toString());
            }
        } else {
            _logger.error("Business Model is not a information map. ");
        }
    }

    public void repair(BusinessModel model) throws IQueryServicesException {
        if (!this._hasBeenAnzlyzed && this._orphanedElementKeys.values().size() == 0) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerCanRepair.txt", new Object[0]);
            throw new IQueryServicesException(formatter);
        }
        if (!this._hasBeenAnzlyzed && this._orphanedElementKeys.values().size() > 0) {
            MDXGenerationUtil.applyDebugStatement("We were still repairing what we have analyzed previously.. but now we reset the analysis flag", this.getClass());
            this._hasBeenAnzlyzed = true;
        } else {
            this._hasBeenAnzlyzed = false;
        }
        this.repair();
    }

    protected void buildChildFilterRepairSteps(OLAPMemberRepairElement repairElement, Object businessItem) throws MetadataException {
        if (businessItem instanceof DataItem) {
            DataItem dataItem = (DataItem)businessItem;
            for (StepInterface step : dataItem.getSteps()) {
                if (step instanceof DataItemMemberFilter) {
                    this.memberFilterRepair((DataItemMemberFilter)step, repairElement, dataItem);
                    continue;
                }
                if (step instanceof DataItemTimeRangeFilter) {
                    this.timeRangeFilterRepair((DataItemTimeRangeFilter)step, repairElement, dataItem);
                    continue;
                }
                if (step instanceof DataItemTimeNPeriodsFilter) {
                    this.timePeriodFilterRepair((DataItemTimeNPeriodsFilter)step, repairElement, dataItem);
                    continue;
                }
                if (step instanceof DataItemTimeNParallelPeriodsFilter) {
                    this.timeParellelFilterRepair((DataItemTimeNParallelPeriodsFilter)step, repairElement, dataItem);
                    continue;
                }
                if (step instanceof DataItemTimeFirstLastPeriodsFilter) {
                    this.timeFirstLastFilterRepair((DataItemTimeFirstLastPeriodsFilter)step, repairElement, dataItem);
                    continue;
                }
                if (!(step instanceof DataItemNavigationFilter)) continue;
                this.navigationFilterRepair((DataItemNavigationFilter)step, repairElement, dataItem);
            }
        } else if (_logger.isEnabled(Level.ERROR)) {
            _logger.error("Definition for this repair was not complete.. " + repairElement.getType().toString() + businessItem.toString());
        }
    }

    protected void repairCustomizedItem(BusinessModel model, OLAPMemberRepairElement repairElement, Object busItem) throws MetadataException {
        if (busItem instanceof DataItem) {
            TimeExpressionMeasure timeExp;
            String oldValue;
            DataItem dataItem = (DataItem)busItem;
            ExpressionInterface expression = dataItem.getExpression();
            if (expression instanceof OLAPResourceAwareStringExpression) {
                OLAPResourceAwareStringExpression rase = (OLAPResourceAwareStringExpression)expression;
                String oldValue2 = rase.getText();
                if (repairElement.isMemberValueResolved(oldValue2)) {
                    Object newValue = repairElement.getResolvedValue(oldValue2);
                    if (!newValue.equals("##REMOVE#")) {
                        rase.setUnresolved();
                    } else {
                        if (dataItem.getBusinessModel() == model) {
                            model.removeBusinessItem(dataItem);
                        }
                        if (model instanceof BusinessQuery) {
                            ((BusinessQuery)((Object)model)).removeResultItem(dataItem);
                        }
                    }
                }
            } else if (expression instanceof TimeExpressionMeasure && (oldValue = (timeExp = (TimeExpressionMeasure)expression).getPeriod()) != null && repairElement.isMemberValueResolved(oldValue)) {
                Object newValue = repairElement.getResolvedValue(oldValue);
                if (!newValue.equals("##REMOVE#")) {
                    timeExp.setUnresolved();
                } else {
                    if (dataItem.getBusinessModel() == model) {
                        model.removeBusinessItem(dataItem);
                    }
                    if (model instanceof BusinessQuery) {
                        ((BusinessQuery)((Object)model)).removeResultItem(dataItem);
                    }
                }
            }
        } else if (_logger.isEnabled(Level.ERROR)) {
            _logger.error("Repair is corrupted: " + repairElement.getType().toString() + busItem.toString());
        }
    }

    protected void repairSort(BusinessModel model, OLAPMemberRepairElement repairElement, Object busItem) throws MetadataException {
        if (busItem == null) {
            if (model instanceof DataSelection) {
                DataSelection dataSelect = (DataSelection)model;
                Role[] roles = new Role[]{Role.ROW, Role.COLUMN};
                for (int i = 0; i < roles.length; ++i) {
                    Role role = roles[i];
                    List<Object> sortCriteria = dataSelect.getSortCriteria(role);
                    sortCriteria.clear();
                    dataSelect.setSortCriteria(sortCriteria, role);
                    dataSelect.setSortDirection(BusinessQueryActionType.SORT_NONE, role);
                }
            }
        } else if (busItem instanceof DataSelection) {
            DataSelection dataSelect = (DataSelection)busItem;
            Role[] roles = new Role[]{Role.ROW, Role.COLUMN};
            for (int i = 0; i < roles.length; ++i) {
                Role role = roles[i];
                List<Object> sortCriteria = dataSelect.getSortCriteria(role);
                sortCriteria.clear();
                dataSelect.setSortCriteria(sortCriteria, role);
                dataSelect.setSortDirection(BusinessQueryActionType.SORT_NONE, role);
            }
        } else if (busItem instanceof DataItem) {
            DataItem dataItem = (DataItem)busItem;
            dataItem.getSortCriteria().clear();
            dataItem.setSortCriteria(dataItem.getSortCriteria());
            dataItem.setSortDirection(DataItemActionType.SORT_NONE);
        }
    }

    protected void repairParentFilter(BusinessModel model, OLAPMemberRepairElement repairElement, Object busItem) throws IQueryServicesException, MetadataException {
        if (busItem instanceof FilterItem) {
            FilterItem filterItem = (FilterItem)busItem;
            ExpressionInterface filterExpression = filterItem.getExpression();
            boolean isFilterEmpty = this.fixFilterExpression(filterExpression, repairElement);
            if (isFilterEmpty) {
                BusinessQuery query;
                List<FilterItem> effectiveFilters;
                if (filterItem.getBusinessModel() == model) {
                    model.removeBusinessItem(filterItem);
                }
                if (model instanceof BusinessQuery && (effectiveFilters = (query = (BusinessQuery)((Object)model)).getEffectiveFilters()).contains(filterItem)) {
                    effectiveFilters.remove(filterItem);
                    query.setFilters(effectiveFilters);
                }
            }
        } else if (_logger.isEnabled(Level.ERROR)) {
            _logger.error("Repair is corrupted: " + repairElement.getType().toString() + busItem.toString());
        }
    }

    public void setBatchModeOn(boolean batchOn) {
        this._batchOn = batchOn;
    }

    public void setFolderLocation(FolderInterface folder) {
        this._folderInterface = folder;
    }

    private void timeFirstLastFilterRepair(DataItemTimeFirstLastPeriodsFilter timeFilter, OLAPMemberRepairElement repairElement, DataItem dataItem) throws MetadataException {
        block2: {
            ExpressionInterface oldLevel = timeFilter.getLevel();
            try {
                timeFilter.setLevel((ExpressionInterface)this.fixDateOrLevelPartOfStep(oldLevel, repairElement));
            }
            catch (IllegalArgumentException e) {
                List<StepInterface> dataItemSteps = dataItem.getSteps();
                if (!dataItemSteps.contains(timeFilter)) break block2;
                dataItemSteps.remove(timeFilter);
                dataItem.setSteps(dataItemSteps);
            }
        }
    }

    private void timeParellelFilterRepair(DataItemTimeNParallelPeriodsFilter timeFilter, OLAPMemberRepairElement repairElement, DataItem dataItem) throws MetadataException {
        block2: {
            ExpressionInterface oldDate = timeFilter.getMember();
            ExpressionInterface oldLevel = timeFilter.getLevel();
            try {
                timeFilter.setMember((ExpressionInterface)this.fixDateOrLevelPartOfStep(oldDate, repairElement));
                timeFilter.setLevel((ExpressionInterface)this.fixDateOrLevelPartOfStep(oldLevel, repairElement));
            }
            catch (IllegalArgumentException e) {
                List<StepInterface> dataItemSteps = dataItem.getSteps();
                if (!dataItemSteps.contains(timeFilter)) break block2;
                dataItemSteps.remove(timeFilter);
                dataItem.setSteps(dataItemSteps);
            }
        }
    }

    private void timePeriodFilterRepair(DataItemTimeNPeriodsFilter timeFilter, OLAPMemberRepairElement repairElement, DataItem dataItem) throws MetadataException {
        block2: {
            ExpressionInterface oldDate = timeFilter.getMember();
            try {
                timeFilter.setMember((ExpressionInterface)this.fixDateOrLevelPartOfStep(oldDate, repairElement));
            }
            catch (IllegalArgumentException e) {
                List<StepInterface> dataItemSteps = dataItem.getSteps();
                if (!dataItemSteps.contains(timeFilter)) break block2;
                dataItemSteps.remove(timeFilter);
                dataItem.setSteps(dataItemSteps);
            }
        }
    }

    private void timeRangeFilterRepair(DataItemTimeRangeFilter timeFilter, OLAPMemberRepairElement repairElement, DataItem dataItem) throws MetadataException {
        block2: {
            ExpressionInterface oldStartDate = timeFilter.getStartMember();
            ExpressionInterface oldEndDate = timeFilter.getEndMember();
            ExpressionInterface oldLevel = timeFilter.getLevelName();
            try {
                timeFilter.setStartMember((ExpressionInterface)this.fixDateOrLevelPartOfStep(oldStartDate, repairElement));
                timeFilter.setEndMember((ExpressionInterface)this.fixDateOrLevelPartOfStep(oldEndDate, repairElement));
                timeFilter.setLevelName((ExpressionInterface)this.fixDateOrLevelPartOfStep(oldLevel, repairElement));
            }
            catch (IllegalArgumentException e) {
                List<StepInterface> dataItemSteps = dataItem.getSteps();
                if (!dataItemSteps.contains(timeFilter)) break block2;
                dataItemSteps.remove(timeFilter);
                dataItem.setSteps(dataItemSteps);
            }
        }
    }
}

