/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.memberRepair.impl;

import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.resourceutil.memberRepair.FilterType;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OLAPMemberRepairElement;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OrphanToolBase;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OrphanToolGenericInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OrphanReportMembers
extends OrphanToolBase {
    static OrphanToolGenericInterface _factoryInstance;
    private static final String TOOLDESCRIPTION = "OrphanedReport.tool.desc";
    private static final String TOOLMNEMONIC = "OrphReportMembers";
    private static final String TOOLNAME = "OrphanedReport.tool.name";
    private static final Logger _logger;

    public static OrphanToolGenericInterface getInstance() {
        if (_factoryInstance == null) {
            _factoryInstance = new OrphanReportMembers();
        }
        return _factoryInstance;
    }

    private OrphanReportMembers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyseDataBasedFilter(BusinessQuery businessQuery, BusinessQueryDataBasedFilter databasedFilterOnAxis, Role role) throws IQueryServicesException {
        for (ExpressionInterface objLeft : databasedFilterOnAxis.getLeftExpression()) {
            String memberValue = this.getMemberValue(businessQuery, databasedFilterOnAxis, role, (Object)objLeft);
            String query = this.buildMDXSetPhrase(memberValue);
            OLAPDataSet olapDataSet = null;
            try {
                olapDataSet = this.executeQuery(query);
                if (olapDataSet != null) continue;
                this.addRepairElement(databasedFilterOnAxis, businessQuery, memberValue, businessQuery.getID(), FilterType.CHILD_AXIS_FILTER);
            }
            finally {
                if (olapDataSet == null) continue;
                this.releaseOLAPResource(olapDataSet);
            }
        }
    }

    @Override
    public void analyze(BusinessModel businessModel) throws IQueryServicesException {
        super.analyze(businessModel);
        this.analyzeParentFilters(businessModel);
    }

    private void analyzeParentFilters(BusinessModel businessModel) throws IQueryServicesException {
        if (businessModel instanceof BusinessQuery) {
            BusinessQuery businessQuery = (BusinessQuery)((Object)businessModel);
            List<FilterItem> filters = businessQuery.getFilters();
            for (FilterItem objInIter : filters) {
                if (!(objInIter instanceof FilterItem)) continue;
                this.checkMemberFilters(objInIter);
            }
        }
        if (this.getOrphans().size() == 0) {
            MDXGenerationUtil.applyDebugStatement("No problems found during anaylsis.", this.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeRankFilter(BusinessQuery businessQuery, BusinessQueryRankFilter rankFilterAppliedToAxis, Role role) throws IQueryServicesException {
        for (Object objLeft : rankFilterAppliedToAxis.getRankQualifiers()) {
            String memberValue = this.getMemberValue(businessQuery, rankFilterAppliedToAxis, role, objLeft);
            String query = this.buildMDXSetPhrase(memberValue);
            OLAPDataSet olapDataSet = null;
            try {
                olapDataSet = this.executeQuery(query);
                if (olapDataSet != null) continue;
                this.addRepairElement(rankFilterAppliedToAxis, businessQuery, memberValue, businessQuery.getID(), FilterType.CHILD_AXIS_FILTER);
            }
            finally {
                if (olapDataSet == null) continue;
                this.releaseOLAPResource(olapDataSet);
            }
        }
    }

    @Override
    protected void analyzeSteps(BusinessModel businessModel) throws IQueryServicesException {
        super.analyzeSteps(businessModel);
        if (businessModel instanceof BusinessQuery) {
            BusinessQuery businessQuery = (BusinessQuery)((Object)businessModel);
            List<Role> roles = Arrays.asList(Role.ROW, Role.COLUMN);
            for (Role role : roles) {
                List<StepInterface> steps = businessQuery.getSteps(role);
                for (StepInterface step : steps) {
                    if (step instanceof BusinessQueryDataBasedFilter) {
                        this.analyseDataBasedFilter(businessQuery, (BusinessQueryDataBasedFilter)step, role);
                        continue;
                    }
                    if (!(step instanceof BusinessQueryRankFilter)) continue;
                    this.analyzeRankFilter(businessQuery, (BusinessQueryRankFilter)step, role);
                }
            }
        }
    }

    private void buildAxisFilterRepairSteps(BusinessQuery businessQuery, OLAPMemberRepairElement repairElement) throws MetadataException {
        List<StepInterface> rowS = businessQuery.getSteps(Role.ROW);
        List<StepInterface> colS = businessQuery.getSteps(Role.COLUMN);
        ArrayList<StepInterface> steps = new ArrayList<StepInterface>();
        steps.addAll(rowS);
        steps.addAll(colS);
        List modifiedList = null;
        for (StepInterface step : steps) {
            if (step instanceof BusinessQueryDataBasedFilter) {
                modifiedList = this.repairDataBasedFilter((BusinessQueryDataBasedFilter)step, repairElement);
                if (modifiedList == null || !modifiedList.isEmpty()) continue;
                if (rowS.contains(step)) {
                    rowS.remove(step);
                    businessQuery.setSteps(rowS, Role.ROW);
                    continue;
                }
                if (!colS.contains(step)) continue;
                colS.remove(step);
                businessQuery.setSteps(colS, Role.COLUMN);
                continue;
            }
            if (!(step instanceof BusinessQueryRankFilter) || !(modifiedList = this.repairRankFilter((BusinessQueryRankFilter)step, repairElement)).isEmpty()) continue;
            if (rowS.contains(step)) {
                rowS.remove(step);
                businessQuery.setSteps(rowS, Role.ROW);
                continue;
            }
            if (!colS.contains(step)) continue;
            colS.remove(step);
            businessQuery.setSteps(colS, Role.COLUMN);
        }
    }

    @Override
    public String getDescription() {
        return TOOLDESCRIPTION;
    }

    private String getMemberValue(BusinessQuery businessQuery, BusinessQueryDataBasedFilter databasedFilterOnAxis, Role role, Object object) throws IQueryServicesException {
        String memberValue = this.buildMDXStringFromMemberString(object);
        if (memberValue == null || memberValue.length() == 0) {
            String msg = IQDataServicesResourceBundle.getStringResource("MemberRepairAnalyzerMemberFilterEmptyOrNull.txt");
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error("Query " + (businessQuery instanceof DataSelection ? ((DataSelection)businessQuery).getIdentityString() : businessQuery) + ", DataFilter=" + databasedFilterOnAxis.getIdentityString() + ", Role=" + role + ": " + msg);
            }
            throw new IQueryServicesException(msg);
        }
        return memberValue;
    }

    private String getMemberValue(BusinessQuery businessQuery, BusinessQueryRankFilter rankF, Role role, Object object) throws IQueryServicesException {
        String memberValue = this.buildMDXStringFromMemberString(object);
        if (memberValue == null || memberValue.length() == 0) {
            String msg = IQDataServicesResourceBundle.getStringResource("MemberRepairAnalyzerMemberFilterEmptyOrNull.txt");
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error("Query " + (businessQuery instanceof DataSelection ? ((DataSelection)businessQuery).getIdentityString() : businessQuery) + ", RankFilter=" + rankF.getIdentityString() + ", Role=" + role + ": " + msg);
            }
            throw new IQueryServicesException(msg);
        }
        return memberValue;
    }

    @Override
    public String getMnemonic() {
        return TOOLMNEMONIC;
    }

    @Override
    public String getName() {
        return TOOLNAME;
    }

    public OrphanToolGenericInterface newInstance(BusinessModel busModel) {
        if (_factoryInstance == null) {
            _factoryInstance = new OrphanReportMembers();
        }
        return _factoryInstance;
    }

    @Override
    public void repair() throws IQueryServicesException {
        if (this._toRepairObject instanceof BusinessQuery) {
            BusinessQuery businessQuery = (BusinessQuery)((Object)this._toRepairObject);
            for (Object elementKey : this._orphanedElementKeys.values()) {
                OLAPMemberRepairElement repairElement = (OLAPMemberRepairElement)elementKey;
                BusinessModelResourceReferencer businessItem = repairElement.getBusinessItem();
                if (businessItem == null) {
                    businessItem = repairElement.getBusinessModel();
                }
                if (repairElement.getType().equals(FilterType.CHILD_AXIS_FILTER)) {
                    this.buildAxisFilterRepairSteps(businessQuery, repairElement);
                    continue;
                }
                if (repairElement.getType().equals(FilterType.CHILD_FILTER)) {
                    this.buildChildFilterRepairSteps(repairElement, businessItem);
                    continue;
                }
                if (repairElement.getType().equals(FilterType.PARENT_FILTER)) {
                    this.repairParentFilter((BusinessModel)((Object)businessQuery), repairElement, businessItem);
                    continue;
                }
                if (repairElement.getType().equals(FilterType.CUSTOMIZED_ITEM)) {
                    this.repairCustomizedItem((BusinessModel)((Object)businessQuery), repairElement, businessItem);
                    continue;
                }
                if (repairElement.getType().equals(FilterType.SORT_ITEM)) {
                    this.repairSort((BusinessModel)((Object)businessQuery), repairElement, businessItem);
                    continue;
                }
                if (!_logger.isEnabled(Level.ERROR)) continue;
                _logger.error("Definition for this repair was not complete.. " + repairElement.getType().toString() + businessItem.toString());
            }
            this.clearResolvedItems();
        } else {
            _logger.error("Business Model is not a businessQuery. ");
        }
    }

    private List repairDataBasedFilter(BusinessQueryDataBasedFilter businessQueryDataBased, OLAPMemberRepairElement repairElement) throws MetadataException {
        List<ExpressionInterface> returnList = null;
        Iterator<ExpressionInterface> oldMemberList = businessQueryDataBased.getLeftExpression().iterator();
        ArrayList<Object> newMemberList = new ArrayList<Object>();
        while (oldMemberList.hasNext()) {
            Object newValue;
            ExpressionInterface oldValue = oldMemberList.next();
            String valueOld = null;
            valueOld = oldValue instanceof String ? (String)((Object)oldValue) : (oldValue instanceof StringExpression ? ((StringExpression)oldValue).getText() : (oldValue instanceof ConstantExpression ? ((ConstantExpression)oldValue).getValue() : oldValue.toString()));
            if (!repairElement.isMemberOrphaned(valueOld)) {
                newMemberList.add(oldValue);
                continue;
            }
            if (!repairElement.isMemberValueResolved(valueOld) || (newValue = repairElement.getResolvedValue(oldValue)).equals("##REMOVE#")) continue;
            newMemberList.add(newValue);
        }
        businessQueryDataBased.setLeftExpression(newMemberList);
        returnList = businessQueryDataBased.getLeftExpression();
        return returnList;
    }

    private List repairRankFilter(BusinessQueryRankFilter businessQueryRank, OLAPMemberRepairElement repairElement) throws MetadataException {
        List returnList = null;
        Iterator qualifiers = businessQueryRank.getRankQualifiers().iterator();
        ArrayList<Object> newMemberList = new ArrayList<Object>();
        while (qualifiers.hasNext()) {
            Object newValue;
            Object oldValue = qualifiers.next();
            String valueOld = null;
            valueOld = oldValue instanceof String ? (String)oldValue : (oldValue instanceof StringExpression ? ((StringExpression)oldValue).getText() : (oldValue instanceof ConstantExpression ? ((ConstantExpression)oldValue).getValue() : oldValue.toString()));
            if (!repairElement.isMemberOrphaned(valueOld)) {
                newMemberList.add(oldValue);
                continue;
            }
            if (!repairElement.isMemberValueResolved(valueOld) || (newValue = repairElement.getResolvedValue(oldValue)).equals("##REMOVE#")) continue;
            newMemberList.add(newValue);
        }
        businessQueryRank.setRankQualifiers(newMemberList);
        returnList = businessQueryRank.getRankQualifiers();
        return returnList;
    }

    static {
        _logger = LogManager.getLogger(OrphanReportMembers.class);
    }
}

