/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.SASOlapServer;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.inmemory.InMemoryTable;
import com.sas.iquery.metadata.physical.oma.OMATable;
import com.sas.iquery.metadata.resourceutil.BasicResource;
import com.sas.iquery.metadata.resourceutil.MediatedResourceManager2;
import com.sas.iquery.metadata.resourceutil.physical.BasicResourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.DataSourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InformationMapResourceReplacementManager2 {
    private static final Logger _clsLogger = LogManager.getLogger(InformationMapResourceReplacementManager2.class);
    private BriefInformationMap _briefMap = null;
    private IntelligentQueryMetadataServiceInterface _iqService = null;
    private InformationMap _map = null;
    private SessionContextInterface _session = null;
    private List _mapExternalResources = null;
    private boolean _useGlobalReplacement = false;
    private boolean _relationalDataStructure = false;
    private MediatedResourceManager2 _resourceManager = null;
    private boolean _lightMapRead = false;
    private boolean _doResolveExternalResources = true;
    private List _dataSourceResources;
    private Logger _logger = null;
    private boolean _validatedSelections = false;
    private DataSourceReplacementMediator2 _dataSourceMediator = null;

    public InformationMapResourceReplacementManager2(BriefInformationMap map, SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Logger logger, boolean useGlobalReplacement, boolean doResolveExternalResources) throws MetadataException {
        this(map, session, service, logger, useGlobalReplacement, doResolveExternalResources, false);
    }

    public InformationMapResourceReplacementManager2(BriefInformationMap map, SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Logger logger, boolean useGlobalReplacement, boolean doResolveExternalResources, boolean externalResourcesOnly) throws MetadataException {
        this._useGlobalReplacement = useGlobalReplacement;
        this._logger = logger;
        this._briefMap = map;
        this._iqService = service;
        this._session = session;
        this._lightMapRead = useGlobalReplacement;
        this._doResolveExternalResources = doResolveExternalResources;
        try {
            this._relationalDataStructure = map.getStructure().isRelational();
        }
        catch (RemoteException re) {
            MetadataException me = new MetadataException(re);
            me.initCause(re);
            throw me;
        }
        catch (ServiceException e) {
            MetadataException me = new MetadataException(e);
            me.initCause(e);
            throw me;
        }
        InformationMapImpl2.FactoryResultsImpl results = InformationMapImpl2.readInNewMap(map, service, session, externalResourcesOnly, doResolveExternalResources);
        this._map = results.getMap();
        this.initialize();
    }

    public InformationMapResourceReplacementManager2(InformationMap map, SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Logger logger, boolean useGlobalReplacement) throws MetadataException {
        this._useGlobalReplacement = useGlobalReplacement;
        this._logger = logger;
        this._briefMap = map.getBriefMap();
        this._iqService = service;
        this._session = session;
        this._lightMapRead = useGlobalReplacement;
        this._relationalDataStructure = map.getStructure().isRelational();
        this._map = map;
        this.initialize();
    }

    private void initialize() throws MetadataException {
        this.determineMapType();
        this._resourceManager = new MediatedResourceManager2(this._session, this._iqService, this._map.getRepository(), this._mapExternalResources, this._useGlobalReplacement, this._logger);
        this._resourceManager.setRelationalData(this._relationalDataStructure);
    }

    private void determineMapType() throws MetadataException {
        try {
            this.populateReplaceableResources();
            if (!this._lightMapRead) {
                this.populateDataSourceList();
            }
            if (!this._relationalDataStructure) {
                if (this._briefMap != null && this._briefMap.getStructure().isOLAP()) {
                    this._relationalDataStructure = false;
                } else {
                    boolean bfoundStructure = false;
                    Iterator iter = this._mapExternalResources.iterator();
                    while (iter.hasNext() && !bfoundStructure) {
                        PhysicalResource res = (PhysicalResource)iter.next();
                        if (!(res instanceof SoftwareServer)) continue;
                        if (res instanceof SASWorkspaceServer) {
                            this._relationalDataStructure = true;
                            bfoundStructure = true;
                            continue;
                        }
                        if (!(res instanceof SASOlapServer)) continue;
                        this._relationalDataStructure = false;
                        bfoundStructure = true;
                    }
                    if (!bfoundStructure) {
                        if (this._logger != null) {
                            this._logger.debug("InformationMapResourceReplacement: Assuming Relational Structure for map");
                        }
                        this._relationalDataStructure = true;
                    }
                }
            }
        }
        catch (RemoteException re) {
            MetadataException me = new MetadataException(re);
            me.initCause(re);
            throw me;
        }
        catch (ServiceException e) {
            MetadataException me = new MetadataException(e);
            me.initCause(e);
            throw me;
        }
    }

    public InformationMapResourceReplacementManager2(InformationMap infoMap, IntelligentQueryMetadataServiceInterface service, Logger logger, boolean useGlobalReplacement, boolean lightMapRead, boolean doResolveExternalResources) throws MetadataException {
        this._logger = logger;
        this._map = infoMap;
        this._useGlobalReplacement = useGlobalReplacement;
        this._briefMap = infoMap.getBriefMap();
        this._iqService = service;
        this._session = infoMap.getSession();
        this._lightMapRead = lightMapRead;
        this._doResolveExternalResources = doResolveExternalResources;
        this.initialize();
    }

    private void populateReplaceableResources() throws MetadataException {
        this._mapExternalResources = ((InformationMapImpl2)this._map).getReplaceableObjects();
        ListIterator it = this._mapExternalResources.listIterator();
        while (it.hasNext()) {
            Object obj = it.next();
            boolean bl = this._useGlobalReplacement ? obj instanceof DataSourceTable || obj instanceof QualifiedColumn : obj instanceof OMATable || obj instanceof InMemoryTable;
            boolean remove = bl;
            if (!remove) continue;
            it.remove();
        }
    }

    private void populateDataSourceList() throws MetadataException {
        List<DataSource> dsResources = this._map.getResources(DataSource.class, 65535);
        List<QualifiedColumn> qcResources = this._map.getResources(QualifiedColumn.class, 65535);
        this._dataSourceResources = new ArrayList(dsResources.size() + qcResources.size());
        this._dataSourceResources.addAll(dsResources);
        this._dataSourceResources.addAll(qcResources);
    }

    public void validateReplacementSelections() throws MetadataException {
        this.pulseCheck();
        this._validatedSelections = false;
        if (this._lightMapRead && this._map == null) {
            InformationMapImpl2.FactoryResultsImpl results = InformationMapImpl2.readInNewMap(this._briefMap, this._iqService, this._session, !this._lightMapRead, this._doResolveExternalResources);
            this._map = results.getMap();
            this.populateDataSourceList();
            if (this._logger != null) {
                this._logger.warn(IQMetadataResourceBundle.getStringResource("InformationMapResourceReplacementManager.reloadingmap.txt"));
            }
        }
        if (this._dataSourceResources == null) {
            this.populateDataSourceList();
        }
        this._dataSourceMediator = new DataSourceReplacementMediator2(this._map, this._dataSourceResources, this._logger, this._resourceManager);
        this._dataSourceMediator.validateDataSources();
        List<Reason> reasons = this._dataSourceMediator.getReasonsUnableToProcess();
        if (!reasons.isEmpty()) {
            if (this._logger.isDebugEnabled()) {
                Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale(this._map);
                for (Reason reason : reasons) {
                    this._logger.debug(reason.getReasonString(viewerLocale));
                }
            }
            MessageFormatter baseMessage = IQMetadataResourceBundle.getMessageFormatter("InformationMapResourceReplacementManager.unableToProcessReasons.fmt.txt", reasons.get(0));
            MessageFormatter reasonListFormatter = Reason.getMessageFormatter(baseMessage, reasons, true);
            MetadataException me = new MetadataException(reasonListFormatter, reasons);
            throw me;
        }
        this._validatedSelections = true;
    }

    public List replaceMapExternalDependencies() throws MetadataException {
        if (!this._validatedSelections) {
            this.validateReplacementSelections();
        }
        return this._dataSourceMediator.processReplacements();
    }

    public Map getMapOfReplacments() throws MetadataException {
        this.pulseCheck();
        HashMap<PhysicalResource, PhysicalResource> replacements = new HashMap<PhysicalResource, PhysicalResource>();
        if (this._useGlobalReplacement) {
            List resources = this._resourceManager.getIncreasingImportanceMediatedResourceList();
            for (List objects : resources) {
                for (BasicResourceReplacementMediator2 med : objects) {
                    PhysicalResource target;
                    PhysicalResource[] values = med.getMappingValue();
                    PhysicalResource source = values[0];
                    if (source == null || (target = values[1]) == null) continue;
                    replacements.put(source, target);
                }
            }
        } else {
            Enumeration<ExternalResourceType> types = ExternalResourceType.enumeration();
            while (types.hasMoreElements()) {
                ExternalResourceType type = types.nextElement();
                List typeList = this._resourceManager.getListOfReplacementHierarchyByLowestType(type);
                for (List items : typeList) {
                    PhysicalResource target;
                    BasicResource targetResource;
                    BasicResourceReplacementMediator2 brrm;
                    PhysicalResource source;
                    int lastIndex = items.size() - 1;
                    if (lastIndex < 0 || (source = (brrm = (BasicResourceReplacementMediator2)items.get(lastIndex)).getPhysicalSourceObject()) == null || (targetResource = brrm.getReplacementObject()) == null || (target = targetResource.getPhysicalResource()) == null) continue;
                    replacements.put(source, target);
                }
            }
        }
        return replacements;
    }

    public MediatedResourceManager2 getResourceManager() throws MetadataException {
        this.pulseCheck();
        return this._resourceManager;
    }

    public boolean isRelationalDataStructure() throws MetadataException {
        return this._relationalDataStructure;
    }

    public boolean isOLAPDataStructure() throws MetadataException {
        return !this.isRelationalDataStructure();
    }

    public BriefInformationMap save(String description) throws MetadataException {
        BriefInformationMap briefMap = null;
        if (this._map != null) {
            briefMap = this._map.save(description);
        }
        return briefMap;
    }

    public List getMapExternalResources(boolean doRefreshExternalResources) throws MetadataException {
        this.pulseCheck();
        if (doRefreshExternalResources) {
            this.populateReplaceableResources();
        }
        return this._mapExternalResources;
    }

    public List<PhysicalResource> getMapUnresolvedPhysicalResources(boolean doRefreshExternalResources) throws MetadataException {
        this.pulseCheck();
        ArrayList<PhysicalResource> urRes = new ArrayList<PhysicalResource>();
        if (doRefreshExternalResources) {
            List<PhysicalResource> physicalResources = this._map.getResources(PhysicalResource.class, 65535);
            for (PhysicalResource physicalResource : physicalResources) {
                if (!physicalResource.isUnresolved()) continue;
                urRes.add(physicalResource);
            }
        } else {
            List<BusinessModelResource> businessModelResources = this._map.getUnresolvedResources();
            for (BusinessModelResource businessModelResource : businessModelResources) {
                if (!(businessModelResource instanceof PhysicalResource)) continue;
                PhysicalResource p = (PhysicalResource)businessModelResource;
                urRes.add(p);
            }
        }
        return urRes;
    }

    public List<PhysicalResource> getMapUnresolvedPhysicalResources() throws MetadataException {
        this.pulseCheck();
        ArrayList<PhysicalResource> urRes = new ArrayList<PhysicalResource>();
        List<BusinessModelResource> businessModelResources = this._map.getUnresolvedResources();
        for (BusinessModelResource businessModelResource : businessModelResources) {
            if (!(businessModelResource instanceof PhysicalResource)) continue;
            PhysicalResource p = (PhysicalResource)businessModelResource;
            urRes.add(p);
        }
        return urRes;
    }

    public void dispose() throws MetadataException {
        if (this._logger != null) {
            this._logger.debug("dispose has been called on " + this.toString());
        } else {
            _clsLogger.debug("dispose has been called on " + this.toString());
        }
        this._mapExternalResources = null;
        this._resourceManager = null;
    }

    private void pulseCheck() throws MetadataException {
        if (this._mapExternalResources == null) {
            this.initialize();
        }
    }
}

