/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.resourceutil.InformationMapMetadataState;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.ServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InformationMapMetadataManager {
    private static final String INFOMAP_METADATA_FETCH_TEMPLATE = "<Templates><Transformation><TransformationSources/><Trees/></Transformation></Templates>";
    private SessionContextInterface _session = null;

    public InformationMapMetadataManager(SessionContextInterface session) {
        this._session = session;
    }

    public List getAllValidInformationMaps() throws MetadataException {
        ArrayList returnValue = new ArrayList();
        Map allValid = this.getMapOfAllValidInformationMaps();
        returnValue.addAll(allValid.keySet());
        return returnValue;
    }

    public Map getMapOfAllValidInformationMaps() throws MetadataException {
        HashMap<BriefInformationMap, InformationMapMetadataState> returnValue = new HashMap<BriefInformationMap, InformationMapMetadataState>();
        FilterComponent filterComponent = new FilterComponent("TransformRole", 0, "InformationMap");
        String template = INFOMAP_METADATA_FETCH_TEMPLATE;
        try {
            List OMRServers = this._session.getUserContext().getServers();
            for (ServerInterface server : OMRServers) {
                List maps = IQModelImplUtilities.generalSearch(server, 16384, template, "Transformation", filterComponent);
                Map<BriefInformationMap, InformationMapMetadataState> vmaps = InformationMapMetadataState.getValidMaps(maps);
                returnValue.putAll(vmaps);
            }
        }
        catch (RemoteException e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("InformationMapMetadataState.unableToGetValid.msg.txt", new Object[0]);
            MetadataException me = new MetadataException(mf, (Throwable)e);
            throw me;
        }
        catch (IllegalStateException e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("InformationMapMetadataState.unableToGetValid.msg.txt", new Object[0]);
            MetadataException me = new MetadataException(mf, (Throwable)e);
            throw me;
        }
        catch (ServiceException e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("InformationMapMetadataState.unableToGetValid.msg.txt", new Object[0]);
            MetadataException me = new MetadataException(mf, (Throwable)e);
            throw me;
        }
        catch (MdException e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("InformationMapMetadataState.unableToGetValid.msg.txt", new Object[0]);
            MetadataException me = new MetadataException(mf, (Throwable)e);
            throw me;
        }
        return returnValue;
    }

    public Map getAllInvalidInformationMaps(boolean includeWarnings) throws MetadataException {
        HashMap<BriefInformationMap, InformationMapMetadataState> returnValue = new HashMap<BriefInformationMap, InformationMapMetadataState>();
        FilterComponent filterComponent = new FilterComponent("TransformRole", 0, "InformationMap");
        String template = INFOMAP_METADATA_FETCH_TEMPLATE;
        try {
            List OMRServers = this._session.getUserContext().getServers();
            Map<BriefInformationMap, InformationMapMetadataState> fetchedInvalid = null;
            for (ServerInterface server : OMRServers) {
                List maps = IQModelImplUtilities.generalSearch(server, 16384, template, "Transformation", filterComponent);
                fetchedInvalid = InformationMapMetadataState.getInvalidMaps(maps);
                if (includeWarnings) {
                    Map<BriefInformationMap, InformationMapMetadataState> fetchedWarning = InformationMapMetadataState.getWarningMaps(maps);
                    returnValue.putAll(fetchedWarning);
                }
                returnValue.putAll(fetchedInvalid);
            }
        }
        catch (RemoteException e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("InformationMapMetadataState.unableToGetInValid.msg.txt", new Object[0]);
            MetadataException me = new MetadataException(mf, (Throwable)e);
            throw me;
        }
        catch (IllegalStateException e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("InformationMapMetadataState.unableToGetInValid.msg.txt", new Object[0]);
            MetadataException me = new MetadataException(mf, (Throwable)e);
            throw me;
        }
        catch (ServiceException e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("InformationMapMetadataState.unableToGetInValid.msg.txt", new Object[0]);
            MetadataException me = new MetadataException(mf, (Throwable)e);
            throw me;
        }
        catch (MdException e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("InformationMapMetadataState.unableToGetInValid.msg.txt", new Object[0]);
            MetadataException me = new MetadataException(mf, (Throwable)e);
            throw me;
        }
        return returnValue;
    }

    public void updateTranformationSources(BriefInformationMap bMap, IntelligentQueryMetadataServiceInterface service) throws MetadataException {
        this.updateAllInvalidMetadata(bMap, service);
    }

    public void updateAllInvalidMetadata(BriefInformationMap bMap, IntelligentQueryMetadataServiceInterface service) throws MetadataException {
        InformationMapImpl2.FactoryResultsImpl results = InformationMapImpl2.readInNewMap(bMap, service, this._session, false, true);
        InformationMap _map = results.getMap();
        _map.save(IQMetadataResourceBundle.getStringResource("InformationMapMetadataManager.updateMetadata.msg.txt"));
    }

    public Map getMetadataStateOfMaps(List generatedMaps) throws MetadataException {
        HashMap<BriefInformationMap, InformationMapMetadataState> returnValue = new HashMap<BriefInformationMap, InformationMapMetadataState>();
        try {
            Map<BriefInformationMap, InformationMapMetadataState> fetchedInvalid = InformationMapMetadataState.getInvalidMaps(generatedMaps);
            Map<BriefInformationMap, InformationMapMetadataState> fetchedWarning = InformationMapMetadataState.getWarningMaps(generatedMaps);
            Map<BriefInformationMap, InformationMapMetadataState> fetchedGood = InformationMapMetadataState.getValidMaps(generatedMaps);
            returnValue.putAll(fetchedWarning);
            returnValue.putAll(fetchedInvalid);
            returnValue.putAll(fetchedGood);
        }
        catch (RemoteException e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("InformationMapMetadataState.unableToGetState.mgs.txt", new Object[0]);
            MetadataException me = new MetadataException(mf, (Throwable)e);
            throw me;
        }
        catch (IllegalStateException e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("InformationMapMetadataState.unableToGetState.mgs.txt", new Object[0]);
            MetadataException me = new MetadataException(mf, (Throwable)e);
            throw me;
        }
        catch (ServiceException e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("InformationMapMetadataState.unableToGetState.mgs.txt", new Object[0]);
            MetadataException me = new MetadataException(mf, (Throwable)e);
            throw me;
        }
        catch (MdException e) {
            MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("InformationMapMetadataState.unableToGetState.mgs.txt", new Object[0]);
            MetadataException me = new MetadataException(mf, (Throwable)e);
            throw me;
        }
        return returnValue;
    }
}

