/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Connection;
import com.sas.iquery.metadata.physical.JFSResourceFactory;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.jfs.JFSStoredProcess;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.xml.sax.SAXException;

public abstract class OMASoftwareServer
extends OMAResourceImpl
implements SoftwareServer {
    private static final long serialVersionUID = 1L;
    private LogicalServer logicalServer;
    private ServerContext serverContext;
    protected static final String dataPackageTemplate = "<XMLSelect search=\"ServerContext[@Id=''{0}'']\"/><Templates>  <ServerContext><DataPackages/></ServerContext></Templates>";
    private List _unresolvedStoredProcessesWhenV2Unresolved = new ArrayList();

    public OMASoftwareServer() {
    }

    public OMASoftwareServer(LogicalServer inputLogicalServer, ServerContext inputServerContext, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((CMetadata)inputLogicalServer, session, metadataServer);
        this.logicalServer = inputLogicalServer;
        this.serverContext = inputServerContext;
    }

    public OMASoftwareServer(LogicalServer inputLogicalServer, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((CMetadata)inputLogicalServer, session, metadataServer);
        this.logicalServer = inputLogicalServer;
        this.serverContext = this.findServerContext(inputLogicalServer);
    }

    private ServerContext findServerContext(LogicalServer inputLogicalServer) {
        ServerContext outputServerContext = null;
        try {
            ArrayList usedByComponents = new ArrayList(inputLogicalServer.getUsedByComponents());
            Iterator it = usedByComponents.iterator();
            while (it.hasNext() && outputServerContext == null) {
                Object obj = it.next();
                if (!(obj instanceof ServerContext)) continue;
                outputServerContext = (ServerContext)obj;
            }
        }
        catch (MdException e) {
            _logger.debug("could not find the server context ... leave it null", (Throwable)e);
        }
        catch (RemoteException e) {
            _logger.debug("could not find the server context ... leave it null", (Throwable)e);
        }
        return outputServerContext;
    }

    @Override
    public String getLabel() {
        String label = null;
        if (this.serverContext != null) {
            try {
                label = this.serverContext.getName();
            }
            catch (RemoteException e) {
                _logger.debug("We are going to eat the exception here for now", (Throwable)e);
            }
        } else {
            label = super.getLabel();
        }
        return label;
    }

    @Override
    public List<Connection> getConnections() throws MetadataException {
        _logger.debug(">> getConnections");
        this.unresolvedCheck();
        ArrayList<Connection> ourConnections = new ArrayList<Connection>();
        if (this.logicalServer != null) {
            try {
                List<ServerComponent> usingComponents = AssociationListUtil.filteredSnapshot(this.logicalServer.getUsingComponents(), ServerComponent.class);
                for (ServerComponent sc : usingComponents) {
                    ourConnections.addAll(this.getReposObjects((List<? extends CMetadata>)sc.getSourceConnections()));
                }
            }
            catch (MdException e) {
                this.error(e);
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("<< getConnections returning: " + ourConnections);
        }
        return ourConnections;
    }

    public LogicalServerInterface getNonPooledLogicalServerInterface() throws MetadataException {
        LogicalServerInterface outServer = null;
        try {
            if (this.logicalServer != null) {
                outServer = (LogicalServerInterface)this.newJFSObject((Root)this.logicalServer);
            }
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return outServer;
    }

    public LogicalServerInterface getPooledLogicalServerInterface() throws MetadataException {
        return null;
    }

    @Override
    public LogicalServerInterface getLogicalServerInterface() throws MetadataException {
        LogicalServerInterface outServer = null;
        try {
            LogicalServerInterface lsi = this.getNonPooledLogicalServerInterface();
            if (lsi == null) {
                lsi = this.getPooledLogicalServerInterface();
            }
            if (lsi != null) {
                PlatformConnectionFactoryConfiguration config = ConnectionResources.createPlatformConnectionFactoryConfiguration(lsi, this.getSession());
                outServer = config.getLogicalServer();
            }
        }
        catch (ConnectionFactoryException e) {
            throw new MetadataException(e);
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return outServer;
    }

    @Override
    public String getVersion() throws MetadataException {
        this.unresolvedCheck();
        String version = null;
        try {
            if (this.serverContext != null) {
                version = this.serverContext.getSoftwareVersion();
            }
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return version;
    }

    protected <T> List<T> getDataPackageObjects(@Nonnull Class<T> type) throws MetadataException {
        List outList;
        if (this.serverContext != null) {
            try {
                outList = this.getReposObjects((List<? extends CMetadata>)this.serverContext.getDataPackages(true), type);
            }
            catch (RemoteException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
            catch (MdException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
        } else {
            outList = Collections.emptyList();
        }
        return outList;
    }

    @Override
    public String getSearchString() throws MetadataException {
        StringBuffer search = new StringBuffer(60);
        try {
            String classId = null;
            classId = this.serverContext == null ? "SAS Application Server" : this.serverContext.getClassIdentifier();
            search.append("*[@").append("ClassIdentifier").append("='").append(classId).append("' and @Name='").append(this.getLabel()).append("']");
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return search.toString();
    }

    @Override
    public String getUsedBySearchString(ExternalResourceType usingType) throws MetadataException {
        String associationName = usingType.getAssociationToTypeName(this.getResourceType());
        StringBuffer search = new StringBuffer(associationName);
        search.append("/*[@Name='").append(this.getLabel()).append("']");
        return search.toString();
    }

    public List getUnresolvedStoredProcesses() {
        return this._unresolvedStoredProcessesWhenV2Unresolved;
    }

    @Override
    public void consumeExternalReferenceRelatedItems(RelatedObjectListsHolder rolsHolder) throws SAXException {
        super.consumeExternalReferenceRelatedItems(rolsHolder);
        this._unresolvedStoredProcessesWhenV2Unresolved = rolsHolder.consumeObjects("StoredProcesses", JFSStoredProcess.class);
        this.setStoredProcessToServerLink();
    }

    private void setStoredProcessToServerLink() {
        int size = this._unresolvedStoredProcessesWhenV2Unresolved.size();
        for (int i = 0; i < size; ++i) {
            JFSStoredProcess unresolvedStoredProcess = (JFSStoredProcess)this._unresolvedStoredProcessesWhenV2Unresolved.get(i);
            unresolvedStoredProcess.setUnresolvedAccessingServer(this);
        }
    }

    protected void addRelationshipsToUnresolvedResources(IdentityHashMap mapping) {
        this.noteRelationshipsWithOtherUnresolvedResources(mapping, "StoredProcesses", this._unresolvedStoredProcessesWhenV2Unresolved);
    }

    public ServerContext getServerContext() {
        return this.serverContext;
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        return null;
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
        JFSStoredProcess stproc;
        if (childResource != null && childResource instanceof JFSStoredProcess && this._unresolvedStoredProcessesWhenV2Unresolved.contains(stproc = (JFSStoredProcess)childResource)) {
            this._unresolvedStoredProcessesWhenV2Unresolved.add(stproc);
            this.setStoredProcessToServerLink();
        }
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
    }

    public List getChildResources(ExternalResourceType type) throws MetadataException {
        List returnValue = new ArrayList();
        if (type == ExternalResourceType.StoredProcess) {
            try {
                List<StoredProcessInterface> storedProcs = IQModelImplUtilities.getAvailableStoredProcesses((ServerInterface)this.getNonPooledLogicalServerInterface());
                if (this.serverContext != null) {
                    ServerInterface outServer = (ServerInterface)this.newJFSObject((Root)this.serverContext);
                    storedProcs.addAll(IQModelImplUtilities.getAvailableStoredProcesses(outServer));
                }
                returnValue = JFSResourceFactory.getJFSResourceObjects(storedProcs, this.session);
            }
            catch (RemoteException e) {
                MetadataException ex = new MetadataException(e);
                ex.initCause(e);
                throw ex;
            }
            catch (ServiceException e) {
                MetadataException ex = new MetadataException(e);
                ex.initCause(e);
                throw ex;
            }
            catch (MdException e) {
                MetadataException ex = new MetadataException(e);
                ex.initCause(e);
                throw ex;
            }
        }
        return returnValue;
    }

    @Override
    public String getClassId() throws MetadataException {
        String classId;
        LogicalServerInterface logicalServer = this.getNonPooledLogicalServerInterface();
        if (logicalServer == null) {
            logicalServer = this.getPooledLogicalServerInterface();
        }
        if (logicalServer == null) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("ServerIdentification.NoServer.txt", new Object[0]));
        }
        try {
            classId = logicalServer.getClassIdentifier();
        }
        catch (RemoteException e) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("ServerIdentifier.ErrorGettingClassIdentifier.fmt.txt", new Object[0]);
            _logger.error((Object)msg, (Throwable)e);
            throw new MetadataException(msg, (Throwable)e);
        }
        catch (ServiceException e) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("ServerIdentifier.ErrorGettingClassIdentifier.fmt.txt", this);
            _logger.error((Object)msg, (Throwable)e);
            throw new MetadataException(msg, (Throwable)e);
        }
        if (classId.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) {
            classId = "440196d4-90f0-11d0-9f41-00a024bb830c";
        }
        return classId;
    }
}

