/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.OMAResourceFactory;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.physical.oma.OMASoftwareServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public abstract class OMASchema
extends OMAResourceImpl
implements Schema {
    private static final long serialVersionUID = 1L;
    private List usingServers = null;

    public OMASchema() {
    }

    public OMASchema(DeployedDataPackage inputOmrDeployedDataPackage, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((CMetadata)inputOmrDeployedDataPackage, session, metadataServer);
    }

    protected abstract Class<?> getServerType();

    protected abstract boolean isRelational();

    List getLogicalServersCapableOfAccessingThisSchema() throws MetadataException {
        String xmlSelect = "<XMLSelect search=\"*[UsedByComponents/ServerContext/DataPackages/" + this.getResourceType().getOMRType() + "[@Name='" + this.getLabel() + "']]\"/> ";
        List logicalServers = null;
        try {
            MetadataServerInterface msi = this.getMetadataServer();
            logicalServers = IQModelImplUtilities.generalSearch((ServerInterface)msi, 0, xmlSelect, "LogicalServer", null);
            for (int i = 0; i < logicalServers.size(); ++i) {
                MetadataInterface smartObject = (MetadataInterface)logicalServers.get(i);
                Object repoEntity = smartObject.getRepositoryEntity();
                logicalServers.set(i, repoEntity);
            }
        }
        catch (ServiceException e) {
            this.error(e);
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return logicalServers;
    }

    ArrayList<ServerContext> getServerContextsProvidingThisSchema() throws MdException, RemoteException {
        this.unresolvedCheck();
        DeployedDataPackage ddPkg = (DeployedDataPackage)this.getOMAObject();
        AssociationList al = ddPkg.getDeployedComponents();
        ArrayList deployedComponents = new ArrayList(al);
        ArrayList<ServerContext> outList = new ArrayList<ServerContext>();
        for (DeployedComponent dc : deployedComponents) {
            if (!(dc instanceof ServerContext)) continue;
            outList.add((ServerContext)dc);
        }
        outList.trimToSize();
        return outList;
    }

    public List<SoftwareServer> getSoftwareServers() throws MetadataException {
        _logger.debug(">> getSoftwareServers");
        this.unresolvedCheck();
        try {
            ArrayList<ServerContext> serverContexts = this.getServerContextsProvidingThisSchema();
            ArrayList<SoftwareServer> servers = new ArrayList<SoftwareServer>(serverContexts.size());
            for (ServerContext sc : serverContexts) {
                OMASoftwareServer server = OMAResourceFactory.getOMAServerObject(sc, this.getSession(), this.getMetadataServer(), this.isRelational());
                if (server == null) continue;
                servers.add(server);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("<< getSoftwareServers returning: " + servers);
            }
            servers.trimToSize();
            return servers;
        }
        catch (MdException e) {
            _logger.error("", (Throwable)e);
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            _logger.error("", (Throwable)e);
            throw new MetadataException(e);
        }
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        if (this.usingServers == null) {
            this.usingServers = this.getSoftwareServers();
        }
        PhysicalResource parentResource = null;
        if (this.usingServers.size() == 1) {
            parentResource = (PhysicalResource)this.usingServers.get(0);
        }
        return parentResource;
    }
}

