/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.JFSResourceFactory;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.SASOlapServer;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.oma.OMAOlapSchema;
import com.sas.iquery.metadata.physical.oma.OMASoftwareServer;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.xml.sax.SAXException;

public class OMASASOlapServer
extends OMASoftwareServer
implements SASOlapServer {
    private static final long serialVersionUID = 1L;
    private List _unresolvedOLAPSchemasWhenV2Unresolved;

    public OMASASOlapServer() {
    }

    public OMASASOlapServer(ServerContext inputServerContext, LogicalServer inputLogicalServer, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super(inputLogicalServer, inputServerContext, session, metadataServer);
    }

    @Override
    protected String getDefinitionElementName() {
        return "ReposSASOlapServer";
    }

    public List getOlapSchemas() throws MetadataException {
        _logger.debug(">> getOlapSchemas");
        List<OlapSchema> schemas = null;
        if (this.isUnresolved()) {
            if (this.getV2ResourceResolutionRelationshipsApply()) {
                schemas = new ArrayList<OlapSchema>(this._unresolvedOLAPSchemasWhenV2Unresolved);
            } else {
                this.unresolvedCheck();
            }
        } else {
            schemas = this.getDataPackageObjects(OlapSchema.class);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("<< getOlapSchemas returning: " + schemas);
        }
        return schemas;
    }

    @Override
    public String getType() {
        return IQModelImplUtilities.getMessage("Type.SASOLAPServer.txt", new Object[0]);
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.OLAPServer;
    }

    @Override
    public void consumeExternalReferenceRelatedItems(RelatedObjectListsHolder rilsHolder) throws SAXException {
        super.consumeExternalReferenceRelatedItems(rilsHolder);
        this._unresolvedOLAPSchemasWhenV2Unresolved = rilsHolder.consumeObjects("Schemas", OMAOlapSchema.class);
        this.setSchemasToServerLinks();
    }

    private void setSchemasToServerLinks() {
        for (OMAOlapSchema unresolvedSchema : this._unresolvedOLAPSchemasWhenV2Unresolved) {
            unresolvedSchema.setAccessingServerWhenUnresolved(this);
        }
    }

    @Override
    protected void addRelationshipsToUnresolvedResources(IdentityHashMap mapping) {
        super.addRelationshipsToUnresolvedResources(mapping);
        this.noteRelationshipsWithOtherUnresolvedResources(mapping, "Schemas", this._unresolvedOLAPSchemasWhenV2Unresolved);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List getChildResources(ExternalResourceType type) throws MetadataException {
        List returnValue = super.getChildResources(type);
        if (type == ExternalResourceType.StoredProcess) {
            try {
                List serverContextServers = AssociationListUtil.getCopyIfASL(this.getNonPooledLogicalServerInterface().getServed());
                if (serverContextServers.size() != 1) return returnValue;
                ServerContextInterface server = (ServerContextInterface)serverContextServers.get(0);
                List servers = server.getServers();
                ArrayList<MetadataInterface> spList = new ArrayList<MetadataInterface>();
                for (LogicalServerInterface element : servers) {
                    if (!element.getClassIdentifier().equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") && !element.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) continue;
                    List<StoredProcessInterface> stps = IQModelImplUtilities.getAvailableStoredProcesses((ServerInterface)element);
                    for (MetadataInterface metadataInterface : stps) {
                        if (spList.contains(metadataInterface)) continue;
                        spList.add(metadataInterface);
                    }
                }
                IQModelImplUtilities.addButNoDuplicates(returnValue, JFSResourceFactory.getJFSResourceObjects(spList, this.session));
                return returnValue;
            }
            catch (RemoteException e) {
                MetadataException ex = new MetadataException(e);
                ex.initCause(e);
                throw ex;
            }
            catch (ServiceException e) {
                MetadataException ex = new MetadataException(e);
                ex.initCause(e);
                throw ex;
            }
            catch (MdException e) {
                MetadataException ex = new MetadataException(e);
                ex.initCause(e);
                throw ex;
            }
        } else {
            if (type != ExternalResourceType.OLAPSchema) return returnValue;
            List schemas = this.getOlapSchemas();
            returnValue.addAll(schemas);
        }
        return returnValue;
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
        super.addUnresolvedChildResource(childResource);
        if (childResource != null && childResource instanceof OMAOlapSchema) {
            if (this._unresolvedOLAPSchemasWhenV2Unresolved == null) {
                this._unresolvedOLAPSchemasWhenV2Unresolved = new ArrayList();
            }
            if (!this._unresolvedOLAPSchemasWhenV2Unresolved.contains(childResource)) {
                this._unresolvedOLAPSchemasWhenV2Unresolved.add(childResource);
                ((OMAOlapSchema)childResource).setAccessingServerWhenUnresolved(this);
            }
        }
    }

    @Override
    public List<Schema> getSchemas() throws MetadataException {
        List olapSchemas = this.getOlapSchemas();
        ArrayList<Schema> schemas = new ArrayList<Schema>(olapSchemas);
        return schemas;
    }

    @Override
    public Schema getSchemaWithLabel(String tableLabel) throws MetadataException {
        Schema schema = null;
        for (Schema check : this.getSchemas()) {
            if (check == null || !check.getLabel().equalsIgnoreCase(tableLabel)) continue;
            schema = check;
            break;
        }
        return schema;
    }
}

