/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.MetadataRepositoryResource;
import com.sas.iquery.metadata.business.impl.OMRTemplates;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.LibraryResource;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.TableResource;
import com.sas.iquery.metadata.physical.oma.OMARelationalSchema;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.physical.oma.OMASASWorkspaceServer;
import com.sas.iquery.metadata.physical.oma.OMATable;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.CredentialResolver;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdLibGenInterface;
import com.sas.metadata.remote.MdModelUtil;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class OMASASLibrary
extends OMARelationalSchema
implements SASLibrary,
LibraryResource {
    private static final long serialVersionUID = 1L;
    private com.sas.metadata.remote.SASLibrary omrLib;
    private OMASASWorkspaceServer _serverWhenV2Unresolved;
    private String _unresolvedSchemaName = null;
    private String _unresolvedOMASchemaType = null;
    private List _unresolvedAccessibleTablesWhenV2Unresolved = new ArrayList();

    public OMASASLibrary() {
    }

    public OMASASLibrary(com.sas.metadata.remote.SASLibrary omrLib, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((RelationalSchema)omrLib, session, metadataServer);
        this.omrLib = omrLib;
    }

    @Override
    protected String getDefinitionElementName() {
        return "ReposSASLibrary";
    }

    protected Class getServerType() {
        return OMASASWorkspaceServer.class;
    }

    @Override
    public String getLibref() throws MetadataException {
        this.unresolvedCheck();
        String libref = null;
        try {
            libref = this.omrLib.getLibref();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return libref;
    }

    @Override
    public String getEngine() throws MetadataException {
        this.unresolvedCheck();
        String engine = null;
        try {
            engine = this.omrLib.getEngine();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return engine;
    }

    @Override
    public boolean isPreassigned() throws MetadataException {
        this.unresolvedCheck();
        boolean result = true;
        try {
            int preassigned = this.omrLib.getIsPreassigned();
            if (preassigned == 0) {
                result = false;
            }
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return result;
    }

    boolean isDBMSLibname() throws MetadataException {
        this.unresolvedCheck();
        boolean result = true;
        try {
            int isDBMSLibname = this.omrLib.getIsDBMSLibname();
            if (isDBMSLibname == 0) {
                result = false;
            }
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public String getLibnameStatement() throws MetadataException {
        return this.getLibnameStatement(false, false);
    }

    @Override
    public String getLibnameStatement(boolean ignorePreassigned) throws MetadataException {
        return this.getLibnameStatement(ignorePreassigned, false);
    }

    @Override
    public String getLibnameStatement(boolean ignorePreassigned, boolean createAsReadonly) throws MetadataException {
        _logger.debug(">> getLibnameStatement");
        this.unresolvedCheck();
        String stmt = null;
        try {
            boolean encodePasswords = true;
            boolean genFileNameForXMLLibs = true;
            UserContextInterface userContext = this.getSession().getUserContext();
            MdLibGenInterface generator = MdModelUtil.getInstance((CredentialResolver)userContext, (String)null, (boolean)encodePasswords, (boolean)genFileNameForXMLLibs, (boolean)ignorePreassigned, (boolean)createAsReadonly);
            stmt = generator.genLibname(this.omrLib);
            if (_logger.isDebugEnabled()) {
                _logger.debug("<< getLibnameStatement returning: " + stmt);
            }
        }
        catch (MdException e) {
            this.error(e);
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return stmt;
    }

    @Override
    public String getConnectStatementForExplicitPassThru(String connectionName) throws MetadataException {
        _logger.debug(">> getConnectStatementForExplicitPassThru");
        this.unresolvedCheck();
        StringBuffer connectStmt = new StringBuffer();
        try {
            boolean encodePasswords = true;
            boolean genFileNameForXMLLibs = true;
            UserContextInterface userContext = this.getSession().getUserContext();
            MdLibGenInterface generator = MdModelUtil.getInstance((CredentialResolver)userContext, (String)null, (boolean)encodePasswords, (boolean)genFileNameForXMLLibs);
            String dbmsOptions = generator.genConnectionOptions(this.omrLib);
            String dbms = this.omrLib.getEngine();
            connectStmt.append("  connect to " + dbms);
            if (connectionName != null && connectionName.trim().length() > 0) {
                connectStmt.append(" as " + connectionName + "  ");
            }
            connectStmt.append("( " + dbmsOptions + " ");
            connectStmt.append(" ); ");
        }
        catch (MdException e) {
            this.error(e);
        }
        catch (RemoteException e) {
            this.error(e);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("<< getConnectStatementForExplicitPassThru returning: " + connectStmt);
        }
        return connectStmt.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Table> getAccessibleTables() throws MetadataException {
        void var1_3;
        _logger.debug(">> getAccessibleTables");
        if (this.isUnresolved()) {
            if (!this.getV2ResourceResolutionRelationshipsApply()) throw new MetadataUnresolvedException((BusinessModelResource)this, IQModelImplUtilities.getMessageFormatter("BusinessModelUnresolvedCheck.txt", new Object[0]));
            ArrayList arrayList = new ArrayList(this._unresolvedAccessibleTablesWhenV2Unresolved);
            return var1_3;
        }
        try {
            List<PhysicalTable> omrTables;
            this.fetchAccessibleTables();
            if (this.omrLib.getIsDBMSLibname() == 0) {
                omrTables = AssociationListUtil.filteredSnapshot(this.omrLib.getTables(), PhysicalTable.class);
            } else {
                RelationalSchema relationalSchemaToUse;
                _logger.debug("  Tables are not hung off the library since this is a DBMS libname.");
                if (_logger.isDebugEnabled()) {
                    _logger.debug("  Libname engine name:" + this.omrLib.getEngine());
                }
                if ((relationalSchemaToUse = this.getRelationalSchema()) != null) {
                    _logger.debug("  Getting tables from OMR RelationalSchema object.");
                    omrTables = AssociationListUtil.filteredSnapshot(relationalSchemaToUse.getTables(), PhysicalTable.class);
                } else {
                    omrTables = null;
                }
            }
            List<Table> list = this.getReposObjects(omrTables, Table.class);
            if (!_logger.isDebugEnabled()) return var1_3;
            _logger.debug("<< getAccessibleTables returning: " + list);
            return var1_3;
        }
        catch (MdException e) {
            _logger.error("", (Throwable)e);
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            _logger.error("", (Throwable)e);
            throw new MetadataException(e);
        }
    }

    public RelationalSchema getRelationalSchema() throws MetadataException {
        RelationalSchema schema = null;
        if (!this.isUnresolved()) {
            try {
                List<RelationalSchema> relationalSchemas = AssociationListUtil.filteredSnapshot(this.omrLib.getUsingPackages(), RelationalSchema.class);
                if (!relationalSchemas.isEmpty()) {
                    schema = relationalSchemas.get(0);
                }
                if (_logger.isDebugEnabled() && schema != null) {
                    _logger.debug("  Found an OMR " + schema.getCMetadataType() + " object to use to get the tables.");
                }
            }
            catch (MdException e) {
                this.error(e);
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
        return schema;
    }

    public List<Table> getTables() throws MetadataException {
        return this.getAccessibleTables();
    }

    @Override
    public String getType() {
        return IQModelImplUtilities.getMessage("Type.SASLibrary.txt", new Object[0]);
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.Library;
    }

    protected void addRelationshipsToUnresolvedResources(IdentityHashMap mapping) {
        this.noteRelationshipsWithOtherUnresolvedResources(mapping, "Tables", this._unresolvedAccessibleTablesWhenV2Unresolved);
    }

    @Override
    public MetadataRepositoryResource getConstrainingResource() throws MetadataException {
        return null;
    }

    @Override
    protected void writeExternalReference(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeExternalReference(thisElement, writingContext);
        RelationalSchema schema = this.getRelationalSchema();
        if (schema != null) {
            OMAResourceImpl omaSchema = (OMAResourceImpl)this.getReposObject((CMetadata)schema);
            IQModelImplUtilities.setAttr(thisElement, "schemaName", omaSchema.getLabel());
            IQModelImplUtilities.setAttr(thisElement, "schemaType", omaSchema.getResourceType().getOMRType());
        } else if (this.isUnresolved()) {
            IQModelImplUtilities.setAttr(thisElement, "schemaName", this._unresolvedSchemaName);
            IQModelImplUtilities.setAttr(thisElement, "schemaType", this._unresolvedOMASchemaType);
        }
    }

    @Override
    public void consumeExternalReferenceAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeExternalReferenceAttributes(attrsProvider);
        this._unresolvedSchemaName = attrsProvider.consumeAttr("schemaName");
        this._unresolvedOMASchemaType = attrsProvider.consumeAttr("schemaType");
    }

    @Override
    public void consumeExternalReferenceRelatedItems(RelatedObjectListsHolder rilsHolder) throws SAXException {
        super.consumeExternalReferenceRelatedItems(rilsHolder);
        this._unresolvedAccessibleTablesWhenV2Unresolved = rilsHolder.consumeObjects("Tables", Table.class);
        this.setTableToAccessingLibraryLink();
    }

    private void setTableToAccessingLibraryLink() {
        int size = this._unresolvedAccessibleTablesWhenV2Unresolved.size();
        for (int i = 0; i < size; ++i) {
            Table unresolvedTable = (Table)this._unresolvedAccessibleTablesWhenV2Unresolved.get(i);
            if (!(unresolvedTable instanceof TableResource)) continue;
            ((TableResource)((Object)unresolvedTable)).setAccessingSASLibraryWhenUnresolved(this);
        }
    }

    @Override
    public List<SoftwareServer> getSoftwareServers() throws MetadataException {
        List<SoftwareServer> out = null;
        if (this.isUnresolved()) {
            if (this.getV2ResourceResolutionRelationshipsApply()) {
                out = new ArrayList<SoftwareServer>();
                if (this._serverWhenV2Unresolved != null) {
                    out.add(this._serverWhenV2Unresolved);
                }
            } else {
                this.unresolvedCheck();
            }
        } else {
            out = super.getSoftwareServers();
        }
        return out;
    }

    @Override
    public void setAccessingServerWhenUnresolved(SASWorkspaceServer server) {
        this._serverWhenV2Unresolved = (OMASASWorkspaceServer)server;
    }

    @Override
    public SASWorkspaceServer getAccessingServerWhenUnresolved() {
        return this._serverWhenV2Unresolved;
    }

    private void fetchAccessibleTables() throws RemoteException, MdException {
        String template = OMRTemplates.getTablesInLibraryTemplate();
        MdOMIUtil omiUtil = this.omrLib.getObjectStore().getFactory().getOMIUtil();
        omiUtil.getMetadataAllDepths((CMetadata)this.omrLib, null, null, template, 260);
    }

    @Override
    @CheckForNull
    public Table getTableWithLabel(String tableLabel) throws MetadataException {
        List<Table> tables = this.getAccessibleTables();
        return this.getTableWithLabel(tableLabel, tables);
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        PhysicalResource returnValue = null;
        if (this.isUnresolved()) {
            returnValue = this.getAccessingServerWhenUnresolved();
        } else {
            returnValue = super.getParentResource();
            if (returnValue == null) {
                returnValue = this.getAccessingServerWhenUnresolved();
            }
            if (returnValue == null) {
                try {
                    List<com.sas.metadata.remote.SASLibrary> sasLibraries;
                    if (this.omrLib.getIsDBMSLibname() == 0 && !(sasLibraries = AssociationListUtil.filteredSnapshot(this.omrLib.getUsedByPackages(true), com.sas.metadata.remote.SASLibrary.class)).isEmpty()) {
                        com.sas.metadata.remote.SASLibrary assocMetadata = sasLibraries.get(0);
                        returnValue = (PhysicalResource)((Object)this.getReposObject((CMetadata)assocMetadata));
                    }
                }
                catch (RemoteException e) {
                    this.error(e);
                }
                catch (MdException e) {
                    this.error(e);
                }
            }
        }
        return returnValue;
    }

    public List getChildResources(ExternalResourceType type) throws MetadataException {
        return this.getAccessibleTables();
    }

    @Override
    public String getSearchString() throws MetadataException {
        StringBuffer search = new StringBuffer("*[@Name='");
        String name = this.getLabel();
        OMAResourceImpl parent = (OMAResourceImpl)this.getParentResource();
        String parentSearchStr = parent.getUsedBySearchString(this.getResourceType());
        search.append(name).append("'][").append(parentSearchStr).append("]");
        return search.toString();
    }

    @Override
    public String getUsedBySearchString(ExternalResourceType usingType) throws MetadataException {
        boolean isUnresolvedSchema;
        String search = null;
        boolean bl = isUnresolvedSchema = this.isUnresolved() && this._unresolvedSchemaName != null;
        if (isUnresolvedSchema) {
            ExternalResourceType schemaType = ExternalResourceType.getExternalResourceTypeForMetadataType(this._unresolvedOMASchemaType);
            String associationName = usingType.getAssociationToTypeName(schemaType);
            StringBuffer buf = new StringBuffer(associationName);
            buf.append("/*[@Name='").append(this._unresolvedSchemaName).append("']/").append(this.getOMALibraryUsedBySearchString(schemaType));
            search = buf.toString();
        } else {
            search = this.getOMALibraryUsedBySearchString(usingType);
        }
        return search;
    }

    private String getOMALibraryUsedBySearchString(ExternalResourceType usingType) throws MetadataException {
        OMAResourceImpl parent = (OMAResourceImpl)this.getParentResource();
        ExternalResourceType type = this.getResourceType();
        String associationName = usingType.getAssociationToTypeName(type);
        StringBuffer search = new StringBuffer(associationName);
        if (usingType == ExternalResourceType.DatabaseSchema || usingType == ExternalResourceType.RelationalSchema || usingType == ExternalResourceType.Library) {
            search.append("/SASLibrary");
        } else {
            search.append("/*");
        }
        search.append("[@Name='").append(this.getLabel()).append("']/").append(parent.getUsedBySearchString(type));
        return search.toString();
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
        if (childResource != null && childResource instanceof OMATable && !this._unresolvedAccessibleTablesWhenV2Unresolved.contains(childResource)) {
            this._unresolvedAccessibleTablesWhenV2Unresolved.add(childResource);
            ((OMATable)childResource).setAccessingSASLibraryWhenUnresolved(this);
        }
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
        if (parentResource != null && parentResource instanceof OMASASWorkspaceServer) {
            OMASASWorkspaceServer server = (OMASASWorkspaceServer)parentResource;
            this.setAccessingServerWhenUnresolved(server);
        }
    }

    @Override
    public void setUnresolvedProperties(PhysicalResource sourceResource) throws MetadataException {
        super.setUnresolvedProperties(sourceResource);
        if (sourceResource != null && sourceResource instanceof OMASASLibrary) {
            OMASASLibrary sourceLibrary = (OMASASLibrary)sourceResource;
            RelationalSchema schema = sourceLibrary.getRelationalSchema();
            if (schema != null) {
                OMAResourceImpl omaSchema = (OMAResourceImpl)this.getReposObject((CMetadata)schema);
                this._unresolvedSchemaName = omaSchema.getLabel();
                this._unresolvedOMASchemaType = omaSchema.getResourceType().getOMRType();
            } else if (sourceLibrary.isUnresolved() && sourceLibrary._unresolvedSchemaName != null) {
                this._unresolvedSchemaName = sourceLibrary._unresolvedSchemaName;
                this._unresolvedOMASchemaType = sourceLibrary._unresolvedOMASchemaType;
            }
        }
    }

    @Override
    public String getDBMSHost() throws MetadataException {
        String host;
        block4: {
            host = null;
            try {
                SASClientConnection connection = this.omrLib.getLibraryConnection();
                if (connection == null) break block4;
                List<Property> props = AssociationListUtil.filteredSnapshot(connection.getProperties(true), Property.class);
                for (Property prop : props) {
                    String propName = prop.getPropertyName();
                    if (!propName.equalsIgnoreCase("Host")) continue;
                    host = prop.getDefaultValue();
                    break;
                }
            }
            catch (RemoteException e) {
                this.error(e);
            }
            catch (MdException e) {
                this.error(e);
            }
        }
        return host;
    }

    @Override
    public String getDBMSPort() throws MetadataException {
        String port;
        block4: {
            port = null;
            try {
                SASClientConnection connection = this.omrLib.getLibraryConnection();
                if (connection == null) break block4;
                List<Property> props = AssociationListUtil.filteredSnapshot(connection.getProperties(true), Property.class);
                for (Property prop : props) {
                    String propName = prop.getPropertyName();
                    if (!propName.equalsIgnoreCase("Serv")) continue;
                    port = prop.getDefaultValue();
                    break;
                }
            }
            catch (RemoteException e) {
                this.error(e);
            }
            catch (MdException e) {
                this.error(e);
            }
        }
        return port;
    }

    @Override
    public List<String> getTableLabels() throws MetadataException {
        List<Table> tables = this.getAccessibleTables();
        ArrayList<String> labels = new ArrayList<String>(tables.size());
        for (Table table : tables) {
            labels.add(table.getLabel());
        }
        return labels;
    }
}

