/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Connection;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.SASOlapSchema;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.oma.OMACube;
import com.sas.iquery.metadata.physical.oma.OMASASOlapServer;
import com.sas.iquery.metadata.physical.oma.OMASchema;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPUtilities;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class OMAOlapSchema
extends OMASchema
implements SASOlapSchema {
    private static final long serialVersionUID = 1L;
    private OLAPSchema _omrOLAPSchema = null;
    private List _unresolvedCubesWhenUnresolved = new ArrayList();
    private OMASASOlapServer _serverWhenV2Unresolved;
    private boolean _initDone = false;
    private Connection _connection;
    private MetadataInterface _metadata = null;
    private static final Logger _logger = LogManager.getLogger(OMAOlapSchema.class);

    public OMAOlapSchema() {
    }

    public OMAOlapSchema(OLAPSchema omrOLAPSchema, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((DeployedDataPackage)omrOLAPSchema, session, metadataServer);
        this._omrOLAPSchema = omrOLAPSchema;
    }

    @Override
    protected String getDefinitionElementName() {
        return "ReposOlapSchema";
    }

    @Override
    protected Class<?> getServerType() {
        return OMASASOlapServer.class;
    }

    @Override
    @Nonnull
    public List<Cube> getCubes() throws MetadataException {
        List<Cube> outCubes;
        if (!this.isUnresolved()) {
            try {
                AssociationList cubes = this._omrOLAPSchema.getCubes(true);
                outCubes = this.getReposObjects((List<? extends CMetadata>)cubes, Cube.class);
            }
            catch (MdException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
            catch (RemoteException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
        } else {
            outCubes = new ArrayList<Cube>(this._unresolvedCubesWhenUnresolved);
        }
        return outCubes;
    }

    @Override
    @CheckForNull
    public Cube getCubeWithLabel(String cubeLabel) throws MetadataException {
        Cube outCube = null;
        List<Cube> cubes = this.getCubes();
        for (Cube cube : cubes) {
            if (!IQModelImplUtilities.sameIgnoreCase(cube.getLabel(), cubeLabel)) continue;
            if (outCube != null) {
                java.lang.Object[] args = new java.lang.Object[]{cubeLabel, this};
                String msgKey = "OMAOlapSchema.DuplicateCubeFound.fmt.txt";
                MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter(msgKey, args);
                Reason reason = new Reason((java.lang.Object)this, 6, 80, msgKey, args);
                MetadataException me = new MetadataException(errorMsg, Collections.singletonList(reason));
                throw me;
            }
            outCube = cube;
        }
        return outCube;
    }

    @Override
    public void consumeExternalReferenceRelatedItems(RelatedObjectListsHolder rilsHolder) throws SAXException {
        super.consumeExternalReferenceRelatedItems(rilsHolder);
        this._unresolvedCubesWhenUnresolved = rilsHolder.consumeObjects("Cubes", OMACube.class);
        this.setCubeToSchemaLinks();
    }

    private void setCubeToSchemaLinks() {
        for (OMACube unresolvedCube : this._unresolvedCubesWhenUnresolved) {
            unresolvedCube.setOwningOlapSchema(this);
        }
    }

    protected void addRelationshipsToUnresolvedResources(IdentityHashMap mapping) {
        this.noteRelationshipsWithOtherUnresolvedResources(mapping, "Cubes", this._unresolvedCubesWhenUnresolved);
    }

    @Override
    protected void readExternalReferenceV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readExternalReferenceV1(thisElement, readingContext);
        this._unresolvedCubesWhenUnresolved = OMAOlapSchema.pre92_readExternalReferenceListDirectlyUnderElement(thisElement, readingContext, "ReposCube", new Class[]{OMACube.class});
        for (OMACube unresolvedCube : this._unresolvedCubesWhenUnresolved) {
            unresolvedCube.setOwningOlapSchema(this);
        }
    }

    public Connection getConnection() throws MetadataException {
        if (!this._initDone) {
            this.init();
        }
        return this._connection;
    }

    public MetadataInterface getMetadata() throws MetadataException {
        if (!this._initDone) {
            this.init();
        }
        return this._metadata;
    }

    @Override
    public String getType() {
        return IQModelImplUtilities.getMessage("Type.OLAPSchema.txt", new java.lang.Object[0]);
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.OLAPSchema;
    }

    @Override
    @Nonnull
    public List<SoftwareServer> getSoftwareServers() throws MetadataException {
        List<SoftwareServer> out = null;
        if (this.isUnresolved()) {
            if (this.getV2ResourceResolutionRelationshipsApply()) {
                out = this._serverWhenV2Unresolved == null ? Collections.emptyList() : Collections.singletonList(this._serverWhenV2Unresolved);
            } else {
                this.unresolvedCheck();
            }
        } else {
            out = super.getSoftwareServers();
        }
        assert (out != null);
        return out;
    }

    public void setAccessingServerWhenUnresolved(OMASASOlapServer server) {
        this._serverWhenV2Unresolved = server;
    }

    public OMASASOlapServer getAccessingServerWhenUnresolved() {
        return this._serverWhenV2Unresolved;
    }

    public List getChildResources(ExternalResourceType type) throws MetadataException {
        return this.getCubes();
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        PhysicalResource returnValue = null;
        if (this.isUnresolved()) {
            returnValue = this.getAccessingServerWhenUnresolved();
        } else {
            returnValue = super.getParentResource();
            if (returnValue == null) {
                returnValue = this.getAccessingServerWhenUnresolved();
            }
        }
        return super.getParentResource();
    }

    @Override
    public String getSearchString() throws MetadataException {
        StringBuffer search = new StringBuffer("*[@Name='");
        search.append(this.getLabel()).append("']");
        return search.toString();
    }

    @Override
    public String getUsedBySearchString(ExternalResourceType usingType) throws MetadataException {
        ExternalResourceType type = this.getResourceType();
        String associationName = usingType.getAssociationToTypeName(type);
        StringBuffer search = new StringBuffer(associationName);
        search.append("/*[@Name='").append(this.getLabel()).append("']");
        return search.toString();
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
        OMACube cube;
        if (childResource != null && childResource instanceof OMACube && !this._unresolvedCubesWhenUnresolved.contains(cube = (OMACube)childResource)) {
            this._unresolvedCubesWhenUnresolved.add(cube);
            ((OMACube)childResource).setOwningOlapSchema(this);
        }
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
        if (parentResource != null && parentResource instanceof OMASASOlapServer) {
            OMASASOlapServer server = (OMASASOlapServer)parentResource;
            this.setAccessingServerWhenUnresolved(server);
        }
    }

    private void init() throws MetadataException {
        block17: {
            List<SoftwareServer> servers = this.getSoftwareServers();
            if (servers.isEmpty()) {
                return;
            }
            Connection connection = null;
            LogicalServerInterface logicalServer = null;
            Iterator<SoftwareServer> it = servers.iterator();
            while (it.hasNext() && connection == null) {
                SoftwareServer server = it.next();
                List<Connection> connections = server.getConnections();
                Iterator<Connection> it2 = connections.iterator();
                while (it2.hasNext() && connection == null) {
                    Connection conn = it2.next();
                    if (!(conn instanceof Connection)) continue;
                    connection = conn;
                    logicalServer = server.getLogicalServerInterface();
                }
            }
            if (connection == null || logicalServer == null) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OLAPServerUtilitiesUnableToConnect.txt", new java.lang.Object[0]));
            }
            Locale connectionLocale = LocaleUtilities.getDefaultComputationalLocale(this.session);
            if (connectionLocale == null) {
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionRecycler.fetchPFSConnection.NoLocale.txt", new java.lang.Object[0]);
                throw new MetadataException(msg);
            }
            try {
                this.init(connection, logicalServer, connectionLocale);
            }
            catch (ExecutionException e) {
                if (_logger.isEnabled(Level.WARN)) {
                    _logger.warn(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (RemoteException e) {
                if (_logger.isEnabled(Level.WARN)) {
                    _logger.warn(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (ServiceException e) {
                if (_logger.isEnabled(Level.WARN)) {
                    _logger.warn(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (GenericError e) {
                if (_logger.isEnabled(Level.WARN)) {
                    _logger.warn(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (ConnectionFactoryException e) {
                if (_logger.isEnabled(Level.WARN)) {
                    _logger.warn(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (OLAPException e) {
                if (!_logger.isEnabled(Level.WARN)) break block17;
                _logger.warn(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Connection connection, LogicalServerInterface logicalServer, Locale connectionLocale) throws RemoteException, MetadataException, ConnectionFactoryException, ServiceException, ExecutionException, GenericError, OLAPException {
        String logicaldesc = logicalServer.getDescription();
        IntelligentQueryMetadataServiceInterface iqService = IntelligentQueryMetadataServiceFactory.newService();
        DataSelection dataSelection = DataSelectionFactory.newDataSelection(this.session, iqService);
        RetrievalPolicy userSessionPolicy = new RetrievalPolicy();
        userSessionPolicy.getConnectionConfiguration().setConnectionLifetime(1);
        RetrievalPolicy acquireReleasePolicy = new RetrievalPolicy();
        acquireReleasePolicy.getConnectionConfiguration().setConnectionLifetime(0);
        ConnectionRecycler recycler = ConnectionUtil.getConnectionRecycler(this.session);
        try {
            ISession iSession;
            IQMetadataInterface olapMetadata;
            ConnectionInterface acquireReleaseConnection;
            boolean isOk;
            OLAPConnectionResource olapConnection;
            block37: {
                block38: {
                    UserContextInterface userContext = this.session.getUserContext();
                    ConnectionInterface userConnection = ConnectionUtil.findConnection(recycler, dataSelection, logicalServer, userContext, userSessionPolicy, connectionLocale);
                    ConnectionUtil.LoggerDebugConnectionObtained(_logger, OLAPConnectionInfoUtil.class, userConnection);
                    ConnectionInterface pfsConnection = ConnectionUtil.findPfsConnection(userConnection);
                    olapConnection = OLAPUtilities.findOlapConnectionResource(pfsConnection);
                    isOk = false;
                    acquireReleaseConnection = null;
                    olapMetadata = null;
                    iSession = null;
                    try {
                        DataSelection tmpDataSelection = DataSelectionFactory.newDataSelection(this.session, iqService);
                        try {
                            boolean isOK = false;
                            try {
                                acquireReleaseConnection = ConnectionUtil.findConnection(recycler, tmpDataSelection, logicalServer, userContext, acquireReleasePolicy, connectionLocale);
                                isOK = true;
                            }
                            finally {
                                if (!isOK && acquireReleaseConnection != null) {
                                    ConnectionResources.close(acquireReleaseConnection);
                                }
                            }
                        }
                        finally {
                            if (tmpDataSelection != null) {
                                tmpDataSelection.dispose();
                            }
                        }
                        IMDXServer mdxServer = null;
                        try {
                            if (OLAPConnectionInfoUtil.isOLAPServer(logicalServer)) {
                                Object obj = acquireReleaseConnection.getObject();
                                mdxServer = IOMServerUtils.GetIMDXServer(obj);
                            }
                        }
                        catch (RemoteException e) {
                            if (OLAPConnectionInfoUtil._logger.isEnabled(Level.ERROR)) {
                                OLAPConnectionInfoUtil._logger.error(e.getLocalizedMessage(), (Throwable)e);
                            }
                            throw new ExecutionException(e);
                        }
                        catch (ServiceException e) {
                            if (OLAPConnectionInfoUtil._logger.isEnabled(Level.ERROR)) {
                                OLAPConnectionInfoUtil._logger.error(e.getLocalizedMessage(), (Throwable)e);
                            }
                            throw new ExecutionException(e);
                        }
                        if (mdxServer == null) {
                            if (OLAPConnectionInfoUtil._logger.isEnabled(Level.ERROR)) {
                                OLAPConnectionInfoUtil._logger.error(logicalServer.toString());
                            }
                            throw new ExecutionException(IQDataServicesResourceBundle.getStringResource("OLAPConnectionInfoUtilBadServerObj.txt"));
                        }
                        IMDXServer imdxserver = mdxServer;
                        try {
                            iSession = ConnectionResources.newISession(imdxserver, connectionLocale);
                            olapMetadata = ConnectionResources.newIQMetadata(iSession, connectionLocale);
                            isOk = acquireReleaseConnection != null && iSession != null && olapMetadata != null;
                        }
                        finally {
                            if (imdxserver != null) {
                                imdxserver._release();
                            }
                        }
                        if (isOk) break block37;
                        if (acquireReleaseConnection == null) break block38;
                    }
                    catch (Throwable throwable) {
                        if (!isOk) {
                            if (acquireReleaseConnection != null) {
                                ConnectionResources.close(acquireReleaseConnection);
                            }
                            if (iSession != null) {
                                try {
                                    iSession.Close();
                                    iSession._release();
                                }
                                catch (GenericError e) {
                                    _logger.warn("Could not close the iSession.", (Throwable)e);
                                }
                            }
                        }
                        throw throwable;
                    }
                    ConnectionResources.close(acquireReleaseConnection);
                }
                if (iSession != null) {
                    try {
                        iSession.Close();
                        iSession._release();
                    }
                    catch (GenericError e) {
                        _logger.warn("Could not close the iSession.", (Throwable)e);
                    }
                }
            }
            if (!isOk) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, logicaldesc, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesUnableToConnect.txt"));
                throw new MetadataException(msF);
            }
            this._connection = connection;
            this._metadata = olapMetadata;
            olapConnection.setOLAPSchemaISession(iSession, acquireReleaseConnection);
            this._initDone = true;
        }
        finally {
            if (dataSelection != null) {
                dataSelection.dispose();
            }
        }
    }

    @Override
    protected boolean isRelational() {
        return false;
    }

    protected void finalize() throws Throwable {
        try {
            if (this._metadata != null) {
                BusinessQueryOLAPUtil.releaseMetadataInterface(this._metadata);
            }
            this._metadata = null;
        }
        finally {
            super.finalize();
        }
    }
}

