/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerCube;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerDimension;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerHierarchy;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerLevel;
import com.sas.iquery.metadata.physical.Connection;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.Member;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.oma.OMADimension;
import com.sas.iquery.metadata.physical.oma.OMAOlapSchema;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.storage.olap.MetadataInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OMALevel
extends OMAResourceImpl
implements Level {
    private static final long serialVersionUID = 1L;
    private com.sas.metadata.remote.Level omrLevel = null;
    private OMADimension owningDimensionWhenUnresolved = null;
    private String hierAllMember = null;
    private String uniqueNameOfHierAllMember = null;
    private boolean isDataLoaded = false;
    private static final Logger _logger = LogManager.getLogger(OMALevel.class);
    private static final Logger _OMALogger = LogManager.getLogger((String)"com.sas.iquery.metadata.physical.oma");

    public OMALevel() {
    }

    public OMALevel(com.sas.metadata.remote.Level omrLevel, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((CMetadata)omrLevel, session, metadataServer);
        this.omrLevel = omrLevel;
    }

    @Override
    protected String getDefinitionElementName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLevelName() throws MetadataException {
        return this.getLabel();
    }

    @Override
    public String getLevelCaption() throws MetadataException {
        return this.getDescription();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public List<Member> getMembers() throws MetadataException {
        void var1_5;
        void var1_2;
        this.unresolvedCheck();
        Object var1_1 = null;
        Dimension dim = this.getOwningDimension();
        MetadataInterface metadata = null;
        if (dim != null) {
            Cube owningCube = dim.getOwningCube();
            if (owningCube != null) {
                OlapSchema olapSchema = owningCube.getOwningOlapSchema();
                if (olapSchema == null) {
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, this.getCubeName(), IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoCredentials.txt"));
                    throw new MetadataException(msF.toString());
                }
                Connection conn = ((OMAOlapSchema)olapSchema).getConnection();
                if (conn == null) {
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, this.getCubeName(), IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoCredentials.txt"));
                    throw new MetadataException(msF.toString());
                }
                if (!(olapSchema instanceof OMAOlapSchema)) {
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, this.getCubeName(), IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoCredentials.txt"));
                    throw new MetadataException(msF.toString());
                }
                metadata = ((OMAOlapSchema)olapSchema).getMetadata();
            }
            if (metadata == null) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, this.getCubeName(), IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoConnection.txt"));
                throw new MetadataException(msF.toString());
            }
            OlapServerCube cube = new OlapServerCube(metadata, this.getCubeName());
            if (_OMALogger.isDebugEnabled()) {
                _logger.debug(IQMetadataResourceBundle.getMessageString("LevelImplGetMembers.fmt.txt", this.getCubeName()));
                _logger.debug(IQMetadataResourceBundle.getMessageString("LevelImplGetCube.fmt.txt", cube.getCubeName()));
                _logger.debug(IQMetadataResourceBundle.getMessageString("LevelImplGetCubeLabel.fmt.txt", cube.getLabel()));
            }
            List dimensions = cube.getDimensions();
            boolean found = false;
            Iterator it = dimensions.iterator();
            while (it.hasNext() && !found) {
                OlapServerDimension dimension = (OlapServerDimension)it.next();
                List hierarchies = dimension.getHierarchies();
                Iterator ith = hierarchies.iterator();
                while (ith.hasNext() && !found) {
                    OlapServerHierarchy hierarchy = (OlapServerHierarchy)ith.next();
                    List levels = hierarchy.getLevels();
                    Iterator itl = levels.iterator();
                    while (itl.hasNext() && !found) {
                        OlapServerLevel level = (OlapServerLevel)itl.next();
                        if (!this.getUniqueName().equalsIgnoreCase(level.getLevelUniqueName())) continue;
                        level.setOwningDimension(this.getOwningDimension());
                        level.setOwningHierarchy(hierarchy.getOwningHierarchy());
                        List list = level.getMembers();
                        found = true;
                    }
                }
            }
        } else if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
            _logger.error(IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoDimension.txt"));
        }
        if (var1_2 == null) {
            if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("HierarchyImplErrorInMember.txt"));
            }
            ArrayList arrayList = new ArrayList();
        }
        return var1_5;
    }

    @Override
    public int getLevelNumber() throws MetadataException {
        this.unresolvedCheck();
        int levelNumber = 0;
        try {
            levelNumber = this.omrLevel.getCardinality();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return levelNumber;
    }

    @Override
    public int getExpressionType() {
        return ExpressionUtil.getExprType(1);
    }

    @Override
    public String getDimensionName() throws MetadataException {
        Dimension dim = this.getOwningDimension();
        return dim.getLabel();
    }

    @Override
    public boolean isInMeasureDimension() throws MetadataException {
        int dimType = this.getOwningDimension().getDimensionType();
        return dimType == 1;
    }

    @Override
    public Dimension getOwningDimension() throws MetadataException {
        OMADimension outDimension = this.owningDimensionWhenUnresolved;
        if (!this.isUnresolved()) {
            try {
                com.sas.metadata.remote.Dimension omrDimension = this.omrLevel.getOwningDimension();
                outDimension = (OMADimension)this.getReposObject((CMetadata)omrDimension);
            }
            catch (MdException e) {
                this.error(e);
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
        return outDimension;
    }

    @Override
    public String getCubeName() throws MetadataException {
        Dimension dim = this.getOwningDimension();
        Cube cube = dim.getOwningCube();
        return cube.getLabel();
    }

    @Override
    public String getUniqueName() throws MetadataException {
        this.unresolvedCheck();
        String uniqueName = null;
        try {
            uniqueName = this.omrLevel.getUniqueName();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return uniqueName;
    }

    @Override
    public String getLevelUniqueName() throws MetadataException {
        return this.getUniqueName();
    }

    @Override
    public String getUniqueNameWithHierarchyAllMember() throws MetadataException {
        if (!this.isDataLoaded) {
            this.loadData();
        }
        return this.uniqueNameOfHierAllMember;
    }

    @Override
    public String getSasFormat() throws MetadataException {
        return null;
    }

    public void setOwningDimension(OMADimension inputOwningDimension) {
        this.owningDimensionWhenUnresolved = inputOwningDimension;
    }

    private void loadData() throws MetadataException {
        if (!this.isDataLoaded) {
            this.unresolvedCheck();
            try {
                List<Hierarchy> hierarchies = AssociationListUtil.filteredSnapshot(this.omrLevel.getHierarchies(), Hierarchy.class);
                Hierarchy omrHier = hierarchies.get(0);
                this.hierAllMember = omrHier.getAllMember();
                if (this.hierAllMember == null || this.hierAllMember.equalsIgnoreCase("")) {
                    StringBuffer nameBuffer = new StringBuffer();
                    nameBuffer.append("[");
                    nameBuffer.append(omrHier.getName());
                    nameBuffer.append("].[");
                    String aM = null;
                    try {
                        List<Property> properties = AssociationListUtil.filteredSnapshot(omrHier.getProperties(), Property.class);
                        for (Property property : properties) {
                            if (!property.getPropertyName().equalsIgnoreCase("AllMemberCaption")) continue;
                            aM = property.getDefaultValue();
                            break;
                        }
                    }
                    catch (RemoteException ee) {
                        this.error(ee);
                    }
                    catch (MdException e) {
                        this.error(e);
                    }
                    nameBuffer.append(aM);
                    nameBuffer.append("]");
                    this.hierAllMember = nameBuffer.toString();
                }
                this.uniqueNameOfHierAllMember = this.hierAllMember;
            }
            catch (MdException e) {
                this.error(e);
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
    }

    @Override
    public String getType() {
        return IQModelImplUtilities.getMessage("Type.Level.txt", new Object[0]);
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.Level;
    }

    public List getChildResources(ExternalResourceType type) throws MetadataException {
        return null;
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        return this.getResourceContainer();
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
        if (parentResource != null && parentResource instanceof OMADimension) {
            this.setOwningDimension((OMADimension)parentResource);
        }
    }
}

