/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.oma.OMACube;
import com.sas.iquery.metadata.physical.oma.OMAHierarchy;
import com.sas.iquery.metadata.physical.oma.OMALevel;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class OMADimension
extends OMAResourceImpl
implements Dimension {
    private static final long serialVersionUID = 1L;
    com.sas.metadata.remote.Dimension _omrDimension = null;
    private OMACube _owningCube = null;
    private List _unresolvedHierarchiesWhenUnresolved = new ArrayList();
    private List _unresolvedLevelsWhenUnresolved = new ArrayList();
    private String _uniqueName = null;
    private boolean _isDataLoaded = false;

    public OMADimension() {
    }

    public OMADimension(com.sas.metadata.remote.Dimension omrDimension, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((CMetadata)omrDimension, session, metadataServer);
        this._omrDimension = omrDimension;
    }

    @Override
    protected String getDefinitionElementName() {
        return "ReposDimension";
    }

    @Override
    public String getDimensionName() throws MetadataException {
        return this.getLabel();
    }

    @Override
    public String getDimensionUniqueName() throws MetadataException {
        this.unresolvedCheck();
        String name = null;
        try {
            name = this._omrDimension.getUniqueName();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return name;
    }

    @Override
    public String getDimensionCaption() throws MetadataException {
        return this.getDescription();
    }

    @Override
    @Nonnull
    public List<Hierarchy> getHierarchies() throws MetadataException {
        List<Hierarchy> outHierarchies;
        if (!this.isUnresolved()) {
            try {
                outHierarchies = this.getReposObjects((List<? extends CMetadata>)this._omrDimension.getHierarchies(), Hierarchy.class);
            }
            catch (MdException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(null, (Throwable)e);
            }
            catch (RemoteException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(null, (Throwable)e);
            }
        } else {
            outHierarchies = new ArrayList<Hierarchy>(this._unresolvedHierarchiesWhenUnresolved);
        }
        return outHierarchies;
    }

    public List<Level> getLevels() throws MetadataException {
        List<Level> outLevels;
        if (!this.isUnresolved()) {
            try {
                outLevels = this.getReposObjects((List<? extends CMetadata>)this._omrDimension.getLevels(), Level.class);
            }
            catch (MdException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(null, (Throwable)e);
            }
            catch (RemoteException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(null, (Throwable)e);
            }
        } else {
            outLevels = this._unresolvedLevelsWhenUnresolved;
        }
        return outLevels;
    }

    @Override
    public String getDefaultHierarchy() throws MetadataException {
        this.unresolvedCheck();
        String hierarchyName = null;
        try {
            com.sas.metadata.remote.Hierarchy omrHier;
            AssociationList hierarchies = this._omrDimension.getHierarchies();
            if (hierarchies.size() > 0 && (omrHier = (com.sas.metadata.remote.Hierarchy)hierarchies.get(0)) != null) {
                hierarchyName = omrHier.getUniqueName();
            }
        }
        catch (MdException e) {
            this.error(e);
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return hierarchyName;
    }

    @Override
    public int getDimensionType() throws MetadataException {
        int dimType = 2;
        try {
            this.unresolvedCheck();
            String dimTypeName = this._omrDimension.getDimensionType();
            if (dimTypeName.equalsIgnoreCase("TIME")) {
                dimType = 0;
            } else if (dimTypeName.equalsIgnoreCase("MEASURES")) {
                dimType = 1;
            } else if (dimTypeName.equalsIgnoreCase("GEO")) {
                dimType = 4;
            }
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return dimType;
    }

    @Override
    public Cube getOwningCube() throws MetadataException {
        OMACube outCube = this._owningCube;
        if (!this.isUnresolved()) {
            try {
                ArrayList cubes = new ArrayList(this._omrDimension.getCubes());
                com.sas.metadata.remote.Cube omrCube = null;
                if (cubes.size() == 1) {
                    omrCube = (com.sas.metadata.remote.Cube)cubes.get(0);
                } else if (cubes.size() > 1 && this._owningCube != null) {
                    CMetadata mObj = this._owningCube.getOMAObject();
                    String mId = null;
                    if (mObj != null) {
                        mId = mObj.getId();
                    }
                    for (int i = 0; i < cubes.size(); ++i) {
                        omrCube = (com.sas.metadata.remote.Cube)cubes.get(i);
                        if (mId != null ? mId.equalsIgnoreCase(omrCube.getId()) : omrCube.getName().equalsIgnoreCase(this._owningCube.getCubeName())) break;
                    }
                }
                outCube = omrCube != null ? (OMACube)this.getReposObject((CMetadata)omrCube) : null;
            }
            catch (MdException e) {
                this.error(e);
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
        return outCube;
    }

    @Override
    public OMAResourceImpl getResourceContainer() throws MetadataException {
        return (OMAResourceImpl)((Object)this.getOwningCube());
    }

    @Override
    public String getRelationshipNameFromKnownConstrainer() {
        return "Dimensions";
    }

    @Override
    public int getExpressionType() {
        return ExpressionUtil.getExprType(1);
    }

    private void loadData() throws MetadataException {
        if (!this._isDataLoaded) {
            this.unresolvedCheck();
            try {
                com.sas.metadata.remote.Hierarchy defaultHierarchy;
                String defaultHierarchyUniqueName = null;
                AssociationList hierarchies = this._omrDimension.getHierarchies();
                if (hierarchies.size() > 0 && (defaultHierarchy = (com.sas.metadata.remote.Hierarchy)hierarchies.get(0)) != null) {
                    defaultHierarchyUniqueName = defaultHierarchy.getUniqueName();
                }
                this._uniqueName = defaultHierarchyUniqueName == null ? "[" + this._omrDimension.getName() + "]" : defaultHierarchyUniqueName;
                this._isDataLoaded = true;
            }
            catch (MdException e) {
                this.error(e);
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
    }

    @Override
    public boolean isInMeasureDimension() throws MetadataException {
        return this.getDimensionType() == 1;
    }

    @Override
    public Dimension getOwningDimension() throws MetadataException {
        return this;
    }

    @Override
    public String getCubeName() throws MetadataException {
        Cube cube = this.getOwningCube();
        return cube.getLabel();
    }

    @Override
    public String getUniqueName() throws MetadataException {
        if (!this._isDataLoaded) {
            this.loadData();
        }
        return this._uniqueName;
    }

    @Override
    public String getUniqueNameWithHierarchyAllMember() throws MetadataException {
        return this.getDimensionUniqueName();
    }

    @Override
    public void consumeExternalReferenceRelatedItems(RelatedObjectListsHolder rilsHolder) throws SAXException {
        super.consumeExternalReferenceRelatedItems(rilsHolder);
        this._unresolvedHierarchiesWhenUnresolved = rilsHolder.consumeObjects("Hierarchies", OMAHierarchy.class);
        this.setHierarchyToDimensionLinks();
    }

    private void setHierarchyToDimensionLinks() {
        for (OMAHierarchy unresolvedHierarchy : this._unresolvedHierarchiesWhenUnresolved) {
            unresolvedHierarchy.setOwningDimension(this);
        }
    }

    protected void addRelationshipsToUnresolvedResources(IdentityHashMap mapping) {
        this.noteRelationshipsWithOtherUnresolvedResources(mapping, "Hierarchies", this._unresolvedHierarchiesWhenUnresolved);
    }

    @Override
    protected void readExternalReferenceV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readExternalReferenceV1(thisElement, readingContext);
        this._unresolvedHierarchiesWhenUnresolved = OMADimension.pre92_readExternalReferenceListDirectlyUnderElement(thisElement, readingContext, "ReposHierarchy", new Class[]{OMAHierarchy.class});
        for (OMAHierarchy unresolvedHierarchy : this._unresolvedHierarchiesWhenUnresolved) {
            unresolvedHierarchy.setOwningDimension(this);
        }
        this._unresolvedLevelsWhenUnresolved = OMADimension.pre92_readExternalReferenceListDirectlyUnderElement(thisElement, readingContext, "ReposLevel", new Class[]{OMALevel.class});
        for (OMALevel unresolvedLevel : this._unresolvedLevelsWhenUnresolved) {
            unresolvedLevel.setOwningDimension(this);
        }
    }

    public void setOwningCube(OMACube inputOwningCube) {
        this._owningCube = inputOwningCube;
    }

    @Override
    public String getType() {
        return IQModelImplUtilities.getMessage("Type.Dimension.txt", new Object[0]);
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.Dimension;
    }

    public List getChildResources(ExternalResourceType type) throws MetadataException {
        return this.getHierarchies();
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        return this.getOwningCube();
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
        if (childResource != null) {
            if (childResource instanceof OMAHierarchy) {
                if (!this._unresolvedHierarchiesWhenUnresolved.contains(childResource)) {
                    this._unresolvedHierarchiesWhenUnresolved.add(childResource);
                    ((OMAHierarchy)childResource).setOwningDimension(this);
                }
            } else if (childResource instanceof OMALevel && !this._unresolvedLevelsWhenUnresolved.contains(childResource)) {
                this._unresolvedLevelsWhenUnresolved.add(childResource);
                ((OMALevel)childResource).setOwningDimension(this);
            }
        }
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
        if (parentResource != null && parentResource instanceof OMACube) {
            this.setOwningCube((OMACube)parentResource);
        }
    }
}

