/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.oma.OMAMeasure;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.metadata.remote.CalculatedMeasure;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.rmi.RemoteException;
import java.util.StringTokenizer;

public class OMACalculatedMeasure
extends OMAMeasure
implements Measure {
    private static final long serialVersionUID = 1L;
    private CalculatedMeasure _omrCalculatedMeasure;

    public OMACalculatedMeasure() {
    }

    public OMACalculatedMeasure(CalculatedMeasure omrMeasure, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((com.sas.metadata.remote.Measure)omrMeasure, session, metadataServer);
        this._omrCalculatedMeasure = omrMeasure;
    }

    @Override
    protected String getDefinitionElementName() {
        return "ReposCalculatedMeasure";
    }

    @Override
    public String getMeasureCaption() throws MetadataException {
        return this.getLabel();
    }

    @Override
    public int getAggregator() throws MetadataException {
        return 8;
    }

    @Override
    public String getType() {
        return IQMetadataResourceBundle.getStringResource("Type.CalculatedMeasure.txt");
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.CalculatedMeasure;
    }

    @NonNull
    public String getGroupLabel() throws MetadataException {
        this.unresolvedCheck();
        String expressionAttribute = null;
        try {
            expressionAttribute = this._omrCalculatedMeasure.getExpression();
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return OMACalculatedMeasure.parseOutGroup(expressionAttribute);
    }

    @Override
    public String getSasFormat() throws MetadataException {
        this.unresolvedCheck();
        String expressionAttribute = null;
        try {
            expressionAttribute = this._omrCalculatedMeasure.getExpression();
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return OMACalculatedMeasure.parseOutFormat(expressionAttribute);
    }

    private static String parseOutGroup(String omrExpressionAttr) {
        String groupLabel = null;
        if (omrExpressionAttr != null) {
            StringTokenizer st = new StringTokenizer(omrExpressionAttr, "\"', =", true);
            while (st.hasMoreTokens() && groupLabel == null) {
                String tok = OMACalculatedMeasure.nextNonBlankToken(st);
                if (tok.toUpperCase().equals("GROUP")) {
                    tok = OMACalculatedMeasure.nextNonBlankToken(st);
                    if (tok.equals("=")) {
                        groupLabel = OMACalculatedMeasure.parseToNextUnquotedComma(st, null);
                        groupLabel = groupLabel.replaceAll("['\"]", "");
                        continue;
                    }
                    OMACalculatedMeasure.parseToNextUnquotedComma(st, tok);
                    continue;
                }
                OMACalculatedMeasure.parseToNextUnquotedComma(st, tok);
            }
        }
        if (groupLabel == null) {
            groupLabel = "";
        }
        return groupLabel;
    }

    private static String parseOutFormat(String omrExpressionAttr) {
        String format = null;
        if (omrExpressionAttr != null) {
            StringTokenizer st = new StringTokenizer(omrExpressionAttr, "\"', =", true);
            while (st.hasMoreTokens() && format == null) {
                String tok = OMACalculatedMeasure.nextNonBlankToken(st);
                if (tok.toUpperCase().equals("FORMAT_STRING")) {
                    tok = OMACalculatedMeasure.nextNonBlankToken(st);
                    if (tok.equals("=")) {
                        format = OMACalculatedMeasure.parseToNextUnquotedComma(st, null);
                        format = format.replaceAll("['\"\\s]", "");
                        continue;
                    }
                    OMACalculatedMeasure.parseToNextUnquotedComma(st, tok);
                    continue;
                }
                OMACalculatedMeasure.parseToNextUnquotedComma(st, tok);
            }
        }
        if (format == null) {
            format = "";
        }
        return format;
    }

    private static String parseToNextUnquotedComma(StringTokenizer st, String currentToken) {
        boolean inSingleQuote = currentToken == null ? false : currentToken.equals("'");
        boolean inDoubleQuote = currentToken == null ? false : currentToken.equals("\"");
        StringBuffer sb = new StringBuffer();
        String token = currentToken;
        boolean done = false;
        while (st.hasMoreTokens() && !done) {
            if (token != null) {
                sb.append(token);
            }
            if ((token = st.nextToken()).equals("'")) {
                if (!inDoubleQuote) {
                    inSingleQuote = !inSingleQuote;
                }
            } else if (token.equals("\"") && !inSingleQuote) {
                boolean bl = inDoubleQuote = !inDoubleQuote;
            }
            if (inSingleQuote || inDoubleQuote || !token.equals(",")) continue;
            done = true;
        }
        return sb.toString();
    }

    private static String nextNonBlankToken(StringTokenizer st) {
        String tok = st.nextToken();
        while (tok.trim().length() == 0) {
            if (st.hasMoreTokens()) {
                tok = st.nextToken();
                continue;
            }
            tok = "";
            break;
        }
        return tok;
    }
}

