/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.inmemory;

import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.MetadataRepositoryResource;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.AccessPathToRelationalData;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Index;
import com.sas.iquery.metadata.physical.Key;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.RelationalServer;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.StructuredData;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.TableResource;
import com.sas.iquery.metadata.physical.inmemory.InMemoryColumn;
import com.sas.iquery.metadata.physical.inmemory.InMemoryFactory;
import com.sas.iquery.metadata.physical.inmemory.InMemoryResourceImpl;
import com.sas.iquery.metadata.physical.inmemory.InMemorySASLibrary;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class InMemoryTable
extends InMemoryResourceImpl
implements Table,
TableResource,
StructuredData {
    private InMemoryFactory _factory = InMemoryFactory.getInstance();
    protected Schema _schema;
    protected List<InMemoryColumn> _columns = new ArrayList<InMemoryColumn>();
    protected String _options;
    private boolean _hasCurrentPfsMetadata;
    private static final Logger _logger = LogManager.getLogger(InMemoryTable.class);

    protected boolean hasCurrentPfsMetadata() {
        return this._hasCurrentPfsMetadata;
    }

    protected void setHasCurrentPfsMetadata(boolean hasCurrentPfsMetadata) {
        this._hasCurrentPfsMetadata = hasCurrentPfsMetadata;
    }

    public InMemoryTable() {
        this._schema = null;
        this._options = "";
    }

    InMemoryTable(String name, RelationalSchema schema) throws MetadataException {
        this.setLabel(name);
        this._schema = schema;
        this._options = "";
    }

    public InMemoryTable(InMemoryTable table) {
        super(table);
        this._schema = table._schema;
        this._options = table._options;
        this._columns.addAll(table._columns);
    }

    public void setColumns(List columns) {
        this._columns = columns;
    }

    @Override
    protected String getDefinitionElementName() {
        return "InMemoryTable";
    }

    @Override
    public void consumeExternalReferenceAttributes(AttributesProvider attrsProvider) throws SAXException {
        String numColsAttr;
        super.consumeExternalReferenceAttributes(attrsProvider);
        ReadingContextV2 readingContext = attrsProvider.getReadingContext();
        String charColsAttr = attrsProvider.consumeAttr("charCols");
        if (charColsAttr != null) {
            this.parseAndAddColumns(charColsAttr, readingContext, false);
        }
        if ((numColsAttr = attrsProvider.consumeAttr("numCols")) != null) {
            this.parseAndAddColumns(numColsAttr, readingContext, true);
        }
        for (InMemoryColumn column : this._columns) {
            column.setOwningTable(this);
        }
    }

    private void parseAndAddColumns(String attr, ReadingContextV2 readingContext, boolean colTypeIsNumeric) throws SAXException {
        boolean done = false;
        int semiColon = -1;
        int columnTextStart = 0;
        boolean columnHasDoubledSemicolons = false;
        while (!done) {
            if ((semiColon = attr.indexOf(59, semiColon + 1)) == -1) {
                String text = attr.substring(columnTextStart);
                this.processColumnText(text, readingContext, colTypeIsNumeric, columnHasDoubledSemicolons);
                done = true;
                continue;
            }
            if (semiColon + 1 >= attr.length()) continue;
            char nextChar = attr.charAt(semiColon + 1);
            if (nextChar == ';') {
                ++semiColon;
                columnHasDoubledSemicolons = true;
                continue;
            }
            String text = attr.substring(columnTextStart, semiColon);
            this.processColumnText(text, readingContext, colTypeIsNumeric, columnHasDoubledSemicolons);
            columnTextStart = semiColon + 1;
            columnHasDoubledSemicolons = false;
        }
    }

    private void processColumnText(String columnText, ReadingContextV2 readingContext, boolean colTypeIsNumeric, boolean hasSemi) throws SAXException {
        int iComma;
        if (hasSemi) {
            columnText = InMemoryTable.unDoubleSemicolons(columnText);
        }
        if ((iComma = columnText.indexOf(44)) >= 0) {
            String columnPersistenceID = columnText.substring(0, iComma);
            String sasName = columnText.substring(iComma + 1);
            InMemoryColumn column = (InMemoryColumn)readingContext.getObjectForNewObjectElement(columnPersistenceID, "InMemoryColumn");
            column.setLabel(sasName);
            column.setSasName(sasName);
            column.setSasType(colTypeIsNumeric ? "N" : "C");
            this._columns.add(column);
        }
    }

    private static String unDoubleSemicolons(String text) {
        StringBuffer buf = new StringBuffer(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            buf.append(c);
            if (c != ';' || i + 1 >= text.length() || text.charAt(i + 1) != ';') continue;
            ++i;
        }
        return buf.toString();
    }

    public void setSchema(Schema schema) {
        this._schema = schema;
    }

    public Schema getSchema() throws MetadataException {
        return this._schema;
    }

    @Deprecated
    public void setRelationalSchema(RelationalSchema schema) {
        this._schema = schema;
    }

    @Override
    @Deprecated
    public RelationalSchema getRelationalSchema() throws MetadataException {
        return this._schema instanceof RelationalSchema ? (RelationalSchema)this._schema : null;
    }

    public void setAccessPath(AccessPathToRelationalData accessPath) {
        this.setSchema(accessPath.getSchema());
    }

    @Override
    @Nonnull
    public List<AccessPath> getAccessPaths() {
        AccessPathToRelationalData path = new AccessPathToRelationalData();
        path.setSchema(this._schema);
        if (this._schema instanceof SASLibrary) {
            try {
                List<SoftwareServer> servers = ((SASLibrary)this._schema).getSoftwareServers();
                assert (!servers.isEmpty());
                path.setRelationalServer((RelationalServer)servers.get(0));
            }
            catch (MetadataException e) {
                _logger.debug("Exception trying to get software server on InMemoryTable", (Throwable)e);
            }
        }
        return Collections.singletonList(path);
    }

    public List<Column> getColumns(boolean forceQueryToPfs) throws MetadataException {
        if (forceQueryToPfs) {
            return this.getColumns();
        }
        return new ArrayList<Column>(this._columns);
    }

    @Override
    public List<Column> getColumns() throws MetadataException {
        Schema schema;
        List<AccessPath> aps;
        AccessPath ap;
        List<InMemoryColumn> oldColumns = this._columns;
        if (!this._hasCurrentPfsMetadata && (ap = (aps = this.getAccessPaths()).get(0)) != null && (schema = ap.getSchema()) instanceof InMemorySASLibrary) {
            InMemorySASLibrary inMemorySASLibrary = (InMemorySASLibrary)schema;
            try {
                this._factory.updateTable(inMemorySASLibrary, this, oldColumns);
            }
            catch (ExecutionException e) {
                throw new MetadataException(e);
            }
        }
        return new ArrayList<Column>(oldColumns);
    }

    public List<InMemoryColumn> getInMemoryColumns() throws MetadataException {
        Schema schema;
        List<AccessPath> aps;
        AccessPath ap;
        List<InMemoryColumn> oldColumns = this._columns;
        if (!this._hasCurrentPfsMetadata && (ap = (aps = this.getAccessPaths()).get(0)) != null && (schema = ap.getSchema()) instanceof InMemorySASLibrary) {
            InMemorySASLibrary inMemorySASLibrary = (InMemorySASLibrary)schema;
            try {
                this._factory.updateTable(inMemorySASLibrary, this, oldColumns);
            }
            catch (ExecutionException e) {
                throw new MetadataException(e);
            }
        }
        return new ArrayList<InMemoryColumn>(oldColumns);
    }

    public List<Index> getIndexes() throws MetadataException {
        String errorMsg = IQModelImplUtilities.getMessage("BusinessModelImplUnsupportedMethod.txt", new Object[0]);
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    public String getSasName() throws MetadataException {
        return this.getLabel();
    }

    @Override
    public String getDbmsName() throws MetadataException {
        return this.getLabel();
    }

    @Override
    public String getDataSetOptionsAsString() {
        return this._options;
    }

    public void setDataSetOptionsAsString(String options) {
        this._options = options;
    }

    @Override
    public List<Key> getKeys() throws MetadataException {
        String errorMsg = IQModelImplUtilities.getMessage("BusinessModelImplUnsupportedMethod.txt", new Object[0]);
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    public <T extends Key> List<T> getKeys(@Nonnull Class<T> type) throws MetadataException {
        String errorMsg = IQModelImplUtilities.getMessage("BusinessModelImplUnsupportedMethod.txt", new Object[0]);
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._schema = (RelationalSchema)InMemoryTable.replace(this._schema, oldObject, newObject);
        InMemoryTable.replaceInList(this._columns, oldObject, newObject);
    }

    @Override
    public String getType() {
        return IQModelImplUtilities.getMessage("Type.Table.txt", new Object[0]);
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
    }

    @Override
    public List<PhysicalResource> getChildResources(ExternalResourceType type) throws MetadataException {
        return new ArrayList<PhysicalResource>(this._columns);
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        return this._schema;
    }

    @Override
    public String getSearchString() throws MetadataException {
        StringBuffer search = new StringBuffer("*[@Name='");
        search.append(this.getLabel());
        search.append("'][");
        ResourceRelationshipInterface parent = (ResourceRelationshipInterface)((Object)this._schema);
        ExternalResourceType ctype = this.getResourceType();
        search.append(parent.getUsedBySearchString(ctype));
        search.append("]");
        return search.toString();
    }

    @Override
    public String getUsedBySearchString(ExternalResourceType usingType) throws MetadataException {
        ResourceRelationshipInterface parent = (ResourceRelationshipInterface)((Object)this._schema);
        ExternalResourceType type = this.getResourceType();
        String associationName = usingType.getAssociationToTypeName(type);
        StringBuffer search = new StringBuffer(associationName);
        search.append("/*[@Name='").append(this.getLabel()).append("']/").append(parent.getUsedBySearchString(type));
        return search.toString();
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
    }

    @Override
    public void setUnresolvedProperties(PhysicalResource sourceResource) throws MetadataException {
    }

    @Override
    public MetadataRepositoryResource getConstrainingResource() throws MetadataException {
        return (MetadataRepositoryResource)((Object)this._schema);
    }

    @Override
    public String getRelationshipNameFromKnownConstrainer() {
        return "Tables";
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.Table;
    }

    @Override
    public void setAccessingSASLibraryWhenUnresolved(SASLibrary library) {
        this._schema = library;
    }

    @Override
    public StructureOfData getStructure() {
        return StructureOfData.RELATIONAL;
    }
}

