/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.inmemory;

import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.MetadataRepositoryResource;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.LibraryResource;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.inmemory.InMemoryFactory;
import com.sas.iquery.metadata.physical.inmemory.InMemorySchema;
import com.sas.iquery.metadata.physical.inmemory.InMemoryTable;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.session.SessionContextInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class InMemorySASLibrary
extends InMemorySchema
implements SASLibrary,
LibraryResource {
    InMemoryFactory _factory = InMemoryFactory.getInstance();
    private String _engine;
    private String _path;
    private String _options;
    private boolean _isPreassigned;
    private boolean _hasCurrentListOfTables = false;
    private boolean _usePlatformServices = false;
    private List<InMemoryTable> _tables = new ArrayList<InMemoryTable>();
    private SASWorkspaceServer _server;
    private SessionContextInterface _session;
    private IntelligentQueryMetadataServiceInterface _service;

    public InMemorySASLibrary() {
        this._engine = null;
        this._path = null;
        this._options = null;
    }

    public InMemorySASLibrary(InMemorySASLibrary lib) {
        super(lib);
        this._engine = lib._engine;
        this._path = lib._path;
        this._options = lib._options;
        this._isPreassigned = lib._isPreassigned;
        this._server = lib._server;
        this._usePlatformServices = lib._usePlatformServices;
        this._tables.addAll(lib._tables);
    }

    public InMemorySASLibrary(String libref, String path, String engine, String options) {
        this.setLabel(libref);
        this._engine = engine;
        this._path = path;
        this._options = options;
    }

    @Override
    protected String getDefinitionElementName() {
        return "InMemoryLibrary";
    }

    @Override
    protected void writeExternalReference(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeExternalReference(thisElement, writingContext);
        boolean suppressVersion93 = Boolean.getBoolean("SASQueryServices.suppressVersion93");
        if (!suppressVersion93) {
            writingContext.adjustModelVersion(ModelVersion.VERSION_93);
        }
        IQModelImplUtilities.setAttr(thisElement, "location", this._path == null || this._path.trim().length() == 0 ? null : this._path);
        IQModelImplUtilities.setAttr(thisElement, "engine", this._engine == null || this._engine.trim().length() == 0 ? null : this._engine);
        IQModelImplUtilities.setAttr(thisElement, "options", this._options == null || this._options.trim().length() == 0 ? null : this._options);
        IQModelImplUtilities.setBooleanAttr(thisElement, "preassigned", this._isPreassigned, false);
        IQModelImplUtilities.setBooleanAttr(thisElement, "usePlatformServices", this._usePlatformServices, false);
    }

    @Override
    public void consumeExternalReferenceAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeExternalReferenceAttributes(attrsProvider);
        this._path = attrsProvider.consumeAttr("location");
        this._engine = attrsProvider.consumeAttr("engine");
        this._options = attrsProvider.consumeAttr("options");
        this._isPreassigned = attrsProvider.consumeBooleanAttr("preassigned", false);
        this._usePlatformServices = attrsProvider.consumeBooleanAttr("usePlatformServices", false);
    }

    @Override
    public void consumeExternalReferenceRelatedItems(RelatedObjectListsHolder rilsHolder) throws SAXException {
        super.consumeExternalReferenceRelatedItems(rilsHolder);
        this._tables.addAll(rilsHolder.consumeObjects("Tables", InMemoryTable.class));
        for (InMemoryTable table : this._tables) {
            table.setAccessingSASLibraryWhenUnresolved(this);
        }
    }

    @Override
    public String getLibref() throws MetadataException {
        return this.getLabel();
    }

    @Override
    public String getEngine() throws MetadataException {
        String engine = this._engine != null ? this._engine : "";
        return engine;
    }

    @Override
    public boolean isPreassigned() throws MetadataException {
        return this._isPreassigned;
    }

    @Override
    public String getLibnameStatement() throws MetadataException {
        return this.getLibnameStatement(false);
    }

    @Override
    public String getLibnameStatement(boolean ignorePreassigned) throws MetadataException {
        return this.getLibnameStatement(ignorePreassigned, false);
    }

    @Override
    public String getLibnameStatement(boolean ignorePreassigned, boolean createAsReadonly) throws MetadataException {
        StringBuilder returnValue;
        if (this._isPreassigned && !ignorePreassigned) {
            returnValue = new StringBuilder();
        } else {
            String options;
            String path;
            String engine;
            returnValue = new StringBuilder();
            returnValue.append("LIBNAME ");
            String label = this.getLabel();
            if (label != null) {
                returnValue.append(this.getLabel() + " ");
            }
            if ((engine = this.getEngine()) != null) {
                returnValue.append(this.getEngine() + " ");
            }
            if ((path = this.getPath()) != null && path.length() > 0) {
                returnValue.append("'" + path + "' ");
            }
            if ((options = this.getOptions()) != null) {
                returnValue.append(options);
            }
            returnValue.append(createAsReadonly ? " ACCESS=READONLY;" : ";");
        }
        return returnValue.toString();
    }

    @Override
    public String getConnectStatementForExplicitPassThru(String connectionName) throws MetadataException {
        throw new UnsupportedOperationException(IQMetadataResourceBundle.getStringResource("InMemorySASLibrary.ConnectToStatement.txt"));
    }

    @Override
    public List<SoftwareServer> getSoftwareServers() {
        List<SoftwareServer> servers = this._server == null ? Collections.emptyList() : Collections.singletonList(this._server);
        return servers;
    }

    public List<InMemoryTable> getTables() throws MetadataException {
        return this._tables;
    }

    @Override
    public List<Table> getAccessibleTables() throws MetadataException {
        if (this.usePlatformServices() && !this._hasCurrentListOfTables) {
            List<InMemoryTable> inMemoryTables;
            try {
                inMemoryTables = this._factory.newTables(this.getSessionContext(), this.getSASWorkspaceServer(), this);
            }
            catch (ExecutionException e) {
                throw new MetadataException(e);
            }
            this._tables = inMemoryTables;
            this._hasCurrentListOfTables = true;
        }
        ArrayList<Table> tables = new ArrayList<Table>(this._tables);
        return tables;
    }

    @Override
    public List<Table> getContainedTables() throws MetadataException {
        return this.getAccessibleTables();
    }

    @Override
    @CheckForNull
    public Table getTableWithLabel(String tableLabel) throws MetadataException {
        Table outTable = null;
        if (!this.usePlatformServices() || this._hasCurrentListOfTables) {
            for (Table table : this._tables) {
                if (!IQModelImplUtilities.sameIgnoreCase(table.getLabel(), tableLabel)) continue;
                if (outTable != null) {
                    Object[] args = new Object[]{tableLabel, this};
                    String msgKey = "OMARelationalSchema.DuplicateTableFound.fmt.txt";
                    MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter(msgKey, args);
                    Reason reason = new Reason((Object)this, 6, 80, msgKey, args);
                    MetadataException me = new MetadataException(errorMsg, Arrays.asList(reason));
                    throw me;
                }
                outTable = table;
            }
        } else {
            try {
                InMemoryTable inMemoryTable;
                outTable = inMemoryTable = this._factory.newTable(this.getSessionContext(), this.getSASWorkspaceServer(), this, tableLabel);
            }
            catch (ExecutionException e) {
                throw new MetadataException(e);
            }
        }
        return outTable;
    }

    public void setTables(List<InMemoryTable> tables) {
        this._tables = tables;
    }

    public void setSoftwareServers(List servers) {
        if (servers != null) {
            for (Object obj : servers) {
                if (!(obj instanceof SASWorkspaceServer)) continue;
                this.setSASWorkspaceServer((SASWorkspaceServer)obj);
                break;
            }
        }
    }

    public SASWorkspaceServer getSASWorkspaceServer() {
        return this._server;
    }

    public void setSASWorkspaceServer(SASWorkspaceServer server) {
        this._server = server;
    }

    public String getPath() {
        String path = this._path != null ? this._path : "";
        return path;
    }

    public String getOptions() {
        String options = this._options != null ? this._options : "";
        return options;
    }

    public void setIsPreassigned(boolean flag) {
        this._isPreassigned = flag;
    }

    public boolean usePlatformServices() {
        return this._usePlatformServices;
    }

    public void setUsePlatformServices(boolean usePlatformServices) {
        this._usePlatformServices = usePlatformServices;
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInNonDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        if (oldObject instanceof SASWorkspaceServer) {
            this._server = (SASWorkspaceServer)newObject;
        } else if (oldObject instanceof Table) {
            InMemorySASLibrary.replaceInList(this._tables, oldObject, newObject);
        }
    }

    @Override
    public String getDBMSHost() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDBMSPort() throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType() {
        return IQModelImplUtilities.getMessage("Type.SASLibrary.txt", new Object[0]);
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
    }

    @Override
    public List<PhysicalResource> getChildResources(ExternalResourceType type) throws MetadataException {
        return ListUtils.newList(this._tables);
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        return this._server;
    }

    @Override
    public String getSearchString() throws MetadataException {
        StringBuilder search = new StringBuilder("*[@Name='");
        search.append(this.getLabel());
        search.append("'][");
        ResourceRelationshipInterface parent = (ResourceRelationshipInterface)((Object)this._server);
        ExternalResourceType ctype = this.getResourceType();
        search.append(parent.getUsedBySearchString(ctype));
        search.append("]");
        return search.toString();
    }

    @Override
    public String getUsedBySearchString(ExternalResourceType usingType) throws MetadataException {
        ResourceRelationshipInterface parent = (ResourceRelationshipInterface)((Object)this._server);
        ExternalResourceType type = this.getResourceType();
        String associationName = usingType.getAssociationToTypeName(type);
        StringBuilder search = new StringBuilder(associationName);
        search.append("/*[@Name='").append(this.getLabel()).append("']/").append(parent.getUsedBySearchString(type));
        return search.toString();
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
    }

    @Override
    public void setUnresolvedProperties(PhysicalResource sourceResource) throws MetadataException {
    }

    @Override
    public MetadataRepositoryResource getConstrainingResource() throws MetadataException {
        return null;
    }

    @Override
    public String getRelationshipNameFromKnownConstrainer() {
        return "SASLibraries";
    }

    @Override
    public void setAccessingServerWhenUnresolved(SASWorkspaceServer server) {
        this._server = server;
    }

    @Override
    public SASWorkspaceServer getAccessingServerWhenUnresolved() {
        return this._server;
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.Library;
    }

    public SessionContextInterface getSessionContext() {
        return this._session;
    }

    public void setSessionContext(SessionContextInterface session) {
        this._session = session;
    }

    public IntelligentQueryMetadataServiceInterface getService() {
        return this._service;
    }

    public void setService(IntelligentQueryMetadataServiceInterface service) {
        this._service = service;
    }

    @Override
    public List<String> getTableLabels() throws MetadataException {
        List<String> tableLabels;
        if (this.usePlatformServices() && !this._hasCurrentListOfTables) {
            try {
                tableLabels = this._factory.getDataSetNames(this.getSessionContext(), this.getSASWorkspaceServer(), this);
            }
            catch (ExecutionException e) {
                throw new MetadataException(e);
            }
        } else {
            tableLabels = new ArrayList<String>();
            for (Table table : this._tables) {
                tableLabels.add(table.getLabel());
            }
        }
        return tableLabels;
    }

    public void validate() throws MetadataException {
        SASWorkspaceServer workspaceServer = this.getSASWorkspaceServer();
        SessionContextInterface sessionContext = this.getSessionContext();
        if (!this._usePlatformServices) {
            String msg = IQMetadataResourceBundle.getStringResource("InMemorySASLibrary.ValidateNonPfsLibrary.txt");
            MetadataException me = new MetadataException(msg);
            throw me;
        }
        try {
            this._factory.validate(sessionContext, workspaceServer, this);
        }
        catch (ExecutionException e) {
            throw new MetadataException(e);
        }
    }
}

