/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.inmemory;

import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.MetadataRepositoryResource;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.QueryTable;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.inmemory.InMemoryColumn;
import com.sas.iquery.metadata.physical.inmemory.InMemoryFactory;
import com.sas.iquery.metadata.physical.inmemory.InMemorySASLibrary;
import com.sas.iquery.metadata.physical.inmemory.InMemoryTable;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.services.session.SessionContextInterface;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class InMemoryQueryTable
extends InMemoryTable
implements QueryTable {
    private final InMemoryFactory _factory = InMemoryFactory.getInstance();
    public static final String WORK_SCHEMA = "WORK";
    public static final String TEMP_SCHEMA = "TEMP";
    private static final String TABLE_NAME_TEMPLATE = "%FullQueryText%";
    private final List<SASLibrary> _libraries = new ArrayList<SASLibrary>();
    private String _queryText = null;
    private boolean _isComplexQuery = false;
    private Locale _computationalLocale = null;
    private SASLibrary _outputSASLibrary = null;
    private SASWorkspaceServer _outputServer = null;
    private String _outputSchemaName = null;
    private SessionContextInterface _session = null;
    private IntelligentQueryMetadataServiceInterface _service = null;
    private static final Logger _perfLogger = LogManager.getLogger((String)"com.sas.iquery.perf.DataServer");
    private static final Logger _logger = LogManager.getLogger(InMemoryQueryTable.class);
    private boolean _alreadyPreparedOnQC = false;
    private QueryConnector _queryConnector = null;
    private StringBuffer _prepareLog = new StringBuffer();

    public InMemoryQueryTable() {
    }

    InMemoryQueryTable(String name, RelationalSchema schema) throws MetadataException {
        super(name, schema);
    }

    public InMemoryQueryTable(InMemoryQueryTable table) {
        super(table);
        this._queryText = table._queryText;
        this._isComplexQuery = table._isComplexQuery;
        this._computationalLocale = table._computationalLocale;
        this._outputSASLibrary = table._outputSASLibrary;
        this._outputServer = table._outputServer;
        this._outputSchemaName = table._outputSchemaName;
        this._session = table._session;
        this._service = table._service;
        this._libraries.addAll(table._libraries);
    }

    @Override
    public Locale getComputationalLocale() {
        Locale queryLocale = null;
        if (this._queryConnector != null) {
            queryLocale = this._queryConnector.getComputationalLocale();
        }
        if (queryLocale == null && (queryLocale = this._computationalLocale) == null) {
            queryLocale = LocaleUtilities.getDefaultComputationalLocale(this._session);
        }
        return queryLocale;
    }

    @Override
    public void setComputationalLocale(Locale computationalLocale) {
        this._computationalLocale = computationalLocale;
    }

    @Override
    public String getOutputSchemaName() {
        return this._outputSchemaName;
    }

    @Override
    public void setOutputSchemaName(String outputSchemaName) {
        this._outputSchemaName = outputSchemaName;
    }

    @Override
    public SASWorkspaceServer getOutputServer() {
        return this._outputServer;
    }

    @Override
    public void setOutputServer(SASWorkspaceServer outputServer) {
        this._outputServer = outputServer;
    }

    @Override
    public List<SASLibrary> getLibraries() {
        return new ArrayList<SASLibrary>(this._libraries);
    }

    @Override
    public void setLibraries(List<? extends SASLibrary> libraries) {
        this._libraries.clear();
        this._libraries.addAll(libraries);
    }

    @Override
    public boolean isComplexQuery() {
        return this._isComplexQuery;
    }

    @Override
    public void setComplexQuery(boolean isComplexQuery) {
        this._isComplexQuery = isComplexQuery;
    }

    @Override
    public String getQueryText() {
        return this._queryText;
    }

    @Override
    public String getFullQueryText(boolean includeLibnames, boolean prepareFlag) throws MetadataException {
        if (this._alreadyPreparedOnQC && !prepareFlag && this.isComplexQuery()) {
            return "";
        }
        String query = this._factory.getInMemoryQueryTableText(includeLibnames, prepareFlag, TABLE_NAME_TEMPLATE, this.getLabel(), this.getComputationalLocale(), this.getOutputSchemaName(), this._outputSASLibrary, this.getQueryText(), this.isComplexQuery(), this.getLibraries());
        query = this._factory.resolveTemplateText(query, TABLE_NAME_TEMPLATE, this.getLabel());
        return query;
    }

    @Override
    public void setQueryText(String queryText) {
        this._queryText = queryText;
    }

    @Override
    public SessionContextInterface getSessionContext() {
        return this._session;
    }

    @Override
    public void setSessionContext(SessionContextInterface session) {
        this._session = session;
    }

    @Override
    public IntelligentQueryMetadataServiceInterface getService() {
        return this._service;
    }

    @Override
    public void setService(IntelligentQueryMetadataServiceInterface service) {
        this._service = service;
    }

    @Override
    public void prepare() throws ExecutionException, GenerationException, MetadataException {
        long startTime = System.nanoTime();
        this._prepare();
        boolean forceRerun = true;
        QueryConnector qc = this.getQueryConnector();
        if (qc != null) {
            forceRerun = qc.getRetrievalPolicy().getPolicyValue() == 0;
        }
        this.buildColumns(qc, forceRerun);
        if (qc != null) {
            this._alreadyPreparedOnQC = true;
        }
        if (_logger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startTime;
            double elapsedSeconds = (double)elapsedNanos / 1.0E9;
            DecimalFormat formatter = new DecimalFormat();
            _perfLogger.info("InMemoryQueryTable#prepare() " + this.getLabel() + " prepared; time= " + formatter.format(elapsedSeconds) + " secs");
        }
    }

    private void buildColumns(Object source, boolean forceRerun) throws MetadataException, ExecutionException, GenerationException {
        if (forceRerun) {
            this._prepareLog.setLength(0);
        }
        String submitText = this.getFullQueryText(true, true);
        String libref = this._outputSASLibrary != null ? this._outputSASLibrary.getLibref() : WORK_SCHEMA;
        Locale queryLocale = this.getComputationalLocale();
        String outputTableName = this.getLabel();
        SASWorkspaceServer outputServer = this.getOutputServer();
        SessionContextInterface sessionContext = this.getSessionContext();
        if (source instanceof QueryConnector) {
            QueryConnector qc = (QueryConnector)source;
            qc.setComputationalLocale(queryLocale);
            this._columns = this._factory.newColumns(sessionContext, outputServer, libref, queryLocale, submitText, TABLE_NAME_TEMPLATE, outputTableName, qc, this._prepareLog, forceRerun || !this._alreadyPreparedOnQC);
        } else if (source instanceof List) {
            this._columns = new ArrayList((List)source);
            this._prepareLog.append("/* user defined in-memory columns used, no pre-query run for " + libref + "." + outputTableName + " */");
        } else {
            this._columns = this._factory.newColumns(sessionContext, outputServer, libref, queryLocale, submitText, TABLE_NAME_TEMPLATE, outputTableName, this._prepareLog);
        }
        for (InMemoryColumn c : this._columns) {
            if (null == c.getSasType() || null == c.getSasName()) {
                String msg = IQDataServicesResourceBundle.getStringResource("InMemoryQueryTable.InvalidColumn.txt");
                throw new ExecutionException(msg);
            }
            c.setOwningTable(this);
        }
    }

    @Override
    public void prepare(List<? extends InMemoryColumn> columns) throws MetadataException, ExecutionException, GenerationException {
        long startTime = System.nanoTime();
        this._prepare();
        this.buildColumns(columns, true);
        if (_logger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startTime;
            double elapsedSeconds = (double)elapsedNanos / 1.0E9;
            DecimalFormat formatter = new DecimalFormat();
            _perfLogger.info("InMemoryQueryTable#prepare() " + this.getLabel() + " prepared; time= " + formatter.format(elapsedSeconds) + " secs");
        }
    }

    private void _prepare() throws ExecutionException, MetadataException {
        boolean isTemp;
        boolean isWork;
        if (this._outputServer == null) {
            String msg = IQDataServicesResourceBundle.getStringResource("InMemoryQueryTable.NullWorkspaceServer.txt");
            throw new ExecutionException(msg);
        }
        String outputTableName = this.getLabel();
        if (!GenerationUtil.isValidIdentifierName(outputTableName, 1)) {
            String msg = IQDataServicesResourceBundle.getMessageString("InMemoryQueryTable.InvalidName.fmt.txt", outputTableName);
            throw new ExecutionException(msg);
        }
        boolean isDefault = this._outputSchemaName == null;
        boolean bl = isWork = isDefault || IQModelImplUtilities.sameIgnoreCase(WORK_SCHEMA, this._outputSchemaName);
        if (isWork) {
            this._outputSchemaName = WORK_SCHEMA;
        }
        if (isTemp = IQModelImplUtilities.sameIgnoreCase(TEMP_SCHEMA, this._outputSchemaName)) {
            this._outputSchemaName = TEMP_SCHEMA;
        }
        SASLibrary outputSASLibrary = this.resolveSchema(this._outputSchemaName, isWork, isTemp, isDefault, this._libraries);
        this._schema = outputSASLibrary;
        this._outputSASLibrary = !isDefault ? outputSASLibrary : null;
    }

    private SASLibrary resolveSchema(String outputSchemaName, boolean isWork, boolean isTemp, boolean isDefault, List<SASLibrary> userProvidedLibraries) throws MetadataException, ExecutionException {
        InMemorySASLibrary inMemorySchema;
        SASWorkspaceServer outputServer = this.getOutputServer();
        SASLibrary schema = null;
        if (isDefault) {
            inMemorySchema = this._factory.newSASLibrary();
            inMemorySchema.setIsPreassigned(true);
            inMemorySchema.setLabel(null);
            String desc = IQMetadataResourceBundle.getMessageString("InMemoryQueryTable.DefaultLibrary.fmt.txt", this.getComputationalLocale(), outputSchemaName);
            inMemorySchema.setDescription(desc);
            inMemorySchema.setUsePlatformServices(false);
            inMemorySchema.setSASWorkspaceServer(outputServer);
            schema = inMemorySchema;
        } else {
            InMemorySASLibrary imsl;
            List<SASLibrary> workspaceLibraries;
            schema = this.search(userProvidedLibraries, outputSchemaName, false, false);
            if (schema == null) {
                schema = this.search(this._libraries, outputSchemaName, true, false);
            }
            if (schema == null && (schema = this.search(workspaceLibraries = outputServer.getSasLibraries(), outputSchemaName, false, true)) == null) {
                schema = this.search(workspaceLibraries, outputSchemaName, true, true);
            }
            if (schema == null) {
                if (isWork || isTemp) {
                    inMemorySchema = this._factory.newSASLibrary();
                    inMemorySchema.setIsPreassigned(true);
                    inMemorySchema.setLabel(outputSchemaName);
                    String desc = IQMetadataResourceBundle.getMessageString("InMemoryQueryTable.Description.fmt.txt", this.getComputationalLocale(), outputSchemaName);
                    inMemorySchema.setDescription(desc);
                    inMemorySchema.setUsePlatformServices(false);
                    inMemorySchema.setSASWorkspaceServer(outputServer);
                    schema = inMemorySchema;
                }
            } else if (schema instanceof InMemorySASLibrary && (imsl = (InMemorySASLibrary)schema).usePlatformServices()) {
                InMemorySASLibrary newInMemorySASLibrary = this._factory.newSASLibrary(imsl.getLabel(), imsl.getPath(), imsl.getEngine(), imsl.getOptions(), outputServer);
                newInMemorySASLibrary.setIsPreassigned(schema.isPreassigned());
                String desc = IQMetadataResourceBundle.getMessageString("InMemoryQueryTable.ShadowLibraryDesc.fmt.txt", this.getComputationalLocale(), schema.getLibref());
                newInMemorySASLibrary.setDescription(desc);
                newInMemorySASLibrary.setUsePlatformServices(false);
                schema = newInMemorySASLibrary;
            }
        }
        if (schema == null) {
            String msg = IQDataServicesResourceBundle.getMessageString("InMemoryQueryTable.CouldNotFindOutputSchema.fmt.txt", outputSchemaName);
            throw new ExecutionException(msg);
        }
        return schema;
    }

    private SASLibrary search(List<SASLibrary> libraries, String searchText, boolean matchOnLibref, boolean onlyPreassigned) throws MetadataException {
        SASLibrary found = null;
        for (SASLibrary library : libraries) {
            String compareToText;
            String string = compareToText = matchOnLibref ? library.getLibref() : library.getLabel();
            if (onlyPreassigned) {
                if (!library.isPreassigned() || !IQModelImplUtilities.sameIgnoreCase(compareToText, searchText)) continue;
                found = library;
                break;
            }
            if (!IQModelImplUtilities.sameIgnoreCase(compareToText, searchText)) continue;
            found = library;
            break;
        }
        return found;
    }

    @Override
    protected String getDefinitionElementName() {
        return "InMemoryQueryTable";
    }

    @Override
    protected void writeExternalReference(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeExternalReference(thisElement, writingContext);
        boolean suppressVersion93 = Boolean.getBoolean("SASQueryServices.suppressVersion93");
        if (!suppressVersion93) {
            writingContext.adjustModelVersion(ModelVersion.VERSION_93);
        }
        IQModelImplUtilities.setAttr(thisElement, "queryText", this.getQueryText());
        IQModelImplUtilities.setBooleanAttr(thisElement, "complex", this._isComplexQuery, false);
        InMemoryQueryTable.writeRelatedObjects(this._libraries, thisElement, writingContext, "SASLibraries");
    }

    @Override
    public void consumeExternalReferenceAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeExternalReferenceAttributes(attrsProvider);
        this._queryText = attrsProvider.consumeAttr("queryText");
        this._isComplexQuery = attrsProvider.consumeBooleanAttr("complex", false);
    }

    @Override
    public void consumeExternalReferenceRelatedItems(RelatedObjectListsHolder rilsHolder) throws SAXException {
        super.consumeExternalReferenceRelatedItems(rilsHolder);
        this._libraries.addAll(rilsHolder.consumeObjects("SASLibraries", SASLibrary.class));
    }

    @Override
    protected boolean mustCallConsumeRelatedObjects() {
        return true;
    }

    @Override
    protected void registerExternalResources(WritingContext writingContext) throws MetadataException {
        super.registerExternalResources(writingContext);
        for (SASLibrary sasLibrary : this._libraries) {
            writingContext.registerResources((AbstractBase)((Object)sasLibrary));
        }
    }

    @Override
    public MetadataRepositoryResource getConstrainingResource() throws MetadataException {
        return (MetadataRepositoryResource)((Object)this._schema);
    }

    @Override
    public String getRelationshipNameFromKnownConstrainer() {
        return "Tables";
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.Table;
    }

    @Override
    public void setQueryConnector(QueryConnector queryConnector) {
        this._queryConnector = queryConnector;
    }

    @Override
    public QueryConnector getQueryConnector() {
        return this._queryConnector;
    }

    public String getPrepareLog() {
        return this._prepareLog.toString();
    }
}

