/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.inmemory;

import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.IDataServicePackage.InvalidEngine;
import com.sas.iom.SAS.IDataServicePackage.LibraryInUse;
import com.sas.iom.SAS.IDataServicePackage.NoLibrary;
import com.sas.iom.SAS.IDataServicePackage.NoWorkDeassign;
import com.sas.iom.SAS.IDataSet;
import com.sas.iom.SAS.ILibref;
import com.sas.iom.SAS.ILibrefPackage.NoMember;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.InvalidLName;
import com.sas.iom.SAS.InvalidPName;
import com.sas.iom.SAS.InvalidPassword;
import com.sas.iom.SAS.LNameNoAssign;
import com.sas.iom.SAS.NoAccessMethod;
import com.sas.iom.SAS.NoReplace;
import com.sas.iom.SASIOMDefs.DateTimeHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.iom.SASIOMDefs.ShortSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.SASSubmitHandler;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.physical.RelationalServer;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.SchemaContainer;
import com.sas.iquery.metadata.physical.inmemory.InMemoryColumn;
import com.sas.iquery.metadata.physical.inmemory.InMemoryQueryTable;
import com.sas.iquery.metadata.physical.inmemory.InMemorySASLibrary;
import com.sas.iquery.metadata.physical.inmemory.InMemoryTable;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.util.DataSelectionUtilities;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.rio.MVAConnection;
import com.sas.rio.MVAResultSetMetaData;
import com.sas.rio.RIOException;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class InMemoryFactory {
    private static final InMemoryFactory _instance = new InMemoryFactory();
    private LibrefCounter _librefCounter = new LibrefCounter();
    private static final Logger _logger = LogManager.getLogger(InMemorySASLibrary.class);
    private static final Logger _perfLogger = LogManager.getLogger((String)"com.sas.iquery.perf.DataServer");
    private static final String LOCK_OBJECT_NAME = "InMemoryFactory";

    private InMemoryFactory() {
    }

    public static InMemoryFactory getInstance() {
        return _instance;
    }

    private LibrefCounter getLibrefCounter() {
        return this._librefCounter;
    }

    public InMemoryTable newTable(BusinessQuery businessQuery) throws MetadataException {
        InMemoryTable table = this.newTable();
        ArrayList<InMemoryColumn> columns = new ArrayList<InMemoryColumn>();
        List<SelectedItem> selectedItems = businessQuery.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem item = selectedItem.getItem();
            Role role = selectedItem.getRole();
            boolean isOutputResultItem = Role.isOutputResultRole(businessQuery, role);
            if (!isOutputResultItem) continue;
            InMemoryColumn column = DataSelectionUtilities.createColumn(item, table);
            columns.add(column);
        }
        table.setColumns(columns);
        return table;
    }

    public InMemoryQueryTable newSimpleQueryTable(String label, BusinessModel model, String queryText, List<? extends SASLibrary> libraries, SASWorkspaceServer outputServer) {
        return this.newSimpleQueryTable(label, queryText, libraries, outputServer, model.getComputationalLocale(), model.getSession(), model.getMetadataService());
    }

    private InMemoryQueryTable newSimpleQueryTable(String label, String queryText, List<? extends SASLibrary> libraries, SASWorkspaceServer outputServer, Locale computationalLocale, SessionContextInterface session, IntelligentQueryMetadataServiceInterface service) {
        InMemoryQueryTable query = new InMemoryQueryTable();
        query.setComputationalLocale(computationalLocale);
        query.setSessionContext(session);
        query.setService(service);
        query.setComplexQuery(false);
        query.setQueryText(queryText);
        query.setOutputServer(outputServer);
        query.setLibraries(libraries);
        query.setLabel(label);
        return query;
    }

    public InMemoryQueryTable newComplexQuery(String label, BusinessModel model, String queryText, List<? extends SASLibrary> libraries, SASWorkspaceServer outputServer) {
        InMemoryQueryTable query = new InMemoryQueryTable();
        query.setComputationalLocale(model.getComputationalLocale());
        query.setSessionContext(model.getSession());
        query.setService(model.getMetadataService());
        query.setComplexQuery(true);
        query.setQueryText(queryText);
        query.setOutputServer(outputServer);
        query.setLibraries(libraries);
        query.setLabel(label);
        return query;
    }

    public InMemoryQueryTable newQuery() throws MetadataException {
        InMemoryQueryTable query = new InMemoryQueryTable();
        return query;
    }

    public InMemoryTable newTable() throws MetadataException {
        InMemoryTable table = new InMemoryTable();
        return table;
    }

    public InMemoryColumn newColumn() throws MetadataException {
        InMemoryColumn column = new InMemoryColumn();
        return column;
    }

    public InMemorySASLibrary newSASLibrary() throws MetadataException {
        InMemorySASLibrary library = new InMemorySASLibrary();
        return library;
    }

    public InMemorySASLibrary newSASLibrary(String libref, String path, String engine, String options, SASWorkspaceServer server) {
        InMemorySASLibrary library = new InMemorySASLibrary(libref, path, engine, options);
        library.setSASWorkspaceServer(server);
        return library;
    }

    public InMemorySASLibrary newUserDefinedSASLibrary(String libref, String path, String engine, String options, SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, SASWorkspaceServer outputServer) throws MetadataException {
        if (libref == null) {
            libref = this.getLibrefCounter().nextLibref();
        } else if (GenerationUtil.isReservedLibref(libref)) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemoryFactory.reservedLibref.fmt.txt", libref);
            MetadataException me = new MetadataException(msg);
            throw me;
        }
        InMemorySASLibrary library = new InMemorySASLibrary(libref, path, engine, options);
        library.setSASWorkspaceServer(outputServer);
        library.setSessionContext(session);
        library.setService(service);
        library.setUsePlatformServices(true);
        return library;
    }

    public InMemorySASLibrary newPreassignedLibrary(String libref, String path, String engine, String options, SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, SASWorkspaceServer outputServer) {
        InMemorySASLibrary library = new InMemorySASLibrary(libref, path, engine, options);
        library.setIsPreassigned(true);
        library.setSASWorkspaceServer(outputServer);
        library.setSessionContext(session);
        library.setService(service);
        library.setUsePlatformServices(true);
        return library;
    }

    String resolveTemplateText(String unresolvedText, String tableNameTemplate, String tableName) {
        String tableIdentifier = tableName;
        boolean tableNeedsEscaping = GenerationUtil.tableNeedsEscaping(tableIdentifier, 1);
        if (tableNeedsEscaping) {
            tableIdentifier = GenerationUtil.generateEscapedIdentifier(tableIdentifier, 1);
        }
        String resolvedText = GenerationUtil.replaceTableName(unresolvedText, tableNameTemplate, tableIdentifier);
        return resolvedText;
    }

    String getInMemoryQueryTableText(boolean includeLibnames, boolean prepareFlag, String tableNameTemplate, String tableLabel, Locale computationalLocale, String outputSchemaNam, SASLibrary outputSASLibrary, String queryText, boolean isComplexQuery, List<SASLibrary> libraries) throws MetadataException {
        StringBuilder sb = new StringBuilder();
        sb.append("/* Processing user defined query */\n\n");
        if (prepareFlag) {
            sb.append("/* query table prepare time */\n");
            sb.append("\n/* clear syscc before new query */\n%let syscc=0;\n%let sysrc=0;\n");
            if (computationalLocale != null) {
                sb.append("options Locale=");
                sb.append(computationalLocale);
                sb.append(";\n");
            }
            sb.append("options VALIDMEMNAME=EXTEND;\n");
            sb.append("options VALIDVARNAME=ANY;\n");
        } else {
            sb.append("/* query table requires VALIDMEMNAME=EXTEND, VALIDVARNAME=ANY */\n");
            sb.append("%let _BIQVALIDMEMNAME = %sysfunc(getoption(validmemname,keyword)) ;\n");
            sb.append("%let _BIQVALIDVARNAME = %sysfunc(getoption(validvarname,keyword)) ;\n");
            sb.append("options VALIDMEMNAME=EXTEND;\n");
            sb.append("options VALIDVARNAME=ANY;\n");
            sb.append("\n");
        }
        if (includeLibnames) {
            if ("WORK".equals(outputSchemaNam)) {
                sb.append("/* User output library is predefined WORK */\n");
            } else if (outputSchemaNam != null && outputSASLibrary == null) {
                sb.append("/* Ignoring user specified predefined SAS Library " + outputSchemaNam + " */\n");
            } else {
                sb.append("/* User specified SAS output library " + outputSchemaNam + " */\n");
                if (!outputSASLibrary.isPreassigned()) {
                    String librefStatement = outputSASLibrary.getLibnameStatement();
                    sb.append(librefStatement + "\n");
                }
            }
            if (!libraries.isEmpty()) {
                sb.append("/* User specified SAS input libraries */\n");
                for (SASLibrary library : libraries) {
                    String str1 = library.getLabel();
                    if (str1 != null && outputSchemaNam != null && str1.equalsIgnoreCase(outputSchemaNam) || str1 == null && outputSchemaNam == null) continue;
                    if (!library.isPreassigned()) {
                        String librefStatement = library.getLibnameStatement();
                        sb.append(librefStatement);
                        continue;
                    }
                    sb.append("/* Ignoring user specified predefined SAS Library " + library.getLabel() + " */\n");
                }
                sb.append("\n");
            }
        }
        if (!isComplexQuery) {
            sb.append("PROC SQL;\n");
            sb.append("Create table ");
            if (outputSASLibrary != null) {
                sb.append(outputSASLibrary.getLibref());
                sb.append(".");
            }
            sb.append(tableNameTemplate);
            sb.append(" as\n");
            sb.append("select * from (\n");
        }
        sb.append("/* Begin user specified query table, " + tableLabel + " */\n");
        sb.append(queryText);
        sb.append("\n");
        sb.append("/* End user specified query table, " + tableLabel + " */\n");
        if (!isComplexQuery) {
            sb.append(" ) checkTable ");
            if (prepareFlag) {
                sb.append("where 0");
            }
            sb.append(";\nQUIT;\n");
        }
        if (!prepareFlag) {
            sb.append("\n");
            sb.append("/* reset VALIDVARNAME and VALIDMEMNAME options to previous values */\n");
            sb.append("options &_BIQVALIDMEMNAME ;\n");
            sb.append("options &_BIQVALIDVARNAME ;\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getDataSetNames(SessionContextInterface sessionContext, RelationalServer server, SASLibrary sasLibrary) throws MetadataException, ExecutionException {
        List<String> dataSetNames;
        long startTime = System.nanoTime();
        this.checkForNulls(sessionContext, server);
        LogicalServerInterface logicalServer = server.getLogicalServerInterface();
        Locale connectionLocale = LocaleUtilities.getDefaultComputationalLocale(sessionContext);
        java.lang.Object lockObject = null;
        ConnectionInterface connection = null;
        try {
            lockObject = this.lockSession(sessionContext, LOCK_OBJECT_NAME);
            connection = this.newConnection(sessionContext, logicalServer, this.newPolicy(), connectionLocale);
            dataSetNames = this.getDataSetNames(connection, sasLibrary);
        }
        catch (Throwable throwable) {
            this.closeConnection(connection, sessionContext);
            this.unlockSession(sessionContext, lockObject);
            throw throwable;
        }
        this.closeConnection(connection, sessionContext);
        this.unlockSession(sessionContext, lockObject);
        if (_perfLogger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startTime;
            double elapsedSeconds = (double)elapsedNanos / 1.0E9;
            DecimalFormat formatter = new DecimalFormat();
            _perfLogger.info("InMemoryFactory#getDataSetNames(SessionContextInterface,RelationalServer,SASLibrary) library= " + sasLibrary.getLibref() + "; time= " + formatter.format(elapsedSeconds) + " secs");
        }
        return dataSetNames;
    }

    List<String> getDataSetNames(ConnectionInterface connection, SASLibrary sasLibrary) throws MetadataException {
        ILibref iLibref = this.assignLibref(connection, sasLibrary);
        List<String> dataSetNames = this.getDataSetNames(iLibref);
        return dataSetNames;
    }

    private List<String> getDataSetNames(ILibref iLibref) throws MetadataException {
        List<String> dataSetNames = null;
        try {
            StringSeqHolder stringHolder = new StringSeqHolder();
            iLibref.ListDataSets(stringHolder);
            dataSetNames = Arrays.asList(stringHolder.value);
        }
        catch (GenericError e) {
            MetadataException me = new MetadataException(e);
            throw me;
        }
        return dataSetNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<InMemoryTable> newTables(SessionContextInterface sessionContext, RelationalServer server, SASLibrary sasLibrary) throws MetadataException, ExecutionException {
        List<InMemoryTable> inMemoryTables;
        long startTime = System.nanoTime();
        this.checkForNulls(sessionContext, server);
        LogicalServerInterface logicalServer = server.getLogicalServerInterface();
        Locale connectionLocale = LocaleUtilities.getDefaultComputationalLocale(sessionContext);
        ConnectionInterface connection = null;
        java.lang.Object lockObject = null;
        try {
            lockObject = this.lockSession(sessionContext, LOCK_OBJECT_NAME);
            connection = this.newConnection(sessionContext, logicalServer, this.newPolicy(), connectionLocale);
            inMemoryTables = this.newTables(connection, sasLibrary);
        }
        catch (Throwable throwable) {
            this.closeConnection(connection, sessionContext);
            this.unlockSession(sessionContext, lockObject);
            throw throwable;
        }
        this.closeConnection(connection, sessionContext);
        this.unlockSession(sessionContext, lockObject);
        if (_perfLogger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startTime;
            double elapsedSeconds = (double)elapsedNanos / 1.0E9;
            DecimalFormat formatter = new DecimalFormat();
            _perfLogger.info("InMemoryFactory#newTables(SessionContextInterface,RelationalServer,SASLibrary) library= " + sasLibrary.getLibref() + "; time= " + formatter.format(elapsedSeconds) + " secs");
        }
        return inMemoryTables;
    }

    public List<InMemoryTable> newTables(ConnectionInterface connection, SASLibrary sasLibrary) throws MetadataException {
        ILibref iLibref = this.assignLibref(connection, sasLibrary);
        List<String> tableLabels = this.getDataSetNames(iLibref);
        ArrayList<InMemoryTable> inMemoryTables = new ArrayList<InMemoryTable>();
        for (String tableLabel : tableLabels) {
            InMemoryTable inMemoryTable = this.newTable(iLibref, tableLabel);
            inMemoryTable.setSchema(sasLibrary);
            inMemoryTables.add(inMemoryTable);
        }
        return inMemoryTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InMemoryTable newTable(SessionContextInterface sessionContext, RelationalServer server, SASLibrary sasLibrary, String tableName) throws MetadataException, ExecutionException {
        InMemoryTable outTable;
        long startTime = System.nanoTime();
        this.checkForNulls(sessionContext, server);
        LogicalServerInterface logicalServer = server.getLogicalServerInterface();
        Locale connectionLocale = LocaleUtilities.getDefaultComputationalLocale(sessionContext);
        ConnectionInterface connection = null;
        java.lang.Object lockObject = null;
        try {
            lockObject = this.lockSession(sessionContext, LOCK_OBJECT_NAME);
            connection = this.newConnection(sessionContext, logicalServer, this.newPolicy(), connectionLocale);
            outTable = this.newTable(connection, sasLibrary, tableName);
        }
        catch (Throwable throwable) {
            this.closeConnection(connection, sessionContext);
            this.unlockSession(sessionContext, lockObject);
            throw throwable;
        }
        this.closeConnection(connection, sessionContext);
        this.unlockSession(sessionContext, lockObject);
        outTable.setSchema(sasLibrary);
        if (_perfLogger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startTime;
            double elapsedSeconds = (double)elapsedNanos / 1.0E9;
            DecimalFormat formatter = new DecimalFormat();
            _perfLogger.info("InMemoryFactory#newTable(SessionContextInterface, RelationalServer, SASLibrary, String) " + tableName + " created; time= " + formatter.format(elapsedSeconds) + " secs");
        }
        return outTable;
    }

    public InMemoryTable newTable(ConnectionInterface connection, SASLibrary sasLibrary, String tableLabel) throws MetadataException {
        ILibref iLibref = this.assignLibref(connection, sasLibrary);
        InMemoryTable inMemoryTable = this.newTable(iLibref, tableLabel);
        inMemoryTable.setSchema(sasLibrary);
        return inMemoryTable;
    }

    InMemoryTable newTable(ILibref iLibref, String dataSetName) throws MetadataException {
        InMemoryTable inMemoryTable = this.newTable();
        inMemoryTable.setLabel(dataSetName);
        StringHolder dataSetLabelHolder = new StringHolder();
        List<InMemoryColumn> columns = this.newColumns(iLibref, dataSetName, dataSetLabelHolder);
        String dataSetLabel = dataSetLabelHolder.value;
        inMemoryTable.setDescription(dataSetLabel);
        for (InMemoryColumn c : columns) {
            c.setOwningTable(inMemoryTable);
        }
        inMemoryTable.setColumns(columns);
        inMemoryTable.setHasCurrentPfsMetadata(true);
        return inMemoryTable;
    }

    private List<InMemoryColumn> newColumns(ILibref iLibref, String dataSetName, StringHolder dataSetLabelHolder) throws MetadataException {
        ArrayList<InMemoryColumn> columns = new ArrayList<InMemoryColumn>();
        try {
            int flags = 5;
            String options = "";
            String[] password = new String[]{"", "", ""};
            StringHolder dataSetTypeHolder = new StringHolder();
            DateTimeHolder dateCreatedHolder = new DateTimeHolder();
            DateTimeHolder dateModifiedHolder = new DateTimeHolder();
            IntHolder recordLengthHolder = new IntHolder();
            StringHolder compressionRoutineHolder = new StringHolder();
            IntHolder bookmarkLengthHolder = new IntHolder();
            IntHolder logRecordCountHolder = new IntHolder();
            IntHolder phyRecordCountHolder = new IntHolder();
            IntHolder attributesHolder = new IntHolder();
            IDataSet dataSet = iLibref.OpenDataSet(5, dataSetName, "", password, dataSetLabelHolder, dataSetTypeHolder, dateCreatedHolder, dateModifiedHolder, recordLengthHolder, compressionRoutineHolder, bookmarkLengthHolder, logRecordCountHolder, phyRecordCountHolder, attributesHolder);
            IntHolder numberColumnsHolder = new IntHolder();
            StringSeqHolder columnNamesHolder = new StringSeqHolder();
            LongSeqHolder columnTypesHolder = new LongSeqHolder();
            LongSeqHolder columnLengthsHolder = new LongSeqHolder();
            StringSeqHolder columnLabelsHolder = new StringSeqHolder();
            StringSeqHolder formatNamesHolder = new StringSeqHolder();
            ShortSeqHolder formatWidthsHolder = new ShortSeqHolder();
            ShortSeqHolder formatDecimalsHolder = new ShortSeqHolder();
            ShortSeqHolder formatLengthsHolder = new ShortSeqHolder();
            StringSeqHolder informatNamesHolder = new StringSeqHolder();
            ShortSeqHolder informatWidthsHolder = new ShortSeqHolder();
            ShortSeqHolder informatDecimalsHolder = new ShortSeqHolder();
            OctetSeqHolder sortedByHolder = new OctetSeqHolder();
            dataSet.GetColumnDefs(new boolean[0], numberColumnsHolder, columnNamesHolder, columnTypesHolder, columnLengthsHolder, columnLabelsHolder, formatNamesHolder, formatWidthsHolder, formatDecimalsHolder, formatLengthsHolder, informatNamesHolder, informatWidthsHolder, informatDecimalsHolder, sortedByHolder);
            for (int columnIndex = 0; columnIndex < numberColumnsHolder.value; ++columnIndex) {
                String columnLabel = columnLabelsHolder.value[columnIndex];
                String columnName = columnNamesHolder.value[columnIndex];
                long columnLength = columnLengthsHolder.value[columnIndex];
                long columnType = columnTypesHolder.value[columnIndex];
                String formatName = formatNamesHolder.value[columnIndex];
                short formatWidth = formatWidthsHolder.value[columnIndex];
                short formatDecimals = formatDecimalsHolder.value[columnIndex];
                InMemoryColumn c = InMemoryFactory.getInstance().newColumn(columnLabel, columnName, columnLength, columnType, formatName, formatWidth, formatDecimals);
                columns.add(c);
            }
            dataSet.Close();
        }
        catch (GenericError e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.PfsRetrievalFailed.fmt.txt", iLibref.Name() + "." + dataSetName);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (InvalidPassword e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.PfsRetrievalFailed.fmt.txt", iLibref.Name() + "." + dataSetName);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (NoMember e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.PfsRetrievalFailed.fmt.txt", iLibref.Name() + "." + dataSetName);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (NoReplace e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.PfsRetrievalFailed.fmt.txt", iLibref.Name() + "." + dataSetName);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        return columns;
    }

    public InMemoryColumn newColumn(String columnLabel, String columnName, long columnLength, long columnType, String formatName, int formatWidth, int formatDecimals) throws MetadataException {
        int sqlType;
        String sasType;
        InMemoryColumn c = this.newColumn();
        if (columnLabel.length() > 0) {
            c.setLabel(columnLabel);
        } else {
            c.setLabel(columnName);
        }
        c.setDescription(columnLabel);
        c.setSasName(columnName);
        c.setDbmsName(columnName);
        c.setSasLength((int)columnLength);
        c.setDbmsLength((int)columnLength);
        if (columnType == 0L) {
            sasType = "N";
            sqlType = 0;
        } else {
            sasType = "C";
            sqlType = 0;
        }
        c.setSasType(sasType);
        c.setDbmsType(sqlType);
        if (formatName == null || formatName.length() == 0) {
            c.setSasFormat("");
        } else {
            StringBuilder sasFormat = new StringBuilder(formatName);
            if (formatWidth > 0) {
                sasFormat.append(formatWidth);
            }
            sasFormat.append(".");
            if (formatDecimals > 0) {
                sasFormat.append(formatDecimals);
            }
            c.setSasFormat(sasFormat.toString());
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<InMemoryColumn> newColumns(SessionContextInterface sessionContext, RelationalServer workspaceServer, String libref, Locale computationalLocale, String submitText, String tableNameTemplate, String outputTableName, StringBuffer logBuffer) throws MetadataException, ExecutionException {
        List<InMemoryColumn> outColumns;
        long startTime = System.nanoTime();
        RetrievalPolicy policy = this.newPolicy();
        LogicalServerInterface logicalServer = workspaceServer.getLogicalServerInterface();
        ExecutionContext context = new ExecutionContext(policy);
        java.lang.Object lockObject = null;
        ConnectionInterface connection = null;
        try {
            lockObject = this.lockSession(sessionContext, LOCK_OBJECT_NAME);
            connection = this.newConnection(sessionContext, logicalServer, policy, computationalLocale);
            context.setConnection(connection);
            context.setWorkspace(IOMServerUtils.GetIWorkspace(connection.getObject()));
            context.setTemporaryTableName(outputTableName);
            outColumns = this.newColumns(context, libref, submitText, tableNameTemplate);
            logBuffer.append(context.getRunningLog());
        }
        catch (Throwable throwable) {
            logBuffer.append(context.getRunningLog());
            this.closeConnection(connection, sessionContext);
            this.unlockSession(sessionContext, lockObject);
            throw throwable;
        }
        this.closeConnection(connection, sessionContext);
        this.unlockSession(sessionContext, lockObject);
        if (_perfLogger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startTime;
            double elapsedSeconds = (double)elapsedNanos / 1.0E9;
            DecimalFormat formatter = new DecimalFormat();
            _perfLogger.info("InMemoryFactory#newColumns(SessionContextInterface,RelationalServer,String,Locale,String,String,String); time= " + formatter.format(elapsedSeconds) + " secs");
        }
        return outColumns;
    }

    private List<InMemoryColumn> newColumns(ExecutionContext context, String libref, String submitText, String tableNameTemplate) throws ExecutionException, MetadataException {
        String outputTableName = context.getTemporaryTableName();
        this.submitTableBuild(context, submitText, tableNameTemplate, outputTableName);
        return this.getBuiltTableColumns(context, libref, tableNameTemplate, outputTableName);
    }

    private void submitTableBuild(ExecutionContext context, String submitText, String tableNameTemplate, String outputTableName) throws ExecutionException {
        submitText = this.resolveTemplateText(submitText, tableNameTemplate, outputTableName);
        SASSubmitHandler submitHandler = new SASSubmitHandler();
        submitHandler.execute(false, context, submitText, true);
    }

    private List<InMemoryColumn> getBuiltTableColumns(ExecutionContext context, String libref, String tableNameTemplate, String outputTableName) throws ExecutionException, MetadataException {
        ArrayList<InMemoryColumn> outColumns = new ArrayList<InMemoryColumn>();
        Properties connectionProps = new Properties();
        MVAConnection sqlConnection = null;
        try {
            sqlConnection = new MVAConnection(context.getWorkspace(), connectionProps);
        }
        catch (SQLException e) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("InMemoryQueryTable.Connection.SQLException.txt", new java.lang.Object[0]);
            _logger.error((java.lang.Object)msg, (Throwable)e);
            throw new ExecutionException(msg, (Throwable)e);
        }
        String sql = "select * from " + (libref != null ? libref + "." : "") + tableNameTemplate;
        Statement ps = null;
        try {
            sql = this.resolveTemplateText(sql, tableNameTemplate, outputTableName);
            ps = sqlConnection.prepareStatement(sql);
            ResultSetMetaData rsmd = ps.getMetaData();
            ArrayList<InMemoryColumn> columns = new ArrayList<InMemoryColumn>();
            int columnCount = rsmd.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                InMemoryColumn inMemoryColumn = this.newColumn(rsmd, i);
                columns.add(inMemoryColumn);
            }
            outColumns.addAll(columns);
        }
        catch (SQLException e) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("InMemoryQueryTable.Query.SQLException.txt", new java.lang.Object[0]);
            _logger.error("table name template = [" + tableNameTemplate + "]");
            _logger.error("output table name = [" + outputTableName + "]");
            _logger.error(sql);
            _logger.error((java.lang.Object)msg, (Throwable)e);
            throw new ExecutionException(msg, (Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sqle) {
                    _logger.warn("", (Throwable)sqle);
                }
            }
            if (sqlConnection != null) {
                try {
                    sqlConnection.close();
                }
                catch (SQLException sqle) {
                    _logger.warn("", (Throwable)sqle);
                }
            }
        }
        return outColumns;
    }

    InMemoryColumn newColumn(ResultSetMetaData rsmd, int columnIndex) throws SQLException, MetadataException {
        String columnName = rsmd.getColumnName(columnIndex);
        String format = null;
        if (rsmd instanceof MVAResultSetMetaData) {
            MVAResultSetMetaData mvaRsmd = (MVAResultSetMetaData)rsmd;
            try {
                format = mvaRsmd.getColumnFormatName(columnIndex);
                if (format != null && format.length() > 0 && format.indexOf(46) == -1) {
                    format = format + ".";
                }
            }
            catch (RIOException rIOException) {
                // empty catch block
            }
        }
        String sasColumnLabel = rsmd.getColumnLabel(columnIndex);
        String sasName = columnName;
        int sqlType = rsmd.getColumnType(columnIndex);
        int expressionType = ExpressionUtil.getExprType(sqlType);
        int dbmsLength = rsmd.getColumnDisplaySize(columnIndex);
        int sasLength = rsmd.getColumnDisplaySize(columnIndex);
        String sasType = expressionType == 3 ? "C" : "N";
        String description = rsmd.getColumnLabel(columnIndex);
        InMemoryColumn inMemoryColumn = InMemoryFactory.getInstance().newColumn();
        inMemoryColumn.setLabel(sasColumnLabel);
        inMemoryColumn.setDescription(description);
        inMemoryColumn.setDbmsName(null);
        inMemoryColumn.setDbmsType(sqlType);
        inMemoryColumn.setDbmsLength(dbmsLength);
        inMemoryColumn.setSasName(sasName);
        inMemoryColumn.setSasType(sasType);
        inMemoryColumn.setSasLength(sasLength);
        if (format != null && format.trim().length() > 0) {
            inMemoryColumn.setSasFormat(format);
        }
        return inMemoryColumn;
    }

    void validate(SessionContextInterface sessionContext, RelationalServer workspaceServer, InMemorySASLibrary library) throws MetadataException, ExecutionException {
        this.validate(sessionContext, workspaceServer, library.getLibref(), library.getEngine(), library.getPath(), library.getOptions(), library.isPreassigned());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate(SessionContextInterface sessionContext, RelationalServer server, String libref, String libEngine, String libPath, String libOptions, boolean libIsPreassigned) throws MetadataException, ExecutionException {
        long startTime = System.nanoTime();
        this.checkForNulls(sessionContext, server);
        LogicalServerInterface logicalServer = server.getLogicalServerInterface();
        Locale connectionLocale = LocaleUtilities.getDefaultComputationalLocale(sessionContext);
        java.lang.Object lockObject = null;
        ConnectionInterface connection = null;
        try {
            lockObject = this.lockSession(sessionContext, LOCK_OBJECT_NAME);
            connection = this.newConnection(sessionContext, logicalServer, this.newPolicy(), connectionLocale);
            this.validate(connection, libref, libEngine, libPath, libOptions, libIsPreassigned);
        }
        catch (Throwable throwable) {
            this.closeConnection(connection, sessionContext);
            this.unlockSession(sessionContext, lockObject);
            throw throwable;
        }
        this.closeConnection(connection, sessionContext);
        this.unlockSession(sessionContext, lockObject);
        if (_perfLogger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startTime;
            double elapsedSeconds = (double)elapsedNanos / 1.0E9;
            DecimalFormat formatter = new DecimalFormat();
            _perfLogger.info("InMemoryFactory#validate(SessionContextInterface,RelationalServer,String,String,String,String,boolean); time= " + formatter.format(elapsedSeconds) + " secs");
        }
    }

    void validate(ConnectionInterface connection, String libref, String libEngine, String libPath, String libOptions, boolean libIsPreassigned) throws MetadataException {
        try {
            Object obj = connection.getObject();
            IWorkspace iWorkspace = IOMServerUtils.GetIWorkspace(obj);
            IDataService iData = IOMServerUtils.GetIDataService(iWorkspace);
            StringSeqHolder librefNamesHolder = new StringSeqHolder();
            iData.ListLibrefs(librefNamesHolder);
            List<String> assignedLibraries = Arrays.asList(librefNamesHolder.value);
            if (assignedLibraries.contains(libref)) {
                iData.UseLibref(libref);
            } else {
                boolean weAssignedIt = false;
                if (!libIsPreassigned) {
                    iData.AssignLibref(libref, libEngine, libPath, libOptions);
                    weAssignedIt = true;
                }
                iData.UseLibref(libref);
                if (weAssignedIt) {
                    iData.DeassignLibref(libref);
                }
            }
        }
        catch (LNameNoAssign e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.AssignFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (NoLibrary e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.AssignFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (GenericError e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.AssignFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (InvalidPName e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.AssignFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (NoAccessMethod e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.AssignFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (InvalidLName e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.AssignFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (InvalidEngine e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.AssignFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (IllegalStateException e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.AssignFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (NoWorkDeassign e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.AssignFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (LibraryInUse e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.AssignFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
    }

    private RetrievalPolicy newPolicy() {
        RetrievalPolicy policy = new RetrievalPolicy();
        policy.setPolicyValue(0);
        policy.getConnectionConfiguration().setConnectionLifetime(0);
        return policy;
    }

    private java.lang.Object lockSession(SessionContextInterface sessionContext, String lockObjectName) throws MetadataException {
        java.lang.Object lockObject = null;
        try {
            lockObject = sessionContext.lock(lockObjectName);
        }
        catch (IllegalStateException e2) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("InMemorySASLibrary.InvalidSessionContext.txt", new java.lang.Object[0]);
            throw new MetadataException(msg, (Throwable)e2);
        }
        catch (RemoteException e1) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("InMemorySASLibrary.InvalidSessionContext.txt", new java.lang.Object[0]);
            throw new MetadataException(msg, (Throwable)e1);
        }
        return lockObject;
    }

    private ConnectionInterface newConnection(SessionContextInterface sessionContext, LogicalServerInterface logicalServer, RetrievalPolicy policy, Locale connectionLocale) throws MetadataException, ExecutionException {
        ConnectionInterface connection;
        ConnectionRecycler recycler = ConnectionUtil.getConnectionRecycler(sessionContext);
        try {
            connection = recycler.getWorkspaceConnection(logicalServer, sessionContext.getUserContext(), policy, connectionLocale);
        }
        catch (RemoteException e) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionInstruction.execute.Remote.txt", new java.lang.Object[0]);
            _logger.error((java.lang.Object)msg, (Throwable)e);
            throw new MetadataException(msg, (Throwable)e);
        }
        catch (ConnectionFactoryException e) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionInstruction.execute.ConnectionFactory.txt", new java.lang.Object[0]);
            _logger.error((java.lang.Object)msg, (Throwable)e);
            throw new MetadataException(msg, (Throwable)e);
        }
        catch (ServiceException e) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionInstruction.execute.ConnectionFactory.txt", new java.lang.Object[0]);
            _logger.error((java.lang.Object)msg, (Throwable)e);
            throw new MetadataException(msg, (Throwable)e);
        }
        catch (IllegalStateException e) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionInstruction.execute.Remote.txt", new java.lang.Object[0]);
            _logger.error((java.lang.Object)msg, (Throwable)e);
            throw new MetadataException(msg, (Throwable)e);
        }
        return connection;
    }

    private ILibref assignLibref(ConnectionInterface connection, SASLibrary sasLibrary) throws MetadataException {
        this.checkForNulls(connection, sasLibrary);
        Object obj = connection.getObject();
        IWorkspace iWorkspace = IOMServerUtils.GetIWorkspace(obj);
        IDataService iData = IOMServerUtils.GetIDataService(iWorkspace);
        String libref = sasLibrary.getLibref();
        ILibref iLibref = null;
        try {
            if (!sasLibrary.isPreassigned()) {
                if (sasLibrary instanceof InMemorySASLibrary) {
                    InMemorySASLibrary inMemoryLibrary = (InMemorySASLibrary)sasLibrary;
                    iData.AssignLibref(libref, inMemoryLibrary.getEngine(), inMemoryLibrary.getPath(), inMemoryLibrary.getOptions());
                } else {
                    String stmt = sasLibrary.getLibnameStatement(true);
                    ExecutionContext context = new ExecutionContext(new RetrievalPolicy());
                    context.setWorkspace(iWorkspace);
                    context.setConnection(connection);
                    SASSubmitHandler ssh = new SASSubmitHandler();
                    try {
                        ssh.execute(true, context, stmt, true);
                    }
                    catch (ExecutionException e) {
                        throw new MetadataException(e);
                    }
                    System.out.println(context.getSASLog());
                    System.out.flush();
                }
            }
            iLibref = iData.UseLibref(libref);
        }
        catch (InvalidPName e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.PfsRetrievalFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (NoAccessMethod e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.PfsRetrievalFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (InvalidLName e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.PfsRetrievalFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (LNameNoAssign e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.PfsRetrievalFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (NoLibrary e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.PfsRetrievalFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (InvalidEngine e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.PfsRetrievalFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (GenericError e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.PfsRetrievalFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (IllegalStateException e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemorySASLibrary.PfsRetrievalFailed.fmt.txt", libref);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        return iLibref;
    }

    private void closeConnection(ConnectionInterface connection, SessionContextInterface sessionContext) throws MetadataException {
        try {
            if (connection != null) {
                ConnectionRecycler recycler = ConnectionRecycler.getInstance(sessionContext);
                recycler.closeConnection(connection);
            }
        }
        catch (IllegalStateException e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemoryFactory.CloseFail.txt", new java.lang.Object[0]);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (RemoteException e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemoryFactory.CloseFail.txt", new java.lang.Object[0]);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
        catch (ServiceException e) {
            String msg = IQMetadataResourceBundle.getMessageString("InMemoryFactory.CloseFail.txt", new java.lang.Object[0]);
            MetadataException me = new MetadataException(e, msg);
            throw me;
        }
    }

    private void unlockSession(SessionContextInterface sessionContext, java.lang.Object lockObject) {
        if (lockObject != null) {
            try {
                sessionContext.unlock(lockObject);
            }
            catch (Exception e) {
                _logger.error((java.lang.Object)e);
            }
        }
    }

    void updateTable(InMemorySASLibrary library, InMemoryTable inMemoryTable, List<InMemoryColumn> oldColumns) throws MetadataException, ExecutionException {
        boolean usePlatformServices = library.usePlatformServices();
        if (usePlatformServices) {
            SessionContextInterface sessionContext = library.getSessionContext();
            SASWorkspaceServer workspaceServer = library.getSASWorkspaceServer();
            this.updateTable(sessionContext, workspaceServer, library, inMemoryTable, oldColumns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTable(SessionContextInterface sessionContext, RelationalServer server, SASLibrary sasLibrary, InMemoryTable inMemoryTable, List<InMemoryColumn> oldColumns) throws MetadataException, ExecutionException {
        long startTime = System.nanoTime();
        this.checkForNulls(sessionContext, server);
        LogicalServerInterface logicalServer = server.getLogicalServerInterface();
        Locale connectionLocale = LocaleUtilities.getDefaultComputationalLocale(sessionContext);
        java.lang.Object lockObject = null;
        ConnectionInterface connection = null;
        try {
            lockObject = this.lockSession(sessionContext, LOCK_OBJECT_NAME);
            connection = this.newConnection(sessionContext, logicalServer, this.newPolicy(), connectionLocale);
            StringHolder dataSetLabelHolder = new StringHolder();
            List<InMemoryColumn> pfsColumns = null;
            ILibref iLibref = this.assignLibref(connection, sasLibrary);
            pfsColumns = this.newColumns(iLibref, inMemoryTable.getLabel(), dataSetLabelHolder);
            String dataSetLabel = dataSetLabelHolder.value;
            inMemoryTable.setDescription(dataSetLabel);
            for (InMemoryColumn c : oldColumns) {
                boolean foundColumn = false;
                for (InMemoryColumn pfsColumn : pfsColumns) {
                    if (!c.isPhysicallyEquivalent(pfsColumn)) continue;
                    c.updatePfsMetadata(pfsColumn);
                    foundColumn = true;
                }
                if (foundColumn) continue;
                c.setUnresolved();
            }
            inMemoryTable.setHasCurrentPfsMetadata(true);
        }
        catch (Throwable throwable) {
            this.closeConnection(connection, sessionContext);
            this.unlockSession(sessionContext, lockObject);
            throw throwable;
        }
        this.closeConnection(connection, sessionContext);
        this.unlockSession(sessionContext, lockObject);
        if (_perfLogger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startTime;
            double elapsedSeconds = (double)elapsedNanos / 1.0E9;
            DecimalFormat formatter = new DecimalFormat();
            _logger.info("InMemoryFactory#updateTable(SessionContextInterface,RelationalServer,SASLibrary,InMemoryTable,List<InMemoryColumn>); time= " + formatter.format(elapsedSeconds) + " secs");
        }
    }

    private void checkForNulls(SessionContextInterface sessionContext, SchemaContainer server) throws MetadataException {
        if (sessionContext == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("InMemorySASLibrary.InvalidSessionContext.txt", new java.lang.Object[0]);
            throw new MetadataException(msg);
        }
        if (server == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("InMemorySASLibrary.NullWorkspaceServer.txt", new java.lang.Object[0]);
            throw new MetadataException(msg);
        }
    }

    private void checkForNulls(ConnectionInterface connection, SASLibrary sasLibrary) throws MetadataException {
        if (connection == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("InMemorySASLibrary.NullConnection.txt", new java.lang.Object[0]);
            throw new MetadataException(msg);
        }
        if (sasLibrary == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("InMemorySASLibrary.NullSASLibrary.txt", new java.lang.Object[0]);
            throw new MetadataException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InMemoryColumn> newColumns(SessionContextInterface sessionContext, SASWorkspaceServer outputServer, String libref, Locale computationalLocale, String submitText, String tableNameTemplate, String outputTableName, QueryConnector qc, StringBuffer logBuffer, boolean forceRerun) throws MetadataException, ExecutionException {
        List<InMemoryColumn> columns;
        RetrievalPolicy retrievalPolicy = qc.getRetrievalPolicy();
        ConnectionRecycler recycler = ConnectionUtil.getConnectionRecycler(sessionContext);
        ConnectionInterface connection = qc.getConnection();
        boolean newConnection = connection == null;
        IWorkspace workspace = qc.getWorkspace();
        boolean newWorkspace = workspace == null;
        ExecutionContext context = new ExecutionContext(retrievalPolicy);
        if (newConnection) {
            LogicalServerInterface logicalServer = outputServer.getLogicalServerInterface();
            try {
                UserContextInterface userContext = sessionContext.getUserContext();
                connection = recycler.getWorkspaceConnection(logicalServer, userContext, retrievalPolicy, computationalLocale);
            }
            catch (ServiceException e) {
                throw new MetadataException(e);
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
            catch (IllegalStateException e) {
                throw new MetadataException(e);
            }
            catch (ConnectionFactoryException e) {
                throw new MetadataException(e);
            }
        }
        boolean ok = false;
        try {
            if (newWorkspace) {
                workspace = IOMServerUtils.GetIWorkspace(connection.getObject());
            }
            context.setConnection(connection);
            context.setWorkspace(workspace);
            context.setTemporaryTableName(outputTableName);
            context.setComputationalLocale(computationalLocale);
            if (forceRerun) {
                this.submitTableBuild(context, submitText, tableNameTemplate, outputTableName);
            }
            columns = this.getBuiltTableColumns(context, libref, tableNameTemplate, outputTableName);
            ok = true;
        }
        finally {
            logBuffer.append(context.getRunningLog());
            if (newWorkspace && ok) {
                qc.setWorkspace(workspace);
            }
            if (newConnection) {
                if (ok) {
                    qc.setConnection(connection);
                } else {
                    this.closeConnection(connection, sessionContext);
                }
            }
        }
        return columns;
    }

    private class LibrefCounter {
        private final AtomicInteger counter = new AtomicInteger(-1);

        LibrefCounter() {
        }

        String nextLibref() {
            int nexts;
            int s;
            while (!this.counter.compareAndSet(s = this.counter.get(), nexts = (s + 1) % 10000)) {
            }
            return "UDL_" + nexts;
        }
    }
}

