/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.inmemory;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.MetadataRepositoryResource;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Key;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.inmemory.InMemoryResourceImpl;
import com.sas.iquery.metadata.physical.inmemory.InMemorySASLibrary;
import com.sas.iquery.metadata.physical.inmemory.InMemoryTable;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class InMemoryColumn
extends InMemoryResourceImpl
implements Column {
    private Table _owningTable = null;
    private String _dbmsString = null;
    private int _dbmsType = 0;
    private int _dbmsLength = 0;
    private String _sasName = null;
    private String _sasType = null;
    private int _sasLength = 0;
    private String _sasFormat = null;
    private boolean _isPrimaryKey;
    private boolean _isUniqueKey;
    private boolean _isForeignKey;
    private boolean _isIndex;
    private static final Logger _logger = LogManager.getLogger(InMemoryColumn.class);

    @Override
    @SuppressWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="Per James, read only clone does not require call to super")
    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    @Override
    protected String getDefinitionElementName() {
        return "InMemoryColumn";
    }

    @Override
    protected void writeExternalReference(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeExternalReference(thisElement, writingContext);
        IQModelImplUtilities.setAttr(thisElement, "dbmsName", this._dbmsString);
        IQModelImplUtilities.setIntAttr(thisElement, "dbmsType", this._dbmsType, 0);
        IQModelImplUtilities.setIntAttr(thisElement, "dbmsLength", this._dbmsLength, 0);
        IQModelImplUtilities.setAttr(thisElement, "sasName", this._sasName);
        IQModelImplUtilities.setAttr(thisElement, "sasType", this._sasType);
        IQModelImplUtilities.setIntAttr(thisElement, "sasLength", this._sasLength, 0);
        IQModelImplUtilities.setAttr(thisElement, "sasFormat", this._sasFormat);
    }

    @Override
    public void consumeExternalReferenceAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeExternalReferenceAttributes(attrsProvider);
        this._dbmsString = attrsProvider.consumeAttr("dbmsName");
        this._dbmsType = attrsProvider.consumeIntAttr("dbmsType", 0);
        this._dbmsLength = attrsProvider.consumeIntAttr("dbmsLength", 0);
        this._sasName = attrsProvider.consumeAttr("sasName");
        this._sasType = attrsProvider.consumeAttrAndInternResult("sasType");
        this._sasLength = attrsProvider.consumeIntAttr("sasLength", 0);
        this._sasFormat = attrsProvider.consumeAttr("sasFormat");
    }

    @Override
    public String getDescription() {
        block2: {
            try {
                this.checkAndRefresh();
            }
            catch (MetadataException e) {
                if (!_logger.isDebugEnabled()) break block2;
                _logger.debug(e.getMessage());
            }
        }
        String description = super.getDescription();
        return description;
    }

    @Override
    public String getLabel() {
        block2: {
            try {
                this.checkAndRefresh();
            }
            catch (MetadataException e) {
                if (!_logger.isDebugEnabled()) break block2;
                _logger.debug(e.getMessage());
            }
        }
        String outLabel = super.getLabel();
        return outLabel;
    }

    @Override
    public Table getOwningTable() throws MetadataException {
        return this._owningTable;
    }

    @Override
    public String getDbmsName() throws MetadataException {
        block2: {
            try {
                this.checkAndRefresh();
            }
            catch (MetadataException e) {
                if (!_logger.isDebugEnabled()) break block2;
                _logger.debug(e.getMessage());
            }
        }
        return this._dbmsString;
    }

    @Override
    public int getDbmsType() throws MetadataException {
        return this._dbmsType;
    }

    @Override
    public int getDbmsLength() throws MetadataException {
        block2: {
            try {
                this.checkAndRefresh();
            }
            catch (MetadataException e) {
                if (!_logger.isDebugEnabled()) break block2;
                _logger.debug(e.getMessage());
            }
        }
        return this._dbmsLength;
    }

    @Override
    public String getSasName() throws MetadataException {
        return this._sasName;
    }

    @Override
    public String getSasType() throws MetadataException {
        return this._sasType;
    }

    @Override
    public int getSasLength() throws MetadataException {
        block2: {
            try {
                this.checkAndRefresh();
            }
            catch (MetadataException e) {
                if (!_logger.isDebugEnabled()) break block2;
                _logger.debug(e.getMessage());
            }
        }
        return this._sasLength;
    }

    @Override
    public String getSasFormat() throws MetadataException {
        block2: {
            try {
                this.checkAndRefresh();
            }
            catch (MetadataException e) {
                if (!_logger.isDebugEnabled()) break block2;
                _logger.debug(e.getMessage());
            }
        }
        return this._sasFormat;
    }

    @Override
    public int getExpressionType() {
        int outExprType;
        block8: {
            outExprType = 0;
            try {
                int columnType = this.getDbmsType();
                if (columnType == 0) {
                    String sasType = this.getSasType();
                    if (sasType != null) {
                        if (sasType.equals("C")) {
                            outExprType = 3;
                        } else if (sasType.equals("N")) {
                            outExprType = 2;
                        }
                    }
                } else {
                    outExprType = ExpressionUtil.getExprType(columnType);
                }
            }
            catch (MetadataException e) {
                if (!_logger.isDebugEnabled()) break block8;
                _logger.debug(e.getMessage());
            }
        }
        return outExprType;
    }

    @Override
    public List<Key> getKeys() throws MetadataException {
        String errorMsg = IQModelImplUtilities.getMessage("BusinessModelImplUnsupportedMethod.txt", new Object[0]);
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    public <T extends Key> List<T> getKeys(@Nonnull Class<T> type) throws MetadataException {
        String errorMsg = IQModelImplUtilities.getMessage("BusinessModelImplUnsupportedMethod.txt", new Object[0]);
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    public boolean isUniqueKey() throws MetadataException {
        return this._isUniqueKey;
    }

    @Override
    public boolean isPrimaryKey() throws MetadataException {
        return this._isPrimaryKey;
    }

    @Override
    public boolean isForeignKey() throws MetadataException {
        return this._isForeignKey;
    }

    @Override
    public boolean isIndex() throws MetadataException {
        return this._isIndex;
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
    }

    public void setOwningTable(Table table) {
        this._owningTable = table;
        if (this._owningTable != null && !this._owningTable.isUnresolved() && this.isUnresolved()) {
            this.setIsUnresolved(false);
        }
    }

    public void setDbmsName(String name) {
        this._dbmsString = name;
    }

    public void setDbmsType(int type) {
        this._dbmsType = type;
    }

    public void setDbmsLength(int length) {
        this._dbmsLength = length;
    }

    public void setSasName(String name) {
        this._sasName = name;
    }

    public void setSasType(String type) {
        this._sasType = type;
    }

    public void setSasLength(int length) {
        this._sasLength = length;
    }

    public void setSasFormat(String format) {
        this._sasFormat = format;
    }

    public void setPrimaryKey(boolean isPrimaryKey) {
        this._isPrimaryKey = isPrimaryKey;
    }

    public void setUniqueKey(boolean isUniqueKey) {
        this._isUniqueKey = isUniqueKey;
    }

    public void setForeignKey(boolean isForeignKey) {
        this._isForeignKey = isForeignKey;
    }

    public void setIndex(boolean isIndex) {
        this._isIndex = isIndex;
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInNonDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._owningTable);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._owningTable = (Table)InMemoryColumn.replace(this._owningTable, oldObject, newObject);
    }

    @Override
    public String getType() {
        return IQModelImplUtilities.getMessage("Type.Column.txt", new Object[0]);
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
    }

    @Override
    public List<PhysicalResource> getChildResources(ExternalResourceType type) throws MetadataException {
        return Collections.emptyList();
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        Table returnValue = this.getOwningTable();
        return returnValue;
    }

    @Override
    public String getSearchString() throws MetadataException {
        return null;
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
        if (parentResource != null && parentResource instanceof InMemoryTable) {
            InMemoryTable parent = (InMemoryTable)parentResource;
            this.setOwningTable(parent);
        }
    }

    @Override
    public void setUnresolvedProperties(PhysicalResource sourceResource) throws MetadataException {
    }

    @Override
    public MetadataRepositoryResource getConstrainingResource() throws MetadataException {
        return (MetadataRepositoryResource)((Object)this._owningTable);
    }

    @Override
    public String getRelationshipNameFromKnownConstrainer() {
        return "Columns";
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.Column;
    }

    @Override
    public boolean isPhysicallyEquivalent(PhysicalResource res) throws MetadataException {
        boolean returnValue = false;
        if (this == res) {
            returnValue = true;
        } else if (res instanceof InMemoryColumn) {
            InMemoryColumn oColumn = (InMemoryColumn)res;
            if (IQModelImplUtilities.sameIgnoreCase(this.getSasType(), oColumn.getSasType())) {
                String tName = this.getSasName();
                String oName = oColumn.getSasName();
                returnValue = IQModelImplUtilities.sameIgnoreCase(tName, oName);
            }
        }
        return returnValue;
    }

    private boolean usePlatformServices() throws MetadataException {
        AccessPath ap;
        Schema schema;
        List<AccessPath> aps;
        boolean usePlatformServices = false;
        if (this._owningTable != null && (aps = this._owningTable.getAccessPaths()) != null && (schema = (ap = aps.get(0)).getSchema()) instanceof InMemorySASLibrary) {
            InMemorySASLibrary library = (InMemorySASLibrary)schema;
            usePlatformServices = library.usePlatformServices();
        }
        return usePlatformServices;
    }

    private boolean tableHasCurrentPfsMetadata() throws MetadataException {
        InMemoryTable table;
        boolean hasCurrentPfsMetadata = false;
        if (this._owningTable != null && (table = (InMemoryTable)this._owningTable).hasCurrentPfsMetadata()) {
            hasCurrentPfsMetadata = true;
        }
        return hasCurrentPfsMetadata;
    }

    private void checkAndRefresh() throws MetadataException {
        boolean usePlatformServices = this.usePlatformServices();
        if (usePlatformServices) {
            this.unresolvedCheck();
            if (!this.tableHasCurrentPfsMetadata()) {
                InMemoryTable table = (InMemoryTable)this._owningTable;
                table.getColumns();
            }
        }
    }

    void updatePfsMetadata(InMemoryColumn pfsColumn) throws MetadataException {
        this.setSasFormat(pfsColumn.getSasFormat());
        this.setSasLength(pfsColumn.getSasLength());
        this.setSasName(pfsColumn.getSasName());
        this.setSasType(pfsColumn.getSasType());
        this.setDescription(pfsColumn.getDescription());
        this.setLabel(pfsColumn.getLabel());
        this.setDbmsLength(pfsColumn.getDbmsLength());
        this.setDbmsName(pfsColumn.getDbmsName());
        this.setDbmsType(pfsColumn.getDbmsType());
    }
}

