/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical;

import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.SessionContextDependentCache;
import com.sas.iquery.metadata.impl.SessionContextDependentCacheException;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.MLSLookup;
import com.sas.iquery.metadata.physical.OMAWrapper;
import com.sas.iquery.metadata.physical.oma.OMACalculatedMeasure;
import com.sas.iquery.metadata.physical.oma.OMACalculatedMember;
import com.sas.iquery.metadata.physical.oma.OMAColumn;
import com.sas.iquery.metadata.physical.oma.OMAConnection;
import com.sas.iquery.metadata.physical.oma.OMACube;
import com.sas.iquery.metadata.physical.oma.OMADatabaseSchema;
import com.sas.iquery.metadata.physical.oma.OMADimension;
import com.sas.iquery.metadata.physical.oma.OMAForeignKey;
import com.sas.iquery.metadata.physical.oma.OMAHierarchy;
import com.sas.iquery.metadata.physical.oma.OMAIndex;
import com.sas.iquery.metadata.physical.oma.OMALevel;
import com.sas.iquery.metadata.physical.oma.OMAMLSLookupDetailsTable;
import com.sas.iquery.metadata.physical.oma.OMAMeasure;
import com.sas.iquery.metadata.physical.oma.OMANamedSet;
import com.sas.iquery.metadata.physical.oma.OMAOlapSchema;
import com.sas.iquery.metadata.physical.oma.OMAPrimaryKey;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.physical.oma.OMASASLibrary;
import com.sas.iquery.metadata.physical.oma.OMASASOlapServer;
import com.sas.iquery.metadata.physical.oma.OMASASWorkspaceServer;
import com.sas.iquery.metadata.physical.oma.OMASoftwareServer;
import com.sas.iquery.metadata.physical.oma.OMATable;
import com.sas.iquery.metadata.physical.oma.OMAUniqueKey;
import com.sas.iquery.metadata.physical.plugable.ResourceFactory;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.CalculatedMeasure;
import com.sas.metadata.remote.CalculatedMember;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Measure;
import com.sas.metadata.remote.NamedSet;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.UniqueKey;
import com.sas.metadata.remote.impl.CalculatedMeasureImpl;
import com.sas.metadata.remote.impl.CalculatedMeasureImpl_Stub;
import com.sas.metadata.remote.impl.CalculatedMemberImpl;
import com.sas.metadata.remote.impl.CalculatedMemberImpl_Stub;
import com.sas.metadata.remote.impl.ColumnImpl;
import com.sas.metadata.remote.impl.ColumnImpl_Stub;
import com.sas.metadata.remote.impl.CubeImpl;
import com.sas.metadata.remote.impl.CubeImpl_Stub;
import com.sas.metadata.remote.impl.DatabaseSchemaImpl;
import com.sas.metadata.remote.impl.DatabaseSchemaImpl_Stub;
import com.sas.metadata.remote.impl.DimensionImpl;
import com.sas.metadata.remote.impl.DimensionImpl_Stub;
import com.sas.metadata.remote.impl.ForeignKeyImpl;
import com.sas.metadata.remote.impl.ForeignKeyImpl_Stub;
import com.sas.metadata.remote.impl.HierarchyImpl;
import com.sas.metadata.remote.impl.HierarchyImpl_Stub;
import com.sas.metadata.remote.impl.IndexImpl;
import com.sas.metadata.remote.impl.IndexImpl_Stub;
import com.sas.metadata.remote.impl.LevelImpl;
import com.sas.metadata.remote.impl.LevelImpl_Stub;
import com.sas.metadata.remote.impl.LoginImpl;
import com.sas.metadata.remote.impl.LoginImpl_Stub;
import com.sas.metadata.remote.impl.MachineImpl;
import com.sas.metadata.remote.impl.MachineImpl_Stub;
import com.sas.metadata.remote.impl.MeasureImpl;
import com.sas.metadata.remote.impl.MeasureImpl_Stub;
import com.sas.metadata.remote.impl.NamedSetImpl;
import com.sas.metadata.remote.impl.NamedSetImpl_Stub;
import com.sas.metadata.remote.impl.OLAPSchemaImpl;
import com.sas.metadata.remote.impl.OLAPSchemaImpl_Stub;
import com.sas.metadata.remote.impl.PhysicalTableImpl;
import com.sas.metadata.remote.impl.PhysicalTableImpl_Stub;
import com.sas.metadata.remote.impl.SASLibraryImpl;
import com.sas.metadata.remote.impl.SASLibraryImpl_Stub;
import com.sas.metadata.remote.impl.SharedDimensionImpl;
import com.sas.metadata.remote.impl.SharedDimensionImpl_Stub;
import com.sas.metadata.remote.impl.TCPIPConnectionImpl;
import com.sas.metadata.remote.impl.TCPIPConnectionImpl_Stub;
import com.sas.metadata.remote.impl.TextStoreImpl;
import com.sas.metadata.remote.impl.TextStoreImpl_Stub;
import com.sas.metadata.remote.impl.UniqueKeyImpl;
import com.sas.metadata.remote.impl.UniqueKeyImpl_Stub;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.datalocalization.DataLocalizationModel;
import com.sas.services.session.SessionContextInterface;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OMAResourceFactory
implements ResourceFactory {
    private static final HashMap<Class<?>, Class<?>> jomaImplToOurClassMappings = new HashMap();
    private static final HashMap<Class<?>, Class<?>> jomaImplToJomaInterfaceMappings;
    private static final Logger _logger;
    private static final String POOL_KEY;
    private static final SessionContextDependentCache _sessionCache;

    public static OMAWrapper getReposObject(CMetadata omrObject, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        OMAWrapperPool pool = OMAResourceFactory.getPool(session);
        return OMAResourceFactory.getReposObject(omrObject, pool, metadataServer);
    }

    private static OMAWrapper getReposObject(CMetadata omrObject, OMAWrapperPool pool, MetadataServerInterface metadataServer) throws MetadataException {
        OMAWrapper reposObj;
        if (omrObject == null) {
            reposObj = null;
        } else {
            try {
                OMAWrapper object = pool.getOMAObject(omrObject);
                if (object == null) {
                    reposObj = OMAResourceFactory.newOMAWrapper(omrObject, pool.getSession(), metadataServer);
                    if (reposObj != null) {
                        pool.addOMAObject(omrObject, reposObj);
                    }
                } else {
                    reposObj = object;
                    if (IQSystemProperties.isVerboseLoggingEnabled() && _logger.isDebugEnabled()) {
                        _logger.debug("Returning existing repository object: " + reposObj);
                    }
                }
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
        }
        return reposObj;
    }

    public static <T> List<T> getReposObjects(List<? extends CMetadata> omrObjects, @Nonnull Class<T> type, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        List list;
        if (omrObjects == null) {
            list = Collections.emptyList();
        } else {
            OMAWrapperPool pool = OMAResourceFactory.getPool(session);
            List inputList = AssociationListUtil.getCopyIfASL(omrObjects);
            list = new ArrayList(inputList.size());
            for (CMetadata omrObject : inputList) {
                OMAWrapper reposObj = OMAResourceFactory.getReposObject(omrObject, pool, metadataServer);
                if (!type.isInstance(reposObj)) continue;
                T o = type.cast(reposObj);
                list.add(o);
            }
            ((ArrayList)list).trimToSize();
        }
        return list;
    }

    public static List<OMAWrapper> getReposObjects(List<? extends CMetadata> omrObjects, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        List<OMAWrapper> outputList;
        if (omrObjects == null) {
            outputList = Collections.emptyList();
        } else {
            OMAWrapperPool pool = OMAResourceFactory.getPool(session);
            List inputList = AssociationListUtil.getCopyIfASL(omrObjects);
            outputList = new ArrayList<OMAWrapper>(inputList.size());
            for (CMetadata omrObject : inputList) {
                OMAWrapper reposObj = OMAResourceFactory.getReposObject(omrObject, pool, metadataServer);
                if (reposObj == null) continue;
                outputList.add(reposObj);
            }
        }
        return outputList;
    }

    public static OMASoftwareServer getOMAServerObject(ServerContext serverContext, SessionContextInterface session, MetadataServerInterface metadataServer, boolean wantRelationalServer) throws MetadataException, RemoteException, MdException {
        OMAWrapperPool pool = OMAResourceFactory.getPool(session);
        List<LogicalServer> logicalServers = AssociationListUtil.filteredSnapshot(serverContext.getUsingComponents(), LogicalServer.class);
        LogicalServer foundUnpooledWorkspaceServer = null;
        LogicalServer foundPooledWorkspaceServer = null;
        LogicalServer foundOLAPServer = null;
        for (LogicalServer logicalServer : logicalServers) {
            MessageFormatter warnMsg;
            String logicalServerClassID = logicalServer.getClassIdentifier();
            if (IQModelImplUtilities.sameIgnoreCase(logicalServerClassID, "440196d4-90f0-11d0-9f41-00a024bb830c")) {
                if (foundUnpooledWorkspaceServer != null && foundUnpooledWorkspaceServer != logicalServer) {
                    foundUnpooledWorkspaceServer = null;
                    if (!_logger.isEnabled(org.apache.logging.log4j.Level.WARN)) continue;
                    warnMsg = IQMetadataResourceBundle.getMessageFormatter("OMAResourceFactory.MultipleWorkspaceServers.fmt.txt", serverContext.getName());
                    _logger.warn(warnMsg.getMessage(null));
                    continue;
                }
                foundUnpooledWorkspaceServer = logicalServer;
                continue;
            }
            if (IQModelImplUtilities.sameIgnoreCase(logicalServerClassID, "620963ee-32bf-4128-bf5f-4b0df8ff90eb")) {
                if (foundPooledWorkspaceServer != null && foundPooledWorkspaceServer != logicalServer) {
                    foundPooledWorkspaceServer = null;
                    if (!_logger.isEnabled(org.apache.logging.log4j.Level.WARN)) continue;
                    warnMsg = IQMetadataResourceBundle.getMessageFormatter("OMAResourceFactory.MultiplePooledWorkspaceServers.fmt.txt", serverContext.getName());
                    _logger.warn(warnMsg.getMessage(null));
                    continue;
                }
                foundPooledWorkspaceServer = logicalServer;
                continue;
            }
            if (!IQModelImplUtilities.sameIgnoreCase(logicalServerClassID, "f3f46472-1e31-11d5-87c2-00c04f38f9f6")) continue;
            if (foundOLAPServer != null && foundOLAPServer != logicalServer) {
                foundOLAPServer = null;
                if (!_logger.isEnabled(org.apache.logging.log4j.Level.WARN)) continue;
                warnMsg = IQMetadataResourceBundle.getMessageFormatter("OMAResourceFactory.MultipleOlapServers.fmt.txt", serverContext.getName());
                _logger.warn(warnMsg.getMessage(null));
                continue;
            }
            foundOLAPServer = logicalServer;
        }
        LogicalServer mainLogicalServerAvailable = null;
        mainLogicalServerAvailable = wantRelationalServer ? (foundUnpooledWorkspaceServer != null ? foundUnpooledWorkspaceServer : foundPooledWorkspaceServer) : foundOLAPServer;
        OMASoftwareServer omaServer = null;
        if (mainLogicalServerAvailable != null) {
            omaServer = (OMASoftwareServer)pool.getOMAObject((CMetadata)mainLogicalServerAvailable);
        }
        if (omaServer == null) {
            if (mainLogicalServerAvailable != null && (omaServer = wantRelationalServer ? new OMASASWorkspaceServer(serverContext, foundUnpooledWorkspaceServer, foundPooledWorkspaceServer, session, metadataServer) : new OMASASOlapServer(serverContext, foundOLAPServer, session, metadataServer)) != null) {
                pool.addOMAObject((CMetadata)mainLogicalServerAvailable, omaServer);
            }
        } else if (_logger.isDebugEnabled()) {
            _logger.debug("Returning existing repository object: " + omaServer);
        }
        return omaServer;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OMAWrapper newOMAWrapper(CMetadata omrObject, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        OMAWrapper reposObject = null;
        Class omrClass = omrObject.getClass();
        Class<?> clazz = jomaImplToOurClassMappings.get(omrClass);
        if (clazz != null) {
            try {
                void var5_7;
                Class<?> parm1Type = jomaImplToJomaInterfaceMappings.get(omrClass);
                if (omrObject instanceof UniqueKey && ((UniqueKey)omrObject).getIsPrimary() != 0) {
                    Class<OMAPrimaryKey> clazz2 = OMAPrimaryKey.class;
                }
                Class[] parmTypes = new Class[]{parm1Type, SessionContextInterface.class, MetadataServerInterface.class};
                Object[] parms = new Object[]{omrObject, session, metadataServer};
                Constructor constructor = var5_7.getConstructor(parmTypes);
                reposObject = (OMAWrapper)constructor.newInstance(parms);
                if (!IQSystemProperties.isVerboseLoggingEnabled() || !_logger.isDebugEnabled()) return reposObject;
                if (reposObject instanceof OMAResourceImpl) {
                    _logger.debug("Returning *new* repository object: " + ((OMAResourceImpl)reposObject).getIdentityString());
                    return reposObject;
                }
                _logger.debug("Returning *new* wrapped object: " + reposObject.getClass());
                return reposObject;
            }
            catch (Exception e) {
                if (!_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) throw new MetadataException(e);
                String errorMsg = IQMetadataResourceBundle.getStringResource("RepositoryObjectFactory.ExceptionCreatingReposObj.txt");
                _logger.error(errorMsg, (Throwable)e);
                throw new MetadataException(e);
            }
        } else {
            if (!_logger.isDebugEnabled()) return reposObject;
            _logger.debug("No class mapped for OMR class: " + omrClass.toString());
        }
        return reposObject;
    }

    private static OMAWrapperPool getPool(SessionContextInterface session) throws MetadataException {
        OMAWrapperPool pool = (OMAWrapperPool)_sessionCache.get(session, POOL_KEY);
        if (pool == null) {
            pool = new OMAWrapperPool(session);
            try {
                _sessionCache.put(session, POOL_KEY, pool, pool);
            }
            catch (SessionContextDependentCacheException e) {
                throw new MetadataException(e);
            }
        }
        return pool;
    }

    public static void freeOMAWrappers(SessionContextInterface session, MdObjectStore store) throws MetadataException, RemoteException {
        OMAWrapperPool pool = OMAResourceFactory.getPool(session);
        pool.freeOMAWrappers(store);
    }

    public static MLSLookup buildMLSLookup(Map<String, MLSLookup> lookupsByColumnName, Map<String, MLSLookup> lookupsCache, DataLocalizationModel model, String columnAlias, Column column) throws MetadataException {
        OMAColumn omaColumn = (OMAColumn)column;
        String foreignKeyColumnName = omaColumn.getSasName();
        ColumnInterface miColumn = (ColumnInterface)omaColumn.getJFSObject();
        MLSLookup mlsLookup = OMAMLSLookupDetailsTable.buildMLSLookup(model, miColumn, foreignKeyColumnName, lookupsCache);
        return mlsLookup;
    }

    static {
        jomaImplToOurClassMappings.put(ColumnImpl.class, OMAColumn.class);
        jomaImplToOurClassMappings.put(ColumnImpl_Stub.class, OMAColumn.class);
        jomaImplToOurClassMappings.put(TCPIPConnectionImpl.class, OMAConnection.class);
        jomaImplToOurClassMappings.put(TCPIPConnectionImpl_Stub.class, OMAConnection.class);
        jomaImplToOurClassMappings.put(PhysicalTableImpl.class, OMATable.class);
        jomaImplToOurClassMappings.put(PhysicalTableImpl_Stub.class, OMATable.class);
        jomaImplToOurClassMappings.put(SASLibraryImpl.class, OMASASLibrary.class);
        jomaImplToOurClassMappings.put(SASLibraryImpl_Stub.class, OMASASLibrary.class);
        jomaImplToOurClassMappings.put(DatabaseSchemaImpl.class, OMADatabaseSchema.class);
        jomaImplToOurClassMappings.put(DatabaseSchemaImpl_Stub.class, OMADatabaseSchema.class);
        jomaImplToOurClassMappings.put(CubeImpl.class, OMACube.class);
        jomaImplToOurClassMappings.put(CubeImpl_Stub.class, OMACube.class);
        jomaImplToOurClassMappings.put(OLAPSchemaImpl.class, OMAOlapSchema.class);
        jomaImplToOurClassMappings.put(OLAPSchemaImpl_Stub.class, OMAOlapSchema.class);
        jomaImplToOurClassMappings.put(DimensionImpl.class, OMADimension.class);
        jomaImplToOurClassMappings.put(SharedDimensionImpl.class, OMADimension.class);
        jomaImplToOurClassMappings.put(DimensionImpl_Stub.class, OMADimension.class);
        jomaImplToOurClassMappings.put(HierarchyImpl.class, OMAHierarchy.class);
        jomaImplToOurClassMappings.put(HierarchyImpl_Stub.class, OMAHierarchy.class);
        jomaImplToOurClassMappings.put(LevelImpl.class, OMALevel.class);
        jomaImplToOurClassMappings.put(LevelImpl_Stub.class, OMALevel.class);
        jomaImplToOurClassMappings.put(MeasureImpl.class, OMAMeasure.class);
        jomaImplToOurClassMappings.put(MeasureImpl_Stub.class, OMAMeasure.class);
        jomaImplToOurClassMappings.put(CalculatedMeasureImpl.class, OMACalculatedMeasure.class);
        jomaImplToOurClassMappings.put(CalculatedMeasureImpl_Stub.class, OMACalculatedMeasure.class);
        jomaImplToOurClassMappings.put(IndexImpl.class, OMAIndex.class);
        jomaImplToOurClassMappings.put(IndexImpl_Stub.class, OMAIndex.class);
        jomaImplToOurClassMappings.put(UniqueKeyImpl.class, OMAUniqueKey.class);
        jomaImplToOurClassMappings.put(UniqueKeyImpl_Stub.class, OMAUniqueKey.class);
        jomaImplToOurClassMappings.put(ForeignKeyImpl.class, OMAForeignKey.class);
        jomaImplToOurClassMappings.put(ForeignKeyImpl_Stub.class, OMAForeignKey.class);
        jomaImplToOurClassMappings.put(NamedSetImpl.class, OMANamedSet.class);
        jomaImplToOurClassMappings.put(NamedSetImpl_Stub.class, OMANamedSet.class);
        jomaImplToOurClassMappings.put(CalculatedMemberImpl.class, OMACalculatedMember.class);
        jomaImplToOurClassMappings.put(CalculatedMemberImpl_Stub.class, OMACalculatedMember.class);
        jomaImplToJomaInterfaceMappings = new HashMap();
        jomaImplToJomaInterfaceMappings.put(ColumnImpl.class, com.sas.metadata.remote.Column.class);
        jomaImplToJomaInterfaceMappings.put(ColumnImpl_Stub.class, com.sas.metadata.remote.Column.class);
        jomaImplToJomaInterfaceMappings.put(TCPIPConnectionImpl.class, TCPIPConnection.class);
        jomaImplToJomaInterfaceMappings.put(TCPIPConnectionImpl_Stub.class, TCPIPConnection.class);
        jomaImplToJomaInterfaceMappings.put(LoginImpl.class, Login.class);
        jomaImplToJomaInterfaceMappings.put(LoginImpl_Stub.class, Login.class);
        jomaImplToJomaInterfaceMappings.put(PhysicalTableImpl.class, PhysicalTable.class);
        jomaImplToJomaInterfaceMappings.put(PhysicalTableImpl_Stub.class, PhysicalTable.class);
        jomaImplToJomaInterfaceMappings.put(MachineImpl.class, Machine.class);
        jomaImplToJomaInterfaceMappings.put(MachineImpl_Stub.class, Machine.class);
        jomaImplToJomaInterfaceMappings.put(SASLibraryImpl.class, SASLibrary.class);
        jomaImplToJomaInterfaceMappings.put(SASLibraryImpl_Stub.class, SASLibrary.class);
        jomaImplToJomaInterfaceMappings.put(DatabaseSchemaImpl.class, DatabaseSchema.class);
        jomaImplToJomaInterfaceMappings.put(DatabaseSchemaImpl_Stub.class, DatabaseSchema.class);
        jomaImplToJomaInterfaceMappings.put(CubeImpl.class, Cube.class);
        jomaImplToJomaInterfaceMappings.put(CubeImpl_Stub.class, Cube.class);
        jomaImplToJomaInterfaceMappings.put(OLAPSchemaImpl.class, OLAPSchema.class);
        jomaImplToJomaInterfaceMappings.put(OLAPSchemaImpl_Stub.class, OLAPSchema.class);
        jomaImplToJomaInterfaceMappings.put(DimensionImpl.class, Dimension.class);
        jomaImplToJomaInterfaceMappings.put(DimensionImpl_Stub.class, Dimension.class);
        jomaImplToJomaInterfaceMappings.put(SharedDimensionImpl.class, Dimension.class);
        jomaImplToJomaInterfaceMappings.put(SharedDimensionImpl_Stub.class, Dimension.class);
        jomaImplToJomaInterfaceMappings.put(HierarchyImpl.class, Hierarchy.class);
        jomaImplToJomaInterfaceMappings.put(HierarchyImpl_Stub.class, Hierarchy.class);
        jomaImplToJomaInterfaceMappings.put(LevelImpl.class, Level.class);
        jomaImplToJomaInterfaceMappings.put(LevelImpl_Stub.class, Level.class);
        jomaImplToJomaInterfaceMappings.put(MeasureImpl.class, Measure.class);
        jomaImplToJomaInterfaceMappings.put(MeasureImpl_Stub.class, Measure.class);
        jomaImplToJomaInterfaceMappings.put(TextStoreImpl.class, TextStore.class);
        jomaImplToJomaInterfaceMappings.put(TextStoreImpl_Stub.class, TextStore.class);
        jomaImplToJomaInterfaceMappings.put(CalculatedMeasureImpl.class, CalculatedMeasure.class);
        jomaImplToJomaInterfaceMappings.put(CalculatedMeasureImpl_Stub.class, CalculatedMeasure.class);
        jomaImplToJomaInterfaceMappings.put(IndexImpl.class, Index.class);
        jomaImplToJomaInterfaceMappings.put(IndexImpl_Stub.class, Index.class);
        jomaImplToJomaInterfaceMappings.put(UniqueKeyImpl.class, UniqueKey.class);
        jomaImplToJomaInterfaceMappings.put(UniqueKeyImpl_Stub.class, UniqueKey.class);
        jomaImplToJomaInterfaceMappings.put(ForeignKeyImpl.class, ForeignKey.class);
        jomaImplToJomaInterfaceMappings.put(ForeignKeyImpl_Stub.class, ForeignKey.class);
        jomaImplToJomaInterfaceMappings.put(NamedSetImpl.class, NamedSet.class);
        jomaImplToJomaInterfaceMappings.put(NamedSetImpl_Stub.class, NamedSet.class);
        jomaImplToJomaInterfaceMappings.put(CalculatedMemberImpl.class, CalculatedMember.class);
        jomaImplToJomaInterfaceMappings.put(CalculatedMemberImpl_Stub.class, CalculatedMember.class);
        _logger = LogManager.getLogger(OMAResourceFactory.class);
        POOL_KEY = OMAWrapperPool.class.getName();
        _sessionCache = SessionContextDependentCache.getNewInstance();
    }

    private static class OMAWrapperPool
    implements SessionContextDependentCache.SessionContextEndListener {
        private final SessionContextInterface _session;
        private Map _jomaObjectKeyToOMAWrapper = Collections.synchronizedMap(new HashMap());

        public OMAWrapperPool(SessionContextInterface session) {
            this._session = session;
        }

        public OMAWrapper getOMAObject(CMetadata jomaObject) throws MetadataException, RemoteException {
            return (OMAWrapper)this._jomaObjectKeyToOMAWrapper.get(OMAWrapperPool.getMappingKey(jomaObject));
        }

        public void addOMAObject(CMetadata jomaObject, OMAWrapper omaObject) throws MetadataException, RemoteException {
            this._jomaObjectKeyToOMAWrapper.put(OMAWrapperPool.getMappingKey(jomaObject), omaObject);
        }

        private static String getMappingKey(CMetadata jomaObject) throws MetadataException, RemoteException {
            String fqid = jomaObject.getFQID();
            MdObjectStore store = (MdObjectStore)jomaObject.getObjectStore();
            if (store == null) {
                MessageFormatter error = IQMetadataResourceBundle.getMessageFormatter("OMAResourceFactory.ObjectHasNoObjectStore.fmt.txt", jomaObject.getCMetadataType(), jomaObject.getFQID());
                throw new MetadataException(error);
            }
            return OMAWrapperPool.getKeyPrefix(store) + fqid;
        }

        private static String getKeyPrefix(MdObjectStore store) throws RemoteException {
            return store.getIdentifier() + ".";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void freeOMAWrappers(MdObjectStore store) throws RemoteException {
            ArrayList allKeys;
            String keyPrefix = OMAWrapperPool.getKeyPrefix(store);
            Map map = this._jomaObjectKeyToOMAWrapper;
            synchronized (map) {
                allKeys = new ArrayList(this._jomaObjectKeyToOMAWrapper.keySet());
            }
            for (String key : allKeys) {
                if (!key.startsWith(keyPrefix)) continue;
                this._jomaObjectKeyToOMAWrapper.remove(key);
            }
        }

        @Override
        public void sessionEnd(SessionContextInterface session) {
            this._jomaObjectKeyToOMAWrapper.clear();
            _sessionCache.removeCachedValue(session, POOL_KEY);
            _sessionCache.removeSessionContextEndListener(session, this);
            if (_logger.isDebugEnabled()) {
                String sessionKey = null;
                try {
                    sessionKey = session.getEntityKey();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                _logger.debug("OMAWrapperPool cleared for logged off session key: \"" + sessionKey + "\"");
            }
        }

        public SessionContextInterface getSession() {
            return this._session;
        }
    }
}

