/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.physical.JFSResource;
import com.sas.iquery.metadata.physical.jfs.JFSStoredProcess;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JFSResourceFactory {
    private static final ArrayList MAPPINGS = new ArrayList();
    private static final Logger _logger;

    public static JFSResource newJFSResource(MetadataInterface metadataObj) throws MetadataException {
        JFSResource metadataRes = null;
        Class metadataClass = metadataObj.getClass();
        int ourClassIndex = -1;
        Class<?>[] interfaces = metadataClass.getInterfaces();
        int interfaceCount = interfaces.length;
        int mapCount = MAPPINGS.size();
        for (int ii = 0; ii < interfaceCount; ++ii) {
            Class<?> metadataInterface = interfaces[ii];
            for (int mapIndex = 0; mapIndex < mapCount; mapIndex += 2) {
                Class key = (Class)MAPPINGS.get(mapIndex);
                if (!metadataInterface.equals(key)) continue;
                ourClassIndex = mapIndex + 1;
                mapIndex = mapCount;
                ii = interfaceCount;
            }
        }
        if (ourClassIndex == -1) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("No MetadataResource defined for the MetadataInterface  " + metadataClass);
            }
        } else {
            try {
                Class ourClass = (Class)MAPPINGS.get(ourClassIndex);
                Class[] parmTypes = new Class[]{(Class)MAPPINGS.get(ourClassIndex - 1)};
                Constructor constructor = ourClass.getConstructor(parmTypes);
                Object[] parms = new Object[]{metadataObj};
                metadataRes = (JFSResource)constructor.newInstance(parms);
            }
            catch (Exception e) {
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("JFSResourceFactory.ExceptionCreatingMetadataObj.txt", new Object[0]);
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error((Object)msg, (Throwable)e);
                }
                throw new MetadataException(msg, (Throwable)e);
            }
        }
        return metadataRes;
    }

    public static List getJFSResourceObjects(List omrObjects, SessionContextInterface session) throws MetadataException {
        if (omrObjects == null) {
            return new ArrayList();
        }
        ArrayList inputList = new ArrayList(omrObjects);
        ArrayList<JFSResource> outputList = new ArrayList<JFSResource>();
        for (Object obj : inputList) {
            MetadataInterface omrObject;
            JFSResource res;
            if (!(obj instanceof MetadataInterface) || (res = JFSResourceFactory.newJFSResource(omrObject = (MetadataInterface)obj)) == null) continue;
            outputList.add(res);
        }
        return outputList;
    }

    static {
        MAPPINGS.add(StoredProcessInterface.class);
        MAPPINGS.add(JFSStoredProcess.class);
        _logger = LogManager.getLogger(JFSResourceFactory.class);
    }
}

