/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.services.information.metadata.LogicalServerInterface;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AccessPath
extends AbstractModelItem
implements Cloneable,
BusinessModelResourceReferencer {
    private Server _server;
    private Schema _schema;

    public AccessPath() {
    }

    public AccessPath(Server inputServer, Schema inputSchema) {
        this._server = inputServer;
        this._schema = inputSchema;
    }

    public abstract boolean givesAccessToRelationalData();

    protected abstract boolean hasSupportedServerType();

    protected abstract boolean hasSupportedSchemaType();

    public LogicalServerInterface getLogicalServer() throws MetadataException {
        LogicalServerInterface outServer = null;
        Server server = this.getServer();
        if (server instanceof SoftwareServer && !server.isUnresolved()) {
            outServer = ((SoftwareServer)server).getLogicalServerInterface();
        }
        return outServer;
    }

    public Server getServer() {
        return this._server;
    }

    public void setServer(Server inputServer) {
        this._server = inputServer;
    }

    public SoftwareServer getSoftwareServer() {
        SoftwareServer outServer = null;
        Server server = this.getServer();
        if (server instanceof SoftwareServer) {
            outServer = (SoftwareServer)server;
        }
        return outServer;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public void setSchema(Schema inputSchema) {
        this._schema = inputSchema;
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this._schema = (Schema)Utils.replaceResource(this._schema, oldResource, newResource, model, recursive);
        this._server = (SoftwareServer)Utils.replaceResource(this._server, oldResource, newResource, model, recursive);
    }

    public boolean equals(Object obj) {
        boolean rc = false;
        if (obj instanceof AccessPath) {
            AccessPath that = (AccessPath)obj;
            rc = IQModelImplUtilities.same(this._server, that._server) && IQModelImplUtilities.same(this._schema, that._schema);
        }
        return rc;
    }

    public int hashCode() {
        int rc = 1;
        if (this._server != null) {
            rc = this._server.hashCode();
        }
        return rc;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public abstract AccessPath copy();

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._server == null) {
            reasons.add(new Reason((Object)this, 2, 78, "AccessPath.ServerNotSpecified.txt", new Object[0]));
        } else if (!this.hasSupportedServerType()) {
            reasons.add(new Reason((Object)this, 2, 79, "AccessPath.UnsupportedServerType.txt", new Object[0]));
        }
        if (this._schema != null && !this.hasSupportedSchemaType()) {
            reasons.add(new Reason((Object)this, 2, 77, "AccessPath.UnsupportedSchemaType.txt", new Object[0]));
        }
    }

    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        intoList.add(this._server);
        intoList.add(this._schema);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._server = (Server)AccessPath.replace(this._server, oldObject, newObject);
        this._schema = (Schema)AccessPath.replace(this._schema, oldObject, newObject);
    }

    @Override
    protected String getDefinitionElementName() {
        return null;
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        AccessPath.writeRelatedObject(this._server, thisElement, writingContext, "Server");
        AccessPath.writeRelatedObject(this._schema, thisElement, writingContext, "Schema");
        writingContext.adjustModelVersion(ModelVersion.VERSION_94);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._server = (Server)((Object)riHolder.consumeObject("Server"));
        this._schema = (Schema)((Object)riHolder.consumeObject("Schema"));
    }
}

