/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl.olap.olapserver;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerMember;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPException;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OlapServerLevel {
    private LevelInterface _level = null;
    private Dimension _owningDimension = null;
    private Hierarchy _owningHierarchy = null;
    private int _levelNumber = -1;
    private List listeners = new ArrayList();
    private static final Logger _logger = LogManager.getLogger(OlapServerLevel.class);

    public OlapServerLevel(LevelInterface level) throws MetadataException {
        this._level = level;
    }

    public String getLevelName() throws MetadataException {
        String levelName = "";
        if (this._level == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoLevel.txt", new Object[0]));
        }
        try {
            levelName = this._level.getName();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
        return levelName;
    }

    public String getLabel() {
        String label;
        block5: {
            label = "";
            if (this._level == null) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQModelImplUtilities.getMessage("OlapServerMemberNoLevel.txt", new Object[0]));
                }
            } else {
                try {
                    label = this._level.getLabel();
                }
                catch (OLAPException ex) {
                    if (!_logger.isEnabled(Level.ERROR)) break block5;
                    _logger.error(ex.getLocalizedMessage());
                }
            }
        }
        return label;
    }

    public String getDescription() {
        String desc;
        block5: {
            desc = "";
            if (this._level == null) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQModelImplUtilities.getMessage("OlapServerMemberNoLevel.txt", new Object[0]));
                }
            } else {
                try {
                    desc = this._level.getDescription();
                }
                catch (OLAPException ex) {
                    if (!_logger.isEnabled(Level.ERROR)) break block5;
                    _logger.error(ex.getLocalizedMessage());
                }
            }
        }
        return desc;
    }

    public String getLevelUniqueName() throws MetadataException {
        String levelUniqueName = "";
        if (this._level == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoLevel.txt", new Object[0]));
        }
        try {
            levelUniqueName = this._level.getUniqueName();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
        return levelUniqueName;
    }

    public String getLevelCaption() throws MetadataException {
        String levelCaption = "";
        if (this._level == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoLevel.txt", new Object[0]));
        }
        try {
            levelCaption = this._level.getLabel();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
        return levelCaption;
    }

    public void setOwningDimension(Dimension owningDimension) {
        this._owningDimension = owningDimension;
    }

    public void setOwningHierarchy(Hierarchy hierarchy) {
        this._owningHierarchy = hierarchy;
    }

    public List getMembers() throws MetadataException {
        ArrayList<OlapServerMember> membersList = new ArrayList<OlapServerMember>();
        if (this._level == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoLevel.txt", new Object[0]));
        }
        try {
            MemberInterface[] members = this._level.getMembers();
            for (int i = 0; i < members.length; ++i) {
                OlapServerMember member = new OlapServerMember(members[i]);
                member.setOwningDimension(this._owningDimension);
                member.setOwningHierarchy(this._owningHierarchy);
                membersList.add(member);
            }
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
        return membersList;
    }

    public int getLevelNumber() throws MetadataException {
        if (this._level == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoLevel.txt", new Object[0]));
        }
        try {
            this._levelNumber = this._level.getDepth();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
        return this._levelNumber;
    }

    public int getExpressionType() {
        return ExpressionUtil.getExprType(1);
    }

    public List getResources(@Nonnull Class c, int searchFlags) {
        ArrayList list = new ArrayList();
        return list;
    }

    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
    }

    public Dimension getOwningDimension() throws MetadataException {
        return this._owningDimension;
    }

    public Hierarchy getOwningHierarchy() {
        return this._owningHierarchy;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        String toStringIt;
        block2: {
            toStringIt = "";
            try {
                toStringIt = this._level.getUniqueName();
            }
            catch (OLAPException ex) {
                if (!_logger.isEnabled(Level.ERROR)) break block2;
                _logger.error(IQMetadataResourceBundle.getStringResource("UnknownError.txt"), (Throwable)ex);
            }
        }
        return toStringIt;
    }

    public String getSasFormat() throws MetadataException {
        return null;
    }

    public void addListener(PropertyChangeListener listener) {
        Utils.addListener(this.listeners, listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        Utils.removeListener(this.listeners, listener);
    }

    public List getListeners() {
        return new ArrayList(this.listeners);
    }
}

