/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl.olap.olapserver;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerLevel;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPException;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OlapServerHierarchy {
    private HierarchyInterface _hierarchy = null;
    private Hierarchy _omrHierarchy = null;
    private Dimension _owningDimension = null;
    private String _cubeName = null;
    private List listeners = new ArrayList();
    private static final Logger _logger = LogManager.getLogger(OlapServerHierarchy.class);

    public OlapServerHierarchy(HierarchyInterface hierarchy) throws MetadataException {
        this._hierarchy = hierarchy;
    }

    public String getHierarchyName() throws MetadataException {
        if (this._hierarchy == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoHier.txt", new Object[0]));
        }
        try {
            return this._hierarchy.getName();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    public String getLabel() {
        String label;
        block5: {
            label = "";
            if (this._hierarchy == null) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQModelImplUtilities.getMessage("OlapServerMemberNoHier.txt", new Object[0]));
                }
            } else {
                try {
                    label = this._hierarchy.getLabel();
                }
                catch (OLAPException ex) {
                    if (!_logger.isEnabled(Level.ERROR)) break block5;
                    _logger.error(IQModelImplUtilities.getMessage("OlapServerMemberNoHierLabel.txt", new Object[0]));
                }
            }
        }
        return label;
    }

    public String getDescription() {
        String desc;
        block5: {
            desc = "";
            if (this._hierarchy == null) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQModelImplUtilities.getMessage("OlapServerMemberNoHier.txt", new Object[0]));
                }
            } else {
                try {
                    desc = this._hierarchy.getDescription();
                }
                catch (OLAPException ex) {
                    if (!_logger.isEnabled(Level.ERROR)) break block5;
                    _logger.error(IQModelImplUtilities.getMessage("OlapServerMemberNoHierLabel.txt", new Object[0]));
                }
            }
        }
        return desc;
    }

    public String getHierarchyUniqueName() throws MetadataException {
        if (this._hierarchy == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoHier.txt", new Object[0]));
        }
        try {
            return this._hierarchy.getUniqueName();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    public String getHierarchyCaption() throws MetadataException {
        if (this._hierarchy == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoHier.txt", new Object[0]));
        }
        try {
            return this._hierarchy.getLabel();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    public List getLevels() throws MetadataException {
        if (this._hierarchy == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoHier.txt", new Object[0]));
        }
        ArrayList<OlapServerLevel> levelsList = new ArrayList<OlapServerLevel>();
        try {
            LevelInterface[] levels = this._hierarchy.getLevels();
            for (int i = 0; i < levels.length; ++i) {
                OlapServerLevel level = new OlapServerLevel(levels[i]);
                level.setOwningDimension(this.getOwningDimension());
                level.setOwningHierarchy(this._omrHierarchy);
                levelsList.add(level);
            }
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
        return levelsList;
    }

    public String getDefaultMember() throws MetadataException {
        if (this._hierarchy == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoHier.txt", new Object[0]));
        }
        try {
            MemberInterface defaultMember = this._hierarchy.getDefaultMember();
            return defaultMember.getUniqueName();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    public String getAllMember() throws MetadataException {
        if (this._hierarchy == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoHier.txt", new Object[0]));
        }
        try {
            MemberInterface allMember = this._hierarchy.getTopMember();
            return allMember.getUniqueName();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    public boolean isDefaultHierarchy() throws MetadataException {
        if (this._owningDimension == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoDim.txt", new Object[0]));
        }
        if (this._hierarchy == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoHier.txt", new Object[0]));
        }
        List<Hierarchy> hierList = this._owningDimension.getHierarchies();
        boolean isDefaultHierarchy = true;
        if (hierList != null && hierList.size() > 0) {
            Hierarchy defaultHierarchy = hierList.get(0);
            try {
                if (!defaultHierarchy.getUniqueName().equalsIgnoreCase(this._hierarchy.getUniqueName())) {
                    isDefaultHierarchy = false;
                }
            }
            catch (OLAPException oe) {
                throw new MetadataException(oe);
            }
        }
        return isDefaultHierarchy;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Dimension getOwningDimension() throws MetadataException {
        return this._owningDimension;
    }

    public Hierarchy getOwningHierarchy() {
        return this._omrHierarchy;
    }

    public void setOwnDimension(Dimension dimension) throws MetadataException {
        this._owningDimension = dimension;
        List<Hierarchy> hierarchies = dimension.getHierarchies();
        for (int i = 0; i < hierarchies.size(); ++i) {
            Hierarchy object = hierarchies.get(i);
            if (!(object instanceof Hierarchy)) continue;
            Hierarchy omrHiearchy = object;
            if (!this.getHierarchyName().equalsIgnoreCase(omrHiearchy.getHierarchyName())) continue;
            this._omrHierarchy = omrHiearchy;
            break;
        }
    }

    public String getCubeName() throws MetadataException {
        return this._cubeName;
    }

    public void setCubeName(String cubeName) {
        this._cubeName = cubeName;
    }

    public String getUniqueName() throws MetadataException {
        return this.getHierarchyUniqueName();
    }

    public String getUniqueNameWithHierarchyAllMember() throws MetadataException {
        return this.getUniqueName();
    }

    public String getDimensionName() throws MetadataException {
        if (this._hierarchy == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoHier.txt", new Object[0]));
        }
        try {
            return this._hierarchy.getDimension().getName();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    public int getExpressionType() {
        return 3;
    }

    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
    }

    public List getResources(@Nonnull Class c, int searchFlags) {
        ArrayList list = new ArrayList();
        return list;
    }

    public void addListener(PropertyChangeListener listener) {
        Utils.addListener(this.listeners, listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        Utils.removeListener(this.listeners, listener);
    }

    public List getListeners() {
        return new ArrayList(this.listeners);
    }
}

