/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl.cache;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.PathUrl;
import java.rmi.RemoteException;
import java.util.Date;

public class MapMDInfo {
    private String _name;
    private String _pathUrl;
    private String _entityKey;
    private String _textStore;
    private long _modDate;

    public MapMDInfo(BriefInformationMap briefInfo, String textStore) throws ServiceException, RemoteException {
        this._name = briefInfo.getName();
        PathUrl pUrl = briefInfo.getPathUrl();
        this._pathUrl = pUrl != null ? briefInfo.getPathUrl().toString() : null;
        this._entityKey = briefInfo.getEntityKey();
        this._modDate = briefInfo.getModifyDate().getTime();
        this._textStore = textStore;
        this.validate(true);
    }

    public MapMDInfo(String metadataName, String optionalPathUrl, String entityKey, String textStore, long modDate) {
        this._name = metadataName;
        this._pathUrl = optionalPathUrl;
        this._entityKey = entityKey;
        this._textStore = MapMDInfo.nonNull(textStore);
        this._modDate = modDate;
        this.validate(false);
    }

    public MapMDInfo(MapMDInfo source) {
        this._name = source._name;
        this._pathUrl = source._pathUrl;
        this._entityKey = source._entityKey;
        this._textStore = source._textStore;
        this._modDate = source._modDate;
        this.validate(false);
    }

    public MapMDInfo(MapMDInfo source, String textStore) {
        this(source);
        this._textStore = textStore;
        this.validate(true);
    }

    private void validate(boolean requireTextStore) throws IllegalArgumentException {
        if (MapMDInfo.empty(this._name)) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("MapMDInfo.EmptyNameFail.txt", new Object[0]));
        }
        if (MapMDInfo.empty(this._entityKey)) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("MapMDInfo.EmptyEntityKeyFail.txt", new Object[0]));
        }
        if (requireTextStore && MapMDInfo.empty(this._textStore)) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("MapMDInfo.EmptyTextStoreFail.txt", new Object[0]));
        }
    }

    public boolean matches(String metadataName, String entityKey, long modDate) {
        return modDate == this._modDate && metadataName.equals(this._name) && entityKey.equals(this._entityKey);
    }

    public String getName() {
        return this._name;
    }

    public String getPathUrl() {
        return this._pathUrl;
    }

    public String getEntityKey() {
        return this._entityKey;
    }

    public String getTextStore() {
        return MapMDInfo.nonNull(this._textStore);
    }

    public long getModDate() {
        return this._modDate;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MapMDInfo)) {
            return false;
        }
        MapMDInfo him = (MapMDInfo)obj;
        return this._modDate == him._modDate && this._name.equals(him._name) && this._entityKey.equals(him._entityKey) && this._textStore.equals(him.getTextStore());
    }

    public int hashCode() {
        return this._entityKey.hashCode();
    }

    public String toString() {
        StringBuffer rval = new StringBuffer(300);
        rval.append("MetadataInfo for ");
        if (this._pathUrl != null) {
            rval.append('(').append(this._pathUrl).append(") ");
        }
        rval.append(" [key: ").append(this._entityKey).append("], mod date: ").append(new Date(this._modDate));
        return rval.toString();
    }

    private static boolean empty(String str) {
        return str == null || str.length() == 0;
    }

    private static String nonNull(String s) {
        return s == null ? "" : s;
    }
}

