/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;

@SASScope(value="ALL")
@Immutable
public final class TimeShiftUnit {
    private static final String SECOND_STRING = "second";
    private static final String MINUTE_STRING = "minute";
    private static final String HOUR_STRING = "hour";
    private static final String DAY_STRING = "day";
    private static final String WEEK_STRING = "week";
    private static final String WEEKDAY_STRING = "weekday";
    private static final String MONTH_STRING = "month";
    private static final String QUARTER_STRING = "qtr";
    private static final String YEAR_STRING = "year";
    public static final TimeShiftUnit SECOND = new TimeShiftUnit("second");
    public static final TimeShiftUnit MINUTE = new TimeShiftUnit("minute");
    public static final TimeShiftUnit HOUR = new TimeShiftUnit("hour");
    public static final TimeShiftUnit DAY = new TimeShiftUnit("day");
    public static final TimeShiftUnit WEEK = new TimeShiftUnit("week");
    public static final TimeShiftUnit WEEKDAY = new TimeShiftUnit("weekday");
    public static final TimeShiftUnit MONTH = new TimeShiftUnit("month");
    public static final TimeShiftUnit QUARTER = new TimeShiftUnit("qtr");
    public static final TimeShiftUnit YEAR = new TimeShiftUnit("year");
    private final String _type;
    private static final Map<String, TimeShiftUnit> _supportedTypes;
    private static final Map<String, String> _displayText;
    private static final Map<String, String> _pluralDisplayText;

    private TimeShiftUnit(String type) {
        this._type = type;
    }

    @SASScope
    public String toString() {
        String text = _displayText.get(this._type);
        assert (text != null);
        return text;
    }

    @SASScope
    public String pluralDisplayText() {
        String text = _pluralDisplayText.get(this._type);
        assert (text != null);
        return text;
    }

    @Nonnull
    public static List<TimeShiftUnit> getValues() {
        ArrayList<TimeShiftUnit> types = new ArrayList<TimeShiftUnit>(_supportedTypes.values());
        return Collections.unmodifiableList(types);
    }

    @Nonnull
    protected String getTypeValue() {
        return this._type;
    }

    @SASScope
    public boolean equals(Object object2) {
        if (this == object2) {
            return true;
        }
        if (!(object2 instanceof TimeShiftUnit)) {
            return false;
        }
        TimeShiftUnit o2 = (TimeShiftUnit)object2;
        String value1 = this.getTypeValue();
        String value2 = o2.getTypeValue();
        return value1.equals(value2);
    }

    @Nullable
    @SASScope
    protected static TimeShiftUnit fromPersistentForm(String attr) {
        TimeShiftUnit result = null;
        if (attr != null) {
            result = _supportedTypes.get(attr);
        }
        return result;
    }

    @Nonnull
    @SASScope
    protected String getPersistentForm() {
        return this._type;
    }

    @Nonnull
    @SASScope
    protected String getQueryText() {
        return this._type;
    }

    @SASScope
    public int hashCode() {
        int result = 173;
        result = 37 * result + (this._type == null ? 0 : this._type.hashCode());
        result = 37 * result + 11;
        return result;
    }

    static {
        HashMap<String, TimeShiftUnit> mutable = new HashMap<String, TimeShiftUnit>(16);
        mutable.put(SECOND_STRING, SECOND);
        mutable.put(MINUTE_STRING, MINUTE);
        mutable.put(HOUR_STRING, HOUR);
        mutable.put(DAY_STRING, DAY);
        mutable.put(WEEK_STRING, WEEK);
        mutable.put(WEEKDAY_STRING, WEEKDAY);
        mutable.put(MONTH_STRING, MONTH);
        mutable.put(QUARTER_STRING, QUARTER);
        mutable.put(YEAR_STRING, YEAR);
        _supportedTypes = Collections.unmodifiableMap(mutable);
        HashMap<String, String> tempDisplayText = new HashMap<String, String>(12);
        tempDisplayText.put(SECOND_STRING, "Second");
        tempDisplayText.put(MINUTE_STRING, "Minute");
        tempDisplayText.put(HOUR_STRING, "Hour");
        tempDisplayText.put(DAY_STRING, "Day");
        tempDisplayText.put(WEEK_STRING, "Week");
        tempDisplayText.put(WEEKDAY_STRING, "Weekday");
        tempDisplayText.put(MONTH_STRING, "Month");
        tempDisplayText.put(QUARTER_STRING, "Quarter");
        tempDisplayText.put(YEAR_STRING, "Year");
        _displayText = Collections.unmodifiableMap(tempDisplayText);
        HashMap<String, String> tempPluralDisplayText = new HashMap<String, String>(12);
        tempPluralDisplayText.put(SECOND_STRING, "Seconds");
        tempPluralDisplayText.put(MINUTE_STRING, "Minutes");
        tempPluralDisplayText.put(HOUR_STRING, "Hours");
        tempPluralDisplayText.put(DAY_STRING, "Days");
        tempPluralDisplayText.put(WEEK_STRING, "Weeks");
        tempPluralDisplayText.put(WEEKDAY_STRING, "Weekdays");
        tempPluralDisplayText.put(MONTH_STRING, "Months");
        tempPluralDisplayText.put(QUARTER_STRING, "Quarters");
        tempPluralDisplayText.put(YEAR_STRING, "Years");
        _pluralDisplayText = Collections.unmodifiableMap(tempPluralDisplayText);
    }
}

