/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.relational.RelationalConditionalExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class SimpleConditionalExpression_Like
extends RelationalConditionalExpression
implements BusinessModelResourceReferencer {
    public static final String EVENT_WHAT_TO_COMPARE_CHANGED = "What to compare expression changed";
    public static final String EVENT_LIKE_PATTERN_CHANGED = "Pattern expression changed";
    public static final String EVENT_ESCAPE_CHAR_CHANGED = "Escape character changed";
    public static final String EVENT_MATCH_MANY_CHAR_CHANGED = "Match many character changed";
    public static final String EVENT_MATCH_ONE_CHAR_CHANGED = "Match one character changed";
    private ExpressionInterface _whatToCompare;
    private ExpressionInterface _patternExpression;
    private Character _escape;
    private Character _matchMany;
    private Character _matchOne;

    public void setWhatToCompare(ExpressionInterface expr) {
        if (expr instanceof ConditionalExpression) {
            // empty if block
        }
        this.moveListeningTo(this._whatToCompare, expr);
        this._whatToCompare = expr;
        this.fireChangeEvent(EVENT_WHAT_TO_COMPARE_CHANGED);
    }

    public ExpressionInterface getWhatToCompare() {
        return this._whatToCompare;
    }

    public void setPatternExpression(ExpressionInterface expr) {
        if (expr instanceof ConditionalExpression) {
            // empty if block
        }
        this.moveListeningTo(this._patternExpression, expr);
        this._patternExpression = expr;
        this.fireChangeEvent(EVENT_LIKE_PATTERN_CHANGED);
    }

    public ExpressionInterface getPatternExpression() {
        return this._patternExpression;
    }

    public void setEscapeCharacter(Character escape) {
        if (!IQModelImplUtilities.same(this._escape, escape)) {
            this._escape = escape;
            this.fireChangeEvent(EVENT_ESCAPE_CHAR_CHANGED);
        }
    }

    public Character getEscapeCharacter() {
        return this._escape;
    }

    public void setMatchManyCharacter(Character matchMany) {
        if (!IQModelImplUtilities.same(this._matchMany, matchMany)) {
            this._matchMany = matchMany;
            this.fireChangeEvent(EVENT_MATCH_MANY_CHAR_CHANGED);
        }
    }

    public Character getMatchManyCharacter() {
        return this._matchMany;
    }

    public void setMatchOneCharacter(Character matchOne) {
        if (!IQModelImplUtilities.same(this._matchOne, matchOne)) {
            this._matchOne = matchOne;
            this.fireChangeEvent(EVENT_MATCH_ONE_CHAR_CHANGED);
        }
    }

    public Character getMatchOneCharacter() {
        return this._matchOne;
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this._whatToCompare = this.singleReplaceResources(this._whatToCompare, oldResource, newResource, model, recursive);
        this._patternExpression = this.singleReplaceResources(this._patternExpression, oldResource, newResource, model, recursive);
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        ExpressionInterface expr;
        SimpleConditionalExpression_Like clone = (SimpleConditionalExpression_Like)super.clone();
        if (!(this._whatToCompare instanceof BusinessModelResource) && this._whatToCompare != null) {
            expr = (ExpressionInterface)this._whatToCompare.clone();
            clone.setWhatToCompare(expr);
        }
        if (!(this._patternExpression instanceof BusinessModelResource) && this._patternExpression != null) {
            expr = (ExpressionInterface)this._patternExpression.clone();
            clone.setPatternExpression(expr);
        }
        return clone;
    }

    @SASScope
    public String toString() {
        try {
            return "(" + StringExpressionUtil.getInstance().getText(this._whatToCompare) + (this.isNegated() ? " NOT" : "") + " LIKE " + StringExpressionUtil.getInstance().getText(this._patternExpression) + ")";
        }
        catch (MetadataException e) {
            return "";
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        this.nullSubexpressionNotAllowed(reasons, this._whatToCompare, "SimpleConditionalExpression_Like.HasNullWhatToCompare.txt");
        this.nullSubexpressionNotAllowed(reasons, this._patternExpression, "SimpleConditionalExpression_Like.HasNullPattern.txt");
        Character escapeChar = this.getEscapeCharacter();
        Character matchManyChar = this.getMatchManyCharacter();
        Character matchOneChar = this.getMatchOneCharacter();
        char escapeCh = escapeChar == null ? (char)'\\' : (char)escapeChar.charValue();
        char matchManyCh = matchManyChar == null ? (char)'%' : (char)matchManyChar.charValue();
        char matchOneCh = matchOneChar == null ? (char)'_' : (char)matchOneChar.charValue();
        Object[] parms = new Object[]{Character.valueOf(matchManyCh), Character.valueOf(matchOneCh), Character.valueOf(escapeCh)};
        if (matchManyCh == matchOneCh && matchManyCh == escapeCh) {
            MessageFormatter message = IQMetadataResourceBundle.getMessageFormatter("SimpleConditionalExpression_Like.duplicateManyOneEscapeChars.fmt.txt", parms);
            Reason reason = new Reason((Object)this, 2, 224, message);
            reasons.add(reason);
        } else if (matchManyCh == matchOneCh) {
            MessageFormatter message = IQMetadataResourceBundle.getMessageFormatter("SimpleConditionalExpression_Like.duplicateManyOneChars.fmt.txt", parms);
            Reason reason = new Reason((Object)this, 2, 221, message);
            reasons.add(reason);
        } else if (escapeCh == matchManyCh) {
            MessageFormatter message = IQMetadataResourceBundle.getMessageFormatter("SimpleConditionalExpression_Like.duplicateManyEscapeChars.fmt.txt", parms);
            Reason reason = new Reason((Object)this, 2, 222, message);
            reasons.add(reason);
        } else if (escapeCh == matchOneCh) {
            MessageFormatter message = IQMetadataResourceBundle.getMessageFormatter("SimpleConditionalExpression_Like.duplicateOneEscapeChars.fmt.txt", parms);
            Reason reason = new Reason((Object)this, 2, 223, message);
            reasons.add(reason);
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        this.validateForPrompt(this._whatToCompare, reasons);
        this.validateForPrompt(this._patternExpression, reasons);
    }

    private void validateForPrompt(ExpressionInterface expression, List<Reason> reasons) {
        if (expression instanceof Prompt) {
            if (!ExpressionUtil.isSingleSelectionPrompt((Prompt)expression)) {
                Reason notSingleSelectionPrompt = new Reason((Object)this, 8, 225, "Expression.OnlySingleSelectionPromptsAreSupported.fmt.txt", this, expression);
                reasons.add(notSingleSelectionPrompt);
            }
            if (expression.getExpressionType() != 3) {
                Reason notCharacter = new Reason((Object)this, 8, 225, "Expression.OnlyCharacterPromptsAreSupported.fmt.txt", this, expression);
                reasons.add(notCharacter);
            }
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "LikeExpr";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        SimpleConditionalExpression_Like.writeRelatedObject(this._whatToCompare, thisElement, writingContext, "LeftExpr");
        SimpleConditionalExpression_Like.writeRelatedObject(this._patternExpression, thisElement, writingContext, "RightExpr");
        IQModelImplUtilities.setCharAttr(thisElement, "escape", this._escape);
        IQModelImplUtilities.setCharAttr(thisElement, "matchMany", this._matchMany);
        IQModelImplUtilities.setCharAttr(thisElement, "matchOne", this._matchOne);
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._whatToCompare = (ExpressionInterface)((Object)riHolder.consumeObject("LeftExpr"));
        this._patternExpression = (ExpressionInterface)((Object)riHolder.consumeObject("RightExpr"));
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._escape = attrsProvider.consumeCharAttr("escape", null);
        this._matchMany = attrsProvider.consumeCharAttr("matchMany", null);
        this._matchOne = attrsProvider.consumeCharAttr("matchOne", null);
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._whatToCompare = (ExpressionInterface)((Object)SimpleConditionalExpression_Like.v1_readItemUnderSubelement(thisElement, readingContext, "LeftExpr", VALID_TYPES_ANY_EXPRESSION));
        this._patternExpression = (ExpressionInterface)((Object)SimpleConditionalExpression_Like.v1_readItemUnderSubelement(thisElement, readingContext, "RightExpr", VALID_TYPES_ANY_EXPRESSION));
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._whatToCompare);
        intoList.add(this._patternExpression);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._whatToCompare = (ExpressionInterface)SimpleConditionalExpression_Like.replace(this._whatToCompare, oldObject, newObject);
        this._patternExpression = (ExpressionInterface)SimpleConditionalExpression_Like.replace(this._patternExpression, oldObject, newObject);
    }
}

