/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.relational.RelationalConditionalExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class SimpleConditionalExpression_Comparison
extends RelationalConditionalExpression
implements BusinessModelResourceReferencer {
    public static final String EVENT_COMPARISON_OPERATOR_CHANGED = "Comparison operator changed";
    public static final String EVENT_LEFT_EXPRESSION_CHANGED = "Left expression changed";
    public static final String EVENT_RIGHT_EXPRESSION_CHANGED = "Right expression changed";
    private ExpressionInterface _leftExpr;
    private ComparisonOperator _operator;
    private ExpressionInterface _rightExpr;

    @SASScope(value="ALL")
    @SubjectToChange
    public ComparisonOperator getComparisonOperator() {
        return this._operator;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setComparisonOperator(ComparisonOperator operator) {
        this._operator = operator;
        this.fireChangeEvent(EVENT_COMPARISON_OPERATOR_CHANGED);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setLeftExpression(ExpressionInterface expr) {
        if (expr instanceof ConditionalExpression) {
            // empty if block
        }
        this.moveListeningTo(this._leftExpr, expr);
        this._leftExpr = expr;
        this.fireChangeEvent(EVENT_LEFT_EXPRESSION_CHANGED);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public ExpressionInterface getLeftExpression() {
        return this._leftExpr;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setRightExpression(ExpressionInterface expr) {
        if (expr instanceof ConditionalExpression) {
            // empty if block
        }
        this.moveListeningTo(this._rightExpr, expr);
        this._rightExpr = expr;
        this.fireChangeEvent(EVENT_RIGHT_EXPRESSION_CHANGED);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public ExpressionInterface getRightExpression() {
        return this._rightExpr;
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this._leftExpr = this.singleReplaceResources(this._leftExpr, oldResource, newResource, model, recursive);
        this._rightExpr = this.singleReplaceResources(this._rightExpr, oldResource, newResource, model, recursive);
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        ExpressionInterface expr;
        SimpleConditionalExpression_Comparison clone = (SimpleConditionalExpression_Comparison)super.clone();
        if (!(this._leftExpr instanceof BusinessModelResource) && this._leftExpr != null) {
            expr = (ExpressionInterface)this._leftExpr.clone();
            clone.setLeftExpression(expr);
        }
        if (!(this._rightExpr instanceof BusinessModelResource) && this._rightExpr != null) {
            expr = (ExpressionInterface)this._rightExpr.clone();
            clone.setRightExpression(expr);
        }
        return clone;
    }

    @SASScope
    public String toString() {
        try {
            return (this.isNegated() ? " NOT " : "") + "(" + StringExpressionUtil.getInstance().getText(this._leftExpr) + " " + Utils.toString(this._operator) + " " + StringExpressionUtil.getInstance().getText(this._rightExpr) + ")";
        }
        catch (MetadataException e) {
            return "";
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        this.nullSubexpressionNotAllowed(reasons, this._leftExpr, "SimpleConditionalExpression_Comparison.HasNullLeftValue.txt");
        this.nullSubexpressionNotAllowed(reasons, this._rightExpr, "SimpleConditionalExpression_Comparison.HasNullRightValue.txt");
        if (this._operator == null && reasons != null) {
            reasons.add(new Reason((Object)this, 2, 54, "SimpleConditionalExpression_Comparison.HasNullComparisonOperator.txt", new Object[0]));
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        this.validateForPrompt(this._leftExpr, reasons);
        this.validateForPrompt(this._rightExpr, reasons);
    }

    private void validateForPrompt(ExpressionInterface expression, List<Reason> reasons) {
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "Compare";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setEnumAttr(thisElement, "operator", this._operator);
        SimpleConditionalExpression_Comparison.writeRelatedObject(this._leftExpr, thisElement, writingContext, "LeftExpr");
        SimpleConditionalExpression_Comparison.writeRelatedObject(this._rightExpr, thisElement, writingContext, "RightExpr");
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._operator = ComparisonOperator.consumeValue(attrsProvider, "operator", null);
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._leftExpr = (ExpressionInterface)((Object)riHolder.consumeObject("LeftExpr"));
        this._rightExpr = (ExpressionInterface)((Object)riHolder.consumeObject("RightExpr"));
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._operator = ComparisonOperator.fromPersistentForm(IQModelImplUtilities.getAttr(thisElement, "op"));
        this._leftExpr = (ExpressionInterface)((Object)SimpleConditionalExpression_Comparison.v1_readItemUnderSubelement(thisElement, readingContext, "LeftExpr", VALID_TYPES_ANY_EXPRESSION));
        this._rightExpr = (ExpressionInterface)((Object)SimpleConditionalExpression_Comparison.v1_readItemUnderSubelement(thisElement, readingContext, "RightExpr", VALID_TYPES_ANY_EXPRESSION));
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._leftExpr);
        intoList.add(this._rightExpr);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._leftExpr = (ExpressionInterface)SimpleConditionalExpression_Comparison.replace(this._leftExpr, oldObject, newObject);
        this._rightExpr = (ExpressionInterface)SimpleConditionalExpression_Comparison.replace(this._rightExpr, oldObject, newObject);
    }
}

