/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope
public class ConditionalExpressionAdapter
extends ConditionalExpression {
    public static final String EVENT_EXPRESSION_CHANGED = "Expression changed";
    private ExpressionInterface _expression;

    public void setExpression(ExpressionInterface expr) {
        this.moveListeningTo(this._expression, expr);
        this._expression = expr;
        this.fireChangeEvent(EVENT_EXPRESSION_CHANGED);
    }

    public ExpressionInterface getExpression() {
        return this._expression;
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this._expression = this.singleReplaceResources(this._expression, oldResource, newResource, model, recursive);
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        reasons.addAll(this.getReasonsExprIsUnusableAsExpressionArg(this._expression, "SimpleConditionalExpression_Comparison.HasNullLeftValue.txt"));
        ExpressionInterface expression = this.getExpression();
        if (expression != null) {
            int type = expression.getExpressionType();
            if (type == 0) {
                Reason expressionNotSet = new Reason((Object)this, 8, 49, "JoinImpl.JoinConditionNotSet.fmt.txt", new Object[0]);
                reasons.add(expressionNotSet);
            } else if (type != 9 && type != 2) {
                Reason expressionNotBoolean = new Reason((Object)this, 8, 106, "ExpressionUtil.JoinExpressionNotBoolean.fmt.txt", new Object[0]);
                reasons.add(expressionNotBoolean);
            }
            if (expression instanceof Prompt && !ExpressionUtil.isSingleSelectionPrompt((Prompt)expression)) {
                Reason UnsupportedPromptType = new Reason((Object)this, 8, 225, "Expression.OnlySingleSelectionPromptsAreSupported.fmt.txt", this, expression);
                reasons.add(UnsupportedPromptType);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ConditionalExpressionAdapter clone = (ConditionalExpressionAdapter)super.clone();
        if (!(this._expression instanceof BusinessModelResource) && this._expression != null) {
            ExpressionInterface expr = (ExpressionInterface)this._expression.clone();
            clone.setExpression(expr);
        }
        return clone;
    }

    public String toString() {
        try {
            return (this.isNegated() ? " NOT " : "") + "(" + StringExpressionUtil.getInstance().getText(this._expression) + ")";
        }
        catch (MetadataException e) {
            return "";
        }
    }

    @Override
    protected String getDefinitionElementName() {
        return "ConditionalExprAdapter";
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        ConditionalExpressionAdapter.writeRelatedObject(this._expression, thisElement, writingContext, "Expr");
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._expression = (ExpressionInterface)((Object)riHolder.consumeObject("Expr"));
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._expression = (ExpressionInterface)((Object)ConditionalExpressionAdapter.v1_readItemUnderSubelement(thisElement, readingContext, "Expression", VALID_TYPES_ANY_EXPRESSION));
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._expression);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._expression = (ExpressionInterface)ConditionalExpressionAdapter.replace(this._expression, oldObject, newObject);
    }
}

