/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.AbstractEnumerationObject;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.relational.AbstractComparisonWithQueryResultsExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope
public class CompareWithQueryResultsExpression
extends AbstractComparisonWithQueryResultsExpression {
    public static final String EVENT_COMPARISON_OPERATOR_CHANGED = "Comparison operator changed";
    public static final String EVENT_COMPARISON_TYPE_CHANGED = "Comparison type changed";
    private ComparisonOperator _operator = ComparisonOperator.COMPARE_EQ;
    private ComparisonType _comparisonType = ComparisonType.COMPARE_WITH_SINGLE_QUERY_RESULT_VALUE;

    public CompareWithQueryResultsExpression() {
    }

    public CompareWithQueryResultsExpression(ExpressionInterface whatToCompare, ComparisonOperator operator, ComparisonType comparisonType, BusinessQuery query) {
        super(whatToCompare, query);
        this.setComparisonOperator(operator);
        this.setComparisonType(comparisonType);
    }

    public ComparisonOperator getComparisonOperator() {
        return this._operator;
    }

    public void setComparisonOperator(ComparisonOperator operator) {
        if (this._operator != operator) {
            this._operator = operator;
            this.fireChangeEvent(EVENT_COMPARISON_OPERATOR_CHANGED);
        }
    }

    public ComparisonType getComparisonType() {
        return this._comparisonType;
    }

    public void setComparisonType(ComparisonType comparisonType) {
        if (this._comparisonType != comparisonType) {
            this._comparisonType = comparisonType;
            this.fireChangeEvent(EVENT_COMPARISON_TYPE_CHANGED);
        }
    }

    public Reason getReasonNotUsableWith(BusinessQuery query, ComparisonType type) {
        Reason out = this.getReasonNotUsableWith(query);
        if (out == null) {
            ComparisonType typeToCompare = type;
            if (typeToCompare == null) {
                typeToCompare = this._comparisonType;
            }
            if (typeToCompare == ComparisonType.COMPARE_WITH_SINGLE_QUERY_RESULT_VALUE) {
                boolean oneRowQuery = CompareWithQueryResultsExpression.oneOutputColumnAggregatingQuery(query);
                if (!oneRowQuery) {
                    out = new Reason((Object)query, 2, 210, "CompareWithQueryResultsExpression.QueryDoesNotReturnAnAggregatedColumnOfData.txt", new Object[0]);
                }
            } else if (typeToCompare == null) {
                out = new Reason((Object)query, 2, 211, "CompareWithQueryResultsExpression.ComparisonTypeIsEmpty.txt", new Object[0]);
            }
        }
        return out;
    }

    private static boolean oneOutputColumnAggregatingQuery(BusinessQuery query) {
        DataItem di;
        SelectedItem si;
        boolean out = false;
        List<SelectedItem> selectedItems = query.getSelectedItems();
        if (selectedItems.size() == 1 && (si = selectedItems.get(0)).getRole() == Role.COLUMN && (di = si.getItem()).getUsage() == DataItemActionType.USAGE_AGGREGATE) {
            out = true;
        }
        return out;
    }

    @Override
    protected String getDefinitionElementName() {
        return "CompareWithQueryResults";
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setEnumAttr(thisElement, "operator", this._operator);
        IQModelImplUtilities.setEnumAttr(thisElement, "comparisonType", this._comparisonType, ComparisonType.COMPARE_WITH_SINGLE_QUERY_RESULT_VALUE);
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._operator = ComparisonOperator.consumeValue(attrsProvider, "operator", null);
        this._comparisonType = ComparisonType.consumeValue(attrsProvider, "comparisonType", ComparisonType.COMPARE_WITH_SINGLE_QUERY_RESULT_VALUE);
    }

    public String toString() {
        try {
            return (this.isNegated() ? " NOT " : "") + "(" + StringExpressionUtil.getInstance().getText(this.getWhatToCompare()) + " " + IQModelImplUtilities.toString(this._operator) + " " + IQModelImplUtilities.toString(this._comparisonType) + " " + IQModelImplUtilities.getMessage("CompareWithQueryResultsExpression.Query.txt", new Object[0]) + ")";
        }
        catch (MetadataException e) {
            return "";
        }
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._operator == null) {
            reasons.add(new Reason((Object)this, 2, 212, "CompareWithQueryResultsExpression.ComparisonOperatorIsEmpty.txt", new Object[0]));
        }
        if (this._comparisonType == null) {
            reasons.add(new Reason((Object)this, 2, 211, "CompareWithQueryResultsExpression.ComparisonTypeIsEmpty.txt", new Object[0]));
        } else {
            Reason reason = this.getReasonNotUsableWith(this.getQuery(), this._comparisonType);
            if (reason != null) {
                reasons.add(reason);
            }
        }
    }

    @SASScope
    public static class ComparisonType
    extends AbstractEnumerationObject {
        private static final CopyOnWriteArrayList<ComparisonType> allDefined = new CopyOnWriteArrayList();
        public static final ComparisonType COMPARE_WITH_SINGLE_QUERY_RESULT_VALUE = new ComparisonType("ComparisonType.SingleValueFrom.txt", "SINGLE_VALUE");
        public static final ComparisonType COMPARE_WITH_ANY_QUERY_RESULT_VALUE = new ComparisonType("ComparisonType.AnyValueFrom.txt", "ANY_VALUE");
        public static final ComparisonType COMPARE_WITH_ALL_QUERY_RESULT_VALUES = new ComparisonType("ComparisonType.AllValuesFrom.txt", "ALL_VALUES");

        private ComparisonType(String visualKey, String persistedForm) {
            super(visualKey, persistedForm, persistedForm);
        }

        @Override
        protected void registerInstance() {
            allDefined.add(this);
        }

        public static Enumeration<ComparisonType> enumeration() {
            return new AbstractEnumerationObject.AEOEnumerator<ComparisonType>(allDefined);
        }

        public Enumeration<ComparisonType> enumerateSiblings() {
            return ComparisonType.enumeration();
        }

        public static ComparisonType consumeValue(AttributesProvider attrsProvider, String attrName, ComparisonType defaultValue) {
            return ComparisonType.consumeValue(attrsProvider, attrName, allDefined, defaultValue);
        }
    }
}

