/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.relational;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.Base;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope
public abstract class AbstractComparisonWithQueryResultsExpression
extends ConditionalExpression {
    public static final String EVENT_WHAT_TO_COMPARE_CHANGED = "What to compare changed";
    public static final String EVENT_QUERY_CHANGED = "Query definition changed";
    private ExpressionInterface _whatToCompare;
    private BusinessQuery _query;

    protected AbstractComparisonWithQueryResultsExpression() {
    }

    protected AbstractComparisonWithQueryResultsExpression(ExpressionInterface whatToCompare, BusinessQuery query) {
        this.setWhatToCompare(whatToCompare);
        this.setQuery(query);
    }

    public ExpressionInterface getWhatToCompare() {
        return this._whatToCompare;
    }

    public void setWhatToCompare(ExpressionInterface expr) {
        if (this._whatToCompare != expr) {
            this.moveListeningTo(this._whatToCompare, expr);
            this._whatToCompare = expr;
            this.fireChangeEvent(EVENT_WHAT_TO_COMPARE_CHANGED);
        }
    }

    public BusinessQuery getQuery() {
        return this._query;
    }

    public void setQuery(BusinessQuery query) {
        if (this._query != query) {
            if (this._query != null) {
                this._query.removeListener(this);
            }
            query.addListener(this);
            this._query = query;
            this.fireChangeEvent(EVENT_QUERY_CHANGED);
        }
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._whatToCompare);
    }

    protected void accumulateDirectlyReferencedModelsInDownwardDefinition(List intoList) {
        super.accumulateDirectlyReferencedModelsInDownwardDefinition(intoList);
        intoList.add(this._query);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._whatToCompare = (ExpressionInterface)AbstractComparisonWithQueryResultsExpression.replace((AbstractBase)((Object)this._whatToCompare), oldObject, newObject);
        this._query = (BusinessQuery)AbstractComparisonWithQueryResultsExpression.replace((AbstractBase)((Object)this._query), oldObject, newObject);
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        AbstractComparisonWithQueryResultsExpression.writeRelatedObject(this._whatToCompare, thisElement, writingContext, "WhatToCompare");
        AbstractComparisonWithQueryResultsExpression.writeRelatedObject((Base)((Object)this._query), thisElement, writingContext, "Query");
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._whatToCompare = (ExpressionInterface)((Object)riHolder.consumeObject("WhatToCompare"));
        this._query = (BusinessQuery)((Object)riHolder.consumeObject("Query"));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractComparisonWithQueryResultsExpression clone = (AbstractComparisonWithQueryResultsExpression)super.clone();
        if (!(this._whatToCompare instanceof BusinessModelResource) && this._whatToCompare != null) {
            ExpressionInterface expr = (ExpressionInterface)this._whatToCompare.clone();
            clone.setWhatToCompare(expr);
        }
        return clone;
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._whatToCompare == null) {
            this.nullSubexpressionNotAllowed(reasons, this._whatToCompare, "AbstractComparisonWithQueryResultsExpression.HasNullWhatToCompare.txt");
        }
        if (this._query == null) {
            reasons.add(new Reason((Object)this, 2, 213, "AbstractComparisonWithQueryResultsExpression.QueryNotSet.txt", new Object[0]));
        } else {
            reasons.addAll(this._query.getReasonsNotValid());
        }
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this._whatToCompare = this.singleReplaceResources(this._whatToCompare, oldResource, newResource, model, recursive);
        if (oldResource == this._query) {
            this._query = (BusinessQuery)((Object)newResource);
        }
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    public Reason getReasonNotUsableWith(BusinessQuery query) {
        Reason out = null;
        if (!AbstractComparisonWithQueryResultsExpression.queryHasRelationalOutput(query)) {
            out = new Reason((Object)query, 2, 209, "AbstractComparisonWithQueryResultsExpression.QueryDoesNotProduceRelationalResults.txt", new Object[0]);
        }
        return out;
    }

    private static boolean queryHasRelationalOutput(BusinessQuery query) {
        boolean relationalOutput = true;
        StructureOfData structure = query.getInputStructure();
        if (structure.isRelational() && !structure.isOLAP()) {
            List<SelectedItem> selectedItems = query.getSelectedItems();
            int size = selectedItems.size();
            for (int i = 0; i < size && relationalOutput; ++i) {
                SelectedItem si = selectedItems.get(i);
                Role role = si.getRole();
                relationalOutput = role == Role.COLUMN || role == Role.HIDDEN;
            }
        }
        return relationalOutput;
    }
}

