/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.parser;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifier;
import com.sas.iquery.metadata.expr.parser.Resource;
import com.sas.iquery.metadata.expr.parser.ResourceIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class ExpressionIdentifierList
implements Cloneable {
    List<ExpressionIdentifier> _expressionList = new ArrayList<ExpressionIdentifier>();
    List _resourceIdentifierList = new ArrayList();
    List _stringIdentifierList = new ArrayList();
    List _escapeIdentifierList = new ArrayList();

    public void add(ExpressionIdentifier identifier) {
        if (identifier == null) {
            return;
        }
        this._expressionList.add(identifier);
        if (identifier.isString()) {
            this._stringIdentifierList.add(identifier);
        } else if (identifier.isResource()) {
            this._resourceIdentifierList.add(identifier);
        } else if (identifier.isEscape()) {
            this._escapeIdentifierList.add(identifier);
        }
    }

    public int size() {
        return this._expressionList.size();
    }

    public List<ExpressionIdentifier> getIdentifiers() {
        return Collections.unmodifiableList(this._expressionList);
    }

    public ExpressionIdentifier get(int index) {
        return this._expressionList.get(index);
    }

    public List getResourceIdentifiers() {
        return Collections.unmodifiableList(this._resourceIdentifierList);
    }

    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource) throws MetadataException {
        this.replaceResource(oldResource, newResource, true);
    }

    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, boolean recursive) {
        for (ResourceIdentifier identifier : this._resourceIdentifierList) {
            BusinessModelResource businessModelResource;
            Resource resource = identifier.getResource();
            if (resource == null || (businessModelResource = resource.getBusinessModelResource()) != oldResource) continue;
            Resource theResource = new Resource(newResource);
            identifier.setResource(theResource);
        }
    }

    public List getStringIdentifiers() {
        return Collections.unmodifiableList(this._stringIdentifierList);
    }

    public List getEscapeIdentifiers() {
        return Collections.unmodifiableList(this._escapeIdentifierList);
    }

    public String getString() {
        Iterator<ExpressionIdentifier> iter = this._expressionList.iterator();
        StringBuffer buf = new StringBuffer();
        while (iter.hasNext()) {
            buf.append(iter.next());
            buf.append(" ");
        }
        return buf.toString();
    }

    public String toString() {
        return this.getString();
    }

    public boolean isCalculatedItem() {
        return this.getStringIdentifiers().size() != 0 || this.getEscapeIdentifiers().size() != 0 || this.hasBusinessResource() || this.hasMultiplePhysicalResources();
    }

    private boolean hasBusinessResource() {
        boolean found = false;
        for (ResourceIdentifier cur : this._resourceIdentifierList) {
            Resource resource = cur.getResource();
            if (resource == null || !resource.isBusinessItem()) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean hasMultiplePhysicalResources() {
        boolean found = false;
        int count = 0;
        for (ResourceIdentifier cur : this._resourceIdentifierList) {
            Resource resource = cur.getResource();
            if (resource == null || !resource.isPhysicalResource() || ++count <= 1) continue;
            found = true;
            break;
        }
        return found;
    }

    public Object clone() throws CloneNotSupportedException {
        ExpressionIdentifierList clone = (ExpressionIdentifierList)super.clone();
        clone._expressionList = new ArrayList<ExpressionIdentifier>();
        clone._resourceIdentifierList = new ArrayList();
        clone._escapeIdentifierList = new ArrayList();
        clone._stringIdentifierList = new ArrayList();
        for (ExpressionIdentifier ei : this._expressionList) {
            ExpressionIdentifier clonedIdentifier = (ExpressionIdentifier)ei.clone();
            clone.add(clonedIdentifier);
        }
        return clone;
    }

    protected void accumulateReasonsItemItselfIsUnusable(List reasons) {
    }

    protected void accumulateDirectlyReferencedItems(List intoList) {
        for (ResourceIdentifier cur : this._resourceIdentifierList) {
            Resource resource = cur.getResource();
            if (resource == null) continue;
            intoList.add(resource.getBusinessModelResource());
        }
    }

    @Nonnull
    public List<ModelItem> getDirectlyReferencedItems() {
        ArrayList<ModelItem> outList = new ArrayList<ModelItem>();
        this.accumulateDirectlyReferencedItems(outList);
        return outList;
    }
}

