/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.TimeFilterExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.jdbc.JDBCDataTypeInfo;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class TimeFilterNParallelPeriodsExpression
extends TimeFilterExpression {
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String EVENT_DATE_CHANGED = "The Date attribute has changed";
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String EVENT_TIME_LEVEL_NAME_CHANGED = "The level name attribute has changed";
    private ExpressionInterface _dateMember = null;
    private ExpressionInterface _level = null;
    private Locale _memberLocale = null;
    private static final Logger _logger = LogManager.getLogger(TimeFilterNParallelPeriodsExpression.class);

    @SASScope(value="ALL")
    @SubjectToChange
    public void setLevelName(String levelName) throws IllegalArgumentException {
        if (levelName == null) {
            MessageFormatter errmsg = IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilterNullLevelName.txt", new Object[0]);
            _logger.error((Object)errmsg);
            throw new IQueryServicesIllegalArgumentException(errmsg);
        }
        ConstantExpression constant = new ConstantExpression();
        constant.setExpressionType(3);
        constant.setValue(levelName);
        this._level = constant;
        this.fireChangeEvent(EVENT_TIME_LEVEL_NAME_CHANGED);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setLevel(ExpressionInterface level) {
        if (level != null) {
            this._level = level;
            ExpressionInterface expression = this.getWhatToCompare();
            if (expression instanceof DataItem && this.getMemberLevelRoot() == null) {
                this.fixDateTuple(expression);
            }
        } else {
            String errmsg = IQMetadataResourceBundle.getStringResource("DataItemTimeFilterNullLevelName.txt");
            _logger.error(errmsg);
            throw new IQueryServicesIllegalArgumentException(errmsg);
        }
        this.fireChangeEvent(EVENT_TIME_LEVEL_NAME_CHANGED);
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (!this.isUnresolved()) {
            Reason reason;
            Object[] reasonArgs;
            Vector<Integer> expTypes;
            int expType;
            if (this._level == null) {
                reasons.add(new Reason((Object)this, 2, 103, "DataItemTimeFilterNullLevelName.txt", new Object[0]));
            } else {
                expType = this._level.getExpressionType();
                if (expType != 3) {
                    expTypes = ExpressionUtil.getJdbcTypes(expType);
                    reasonArgs = new Object[]{this._level, JDBCDataTypeInfo.getJDBCTypeString((int)1), JDBCDataTypeInfo.getJDBCTypeString((int)((Integer)expTypes.get(0)))};
                    reason = new Reason((Object)this, 2, 226, "DataItemTimeFilterBadExpressionType.fmt.txt", reasonArgs);
                    reasons.add(reason);
                }
            }
            if (this._dateMember == null) {
                reasons.add(new Reason((Object)this, 2, 104, "DataItemTimeFilterNullDateMember.txt", new Object[0]));
            } else {
                expType = this._dateMember.getExpressionType();
                if (expType != 3) {
                    expTypes = ExpressionUtil.getJdbcTypes(expType);
                    reasonArgs = new Object[]{this._dateMember, JDBCDataTypeInfo.getJDBCTypeString((int)1), JDBCDataTypeInfo.getJDBCTypeString((int)((Integer)expTypes.get(0)))};
                    reason = new Reason((Object)this, 2, 226, "DataItemTimeFilterBadExpressionType.fmt.txt", reasonArgs);
                    reasons.add(reason);
                }
            }
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        super.accumulateReasonsPromptsAreUnusable(reasons);
        this.validateForPrompt(this._level, reasons);
        this.validateForPrompt(this._dateMember, reasons);
    }

    private void validateForPrompt(ExpressionInterface expression, List<Reason> reasons) {
        if (expression instanceof Prompt && !TimeFilterNParallelPeriodsExpression.isValidOlapMemberPrompt((Prompt)expression)) {
            Reason reason = new Reason((Object)this, 8, 225, "Expression.InvalidSingleSelectOlapMemberPrompt.fmt.txt", this, expression);
            reasons.add(reason);
        }
    }

    private void determineMemberLocale(ExpressionInterface expression) {
        if (expression instanceof DataItem) {
            DataItem da = (DataItem)expression;
            BusinessModel model = da.getBusinessModel();
            this._memberLocale = LocaleUtilities.getDefaultViewerLocale(model);
        } else {
            this._memberLocale = LocaleUtilities.getDefaultViewerLocale();
        }
    }

    public void setDateMember(String date) throws IllegalArgumentException {
        if (date != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(date);
            this._dateMember = constant;
            ExpressionInterface expression = this.getWhatToCompare();
            this.determineMemberLocale(expression);
            if (expression instanceof DataItem && this.getMemberLevelRoot() == null) {
                this.fixDateTuple(expression);
            }
        } else {
            String errmsg = IQMetadataResourceBundle.getStringResource("DataItemTimeFilterNullDateMember.txt");
            _logger.error(errmsg);
            throw new IQueryServicesIllegalArgumentException(errmsg);
        }
        this.fireChangeEvent(EVENT_DATE_CHANGED);
    }

    public Locale getMemberLocale() {
        return this._memberLocale;
    }

    public void setDate(ExpressionInterface date) throws IllegalArgumentException {
        if (date != null) {
            this._dateMember = date;
            ExpressionInterface expression = this.getWhatToCompare();
            this.determineMemberLocale(expression);
            if (expression instanceof DataItem && this.getMemberLevelRoot() == null) {
                this.fixDateTuple(expression);
            }
        } else {
            String errmsg = IQMetadataResourceBundle.getStringResource("DataItemTimeFilterNullDateMember.txt");
            _logger.error(errmsg);
            throw new IQueryServicesIllegalArgumentException(errmsg);
        }
        this.fireChangeEvent(EVENT_DATE_CHANGED);
    }

    public String getDateMember() {
        String dataMember;
        if (this._dateMember instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)this._dateMember;
            dataMember = constant.getValue();
        } else {
            dataMember = "";
        }
        return dataMember;
    }

    public ExpressionInterface getDate() {
        return this._dateMember;
    }

    public String getLevelName() {
        String level;
        if (this._level instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)this._level;
            level = constant.getValue();
        } else {
            level = "";
        }
        return level;
    }

    public ExpressionInterface getLevel() {
        return this._level;
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        TimeFilterNParallelPeriodsExpression clone = (TimeFilterNParallelPeriodsExpression)super.clone();
        clone._level = TimeFilterNParallelPeriodsExpression.cloneReferencedExpression(this._level);
        clone._dateMember = TimeFilterNParallelPeriodsExpression.cloneReferencedExpression(this._dateMember);
        return clone;
    }

    @Override
    @SASScope
    public String toString() {
        String result;
        block2: {
            result = null;
            try {
                result = StringExpressionUtil.getInstance().getReadableText(this);
            }
            catch (MetadataException me) {
                result = "(Level Name: " + this._level + " Date member: " + this._dateMember + ")";
                if (!_logger.isDebugEnabled()) break block2;
                _logger.debug("Exception getting readable text for TimeFilterNParallelPeriodsExpression", (Throwable)me);
            }
        }
        return result;
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "TimeNParallelPeriodsFilterExpr";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        TimeFilterNParallelPeriodsExpression.writeRelatedObject(this._dateMember, thisElement, writingContext, "DateMember");
        TimeFilterNParallelPeriodsExpression.writeRelatedObject(this._level, thisElement, writingContext, "Level");
        if (this._memberLocale != null) {
            this.writeDataLocale(this._memberLocale, thisElement, writingContext, "DataLocale");
            writingContext.adjustModelVersion(ModelVersion.VERSION_94);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        String level;
        super.consumeAttributes(attrsProvider);
        String dateMember = attrsProvider.consumeAttr("timeDateMember");
        if (dateMember != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(dateMember);
            this._dateMember = constant;
        }
        if ((level = attrsProvider.consumeAttr("timeLevelName")) != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(level);
            this._level = constant;
        }
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        AbstractBase dateMember;
        super.consumeRelatedObjects(riHolder);
        AbstractBase level = riHolder.consumeObject("Level");
        if (level != null) {
            this._level = (ExpressionInterface)((Object)level);
        }
        if ((dateMember = riHolder.consumeObject("DateMember")) != null) {
            this._dateMember = (ExpressionInterface)((Object)dateMember);
        }
        this._memberLocale = (Locale)riHolder.consumeForeignObject("DataLocale");
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        String level;
        super.readDefinitionV1(thisElement, readingContext);
        String dateMember = IQModelImplUtilities.getAttr(thisElement, "timeDateMember");
        if (dateMember != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(dateMember);
            this._dateMember = constant;
        }
        if ((level = IQModelImplUtilities.getAttr(thisElement, "timeLevelName")) != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(level);
            this._level = constant;
        }
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        if (this._level instanceof AbstractModelItem) {
            intoList.add(this._level);
        }
        if (this._dateMember instanceof AbstractModelItem) {
            intoList.add(this._dateMember);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        super.replaceDirectReferences(oldObject, newObject);
        this._dateMember = (ExpressionInterface)TimeFilterNParallelPeriodsExpression.replace(this._dateMember, oldObject, newObject);
        this._level = (ExpressionInterface)TimeFilterNParallelPeriodsExpression.replace(this._level, oldObject, newObject);
    }

    @Override
    @SASScope
    protected void replaceDirectReferencesDuringResourceReplacement(Object oldObject, Object newObject) {
        if (this._dateMember instanceof ConstantExpression && BusinessQueryOLAPUtil.shouldReplaceStringInFilter(this.getWhatToCompare(), newObject)) {
            ExpressionInterface prevdate = this._dateMember;
            BusinessQueryOLAPUtil.replaceHierarchyInFilter(this._dateMember, this.getWhatToCompare(), newObject);
            MDXGenerationUtil.applyDebugStatement("Date member replaced from " + prevdate.toString() + " to " + this._dateMember.toString(), this.getClass());
        }
        super.replaceDirectReferencesDuringResourceReplacement(oldObject, newObject);
        if (this._level instanceof ConstantExpression && BusinessQueryOLAPUtil.shouldReplaceStringInFilter(this.getWhatToCompare(), newObject) && !BusinessQueryOLAPUtil.isPersistencePath(oldObject, newObject)) {
            ExpressionInterface prevlevel = this._level;
            BusinessQueryOLAPUtil.replaceHierarchyInFilter(this._level, this.getWhatToCompare(), newObject);
            MDXGenerationUtil.applyDebugStatement("Level replaced from " + prevlevel.toString() + " to " + this._level.toString(), this.getClass());
        }
    }
}

