/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.TimeFilterExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.jdbc.JDBCDataTypeInfo;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class TimeFilterFirstLastPeriodsExpression
extends TimeFilterExpression {
    public static final String EVENT_TIME_LEVEL_NAME_CHANGED = "The level name attribute has changed";
    private ExpressionInterface _level = null;
    private static final Logger _logger = LogManager.getLogger(TimeFilterFirstLastPeriodsExpression.class);

    public void setLevelName(String levelName) throws IllegalArgumentException {
        if (levelName != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(levelName);
            this._level = constant;
            ExpressionInterface expression = this.getWhatToCompare();
            if (expression instanceof DataItem && this.getMemberLevelRoot() == null) {
                this.fixDateTuple(expression);
            }
        } else {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilterNullLevelName.txt", new Object[0]));
        }
        this.fireChangeEvent(EVENT_TIME_LEVEL_NAME_CHANGED);
    }

    public String getLevelName() {
        String level;
        if (this._level instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)this._level;
            level = constant.getValue();
        } else {
            level = "";
        }
        return level;
    }

    public void setLevel(ExpressionInterface level) {
        if (level != null) {
            this._level = level;
            ExpressionInterface expression = this.getWhatToCompare();
            if (expression instanceof DataItem && this.getMemberLevelRoot() == null) {
                this.fixDateTuple(expression);
            }
        } else {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilterNullLevelName.txt", new Object[0]));
        }
        this.fireChangeEvent(EVENT_TIME_LEVEL_NAME_CHANGED);
    }

    public ExpressionInterface getLevel() {
        return this._level;
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (!this.isUnresolved()) {
            if (this._level == null) {
                reasons.add(new Reason((Object)this, 2, 103, "DataItemTimeFilterNullLevelName.txt", new Object[0]));
            } else {
                int expType = this._level.getExpressionType();
                if (expType != 3) {
                    Vector<Integer> expTypes = ExpressionUtil.getJdbcTypes(expType);
                    Object[] reasonArgs = new Object[]{this._level, JDBCDataTypeInfo.getJDBCTypeString((int)1), JDBCDataTypeInfo.getJDBCTypeString((int)((Integer)expTypes.get(0)))};
                    Reason reason = new Reason((Object)this, 2, 226, "DataItemTimeFilterBadExpressionType.fmt.txt", reasonArgs);
                    reasons.add(reason);
                }
            }
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        super.accumulateReasonsPromptsAreUnusable(reasons);
        if (this._level instanceof Prompt && !TimeFilterFirstLastPeriodsExpression.isValidOlapMemberPrompt((Prompt)this._level)) {
            Reason reason = new Reason((Object)this, 8, 225, "Expression.InvalidSingleSelectOlapMemberPrompt.fmt.txt", this, this._level);
            reasons.add(reason);
        }
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        TimeFilterFirstLastPeriodsExpression clone = (TimeFilterFirstLastPeriodsExpression)super.clone();
        clone._level = TimeFilterFirstLastPeriodsExpression.cloneReferencedExpression(this._level);
        return clone;
    }

    @Override
    @SASScope
    public String toString() {
        String result;
        block2: {
            result = null;
            try {
                result = StringExpressionUtil.getInstance().getReadableText(this);
            }
            catch (MetadataException me) {
                result = "(Level Name: " + this._level + ")";
                if (!_logger.isDebugEnabled()) break block2;
                _logger.debug("Exception getting readable text for TimeFilterFirstLastPeriodsExpression", (Throwable)me);
            }
        }
        return result;
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "TimeFirstLastPeriodsFilterExpr";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        TimeFilterFirstLastPeriodsExpression.writeRelatedObject(this._level, thisElement, writingContext, "Level");
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        String level = attrsProvider.consumeAttr("timeLevelName");
        if (level != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(level);
            this._level = constant;
        }
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        AbstractBase level = riHolder.consumeObject("Level");
        if (level != null) {
            this._level = (ExpressionInterface)((Object)level);
        }
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        String level = IQModelImplUtilities.getAttr(thisElement, "timeLevelName");
        if (level != null) {
            ConstantExpression constant = new ConstantExpression();
            constant.setExpressionType(3);
            constant.setValue(level);
            this._level = constant;
        }
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        if (this._level instanceof AbstractModelItem) {
            intoList.add(this._level);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        super.replaceDirectReferences(oldObject, newObject);
        this._level = (ExpressionInterface)TimeFilterFirstLastPeriodsExpression.replace(this._level, oldObject, newObject);
    }

    @Override
    @SASScope
    protected void replaceDirectReferencesDuringResourceReplacement(Object oldObject, Object newObject) {
        super.replaceDirectReferencesDuringResourceReplacement(oldObject, newObject);
        if (!(newObject instanceof PhysicalResource && ((PhysicalResource)newObject).isUnresolved() || !(this._level instanceof ConstantExpression) || !BusinessQueryOLAPUtil.shouldReplaceStringInFilter(this.getWhatToCompare(), newObject) || BusinessQueryOLAPUtil.isPersistencePath(oldObject, newObject))) {
            ExpressionInterface prelevel = this._level;
            BusinessQueryOLAPUtil.replaceHierarchyInFilter(this._level, this.getWhatToCompare(), newObject);
            MDXGenerationUtil.applyDebugStatement("Level replaced from " + prelevel.toString() + " to " + this._level.toString(), this.getClass());
        }
    }
}

