/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.impl.AbstractExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class TimeExpressionMeasure
extends AbstractExpression
implements ExpressionInterface {
    public static final String EVENT_TIME_MEASURE_CHANGED = "Measure changed";
    public static final String EVENT_TIME_FUNCTION_CHANGED = "Function changed";
    public static final String EVENT_START_PERIOD_CHANGED = "The Starting Period attribute has changed";
    public static final String DIFFERENCE_PREVIOUS_PERIOD = "DIFFERENCE_PREVIOUS_PERIOD";
    public static final String DIFFERENCE_PREVIOUS_YEAR = "DIFFERENCE_PREVIOUS_YEAR";
    public static final String PERCENTCHANGE_PREVIOUS_PERIOD = "PERCENTCHANGE_PREVIOUS_PERIOD";
    public static final String PERCENTCHANGE_PREVIOUS_YEAR = "PERCENTCHANGE_PREVIOUS_YEAR";
    public static final String CUMULATIVE = "CUMULATIVE";
    private String _startingPeriod = null;
    private DataItem _measure = null;
    private String _function = null;
    private static final Logger _logger = LogManager.getLogger(TimeExpressionMeasure.class);

    public TimeExpressionMeasure() {
    }

    public TimeExpressionMeasure(DataItem measure, String function) {
        this.setFunction(function);
        this.setMeasure(measure);
    }

    public void setMeasure(DataItem measure) throws IllegalArgumentException {
        if (measure != null && measure.getExpressionType() != 2) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("TimeExpressionMeasureNullMeasureName.txt", new Object[0]));
        }
        if (measure == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("TimeExpressionMeasureNullMeasureName.txt", new Object[0]));
        }
        ExpressionInterface expression = measure.getExpression();
        Utils.ensureProperArgumentType(measure, new Class[]{ExpressionInterface.class});
        if (!(expression instanceof Measure) && !(expression instanceof StringExpression)) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("TimeExpressionMeasureNotAMeasure.txt", new Object[0]));
        }
        this._measure = measure;
        this.fireChangeEvent(EVENT_TIME_MEASURE_CHANGED);
    }

    public DataItem getMeasure() {
        return this._measure;
    }

    public void setFunction(String function) throws IllegalArgumentException {
        if (!(function != null && (function.equals(DIFFERENCE_PREVIOUS_PERIOD) || function.equals(DIFFERENCE_PREVIOUS_YEAR) || function.equals(PERCENTCHANGE_PREVIOUS_YEAR) || function.equals(PERCENTCHANGE_PREVIOUS_PERIOD) || function.equals(CUMULATIVE)))) {
            MessageFormatter errmsg = IQModelImplUtilities.getMessageFormatter("TimeExpressionMeasureInvalidFunction.txt", new Object[0]);
            _logger.error((Object)errmsg);
            throw new IQueryServicesIllegalArgumentException(errmsg);
        }
        this._function = function;
        this.fireChangeEvent(EVENT_TIME_FUNCTION_CHANGED);
    }

    public String getFunction() {
        return this._function;
    }

    public void setPeriod(String startingPeriod) {
        this._startingPeriod = startingPeriod;
        this.fireChangeEvent(EVENT_START_PERIOD_CHANGED);
    }

    public String getPeriod() {
        return this._startingPeriod;
    }

    @Override
    public int getExpressionType() {
        return 2;
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        DataItem oldTimeItem = this._measure;
        this._measure = (DataItem)Utils.replaceResource(this._measure, oldResource, newResource, model, recursive);
        if (oldTimeItem != this._measure) {
            this.moveListeningTo(oldTimeItem, this._measure);
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        DataItem da;
        ExpressionInterface ex;
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._measure == null) {
            reasons.add(new Reason((Object)this, 2, 99, "TimeExpressionMeasure.measureIsNull.txt", new Object[0]));
        }
        if (this._function == null) {
            reasons.add(new Reason((Object)this, 2, 100, "TimeExpressionMeasure.FunctionIsNull.txt", new Object[0]));
        }
        if (!((ex = (da = this.getMeasure()).getExpression()) instanceof Measure) && !(ex instanceof StringExpression)) {
            reasons.add(new Reason((Object)this, 2, 202, "TimeExpressionMeasureNotAMeasure.txt", new Object[0]));
        }
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._measure);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._measure = (DataItem)TimeExpressionMeasure.replace(this._measure, oldObject, newObject);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        TimeExpressionMeasure clone = (TimeExpressionMeasure)super.clone();
        clone._measure = this._measure;
        clone._function = this._function;
        return clone;
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        TimeExpressionMeasure.writeRelatedObject(this._measure, thisElement, writingContext, "Measure");
        IQModelImplUtilities.setAttr(thisElement, "ftn", this._function);
        IQModelImplUtilities.setAttr(thisElement, "period", this._startingPeriod);
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._function = attrsProvider.consumeAttrAndInternResult("ftn");
        this._startingPeriod = attrsProvider.consumeAttr("period");
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._measure = (DataItem)((Object)riHolder.consumeObject("Measure"));
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._measure = (DataItem)((Object)TimeExpressionMeasure.v1_readItemUnderSubelement(thisElement, readingContext, "Expression", new Class[]{ExpressionInterface.class}));
        this._function = IQModelImplUtilities.getAttrAndInternResult(thisElement, "function");
        this._startingPeriod = IQModelImplUtilities.getAttr(thisElement, "period");
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "TimeExpressionMeasure";
    }

    @SASScope
    public String toString() {
        return "(OLAP Time Measure: " + this._function + " " + this._startingPeriod + " " + Utils.toString(this._measure) + "))";
    }
}

