/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.olap;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.AbstractTimeRangeFilterExpression;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.jdbc.JDBCDataTypeInfo;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope
public class PromptedTimeRangeFilterExpression
extends AbstractTimeRangeFilterExpression {
    public static final String EVENT_RANGE_PROMPT_MEMBER_CHANGED = "The range prompt attribute has changed";
    private Prompt _rangePrompt = null;
    private static final Logger _logger = LogManager.getLogger(PromptedTimeRangeFilterExpression.class);

    public PromptedTimeRangeFilterExpression() {
    }

    public PromptedTimeRangeFilterExpression(Prompt rangePrompt) {
        this.setRangePrompt(rangePrompt);
    }

    public void setRangePrompt(Prompt rangePrompt) throws IllegalArgumentException {
        if (rangePrompt == null) {
            MessageFormatter errmsg = IQMetadataResourceBundle.getMessageFormatter("DataItemTimeFilterNullDateMember.txt", new Object[0]);
            _logger.error((Object)errmsg);
            throw new IQueryServicesIllegalArgumentException(errmsg);
        }
        this._rangePrompt = rangePrompt;
        this.fireChangeEvent(EVENT_RANGE_PROMPT_MEMBER_CHANGED);
    }

    public Prompt getRangePrompt() {
        return this._rangePrompt;
    }

    @Override
    protected String getDefinitionElementName() {
        return "PromptedTimeRangeFilterExpr";
    }

    public String toString() {
        String result = null;
        try {
            result = StringExpressionUtil.getInstance().getReadableText(this);
        }
        catch (MetadataException me) {
            result = "PromptedTimeRangeFilterExpression(Prompt=" + this._rangePrompt + ")";
            _logger.debug("Exception getting readable text for PromptedTimeRangeFilterExpression", (Throwable)me);
        }
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PromptedTimeRangeFilterExpression clone = (PromptedTimeRangeFilterExpression)super.clone();
        clone._rangePrompt = (Prompt)PromptedTimeRangeFilterExpression.cloneReferencedExpression(this._rangePrompt);
        return clone;
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        PromptedTimeRangeFilterExpression.writeRelatedObject(this._rangePrompt, thisElement, writingContext, "RangePrompt");
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._rangePrompt = (Prompt)((Object)riHolder.consumeObject("RangePrompt"));
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        intoList.add(this._rangePrompt);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        super.replaceDirectReferences(oldObject, newObject);
        this._rangePrompt = (Prompt)PromptedTimeRangeFilterExpression.replace(this._rangePrompt, oldObject, newObject);
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (!this.isUnresolved()) {
            if (this._rangePrompt != null) {
                int expType = this._rangePrompt.getExpressionType();
                if (expType != 3) {
                    Vector<Integer> expTypes = ExpressionUtil.getJdbcTypes(expType);
                    Object[] reasonArgs = new Object[]{this._rangePrompt, JDBCDataTypeInfo.getJDBCTypeString((int)1), JDBCDataTypeInfo.getJDBCTypeString((int)((Integer)expTypes.get(0)))};
                    Reason reason = new Reason((Object)this, 2, 226, "DataItemTimeFilterBadExpressionType.fmt.txt", reasonArgs);
                    reasons.add(reason);
                }
            } else {
                Reason reason = new Reason((Object)this, 2, 32, "DataItemTimeFilterNullRangePrompt.txt", new Object[0]);
                reasons.add(reason);
            }
        }
    }

    @Override
    protected void accumulateReasonsPromptsAreUnusable(List<Reason> reasons) {
        super.accumulateReasonsPromptsAreUnusable(reasons);
        if (!ExpressionUtil.isRangePrompt(this._rangePrompt) || !PromptedTimeRangeFilterExpression.isOLAPMemberNameDefinition(this._rangePrompt)) {
            Reason reason = new Reason((Object)this, 8, 225, "Expression.InvalidRangeOlapMemberPrompt.fmt.txt", this, this._rangePrompt);
            reasons.add(reason);
        }
    }
}

