/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.olap;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ListUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public class DataBasedFilterExpression_Between
extends ConditionalExpression {
    public static final String EVENT_WHAT_TO_FILTER_CHANGED = "What to filter changed";
    public static final String EVENT_COMPARISON_OPERATOR_CHANGED = "Comparison operator changed";
    public static final String EVENT_LOWER_BOUND_CHANGED = "Lower bound changed";
    public static final String EVENT_UPPER_BOUND_CHANGED = "Upper bound changed";
    public static final String EVENT_WHAT_TO_COMPARE_CHANGED = "What to compare changed";
    @SASScope
    protected ExpressionInterface whatToFilter;
    private List<ExpressionInterface> whatToCompare = new ArrayList<ExpressionInterface>();
    @SASScope
    protected List<ExpressionInterface> lowerBound = new ArrayList<ExpressionInterface>();
    @SASScope
    protected List<ExpressionInterface> upperBound = new ArrayList<ExpressionInterface>();

    public void setWhatToFilter(ExpressionInterface expr) {
        this.changeableCheck();
        this.moveListeningTo(this.whatToFilter, expr);
        this.whatToFilter = expr;
        this.fireChangeEvent(EVENT_WHAT_TO_FILTER_CHANGED);
    }

    public ExpressionInterface getWhatToFilter() {
        return this.whatToFilter;
    }

    public void setWhatToCompare(List<? extends ExpressionInterface> values) {
        this.changeableCheck();
        this.removeListeningTo(this.whatToCompare);
        this.whatToCompare = ListUtils.newList(values);
        Preconditions.ensureNonNullTypedElements(this.whatToCompare, ExpressionInterface.class);
        this.listenTo(this.whatToCompare);
        this.fireChangeEvent(EVENT_WHAT_TO_COMPARE_CHANGED);
    }

    public List<ExpressionInterface> getWhatToCompare() {
        return ListUtils.newList(this.whatToCompare);
    }

    public void setLowerBound(List<ExpressionInterface> values) {
        this.changeableCheck();
        this.removeListeningTo(this.lowerBound);
        this.lowerBound = ListUtils.newList(values);
        Preconditions.ensureNonNullTypedElements(this.lowerBound, ExpressionInterface.class);
        this.listenTo(this.lowerBound);
        this.fireChangeEvent(EVENT_LOWER_BOUND_CHANGED);
    }

    public List<ExpressionInterface> getLowerBound() {
        return ListUtils.newList(this.lowerBound);
    }

    public void setUpperBound(List<? extends ExpressionInterface> values) {
        this.changeableCheck();
        this.removeListeningTo(this.upperBound);
        this.upperBound = ListUtils.newList(values);
        Preconditions.ensureNonNullTypedElements(this.upperBound, ExpressionInterface.class);
        this.listenTo(this.upperBound);
        this.fireChangeEvent(EVENT_UPPER_BOUND_CHANGED);
    }

    public List<ExpressionInterface> getUpperBound() {
        return ListUtils.newList(this.upperBound);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        ExpressionInterface expr;
        if (this.whatToFilter != null && (expr = this.singleReplaceResources(this.whatToFilter, oldResource, newResource, model, recursive)) != this.whatToFilter) {
            this.setWhatToFilter(expr);
        }
        this.singleReplaceResourcesInList(this.lowerBound, oldResource, newResource, model, recursive);
        this.singleReplaceResourcesInList(this.upperBound, oldResource, newResource, model, recursive);
        this.singleReplaceResourcesInList(this.whatToCompare, oldResource, newResource, model, recursive);
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        DataBasedFilterExpression_Between clone = (DataBasedFilterExpression_Between)super.clone();
        if (this.whatToFilter != null && !(this.whatToFilter instanceof BusinessModelResource)) {
            clone.setWhatToFilter((ExpressionInterface)this.whatToFilter.clone());
        }
        List<ExpressionInterface> newLeftList = Utils.cloneExpressionList(this.lowerBound, false);
        clone.setLowerBound(newLeftList);
        List<ExpressionInterface> newRightList = Utils.cloneExpressionList(this.upperBound, false);
        clone.setUpperBound(newRightList);
        List<ExpressionInterface> newCenterList = Utils.cloneExpressionList(this.whatToCompare, false);
        clone.setWhatToCompare(newCenterList);
        return clone;
    }

    @SASScope
    public String toString() {
        return "(" + IQModelImplUtilities.toString(this.whatToFilter) + " " + IQModelImplUtilities.toString(this.whatToCompare) + " IS " + (this.isNegated() ? "NOT " : "") + "BETWEEN " + IQModelImplUtilities.toString(this.lowerBound) + " AND " + IQModelImplUtilities.toString(this.upperBound) + ")";
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this.lowerBound == null || this.lowerBound.size() == 0) {
            reasons.add(new Reason((Object)this, 2, 35, "DataBasedFilterExpression_Between.HasEmptyLowerBoundList.txt", new Object[0]));
        }
        if (this.upperBound == null || this.upperBound.size() == 0) {
            reasons.add(new Reason((Object)this, 2, 36, "DataBasedFilterExpression_Between.HasEmptyUpperBoundList.txt", new Object[0]));
        }
        if (this.whatToCompare == null || this.whatToCompare.size() == 0) {
            reasons.add(new Reason((Object)this, 2, 32, "DataBasedFilterExpression_Between.HasEmptyWhatToCompareList.txt", new Object[0]));
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "OLAPBetweenExpr";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        DataBasedFilterExpression_Between.writeRelatedObject(this.whatToFilter, thisElement, writingContext, "WhatToFilter");
        DataBasedFilterExpression_Between.writeRelatedObjects(this.lowerBound, thisElement, writingContext, "LeftExprs");
        DataBasedFilterExpression_Between.writeRelatedObjects(this.whatToCompare, thisElement, writingContext, "WhatToCompare");
        DataBasedFilterExpression_Between.writeRelatedObjects(this.upperBound, thisElement, writingContext, "RightExprs");
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this.whatToFilter = (ExpressionInterface)((Object)riHolder.consumeObject("WhatToFilter"));
        this.lowerBound = riHolder.consumeObjects("LeftExprs", ExpressionInterface.class);
        this.whatToCompare = riHolder.consumeObjects("WhatToCompare", ExpressionInterface.class);
        this.upperBound = riHolder.consumeObjects("RightExprs", ExpressionInterface.class);
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this.whatToFilter = (ExpressionInterface)((Object)DataBasedFilterExpression_Between.v1_readItemUnderSubelement(thisElement, readingContext, "WhatToFilter", new Class[]{ExpressionInterface.class}));
        this.lowerBound = DataBasedFilterExpression_Between.v1_readItemListUnderSubelement(thisElement, readingContext, "LeftExprList", new Class[]{ExpressionInterface.class, DataItem.class});
        this.whatToCompare = DataBasedFilterExpression_Between.v1_readItemListUnderSubelement(thisElement, readingContext, "WhatToCompare", new Class[]{ExpressionInterface.class});
        this.upperBound = DataBasedFilterExpression_Between.v1_readItemListUnderSubelement(thisElement, readingContext, "RightExprList", new Class[]{ExpressionInterface.class, DataItem.class});
    }

    @Override
    @SASScope
    public void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        if (this.lowerBound != null) {
            intoList.addAll(this.lowerBound);
        }
        if (this.upperBound != null) {
            intoList.addAll(this.upperBound);
        }
        if (this.whatToCompare != null) {
            intoList.addAll(this.whatToCompare);
        }
        intoList.add(this.whatToFilter);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        DataBasedFilterExpression_Between.replaceInList(this.lowerBound, oldObject, newObject);
        DataBasedFilterExpression_Between.replaceInList(this.upperBound, oldObject, newObject);
        DataBasedFilterExpression_Between.replaceInList(this.whatToCompare, oldObject, newObject);
        this.whatToFilter = (ExpressionInterface)DataBasedFilterExpression_Between.replace(this.whatToFilter, oldObject, newObject);
    }
}

