/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.olap;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.olap.BaseFilterExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ListUtils;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public class DataBasedFilterExpression
extends BaseFilterExpression {
    public static final String EVENT_WHAT_TO_FILTER_CHANGED = "What to filter changed";
    public static final String EVENT_COMPARISON_OPERATOR_CHANGED = "Comparison operator changed";
    public static final String EVENT_LEFT_EXPRESSION_CHANGED = "Left expression changed";
    public static final String EVENT_RIGHT_EXPRESSION_CHANGED = "Right expression changed";
    @SASScope
    protected List<ExpressionInterface> _leftExpr = ListUtils.newList(3);
    @SASScope
    protected ComparisonOperator _operator;
    @SASScope
    protected List<ExpressionInterface> _rightExpr = ListUtils.newList(3);

    public void setWhatToFilter(ExpressionInterface expr) {
        this.setWhatToCompare(expr);
        this.fireChangeEvent(EVENT_WHAT_TO_FILTER_CHANGED);
    }

    @Override
    @SASScope
    public void setWhatToCompare(ExpressionInterface expr) {
        if (!(expr instanceof DataItem)) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("IQModelImplUtilities.ImproperObjTypeSpecified.fmt.txt", expr.getClass().getName(), DataItem.class));
        }
        super.setWhatToCompare(expr);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public ExpressionInterface getWhatToFilter() {
        return this.getWhatToCompare();
    }

    @SASScope
    public ComparisonOperator getComparisonOperator() {
        return this._operator;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setComparisonOperator(ComparisonOperator operator) {
        if (this._operator != operator) {
            this._operator = operator;
            this.fireChangeEvent(EVENT_COMPARISON_OPERATOR_CHANGED);
        }
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setLeftExpression(List<? extends ExpressionInterface> values) {
        this.removeListeningTo(this._leftExpr);
        this._leftExpr = ListUtils.newList(values);
        Preconditions.ensureNonNullTypedElements(this._leftExpr, ExpressionInterface.class);
        this.listenTo(this._leftExpr);
        this.fireChangeEvent(EVENT_LEFT_EXPRESSION_CHANGED);
    }

    public List<ExpressionInterface> getLeftExpression() {
        return ListUtils.newList(this._leftExpr);
    }

    public void setRightExpression(List<? extends ExpressionInterface> values) {
        this.removeListeningTo(this._rightExpr);
        this._rightExpr = ListUtils.newList(values);
        Preconditions.ensureNonNullTypedElements(this._rightExpr, ExpressionInterface.class);
        this.listenTo(this._rightExpr);
        this.fireChangeEvent(EVENT_RIGHT_EXPRESSION_CHANGED);
    }

    public List<ExpressionInterface> getRightExpression() {
        return ListUtils.newList(this._rightExpr);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        super.replaceResource(oldResource, newResource, model, recursive);
        this.singleReplaceResourcesInList(this._leftExpr, oldResource, newResource, model, recursive);
        this.singleReplaceResourcesInList(this._rightExpr, oldResource, newResource, model, recursive);
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        super.clone();
        DataBasedFilterExpression clone = (DataBasedFilterExpression)super.clone();
        List<ExpressionInterface> newLeftList = Utils.cloneExpressionList(this._leftExpr, true);
        clone.setLeftExpression(newLeftList);
        List<ExpressionInterface> newRightList = Utils.cloneExpressionList(this._rightExpr, true);
        clone.setRightExpression(newRightList);
        return clone;
    }

    @SASScope
    public String toString() {
        return "(" + IQModelImplUtilities.toString(super.getWhatToCompare()) + " " + IQModelImplUtilities.toString(this._leftExpr) + " " + IQModelImplUtilities.toString(this._operator) + " " + IQModelImplUtilities.toString(this._rightExpr) + ")";
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        this.accumulateReasonsListExprsInvalid(reasons, this._leftExpr, 2, 35, "DataBasedFilterExpression.HasEmptyLeftExpressionList.txt", 2, 31, "DataBasedFilterExpression.ReferencesInvalidExpressionTypeOnLeft.txt");
        this.accumulateReasonsListExprsInvalid(reasons, this._rightExpr, 2, 36, "DataBasedFilterExpression.HasEmptyRightExpressionList.txt", 2, 31, "DataBasedFilterExpression.ReferencesInvalidExpressionTypeOnRight.txt");
        if (this._operator == null) {
            reasons.add(new Reason((Object)this, 2, 37, "DataBasedFilterExpression.HasNullComparisonOperator.txt", new Object[0]));
        }
    }

    private void accumulateReasonsListExprsInvalid(List<Reason> reasons, List<? extends ExpressionInterface> list, int emptyListReasonCode, int emptyListSubReasonCode, String emptyListResourceKey, int invalidTypeReasonCode, int invalidTypeSubReasonCode, String invalidTypeResourceKey) {
        if (list == null || list.size() == 0) {
            reasons.add(new Reason((Object)this, emptyListReasonCode, emptyListSubReasonCode, emptyListResourceKey, new Object[0]));
        } else {
            for (ExpressionInterface expressionInterface : list) {
                if (expressionInterface instanceof DataItem) {
                    DataItem da = (DataItem)expressionInterface;
                    ExpressionInterface daExpression = da.getExpression();
                    reasons.addAll(this.getReasonsExprIsUnusableAsExpressionArg(daExpression, "Expression.ReferencesNullSubexpression.txt"));
                    continue;
                }
                if (expressionInterface instanceof ExpressionInterface) {
                    reasons.addAll(this.getReasonsExprIsUnusableAsExpressionArg(expressionInterface, "Expression.ReferencesNullSubexpression.txt"));
                    continue;
                }
                reasons.add(new Reason((Object)this, invalidTypeReasonCode, invalidTypeSubReasonCode, invalidTypeResourceKey, new Object[0]));
            }
        }
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        if (this._leftExpr != null) {
            intoList.addAll(this._leftExpr);
        }
        if (this._rightExpr != null) {
            intoList.addAll(this._rightExpr);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        super.replaceDirectReferences(oldObject, newObject);
        DataBasedFilterExpression.replaceInList(this._leftExpr, oldObject, newObject);
        DataBasedFilterExpression.replaceInList(this._rightExpr, oldObject, newObject);
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "DataBasedFilterExpr";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setEnumAttr(thisElement, "operator", this._operator);
        DataBasedFilterExpression.writeRelatedObjects(this._leftExpr, thisElement, writingContext, "LeftExprs");
        DataBasedFilterExpression.writeRelatedObjects(this._rightExpr, thisElement, writingContext, "RightExprs");
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._operator = ComparisonOperator.consumeValue(attrsProvider, "operator", null);
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._leftExpr = riHolder.consumeObjects("LeftExprs", ExpressionInterface.class);
        this._rightExpr = riHolder.consumeObjects("RightExprs", ExpressionInterface.class);
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._operator = ComparisonOperator.fromPersistentForm(IQModelImplUtilities.getAttr(thisElement, "op"));
        ExpressionInterface _whatToFilter = (ExpressionInterface)((Object)DataBasedFilterExpression.v1_readItemUnderSubelement(thisElement, readingContext, "WhatToFilter", VALID_TYPES_ANY_EXPRESSION));
        if (_whatToFilter != null) {
            this.setWhatToFilter(_whatToFilter);
        }
        this._leftExpr = DataBasedFilterExpression.v1_readItemListUnderSubelement(thisElement, readingContext, "LeftExprList", VALID_TYPES_ANY_EXPRESSION);
        this._rightExpr = DataBasedFilterExpression.v1_readItemListUnderSubelement(thisElement, readingContext, "RightExprList", VALID_TYPES_ANY_EXPRESSION);
    }
}

