/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.iqtextparser;

import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.expr.iqtextparser.Messages;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedToken;
import com.sas.iquery.metadata.expr.iqtextparser.Token;
import com.sas.iquery.metadata.expr.iqtextparser.TokenError;
import com.sas.iquery.metadata.expr.iqtextparser.Tokenizer;
import com.sas.iquery.util.impl.MessageFormatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class TokenizerImpl
implements Tokenizer {
    public int tokIndex = 0;
    ArrayList<ParsedToken> parsed = new ArrayList();

    TokenizerImpl() {
    }

    @Override
    public List<ParsedToken> getTokensRead() {
        return this.parsed;
    }

    protected ParsedToken addToParsed(Token token, String toString) {
        ParsedToken parsedToken = new ParsedToken(token, toString);
        this.parsed.add(parsedToken);
        return parsedToken;
    }

    @Override
    public int getIndex() {
        return this.tokIndex;
    }

    @Override
    public void next() {
        if (!this.isEOF()) {
            ++this.tokIndex;
            try {
                this.readToken();
            }
            catch (IOException e) {
                TokenError e2 = this.tokenerror(Messages.getBundleName(), "TokenizerImpl.ErrorReadingNextToken.txt", null);
                e2.initCause(e);
                throw e2;
            }
        }
    }

    @Override
    public abstract Token getToken();

    abstract void readToken() throws IOException;

    @Override
    public abstract boolean isEOF();

    @Override
    public TokenError tokenerror(String bundleName, String resourceKey, Token token) {
        return new TokenError(bundleName, resourceKey, new Object[]{this.tokenizerStatus(token)});
    }

    public TokenError tokenerror(String bundleName, String resourceKey, String text, Token token) {
        return new TokenError(bundleName, resourceKey, new Object[]{text, this.tokenizerStatus(token)});
    }

    @Override
    public Object tokenizerStatus(Token token) {
        Object[] tokenStatusObjects;
        String tokenStatusFormat;
        if (token == null) {
            tokenStatusFormat = "TokenizerImpl.StatusNoToken.fmt.txt";
            tokenStatusObjects = new Object[]{this.tokIndex, this.parsed};
        } else {
            tokenStatusFormat = "TokenizerImpl.StatusWithToken.fmt.txt";
            tokenStatusObjects = new Object[]{this.tokIndex, token, this.toString(token.getValue()), this.parsed};
        }
        MessageFormatter msg = IQueryServicesRuntimeException.newMessage(Messages.getBundleName(), tokenStatusFormat, tokenStatusObjects);
        return msg;
    }

    @Override
    public String toString(int tokenValueOrType) {
        String ret;
        switch (tokenValueOrType) {
            case -100: {
                ret = "<EOF>";
                break;
            }
            case -101: {
                ret = "OPENPARENTESIS";
                break;
            }
            case -102: {
                ret = "CLOSEPARENTESIS";
                break;
            }
            case -106: {
                ret = "OPENCURLYBRACE";
                break;
            }
            case -107: {
                ret = "CLOSECURLYBRACE";
                break;
            }
            case -103: {
                ret = "COMMA";
                break;
            }
            case -104: {
                ret = "COLONCOLON";
                break;
            }
            case -108: {
                ret = "COLON";
                break;
            }
            case -110: {
                ret = "PLUS";
                break;
            }
            case -111: {
                ret = "MINUS";
                break;
            }
            case -112: {
                ret = "SLASH";
                break;
            }
            case -113: {
                ret = "STAR";
                break;
            }
            case -114: {
                ret = "PERCENT";
                break;
            }
            case -150: {
                ret = "CARET";
                break;
            }
            case -151: {
                ret = "TILDE";
                break;
            }
            case -116: {
                ret = "EXPON2";
                break;
            }
            case -120: {
                ret = "CONCAT";
                break;
            }
            case -121: {
                ret = "BANG";
                break;
            }
            case -130: {
                ret = "AMPERSAND";
                break;
            }
            case -122: {
                ret = "BAR";
                break;
            }
            case -140: {
                ret = "QUESTIONMARK";
                break;
            }
            case -500: {
                ret = "RESOURCENAME";
                break;
            }
            case -600: {
                ret = "TUPLENAME";
                break;
            }
            case -105: {
                ret = "DOT";
                break;
            }
            case -200: {
                ret = "COMPARISON_EQ";
                break;
            }
            case -201: {
                ret = "COMPARISON_NE";
                break;
            }
            case -202: {
                ret = "COMPARISON_LT";
                break;
            }
            case -203: {
                ret = "COMPARISON_LE";
                break;
            }
            case -204: {
                ret = "COMPARISON_GT";
                break;
            }
            case -205: {
                ret = "COMPARISON_GE";
                break;
            }
            case -300: {
                ret = "IS";
                break;
            }
            case -301: {
                ret = "LIKE";
                break;
            }
            case -302: {
                ret = "BETWEEN";
                break;
            }
            case -303: {
                ret = "IN";
                break;
            }
            case -304: {
                ret = "EXISTS";
                break;
            }
            case -314: {
                ret = "PUT";
                break;
            }
            case -306: {
                ret = "NOT";
                break;
            }
            case -307: {
                ret = "AND";
                break;
            }
            case -308: {
                ret = "OR";
                break;
            }
            case -309: {
                ret = "NULL";
                break;
            }
            case -310: {
                ret = "ESCAPE";
                break;
            }
            case -311: {
                ret = "ALL";
                break;
            }
            case -312: {
                ret = "DISTINCT";
                break;
            }
            case -313: {
                ret = "UNIQUE";
                break;
            }
            case -320: {
                ret = "CASE";
                break;
            }
            case -321: {
                ret = "WHEN";
                break;
            }
            case -322: {
                ret = "THEN";
                break;
            }
            case -323: {
                ret = "ELSE";
                break;
            }
            case -324: {
                ret = "END";
                break;
            }
            case -330: {
                ret = "CAST";
                break;
            }
            case -331: {
                ret = "AS";
                break;
            }
            case -340: {
                ret = "PHYSICAL";
                break;
            }
            case -341: {
                ret = "PROMPT";
                break;
            }
            case -401: {
                ret = "\"";
                break;
            }
            case -402: {
                ret = "'";
                break;
            }
            case -403: {
                ret = "SLASHSTARCOMMENT";
                break;
            }
            case -407: {
                ret = "XMLCOMMENT";
                break;
            }
            case -404: {
                ret = "FUNCTION";
                break;
            }
            case -405: {
                ret = "WORD";
                break;
            }
            case -406: {
                ret = "NUMBER";
                break;
            }
            case -1: {
                ret = "TT_EOF";
                break;
            }
            case 10: {
                ret = "TT_EOL";
                break;
            }
            case -3: {
                ret = "TT_WORD";
                break;
            }
            case -4: {
                ret = "TT_NOTHING";
                break;
            }
            default: {
                ret = String.valueOf(tokenValueOrType);
            }
        }
        return ret;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Token token = this.getToken();
        String tokenName = this.toString(token.getValue());
        switch (token.getValue()) {
            case -100: 
            case -1: {
                buffer.append("<EOF>");
                break;
            }
            case -406: 
            case -405: 
            case -404: 
            case -3: {
                buffer.append(token.getString());
                break;
            }
            case -401: {
                buffer.append('\"').append(token.getString()).append('\"');
                break;
            }
            case -402: {
                buffer.append("'").append(token.getString()).append("'");
                break;
            }
            case -500: {
                buffer.append("<<").append(token.getString()).append(">>");
                break;
            }
            case -600: {
                buffer.append("[").append(token.getString()).append("]");
                break;
            }
            case -105: {
                buffer.append(".");
                break;
            }
            case -403: {
                buffer.append("/*").append(token.getString()).append("*/");
                break;
            }
            case -407: {
                buffer.append("<!--").append(token.getString()).append("-->");
                break;
            }
            default: {
                buffer.append(token.getString());
            }
        }
        buffer.append(" (token=").append(tokenName).append(", index=").append(this.tokIndex).append(')');
        return buffer.toString();
    }
}

