/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.iqtextparser;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.iqtextparser.NodeFactoryImpl;
import com.sas.iquery.metadata.expr.iqtextparser.NodeParser;
import com.sas.iquery.metadata.expr.iqtextparser.NodeParserImpl;
import com.sas.iquery.metadata.expr.iqtextparser.ParseError;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNodeUtil;
import com.sas.iquery.metadata.expr.iqtextparser.TokenError;
import com.sas.iquery.metadata.expr.iqtextparser.Tokenizer;
import java.util.Map;

public class ParserUtil {
    public static NodeParser newParser() throws IllegalArgumentException {
        NodeFactoryImpl nodeFactory = new NodeFactoryImpl();
        NodeParserImpl parser = new NodeParserImpl(nodeFactory);
        return parser;
    }

    public static Tokenizer newTokenizer(String text, boolean enableComments, boolean enableTuples, boolean enableSets, boolean enableObjRefs) throws ParseError, TokenError {
        NodeFactoryImpl nodeFactory = new NodeFactoryImpl();
        NodeParserImpl parser = new NodeParserImpl(nodeFactory);
        return parser.newTokenizer(text, enableComments, enableTuples, enableSets, enableObjRefs);
    }

    public static ParsedNode parsePredicate(String text, boolean keepComments, boolean enableTuples, boolean enableSets, boolean enableObjRefs) throws ParseError, TokenError {
        NodeParser parser = ParserUtil.newParser();
        ParsedNode node = parser.parsePredicate(text, keepComments, enableTuples, enableSets, enableObjRefs);
        return node;
    }

    public static ParsedNode parseCalculation(String text, boolean keepComments, boolean enableTuples, boolean enableSets, boolean enableObjRefs) throws ParseError, TokenError {
        NodeParser parser = ParserUtil.newParser();
        ParsedNode node = parser.parseCalculation(text, keepComments, enableTuples, enableSets, enableObjRefs);
        return node;
    }

    public static ExpressionInterface newExpressionInterface(ParsedNode node, BusinessModel model, ResourceScope allowedScope) throws MetadataException {
        NodeFactoryImpl nodeFactory = new NodeFactoryImpl();
        ExpressionInterface expr = ParsedNodeUtil.newExpressionInterface(nodeFactory, node, model, allowedScope);
        return expr;
    }

    public static ParsedNode refactorAggChildren(ParsedNode node, String leafNameTemplate, int startNameNum, Map<ParsedNode, ParsedNode> leaves) throws CloneNotSupportedException {
        NodeFactoryImpl nodeFactory = new NodeFactoryImpl();
        ParsedNode clone = ParsedNodeUtil.refactorAggChildren(nodeFactory, node, leafNameTemplate, startNameNum, leaves);
        return clone;
    }

    public static ParsedNode refactorAggParents(ParsedNode node, String leafNameTemplate, int startNameNum, Map<ParsedNode, ParsedNode> leaves) throws CloneNotSupportedException {
        NodeFactoryImpl nodeFactory = new NodeFactoryImpl();
        ParsedNode clone = ParsedNodeUtil.refactorAggParents(nodeFactory, node, leafNameTemplate, startNameNum, leaves);
        return clone;
    }

    public static ParsedNode createPlaceHolderAndMarker(ParsedNode node, String nameTemplate, int nameNum, Map<ParsedNode, ParsedNode> markers) {
        NodeFactoryImpl nodeFactory = new NodeFactoryImpl();
        ParsedNode placeHolder = ParsedNodeUtil.createPlaceHolderAndMarker(nodeFactory, node, nameTemplate, nameNum, markers);
        return placeHolder;
    }

    public static ParsedNode parseFormat(String text, boolean keepComments, boolean enableTuples, boolean enableSets, boolean enableObjRefs) {
        NodeParser parser = ParserUtil.newParser();
        ParsedNode node = parser.parseFormat(text, keepComments, enableTuples, enableSets, enableObjRefs);
        return node;
    }
}

