/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.iqtextparser;

import com.sas.iquery.metadata.expr.iqtextparser.Messages;
import com.sas.iquery.metadata.expr.iqtextparser.Token;
import com.sas.iquery.metadata.expr.iqtextparser.TokenizerImpl;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.math.BigDecimal;
import java.util.ArrayList;

class NodeLexer
extends TokenizerImpl {
    private StreamTokenizer strtok;
    private Token currentToken;
    private boolean includeComments = false;
    private boolean allowTuples = false;
    private boolean inTupleList = false;
    private boolean allowSets = false;
    private boolean allowObjectRefs = false;
    ArrayList<Token> pendingTokens = new ArrayList();
    private static final int NP_DIGITS = 1;
    private static final int NP_E_ONLY = 2;
    private static final int NP_E_DIGITS = 3;
    private static final int NP_DIGITS_E = 4;
    private static final int NP_DIGITS_E_DIGITS = 5;
    private static final int NP_DOT = 6;
    private static final int NP_PLUS = 7;
    private static final int NP_MINUS = 8;

    NodeLexer(Reader reader, boolean keepCommmentsInParseTree, boolean allowTuplesSyntax, boolean allowSetsSupport, boolean allowObjectRefsSyntax) {
        this.strtok = new StreamTokenizer(reader);
        this.includeComments = keepCommmentsInParseTree;
        this.allowTuples = allowTuplesSyntax;
        this.allowSets = allowSetsSupport;
        this.allowObjectRefs = allowObjectRefsSyntax;
        this.setupNormal();
        this.next();
    }

    @Override
    public boolean isIncludeCommentsEnabled() {
        return this.includeComments;
    }

    @Override
    public boolean isTuplesSyntaxEnabled() {
        return this.allowTuples;
    }

    @Override
    public boolean isSetsSupportEnabled() {
        return this.allowSets;
    }

    @Override
    public boolean isObjRefsSupportEnabled() {
        return this.allowObjectRefs;
    }

    private void setupNormal() {
        this.strtok.resetSyntax();
        this.strtok.whitespaceChars(32, 32);
        this.strtok.whitespaceChars(9, 9);
        this.strtok.whitespaceChars(10, 10);
        this.strtok.whitespaceChars(13, 13);
        this.strtok.wordChars(97, 122);
        this.strtok.wordChars(65, 90);
        this.strtok.wordChars(48, 57);
        this.strtok.wordChars(95, 95);
        this.strtok.wordChars(36, 36);
        this.strtok.quoteChar(34);
        this.strtok.quoteChar(39);
        this.strtok.slashStarComments(!this.includeComments);
        if (this.allowTuples) {
            this.strtok.ordinaryChar(91);
        }
    }

    private void setupComment(boolean enterComment) {
        if (enterComment) {
            this.strtok.resetSyntax();
            this.strtok.ordinaryChars(0, 597);
            this.strtok.slashStarComments(false);
        } else {
            this.setupNormal();
        }
    }

    private void setupResource(boolean enterResource) {
        if (enterResource) {
            this.strtok.resetSyntax();
            this.strtok.wordChars(1, 597);
            this.strtok.ordinaryChar(62);
            this.strtok.slashStarComments(false);
        } else {
            this.setupNormal();
        }
    }

    private void setupTuple(boolean enterTuple) {
        if (enterTuple) {
            this.strtok.resetSyntax();
            this.strtok.wordChars(1, 597);
            this.strtok.ordinaryChar(93);
            this.strtok.slashStarComments(false);
        } else {
            this.setupNormal();
        }
    }

    private Token getNextToken() throws IOException {
        Token fetchedToken;
        if (this.pendingTokens.size() > 0) {
            fetchedToken = this.pendingTokens.remove(0);
        } else {
            int tok = this.strtok.nextToken();
            String sTok = String.valueOf((char)tok);
            String string = this.strtok.sval == null ? sTok : this.strtok.sval;
            fetchedToken = new Token(tok, this.strtok.ttype, string, null, this.strtok.lineno());
        }
        if (this.inTupleList) {
            String tokenString = fetchedToken.getString();
            int tokenValue = fetchedToken.getValue();
            if (tokenValue == -3) {
                if (tokenString.trim().indexOf(46) == 0) {
                    int dotIndex = tokenString.indexOf(46);
                    if ((tokenString = tokenString.substring(dotIndex + 1).trim()).length() > 0) {
                        Token pushBack = new Token(tokenValue, -3, tokenString, null, fetchedToken.getLineNo());
                        this.pushBackToken(pushBack);
                    }
                    fetchedToken = new Token(46, -3, ".", null, fetchedToken.getLineNo());
                }
            } else {
                this.inTupleList = tokenValue == 91 || tokenValue == 93;
            }
        }
        return fetchedToken;
    }

    private void pushBackToken(Token pushToken) {
        this.pendingTokens.add(0, pushToken);
    }

    protected Token peekAheadFor(Token token, int ifValue, int newValue, String newString) throws IOException {
        Token peekToken = this.getNextToken();
        if (peekToken.getValue() == ifValue) {
            token.string = newString;
            token.value = newValue;
        } else {
            this.pushBackToken(peekToken);
        }
        return token;
    }

    @Override
    public boolean isEOF() {
        Token token = this.getToken();
        return token != null && token.getValue() == -100;
    }

    protected void setToken(Token token) {
        this.currentToken = token;
    }

    @Override
    public Token getToken() {
        return this.currentToken;
    }

    @Override
    void readToken() throws IOException {
        String parsedAliasText = null;
        Token token = this.getNextToken();
        block0 : switch (token.getValue()) {
            case -1: {
                token.value = -100;
                token.string = "<EOF>";
                break;
            }
            case -3: {
                boolean isName;
                String numberText = this.compileNumber(token);
                if (numberText != null) {
                    token.value = -406;
                    token.string = numberText;
                    token.number = new BigDecimal(numberText);
                    break;
                }
                Token peekWord = this.getNextToken();
                boolean peekIsParen = peekWord.getValue() == 40;
                this.pushBackToken(peekWord);
                String tokenString = token.getString();
                boolean bl = isName = tokenString != null && tokenString.length() > 0 && !Character.isDigit(tokenString.charAt(0));
                if (peekIsParen && isName) {
                    this.tokenizeKeywords(token, -404);
                    break;
                }
                this.tokenizeKeywords(token, -405);
                break;
            }
            case 47: {
                token.value = -112;
                if (!this.includeComments) break;
                Token peekComments = this.getNextToken();
                if (peekComments.getValue() == 42) {
                    token = this.compileComment(token, -403, "/*", "*/");
                    parsedAliasText = "/*" + token.getString() + "*/";
                    break;
                }
                this.pushBackToken(peekComments);
                break;
            }
            case 60: {
                Token peekLessThanNext = this.getNextToken();
                switch (peekLessThanNext.getValue()) {
                    case 60: {
                        Token peekLessThanNextNext = this.getNextToken();
                        if (peekLessThanNextNext.getValue() == 60) {
                            token.value = -202;
                            this.pushBackToken(peekLessThanNextNext);
                            this.pushBackToken(peekLessThanNext);
                            break block0;
                        }
                        this.pushBackToken(peekLessThanNextNext);
                        token = this.compileResource(token);
                        parsedAliasText = "<<" + token.getString() + ">>";
                        break block0;
                    }
                    case 61: {
                        token.value = -203;
                        token.string = "<=";
                        break block0;
                    }
                    case 62: {
                        token.value = -201;
                        token.string = "<>";
                        break block0;
                    }
                    case 33: {
                        Token peekXmlCommentDash = this.getNextToken();
                        if (peekXmlCommentDash.getValue() == 45) {
                            Token peekXmlCommentDashDash = this.getNextToken();
                            if (peekXmlCommentDashDash.getValue() == 45) {
                                token.value = -407;
                                token = this.compileComment(token, -407, "<!--", "-->");
                                parsedAliasText = "<!--" + token.getString() + "-->";
                                break block0;
                            }
                            this.pushBackToken(peekXmlCommentDashDash);
                            this.pushBackToken(peekXmlCommentDash);
                            this.pushBackToken(peekLessThanNext);
                            break block0;
                        }
                        this.pushBackToken(peekXmlCommentDash);
                        this.pushBackToken(peekLessThanNext);
                        break block0;
                    }
                }
                token.value = -202;
                this.pushBackToken(peekLessThanNext);
                break;
            }
            case 34: {
                token.value = -401;
                parsedAliasText = '\"' + token.getString() + '\"';
                break;
            }
            case 39: {
                token.value = -402;
                parsedAliasText = '\'' + token.getString() + '\'';
                break;
            }
            case 124: {
                token.value = -122;
                token = this.peekAheadFor(token, 124, -120, "||");
                break;
            }
            case 33: {
                token.value = -121;
                token = this.peekAheadFor(token, 33, -120, "!!");
                break;
            }
            case 58: {
                token.value = -108;
                token = this.peekAheadFor(token, 58, -104, "::");
                break;
            }
            case 42: {
                token.value = -113;
                token = this.peekAheadFor(token, 42, -116, "**");
                break;
            }
            case 62: {
                token.value = -204;
                token = this.peekAheadFor(token, 61, -205, ">=");
                break;
            }
            case 94: {
                token.value = -150;
                token = this.peekAheadFor(token, 61, -201, "^=");
                break;
            }
            case 126: {
                token.value = -151;
                token = this.peekAheadFor(token, 61, -201, "~=");
                break;
            }
            case 61: {
                token.value = -200;
                break;
            }
            case 40: {
                token.value = -101;
                break;
            }
            case 41: {
                token.value = -102;
                break;
            }
            case 43: {
                token.value = -110;
                break;
            }
            case 45: {
                token.value = -111;
                break;
            }
            case 37: {
                token.value = -114;
                break;
            }
            case 44: {
                token.value = -103;
                break;
            }
            case 38: {
                token.value = -130;
                break;
            }
            case 63: {
                token.value = -140;
                break;
            }
            case 91: {
                if (!this.allowTuples) {
                    this.setToken(token);
                    throw this.tokenerror(Messages.getBundleName(), "NodeLexer.Error.IllegalToken.TupleStart.TuplesDisabled.fmt.txt", token);
                }
                token = this.compileTuple(token);
                parsedAliasText = "[" + token.getString() + "]";
                break;
            }
            case 46: {
                String numberText = this.compileNumber(token);
                if (numberText != null) {
                    token.type = -3;
                    token.value = -406;
                    token.string = numberText;
                    token.number = new BigDecimal(numberText);
                    break;
                }
                token.value = -105;
                break;
            }
            case 123: {
                token.value = -106;
                break;
            }
            case 125: {
                token.value = -107;
                break;
            }
            default: {
                this.setToken(token);
                throw this.tokenerror(Messages.getBundleName(), "NodeLexer.Error.UnknownToken.fmt.txt", token);
            }
        }
        this.addToParsed(token, parsedAliasText);
        this.setToken(token);
    }

    private String compileNumber(Token startToken) throws IOException {
        return this.compileNumber_start(startToken);
    }

    private Token compileComment(Token startToken, int commentValue, String startSequence, String closeSequence) throws IOException {
        int closeSeqLen = closeSequence.length();
        Token compiledToken = startToken;
        this.setupComment(true);
        StringBuffer comment = new StringBuffer();
        boolean reading = true;
        while (reading) {
            Token token = this.getNextToken();
            int tokenValue = token.getValue();
            if (tokenValue == -1) {
                this.setupComment(false);
                compiledToken = new Token(commentValue, -3, comment.toString(), null, token.getLineNo());
                this.addToParsed(compiledToken, startSequence + comment);
                token.string = "<EOF>";
                token.value = -100;
                this.addToParsed(token, "<EOF>");
                this.setToken(token);
                throw this.tokenerror(Messages.getBundleName(), "NodeLexer.Error.UnclosedComment.fmt.txt", startSequence, token);
            }
            comment.append(token.getString());
            int found = comment.lastIndexOf(closeSequence);
            if (found == -1 || found + closeSeqLen != comment.length()) continue;
            comment.setLength(comment.length() - closeSeqLen);
            compiledToken = new Token(commentValue, -3, comment.toString(), null, token.getLineNo());
            this.setupComment(false);
            reading = false;
        }
        return compiledToken;
    }

    private Token compileResource(Token startToken) throws IOException {
        Token compiledToken = startToken;
        this.setupResource(true);
        StringBuffer resource = new StringBuffer();
        boolean reading = true;
        block5: while (reading) {
            Token token = this.getNextToken();
            switch (token.getValue()) {
                case -3: {
                    resource.append(token.getString());
                    continue block5;
                }
                case 62: {
                    Token peekEoR = this.getNextToken();
                    if (peekEoR.getValue() == 62) {
                        compiledToken = new Token(-500, -3, resource.toString(), null, peekEoR.getLineNo());
                        this.setupResource(false);
                        reading = false;
                        continue block5;
                    }
                    resource.append(token.getString()).append(peekEoR.getString());
                    continue block5;
                }
                case -1: {
                    this.setupResource(false);
                    compiledToken = new Token(-500, -3, resource.toString(), null, token.getLineNo());
                    this.addToParsed(compiledToken, "<<" + resource);
                    token.string = "<EOF>";
                    token.value = -100;
                    this.addToParsed(token, "<EOF>");
                    this.setToken(token);
                    throw this.tokenerror(Messages.getBundleName(), "NodeLexer.Error.UnclosedResource.fmt.txt", null);
                }
            }
            this.setupResource(false);
            compiledToken = new Token(-500, -3, resource.toString(), null, token.getLineNo());
            this.addToParsed(compiledToken, "<<" + resource);
            this.addToParsed(token, null);
            this.setToken(token);
            throw this.tokenerror(Messages.getBundleName(), "NodeLexer.Error.IllegalToken.CompilingResource.fmt.txt", token);
        }
        return compiledToken;
    }

    private Token compileTuple(Token startToken) throws IOException {
        Token token = startToken;
        this.inTupleList = true;
        this.setupTuple(true);
        StringBuffer tuple = new StringBuffer();
        boolean reading = true;
        block5: while (reading) {
            token = this.getNextToken();
            switch (token.getValue()) {
                case -3: {
                    tuple.append(token.getString());
                    continue block5;
                }
                case 93: {
                    this.setupTuple(false);
                    token.value = -600;
                    token.type = -600;
                    token.string = tuple.toString();
                    reading = false;
                    continue block5;
                }
                case -1: {
                    this.setupTuple(false);
                    Token faketoken1 = new Token(-600, -3, tuple.toString(), null, token.getLineNo());
                    this.addToParsed(faketoken1, "[" + tuple);
                    token.string = "<EOF>";
                    token.value = -100;
                    this.addToParsed(token, "<EOF>");
                    this.setToken(token);
                    throw this.tokenerror(Messages.getBundleName(), "NodeLexer.Error.UnclosedTuple.fmt.txt", null);
                }
            }
            this.setupTuple(false);
            Token faketoken2 = new Token(-600, -3, tuple.toString(), null, token.getLineNo());
            this.addToParsed(faketoken2, "[" + tuple);
            this.addToParsed(token, null);
            this.setToken(token);
            throw this.tokenerror(Messages.getBundleName(), "NodeLexer.Error.IllegalToken.CompilingTuple.fmt.txt", token);
        }
        return token;
    }

    private void tokenizeKeywords(Token tokenToUpdate, int valueIfNotKeyword) {
        int newValue = 0;
        String sval = tokenToUpdate.getString();
        if (sval.equalsIgnoreCase("IS")) {
            newValue = -300;
        } else if (sval.equalsIgnoreCase("LIKE")) {
            newValue = -301;
        } else if (sval.equalsIgnoreCase("BETWEEN")) {
            newValue = -302;
        } else if (sval.equalsIgnoreCase("IN")) {
            newValue = -303;
        } else if (sval.equalsIgnoreCase("CONTAINS")) {
            newValue = -315;
        } else if (sval.equalsIgnoreCase("EXISTS")) {
            newValue = -304;
        } else if (sval.equalsIgnoreCase("INPUT")) {
            newValue = -316;
        } else if (sval.equalsIgnoreCase("PUT")) {
            newValue = -314;
        } else if (sval.equalsIgnoreCase("NOT")) {
            newValue = -306;
        } else if (sval.equalsIgnoreCase("AND")) {
            newValue = -307;
        } else if (sval.equalsIgnoreCase("OR")) {
            newValue = -308;
        } else if (sval.equalsIgnoreCase("NULL")) {
            newValue = -309;
        } else if (sval.equalsIgnoreCase("ESCAPE")) {
            newValue = -310;
        } else if (sval.equalsIgnoreCase("ALL")) {
            newValue = -311;
        } else if (sval.equalsIgnoreCase("DISTINCT")) {
            newValue = -312;
        } else if (sval.equalsIgnoreCase("UNIQUE")) {
            newValue = -313;
        } else if (sval.equalsIgnoreCase("CASE")) {
            newValue = -320;
        } else if (sval.equalsIgnoreCase("WHEN")) {
            newValue = -321;
        } else if (sval.equalsIgnoreCase("THEN")) {
            newValue = -322;
        } else if (sval.equalsIgnoreCase("ELSE")) {
            newValue = -323;
        } else if (sval.equalsIgnoreCase("END")) {
            newValue = -324;
        } else if (sval.equalsIgnoreCase("CAST")) {
            newValue = -330;
        } else if (sval.equalsIgnoreCase("AS")) {
            newValue = -331;
        } else if (sval.equalsIgnoreCase("physical")) {
            newValue = -340;
        } else if (sval.equalsIgnoreCase("prompt")) {
            newValue = -341;
        }
        if (newValue != 0) {
            tokenToUpdate.string = sval;
        } else {
            newValue = valueIfNotKeyword;
        }
        tokenToUpdate.value = newValue;
    }

    private int typeOfNumberPart(Token token) {
        int np = 0;
        switch (token.getValue()) {
            case -3: {
                String check = token.getString().trim().toLowerCase();
                if (check.length() == 1 && check.charAt(0) == 'e') {
                    np = 2;
                    break;
                }
                int len = check.length();
                int eLoc = check.indexOf(101);
                if (eLoc == -1) {
                    if (!this.isDigits(check)) break;
                    np = 1;
                    break;
                }
                if (eLoc == 0) {
                    if (!this.isDigits(check.substring(eLoc + 1))) break;
                    np = 3;
                    break;
                }
                if (eLoc == len - 1) {
                    if (!this.isDigits(check.substring(0, eLoc - 1))) break;
                    np = 4;
                    break;
                }
                if (!this.isDigits(check.substring(eLoc + 1)) || !this.isDigits(check.substring(0, eLoc - 1))) break;
                np = 5;
                break;
            }
            case 46: {
                np = 6;
                break;
            }
            case 43: {
                np = 7;
                break;
            }
            case 45: {
                np = 8;
            }
        }
        return np;
    }

    private boolean isDigits(String text) {
        if (text == null) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private String ensureValidNumber(String possibleNumberText) {
        if (possibleNumberText != null) {
            boolean valid;
            try {
                new BigDecimal(possibleNumberText);
                valid = true;
            }
            catch (NumberFormatException nfe) {
                valid = false;
            }
            if (!valid) {
                return null;
            }
        }
        return possibleNumberText;
    }

    private String compileNumber_start(Token token) throws IOException {
        String ret;
        String tokenString = token.getString();
        int type = this.typeOfNumberPart(token);
        switch (type) {
            case 5: {
                ret = this.ensureValidNumber(tokenString);
                break;
            }
            case 1: {
                ret = this.compileNumber_startDigits(tokenString);
                break;
            }
            case 4: {
                ret = this.compileNumber_exponent(tokenString);
                break;
            }
            case 6: {
                ret = this.compileNumber_startDot(tokenString);
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    private String compileNumber_startDigits(String previous) throws IOException {
        String ret = null;
        Token nextToken = this.getNextToken();
        String tokenString = nextToken.getString();
        int type = this.typeOfNumberPart(nextToken);
        if (type == 6) {
            ret = this.compileNumber_coefficient(previous + tokenString);
        }
        if (ret == null) {
            this.pushBackToken(nextToken);
            ret = this.ensureValidNumber(previous);
        }
        return ret;
    }

    private String compileNumber_coefficient(String previous) throws IOException {
        String ret = null;
        Token nextToken = this.getNextToken();
        String tokenString = nextToken.getString();
        int nextType = this.typeOfNumberPart(nextToken);
        switch (nextType) {
            case 1: 
            case 3: 
            case 5: {
                ret = this.ensureValidNumber(previous + tokenString);
                break;
            }
            case 2: 
            case 4: {
                ret = this.compileNumber_exponent(previous + tokenString);
            }
        }
        if (ret == null) {
            this.pushBackToken(nextToken);
            ret = this.ensureValidNumber(previous);
        }
        return ret;
    }

    private String compileNumber_startDot(String previous) throws IOException {
        String ret = null;
        Token nextToken = this.getNextToken();
        String tokenString = nextToken.getString();
        int nextType = this.typeOfNumberPart(nextToken);
        switch (nextType) {
            case 1: 
            case 5: {
                ret = this.ensureValidNumber(previous + tokenString);
                break;
            }
            case 4: {
                ret = this.compileNumber_exponent(previous + tokenString);
            }
        }
        if (ret == null) {
            this.pushBackToken(nextToken);
        }
        return ret;
    }

    private String compileNumber_exponent(String previous) throws IOException {
        String ret = null;
        Token nextToken = this.getNextToken();
        String tokenString = nextToken.getString();
        int type = this.typeOfNumberPart(nextToken);
        switch (type) {
            case 7: 
            case 8: {
                ret = this.compileNumber_mantissa(previous + tokenString);
            }
        }
        if (ret == null) {
            this.pushBackToken(nextToken);
        }
        return ret;
    }

    private String compileNumber_mantissa(String previous) throws IOException {
        String ret = null;
        Token nextToken = this.getNextToken();
        String tokenString = nextToken.getString();
        int type = this.typeOfNumberPart(nextToken);
        if (type == 1) {
            ret = this.ensureValidNumber(previous + tokenString);
        }
        if (ret == null) {
            this.pushBackToken(nextToken);
        }
        return ret;
    }
}

