/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.iqtextparser;

import com.sas.iquery.metadata.expr.iqtextparser.Formatter;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNodeUtil;
import java.text.MessageFormat;
import java.util.ArrayList;

class FormatterInfoText
implements Formatter {
    FormatterInfoText() {
    }

    @Override
    public Object format(ParsedNode node, String childPrefixText, String childIndentText, boolean includeComments) {
        return this.format(node, childPrefixText, childIndentText, includeComments, 0);
    }

    protected String getNodeTag(ParsedNode node) {
        return "node";
    }

    @Override
    public Object format(ParsedNode node, String childPrefixText, String childIndentText, boolean includeComments, int nested) {
        ArrayList<Object> parms = new ArrayList<Object>();
        ParsedNodeUtil.getFormattedParms(parms, node, this, childPrefixText, childIndentText, includeComments, nested);
        String template = this.getTemplate(node, childPrefixText, childIndentText, includeComments, nested);
        MessageFormat format = new MessageFormat(template);
        return format.format(parms.toArray());
    }

    protected String getTemplate(ParsedNode node, String childPrefixText, String childIndentText, boolean includeComments, int nestedLevel) {
        int type = node.getType();
        int parm = 0;
        StringBuffer buffer = new StringBuffer();
        buffer.append("'{'").append(this.getNodeTag(node)).append(":type=").append(Integer.toHexString(type)).append(",keywords=");
        Object[] keywords = node.getKeywords();
        if (keywords == null) {
            buffer.append("null");
        } else {
            buffer.append('[');
            String delimiter = "";
            for (int i = 0; i < keywords.length; ++i) {
                boolean notString;
                buffer.append(delimiter).append(parm).append('=');
                boolean bl = notString = keywords[i] != null && !(keywords[i] instanceof String);
                if (notString) {
                    buffer.append("'{'").append(keywords[i].getClass().getSimpleName()).append(":");
                }
                buffer.append('{').append(parm++).append('}');
                if (notString) {
                    buffer.append("}");
                }
                delimiter = ",";
            }
            buffer.append(']');
        }
        ParsedNode[] children = node.getChildren();
        buffer.append(",children=");
        if (children == null) {
            buffer.append("null");
        } else {
            String childPrefix = this.getChildPrefix(childPrefixText, childIndentText, nestedLevel + 1);
            String delimiter = "";
            buffer.append('[');
            for (int i = 0; i < children.length; ++i) {
                buffer.append(delimiter).append(childPrefix).append(parm).append('=').append('{').append(parm++).append('}');
                delimiter = ",";
            }
            buffer.append(']');
        }
        buffer.append("'}'");
        String template = buffer.toString();
        return template;
    }

    protected String getChildPrefix(String childPrefixText, String childIndentText, int nestedLevel) {
        StringBuffer buffer = new StringBuffer();
        if (childPrefixText != null) {
            buffer.append(childPrefixText);
        }
        if (childIndentText != null) {
            for (int j = 0; j < nestedLevel; ++j) {
                buffer.append(childIndentText);
            }
        }
        return buffer.toString();
    }
}

