/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr.iqtextparser;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.iqtextparser.Formatter;
import com.sas.iquery.metadata.expr.iqtextparser.FormatterFactory;
import com.sas.iquery.metadata.expr.iqtextparser.Messages;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifier;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifierList;
import com.sas.iquery.metadata.expr.parser.StringExpressionParser;
import com.sas.iquery.metadata.expr.relational.DataItemFormattingExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Contains;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Like;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_TestForNull;
import com.sas.iquery.metadata.serverprop.Category;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.metadata.serverprop.FunctionSignature;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FormatterExpressionizer
implements Formatter {
    protected final Formatter _retextualizer = FormatterFactory.newRetextualizer();
    static final Map<String, FunctionNameID> _lookupMap = new HashMap<String, FunctionNameID>();

    @Override
    public Object format(ParsedNode node, String childPrefixText, String childIndentText, boolean includeComments) {
        return this._retextualizer.format(node, childPrefixText, childIndentText, includeComments);
    }

    @Override
    public Object format(ParsedNode node, String childPrefixText, String childIndentText, boolean includeComments, int nesting) {
        return this._retextualizer.format(node, childPrefixText, childIndentText, includeComments, nesting);
    }

    private String retext(ParsedNode node, boolean includeComments) {
        return String.valueOf(this._retextualizer.format(node, "", "", includeComments));
    }

    public ExpressionInterface newExpressionInterface(BusinessModel model, ParsedNode node, boolean includeComments, boolean useFuncCallsFirst, ResourceScope allowedScope) throws MetadataException {
        ExpressionInterface expr;
        ServerProperties serverProperties = model.getServerProperties();
        int type = node.getType();
        ParsedNode[] children = node.getChildren();
        Object[] keywords = node.getKeywords();
        switch (type) {
            case 4: 
            case 327700: 
            case 327720: {
                String text = this.retext(node, includeComments);
                expr = StringExpressionUtil.getInstance().newExpression(model, text, 2, allowedScope);
                break;
            }
            case 327713: 
            case 327714: {
                throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.UnexpectedResourceQualifier.fmt.txt", new Object[]{this.retext(node, includeComments)}));
            }
            case 32: 
            case 327712: {
                ExpressionInterface use = null;
                try {
                    ExpressionIdentifier exprIdentifier;
                    BusinessModelResource bmr;
                    String noCommentsText = this.retext(node, false);
                    ExpressionIdentifierList eiList = StringExpressionParser.parseExpression(model, noCommentsText, allowedScope);
                    if (eiList != null && eiList.size() == 1 && (bmr = (exprIdentifier = eiList.get(0)).getBusinessModelResource()) instanceof ExpressionInterface) {
                        use = (ExpressionInterface)((Object)bmr);
                    }
                }
                catch (MetadataException noCommentsText) {
                    // empty catch block
                }
                if (use == null) {
                    String text = this.retext(node, includeComments);
                    use = StringExpressionUtil.getInstance().newExpression(model, text, 2, allowedScope);
                }
                expr = use;
                break;
            }
            case 327760: {
                expr = this.newStringConstant(11, this.retext(node, includeComments));
                break;
            }
            case 0x500051: {
                expr = this.newStringConstant(11, this.retext(node, includeComments));
                break;
            }
            case 327744: {
                expr = this.newStringConstant(11, this.retext(node, includeComments));
                break;
            }
            case 327745: {
                expr = this.newStringConstant(11, this.retext(node, includeComments));
                break;
            }
            case 327683: {
                expr = this.newStringConstant(11, this.retext(node, includeComments));
                break;
            }
            case 327681: {
                Function function;
                String functionName = String.valueOf(keywords[0]);
                if ("FractionOfTotal".compareToIgnoreCase(functionName) == 0) {
                    expr = this.compile_FractionOfTotalExpression(model, node, includeComments, useFuncCallsFirst, allowedScope);
                    break;
                }
                if ("DataItemFormattingExpression".compareToIgnoreCase(functionName) == 0) {
                    expr = this.compile_DataItemFormattingExpression(model, node, includeComments, useFuncCallsFirst, allowedScope);
                    break;
                }
                ArrayList<ConstantExpression> parms = new ArrayList<ConstantExpression>();
                if (children != null && children.length > 0) {
                    this.compile_listParms(model, parms, children[0], includeComments, useFuncCallsFirst, allowedScope);
                }
                if ((function = this.findFunction(node, serverProperties, functionName, parms)) == null) {
                    ConstantExpression fnConst = new ConstantExpression();
                    fnConst.setExpressionType(11);
                    fnConst.setValue(functionName);
                    parms.add(0, fnConst);
                    function = this.findFunctionByID(serverProperties, FunctionNameID.USER_FN);
                }
                expr = this.newFunction(serverProperties, function, parms);
                break;
            }
            case 327690: 
            case 327691: 
            case 327692: {
                FunctionNameID functID;
                int listIndex;
                String functionName = String.valueOf(keywords[0]);
                ParsedNode modifier = type == 327690 ? null : children[0];
                ArrayList<ConstantExpression> parms = new ArrayList<ConstantExpression>();
                int n = listIndex = type == 327690 ? 0 : 1;
                if (children != null && children.length > listIndex) {
                    this.compile_listParms(model, parms, children[listIndex], includeComments, useFuncCallsFirst, allowedScope);
                }
                if ((functID = this.findAggregate(serverProperties, functionName, modifier, parms)) == null) {
                    functID = modifier.getType() == 327693 ? FunctionNameID.USER_FN : FunctionNameID.USER_FN_DISTINCT;
                    ConstantExpression fnConst = new ConstantExpression();
                    fnConst.setExpressionType(11);
                    fnConst.setValue(functionName);
                    parms.add(0, fnConst);
                }
                expr = this.newFunction(serverProperties, this.findFunctionByID(serverProperties, functID), parms);
                break;
            }
            case 48: {
                expr = this.newFunction(serverProperties, FunctionNameID.PUT, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 49: {
                expr = this.newFunction(serverProperties, FunctionNameID.PUT_Q, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 50: {
                expr = this.newFunction(serverProperties, FunctionNameID.INPUT, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 51: {
                expr = this.newFunction(serverProperties, FunctionNameID.INPUT_Q, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newStringConstant(10, String.valueOf(keywords[1])), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 0: {
                expr = this.newStringConstant(11, "");
                break;
            }
            case 18: {
                expr = this.newStringConstant(11, this.retext(node, includeComments));
                break;
            }
            case 19: {
                expr = this.newStringConstant(11, this.retext(node, includeComments));
                break;
            }
            case 20: {
                expr = this.newStringConstant(11, this.retext(node, includeComments));
                break;
            }
            case 327686: {
                expr = this.newStringConstant(2, this.retext(node, includeComments));
                break;
            }
            case 327695: {
                expr = this.newStringConstant(11, this.retext(node, includeComments));
                break;
            }
            case 52: {
                expr = this.newStringConstant(11, this.retext(node, includeComments));
                break;
            }
            case 327684: {
                String text = this.retext(children[0], false).replace("\"", "\"\"");
                String doubleQuotedText = "\"" + text + "\"";
                expr = this.newStringExpression(3, doubleQuotedText);
                break;
            }
            case 327685: {
                String text = this.retext(children[0], false).replace("'", "''");
                String singleQuoteText = "'" + text + "'";
                expr = this.newStringExpression(3, singleQuoteText);
                break;
            }
            case 327693: 
            case 327694: 
            case 327696: 
            case 327697: 
            case 327698: 
            case 327699: {
                expr = this.newStringConstant(11, this.retext(node, includeComments));
                break;
            }
            case 0xFF0001: {
                expr = this.newStringConstant(11, this.retext(node, includeComments));
                break;
            }
            case 0xFF0002: {
                expr = this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope);
                break;
            }
            case 589825: {
                throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.UnsupportedSyntaxTypeIsOf.fmt.txt", new Object[]{this.retext(node, includeComments)}));
            }
            case 17: {
                throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.UnsupportedSyntaxTypeCastOp.fmt.txt", new Object[]{this.retext(node, includeComments)}));
            }
            case 16: {
                throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.UnsupportedSyntaxTypeCastAs.fmt.txt", new Object[]{this.retext(node, includeComments)}));
            }
            case 327682: {
                throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.UnexpectedListNode.fmt.txt", new Object[]{this.retext(node, includeComments)}));
            }
            case 1: {
                expr = this.newFunction(serverProperties, FunctionNameID.PARENTHESIS, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 2: {
                expr = this.newFunction(serverProperties, FunctionNameID.PRECOMMENT, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 3: {
                expr = this.newFunction(serverProperties, FunctionNameID.POSTCOMMENT, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 5: {
                expr = this.newFunction(serverProperties, FunctionNameID.PREXMLCOMMENT, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 6: {
                expr = this.newFunction(serverProperties, FunctionNameID.POSTXMLCOMMENT, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 65537: {
                expr = this.newFunction(serverProperties, FunctionNameID.UNITY, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 65538: {
                expr = this.newFunction(serverProperties, FunctionNameID.NEGATION, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 262145: {
                expr = this.newFunction(serverProperties, FunctionNameID.ADDITION, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 262146: {
                expr = this.newFunction(serverProperties, FunctionNameID.SUBTRACTION, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 196611: {
                ArrayList<ExpressionInterface> parms = new ArrayList<ExpressionInterface>();
                parms.add(this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope));
                parms.add(this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                expr = this.newFunction(serverProperties, this.findFunction(node, serverProperties, "Mod", parms), parms);
                break;
            }
            case 196609: {
                expr = this.newFunction(serverProperties, FunctionNameID.MULTIPLICATION, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 131073: {
                expr = this.newFunction(serverProperties, FunctionNameID.EXPONENTIATION, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 131074: {
                expr = this.newFunction(serverProperties, FunctionNameID.EXPONENTIATION, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 196610: {
                expr = this.newFunction(serverProperties, FunctionNameID.DIVISION, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 262147: {
                expr = this.newFunction(serverProperties, FunctionNameID.CONCATENATION, this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope), this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope));
                break;
            }
            case 655361: 
            case 655362: 
            case 655363: {
                ExpressionInterface leftExpr = this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope);
                if (type == 655361) {
                    if (useFuncCallsFirst && serverProperties != null) {
                        expr = this.newFunction(serverProperties, FunctionNameID.NOT, leftExpr);
                        break;
                    }
                    CompoundConditionalExpression compound = new CompoundConditionalExpression();
                    compound.setIsNegated(true);
                    compound.setLeftExpression(leftExpr);
                    expr = compound;
                    break;
                }
                ExpressionInterface rightExpr = this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope);
                if (type == 655362) {
                    if (useFuncCallsFirst && serverProperties != null) {
                        expr = this.newFunction(serverProperties, FunctionNameID.AND, leftExpr, rightExpr);
                        break;
                    }
                    CompoundConditionalExpression compound = new CompoundConditionalExpression();
                    compound.setLeftExpression(leftExpr);
                    compound.setRightExpression(rightExpr);
                    compound.setRelationType(ConditionalRelationType.AND);
                    expr = compound;
                    break;
                }
                if (useFuncCallsFirst && serverProperties != null) {
                    expr = this.newFunction(serverProperties, FunctionNameID.OR, leftExpr, rightExpr);
                    break;
                }
                CompoundConditionalExpression compound = new CompoundConditionalExpression();
                compound.setLeftExpression(leftExpr);
                compound.setRightExpression(rightExpr);
                compound.setRelationType(ConditionalRelationType.OR);
                expr = compound;
                break;
            }
            case 393217: 
            case 393218: 
            case 393219: 
            case 393220: 
            case 393221: 
            case 393222: 
            case 393233: 
            case 393234: 
            case 393235: 
            case 393236: 
            case 393237: 
            case 393238: {
                ComparisonOperator operator = null;
                FunctionNameID functID = null;
                switch (type) {
                    case 393217: {
                        operator = ComparisonOperator.COMPARE_EQ;
                        functID = FunctionNameID.EQUALS;
                        break;
                    }
                    case 393218: {
                        operator = ComparisonOperator.COMPARE_NEQ;
                        functID = FunctionNameID.NOT_EQUALS;
                        break;
                    }
                    case 393219: {
                        operator = ComparisonOperator.COMPARE_LT;
                        functID = FunctionNameID.LESS_THAN;
                        break;
                    }
                    case 393220: {
                        operator = ComparisonOperator.COMPARE_LE;
                        functID = FunctionNameID.LESS_THAN_OR_EQUALS;
                        break;
                    }
                    case 393221: {
                        operator = ComparisonOperator.COMPARE_GT;
                        functID = FunctionNameID.GREATER_THAN;
                        break;
                    }
                    case 393222: {
                        operator = ComparisonOperator.COMPARE_GE;
                        functID = FunctionNameID.GREATER_THAN_OR_EQUALS;
                        break;
                    }
                    case 393233: {
                        functID = FunctionNameID.EQUALS_TRUNC;
                        break;
                    }
                    case 393234: {
                        functID = FunctionNameID.NOT_EQUALS_TRUNC;
                        break;
                    }
                    case 393235: {
                        functID = FunctionNameID.LESS_THAN_TRUNC;
                        break;
                    }
                    case 393236: {
                        functID = FunctionNameID.LESS_THAN_OR_EQUALS_TRUNC;
                        break;
                    }
                    case 393237: {
                        functID = FunctionNameID.GREATER_THAN_TRUNC;
                        break;
                    }
                    case 393238: {
                        functID = FunctionNameID.GREATER_THAN_OR_EQUALS_TRUNC;
                    }
                }
                ExpressionInterface whatToCompare = this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope);
                ExpressionInterface compareToValue = this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope);
                if (useFuncCallsFirst || operator == null) {
                    expr = this.newFunction(serverProperties, functID, whatToCompare, compareToValue);
                    break;
                }
                SimpleConditionalExpression_Comparison compare = new SimpleConditionalExpression_Comparison();
                compare.setComparisonOperator(operator);
                compare.setLeftExpression(whatToCompare);
                compare.setRightExpression(compareToValue);
                expr = compare;
                break;
            }
            case 458755: 
            case 458756: 
            case 458757: 
            case 458758: {
                boolean negated = type == 458756 || type == 458758;
                boolean escaped = type == 458757 || type == 458758;
                ExpressionInterface whatToCompare = this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope);
                ExpressionInterface pattern = this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope);
                ParsedNode escapeNode = escaped ? children[2] : null;
                String escape = "";
                if (escapeNode != null) {
                    String escapeText = this.retext(escapeNode, false);
                    if (escapeText != null && escapeText.toString().trim().length() > 0) {
                        escape = escapeText.toString().trim();
                    } else {
                        escaped = false;
                    }
                } else {
                    escaped = false;
                }
                if (useFuncCallsFirst && serverProperties != null) {
                    FunctionNameID functID;
                    FunctionNameID functionNameID = negated ? (escaped ? FunctionNameID.NOT_LIKE_ESC : FunctionNameID.NOT_LIKE) : (functID = escaped ? FunctionNameID.LIKE_ESC : FunctionNameID.NOT_LIKE);
                    if (escaped) {
                        expr = this.newFunction(serverProperties, functID, whatToCompare, pattern, this.newStringConstant(3, escape.substring(0, 1)));
                        break;
                    }
                    expr = this.newFunction(serverProperties, functID, whatToCompare, pattern);
                    break;
                }
                SimpleConditionalExpression_Like like = new SimpleConditionalExpression_Like();
                like.setIsNegated(negated);
                like.setWhatToCompare(whatToCompare);
                like.setPatternExpression(pattern);
                if (escaped) {
                    like.setEscapeCharacter(Character.valueOf(escape.charAt(0)));
                }
                expr = like;
                break;
            }
            case 458759: 
            case 458760: {
                boolean negated = type == 458760;
                ExpressionInterface whatToCompare = this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope);
                ExpressionInterface lower = this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope);
                ExpressionInterface upper = this.newExpressionInterface(model, children[2], includeComments, useFuncCallsFirst, allowedScope);
                if (useFuncCallsFirst && serverProperties != null) {
                    expr = this.newFunction(serverProperties, negated ? FunctionNameID.NOT_BETWEEN : FunctionNameID.BETWEEN, whatToCompare, lower, upper);
                    break;
                }
                SimpleConditionalExpression_Between between = new SimpleConditionalExpression_Between();
                between.setIsNegated(negated);
                between.setWhatToCompare(whatToCompare);
                between.setLeftExpression(lower);
                between.setRightExpression(upper);
                expr = between;
                break;
            }
            case 458753: 
            case 458754: {
                boolean negated = type == 458754;
                ExpressionInterface whatToCompare = this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope);
                String textualizeChild = this.retext(children[1], includeComments);
                if ("NULL".equalsIgnoreCase(textualizeChild.toString())) {
                    if (useFuncCallsFirst && serverProperties != null) {
                        expr = this.newFunction(serverProperties, negated ? FunctionNameID.IS_NOT_NULL : FunctionNameID.IS_NULL, whatToCompare);
                        break;
                    }
                    SimpleConditionalExpression_TestForNull test = new SimpleConditionalExpression_TestForNull();
                    test.setIsNegated(negated);
                    test.setWhatToCompare(whatToCompare);
                    expr = test;
                    break;
                }
                if ("MISSING".equalsIgnoreCase(textualizeChild.toString())) {
                    expr = this.newFunction(serverProperties, negated ? FunctionNameID.IS_NOT_MISSING : FunctionNameID.IS_MISSING, whatToCompare);
                    break;
                }
                throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), negated ? "FormatterExpressionizer.Error.InvalidIsNotClauseTerm.fmt.txt" : "FormatterExpressionizer.Error.InvalidIsClauseTerm.fmt.txt", new Object[]{textualizeChild}));
            }
            case 458761: 
            case 458762: {
                boolean negated = type == 458762;
                ExpressionInterface whatToCompare = this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope);
                ArrayList values = new ArrayList();
                this.compile_listParms(model, values, children[1], includeComments, false, allowedScope);
                if (useFuncCallsFirst && serverProperties != null) {
                    ArrayList<ExpressionInterface> arguments = new ArrayList<ExpressionInterface>(1 + (values == null ? 0 : values.size()));
                    arguments.add(whatToCompare);
                    arguments.addAll(values);
                    expr = this.newFunction(serverProperties, negated ? FunctionNameID.NOT_IN : FunctionNameID.IN, arguments);
                    break;
                }
                SimpleConditionalExpression_In in = new SimpleConditionalExpression_In();
                in.setIsNegated(negated);
                in.setWhatToCompare(whatToCompare);
                in.setComparisonList(values);
                expr = in;
                break;
            }
            case 458763: 
            case 458764: {
                boolean negated = type == 458764;
                ExpressionInterface whatToCompare = this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope);
                ExpressionInterface whatToContain = this.newExpressionInterface(model, children[1], includeComments, useFuncCallsFirst, allowedScope);
                if (useFuncCallsFirst && serverProperties != null) {
                    expr = this.newFunction(serverProperties, negated ? FunctionNameID.NOT_CONTAINS : FunctionNameID.CONTAINS, whatToCompare, whatToContain);
                    break;
                }
                SimpleConditionalExpression_Contains contains = new SimpleConditionalExpression_Contains();
                contains.setIsNegated(negated);
                contains.setWhatToCompare(whatToCompare);
                contains.setWhatToContain(whatToContain);
                expr = contains;
                break;
            }
            case 327728: {
                ArrayList<ExpressionInterface> simpleParms = new ArrayList<ExpressionInterface>();
                ParsedNode simpleList = children[1];
                ExpressionInterface value = this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope);
                simpleParms.add(value);
                this.compile_caseParms(model, simpleParms, node, simpleList, includeComments, useFuncCallsFirst, allowedScope, 327730);
                expr = this.newFunction(serverProperties, this.findFunctionByID(serverProperties, FunctionNameID.CASE_SIMPLE), simpleParms);
                break;
            }
            case 327730: {
                ArrayList simpleWhenThenValues = new ArrayList();
                this.complie_whenThenValues(model, simpleWhenThenValues, node, includeComments, useFuncCallsFirst, allowedScope, 327730);
                expr = this.newFunction(serverProperties, this.findFunctionByID(serverProperties, FunctionNameID.CASE_WHENTHEN), simpleWhenThenValues);
                break;
            }
            case 327729: {
                ArrayList searchParms = new ArrayList();
                ParsedNode searchList = children[0];
                this.compile_caseParms(model, searchParms, node, searchList, includeComments, useFuncCallsFirst, allowedScope, 327731);
                expr = this.newFunction(serverProperties, this.findFunctionByID(serverProperties, FunctionNameID.CASE_SEARCH), searchParms);
                break;
            }
            case 327731: {
                ArrayList whenThenValues = new ArrayList();
                this.complie_whenThenValues(model, whenThenValues, node, includeComments, useFuncCallsFirst, allowedScope, 327731);
                expr = this.newFunction(serverProperties, this.findFunctionByID(serverProperties, FunctionNameID.CASE_WHENTHEN), whenThenValues);
                break;
            }
            case 327732: {
                expr = this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope);
                break;
            }
            case 327733: {
                expr = this.newExpressionInterface(model, children[0], includeComments, useFuncCallsFirst, allowedScope);
                break;
            }
            case 524289: {
                throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.UnsupportedSyntaxExists.fmt.txt", new Object[]{this.retext(node, includeComments)}));
            }
            default: {
                String text = this.retext(node, includeComments);
                expr = StringExpressionUtil.getInstance().newExpression(model, text, 2);
            }
        }
        return expr;
    }

    private ExpressionInterface compile_FractionOfTotalExpression(BusinessModel model, ParsedNode node, boolean includeComments, boolean useFuncCallsFirst, ResourceScope allowedScope) throws MetadataException {
        DataItem denominator;
        ParsedNode[] children = node.getChildren();
        ParsedNode[] parms = children != null && children.length > 0 ? children[0].getChildren() : new ParsedNode[]{};
        ParsedNode numItemNode = parms.length > 0 ? parms[0] : null;
        String numItemText = numItemNode == null ? null : this.retext(numItemNode, false);
        ExpressionInterface numItemExpr = numItemText == null || numItemText.equalsIgnoreCase("null") ? null : this.newExpressionInterface(model, numItemNode, includeComments, useFuncCallsFirst, allowedScope);
        ParsedNode denItemNode = parms.length > 2 ? parms[2] : null;
        String denItemText = denItemNode == null ? null : this.retext(denItemNode, false);
        ExpressionInterface demItemExpr = denItemText == null || denItemText.equalsIgnoreCase("null") ? null : this.newExpressionInterface(model, denItemNode, includeComments, useFuncCallsFirst, allowedScope);
        ParsedNode denTypeNode = parms.length > 1 ? parms[1] : null;
        int denType = -1;
        String denTypeText = this.retext(denTypeNode, false);
        if ("'Subtotal of Category'".compareToIgnoreCase(denTypeText) == 0) {
            denType = 0;
        } else if ("'Row Subtotal'".compareToIgnoreCase(denTypeText) == 0) {
            denType = 4;
        } else if ("'Column Subtotal'".compareToIgnoreCase(denTypeText) == 0) {
            denType = 5;
        } else if ("'Grand Total'".compareToIgnoreCase(denTypeText) == 0) {
            denType = 1;
        } else if ("'Row Total'".compareToIgnoreCase(denTypeText) == 0) {
            denType = 2;
        } else if ("'Column Total'".compareToIgnoreCase(denTypeText) == 0) {
            denType = 3;
        } else {
            MessageFormat inFormat = new MessageFormat("'Unknown Denominator Type=[{0,number,integer}]'");
            try {
                Object[] objects = inFormat.parse(denTypeText);
                if (objects.length == 1 && objects[0] instanceof Number) {
                    denType = ((Number)objects[0]).intValue();
                }
            }
            catch (ParseException e) {
                denType = -1;
            }
        }
        if (denType == -1) {
            int rowMark;
            int subtotalMark;
            int grandMark;
            String scanText = denTypeText.toLowerCase();
            int categoryMark = scanText.indexOf("category");
            denType = categoryMark != -1 ? 0 : ((grandMark = scanText.indexOf("grand")) != -1 ? 1 : ((subtotalMark = scanText.indexOf("subtotal")) != -1 ? ((rowMark = scanText.indexOf("row")) != -1 ? 4 : 5) : ((rowMark = scanText.indexOf("row")) != -1 ? 2 : 3)));
        }
        FractionOfTotalExpression fot = new FractionOfTotalExpression();
        DataItem numerator = numItemExpr instanceof DataItem ? (DataItem)numItemExpr : null;
        DataItem dataItem = denominator = demItemExpr instanceof DataItem ? (DataItem)demItemExpr : null;
        if (numerator != null) {
            fot.setNumerator(numerator);
        }
        if (denType != -1) {
            fot.setDenominatorType(denType);
        }
        if (denominator != null) {
            fot.setDenominator(denominator);
        }
        return fot;
    }

    private ExpressionInterface compile_DataItemFormattingExpression(BusinessModel model, ParsedNode node, boolean includeComments, boolean useFuncCallsFirst, ResourceScope allowedScope) throws MetadataException {
        ParsedNode parm3node;
        ParsedNode parm2node;
        ParsedNode[] children = node.getChildren();
        ParsedNode[] parms = children != null && children.length > 0 ? children[0].getChildren() : new ParsedNode[]{};
        ParsedNode numItemNode = parms.length > 0 ? parms[0] : null;
        String diItemText = numItemNode == null ? null : this.retext(numItemNode, false);
        ExpressionInterface diItemExpr = diItemText == null || diItemText.equalsIgnoreCase("null") ? null : this.newExpressionInterface(model, numItemNode, includeComments, useFuncCallsFirst, allowedScope);
        boolean isFormatted = true;
        boolean isCharacterFormattedWhenNoFormat = false;
        ParsedNode parsedNode = parm2node = parms.length > 1 ? parms[1] : null;
        if (parm2node != null) {
            String parm2text = this.retext(parm2node, false);
            if (parm2text == null || parm2text.length() == 0 || "'formatted'".compareToIgnoreCase(parm2text) == 0 || "formatted='true'".compareToIgnoreCase(parm2text) == 0 || "true".compareToIgnoreCase(parm2text) == 0 || "null".compareToIgnoreCase(parm2text) == 0 || "'true'".compareToIgnoreCase(parm2text) == 0) {
                isFormatted = true;
            } else if ("'unformatted'".compareToIgnoreCase(parm2text) == 0 || "formatted='false'".compareToIgnoreCase(parm2text) == 0 || "false".compareToIgnoreCase(parm2text) == 0 || "'false'".compareToIgnoreCase(parm2text) == 0) {
                isFormatted = false;
            } else if ("'charNotFormattedWhenNoFormat'".compareToIgnoreCase(parm2text) == 0 || "charFormattedWhenNoFormat='false'".compareToIgnoreCase(parm2text) == 0) {
                isCharacterFormattedWhenNoFormat = false;
            } else if ("'charFormattedWhenNoFormat'".compareToIgnoreCase(parm2text) == 0 || "charFormattedWhenNoFormat='true'".compareToIgnoreCase(parm2text) == 0) {
                isCharacterFormattedWhenNoFormat = true;
            } else {
                throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.DataItemFormattingExpression.InvalidFormattedParm.fmt.txt", new Object[]{this.retext(node, includeComments)}));
            }
        }
        ParsedNode parsedNode2 = parm3node = parms.length > 2 ? parms[2] : null;
        if (parm3node != null) {
            String parm3text = this.retext(parm3node, false);
            if (parm3text == null || parm3text.length() == 0 || "'charNotFormattedWhenNoFormat'".compareToIgnoreCase(parm3text) == 0 || "charFormattedWhenNoFormat='false'".compareToIgnoreCase(parm3text) == 0 || "null".compareToIgnoreCase(parm3text) == 0 || "false".compareToIgnoreCase(parm3text) == 0 || "'false'".compareToIgnoreCase(parm3text) == 0) {
                isCharacterFormattedWhenNoFormat = false;
            } else if ("'charFormattedWhenNoFormat'".compareToIgnoreCase(parm3text) == 0 || "charFormattedWhenNoFormat='true'".compareToIgnoreCase(parm3text) == 0 || "true".compareToIgnoreCase(parm3text) == 0 || "'true'".compareToIgnoreCase(parm3text) == 0) {
                isCharacterFormattedWhenNoFormat = true;
            } else if ("'formatted'".compareToIgnoreCase(parm3text) == 0 || "formatted='true'".compareToIgnoreCase(parm3text) == 0) {
                isFormatted = true;
            } else if ("'unformatted'".compareToIgnoreCase(parm3text) == 0 || "formatted='false'".compareToIgnoreCase(parm3text) == 0) {
                isFormatted = false;
            } else {
                throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.DataItemFormattingExpression.InvalidCharFormatParm.fmt.txt", new Object[]{this.retext(node, includeComments)}));
            }
        }
        DataItemFormattingExpression dife = new DataItemFormattingExpression();
        DataItem item = diItemExpr instanceof DataItem ? (DataItem)diItemExpr : null;
        dife.setDataItem(item);
        dife.setIsFormatted(isFormatted);
        dife.setIsCharacterFormattedWhenNoFormat(isCharacterFormattedWhenNoFormat);
        return dife;
    }

    private FunctionNameID findAggregate(ServerProperties serverProperties, String functionName, ParsedNode modifier, List<? extends ExpressionInterface> parms) {
        String modText = "ALL";
        if (modifier != null) {
            if (modifier.getType() == 327693) {
                modText = "ALL";
            } else if (modifier.getType() == 327694) {
                modText = "DISTINCT";
            }
        }
        String lookupValue = functionName.trim() + ',' + modText + ',' + parms.size();
        String key = lookupValue.toUpperCase();
        FunctionNameID functID = _lookupMap.get(key);
        return functID;
    }

    private Function findFunction(ParsedNode node, ServerProperties serverProperties, String functionName, List<? extends ExpressionInterface> parms) {
        int argLen = parms.size();
        Function match = null;
        String compName = functionName.trim();
        List<Function> functions = serverProperties.getFunctions();
        Iterator<Function> iterFunctions = functions.iterator();
        while (iterFunctions.hasNext() && match == null) {
            FunctionSignature fSig;
            String argSigTemp;
            String fSyntaxToken;
            Function function = iterFunctions.next();
            boolean ignore = function.isDistinct() || function.isInCategory(Category.CAT_AGGREGATE) || function.isInCategory(Category.CAT_COUNTING_AGGREGATE);
            if (ignore || compName.compareToIgnoreCase(fSyntaxToken = function.getSyntaxToken().trim()) != 0 || (argSigTemp = function.getSyntaxTemplateFor(argLen)) == null || argSigTemp.length() == 0 || (fSig = function.getCompatibleSignature(parms)) == null) continue;
            match = function;
        }
        return match;
    }

    private void compile_listParms(BusinessModel model, List<? super ExpressionInterface> values, ParsedNode listNode, boolean includeComments, boolean useFuncCallsFirst, ResourceScope allowedScope) throws MetadataException {
        if (listNode != null) {
            if (listNode.getType() != 327682) {
                values.add(this.newExpressionInterface(model, listNode, includeComments, useFuncCallsFirst, allowedScope));
            } else {
                ParsedNode[] listElements = listNode.getChildren();
                for (int i = 0; i < listElements.length; ++i) {
                    ParsedNode subNode2;
                    ParsedNode[] subNodes;
                    int type;
                    String val;
                    ParsedNode nodeInList = listElements[i];
                    ExpressionInterface expr = null;
                    String fixid_S1099873 = null;
                    try {
                        fixid_S1099873 = System.getProperty("SASQueryServices.BiqNoNegParens");
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                        fixid_S1099873 = null;
                    }
                    if (fixid_S1099873 == null) {
                        try {
                            fixid_S1099873 = System.getenv("SASQueryServices.BiqNoNegParens");
                        }
                        catch (SecurityException e) {
                            e.printStackTrace();
                            fixid_S1099873 = null;
                        }
                    }
                    if (!(fixid_S1099873 == null || (val = fixid_S1099873.trim().toUpperCase()).length() <= 0 || val.charAt(0) != 'T' && val.charAt(0) != 'Y' || (type = nodeInList.getType()) != 65537 && type != 65538 || (subNodes = nodeInList.getChildren()) == null || subNodes.length <= 0 || subNodes[0] == null || (subNode2 = subNodes[0]).getType() != 327686)) {
                        expr = this.newExpressionInterface(model, subNode2, includeComments, useFuncCallsFirst, allowedScope);
                        if (expr instanceof ConstantExpression) {
                            String value = (type == 65538 ? "-" : "+") + String.valueOf(((ConstantExpression)expr).getValue());
                            ((ConstantExpression)expr).setValue(value);
                        } else {
                            expr = null;
                        }
                    }
                    if (expr == null) {
                        expr = this.newExpressionInterface(model, nodeInList, includeComments, useFuncCallsFirst, allowedScope);
                    }
                    values.add(expr);
                }
            }
        }
    }

    private void compile_caseParms(BusinessModel model, List<? super ExpressionInterface> parms, ParsedNode node, ParsedNode list, boolean includeComments, boolean useOperFuncsOnly, ResourceScope allowedScope, int whenNodeTypeAllowed) throws MetadataException {
        ParsedNode[] whenThenElses;
        if (list.getType() == 327682) {
            whenThenElses = list.getChildren();
        } else if (list.getType() == whenNodeTypeAllowed) {
            whenThenElses = new ParsedNode[]{list};
        } else {
            throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.InvalidCaseStatementList.fmt.txt", new Object[]{this.retext(node, includeComments), this.retext(list, includeComments)}));
        }
        ParsedNode whenNode = whenThenElses[0];
        this.complie_whenThenValues(model, parms, whenNode, includeComments, useOperFuncsOnly, allowedScope, whenNodeTypeAllowed);
        for (int i = 1; i < whenThenElses.length; ++i) {
            ParsedNode nextNode = whenThenElses[i];
            if (nextNode.getType() != whenNodeTypeAllowed) {
                parms.add(this.newExpressionInterface(model, nextNode, includeComments, useOperFuncsOnly, allowedScope));
                continue;
            }
            if (nextNode.getType() != 327733) {
                parms.add(this.newExpressionInterface(model, nextNode, includeComments, useOperFuncsOnly, allowedScope));
                continue;
            }
            throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.InvalidCaseStatementWhenElse.fmt.txt", new Object[]{this.retext(node, includeComments), this.retext(nextNode, includeComments)}));
        }
    }

    private void complie_whenThenValues(BusinessModel model, List<? super ExpressionInterface> whenThenValues, ParsedNode node, boolean includeComments, boolean useOperFuncsOnly, ResourceScope allowedScope, int whenNodeTypeAllowed) throws MetadataException {
        ParsedNode[] children = node.getChildren();
        if (node.getType() != whenNodeTypeAllowed) {
            throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.InvalidCaseStatementWhen.fmt.txt", new Object[]{this.retext(node, includeComments), this.retext(children[0], includeComments)}));
        }
        ExpressionInterface whenValue = this.newExpressionInterface(model, children[0], includeComments, useOperFuncsOnly, allowedScope);
        whenThenValues.add(whenValue);
        if (children[1].getType() != 327732) {
            throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.InvalidCaseStatementThen.fmt.txt", new Object[]{this.retext(node, includeComments), this.retext(children[1], includeComments)}));
        }
        ExpressionInterface thenValue = this.newExpressionInterface(model, children[1], includeComments, useOperFuncsOnly, allowedScope);
        whenThenValues.add(thenValue);
    }

    private ExpressionInterface newFunction(ServerProperties serverProperties, FunctionNameID functionNameID, List<ExpressionInterface> arguments) throws MetadataException {
        Function function = serverProperties.getFunctionByNameID(functionNameID);
        if (function == null) {
            throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.InvalidFunctionNameID.fmt.txt", new Object[]{functionNameID}));
        }
        return new FunctionCall(function, arguments);
    }

    private ExpressionInterface newFunction(ServerProperties serverProperties, FunctionNameID FunctionNameID2, ExpressionInterface expression) throws MetadataException {
        Function function = serverProperties.getFunctionByNameID(FunctionNameID2);
        if (function == null) {
            throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.InvalidFunctionNameID.fmt.txt", new Object[]{FunctionNameID2}));
        }
        return new FunctionCall(function, expression);
    }

    private ExpressionInterface newFunction(ServerProperties serverProperties, FunctionNameID FunctionNameID2, ExpressionInterface expression1, ExpressionInterface expression2) throws MetadataException {
        Function function = serverProperties.getFunctionByNameID(FunctionNameID2);
        if (function == null) {
            throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.InvalidFunctionNameID.fmt.txt", new Object[]{FunctionNameID2}));
        }
        return new FunctionCall(function, expression1, expression2);
    }

    private ExpressionInterface newFunction(ServerProperties serverProperties, FunctionNameID FunctionNameID2, ExpressionInterface expression1, ExpressionInterface expression2, ExpressionInterface expression3) throws MetadataException {
        Function function = serverProperties.getFunctionByNameID(FunctionNameID2);
        if (function == null) {
            throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.InvalidFunctionNameID.fmt.txt", new Object[]{FunctionNameID2}));
        }
        return new FunctionCall(function, expression1, expression2, expression3);
    }

    private Function findFunctionByID(ServerProperties serverProperties, FunctionNameID functionNameID) throws MetadataException {
        Function function = serverProperties.getFunctionByNameID(functionNameID);
        if (function == null) {
            throw new MetadataException(MetadataException.newMessage(Messages.getBundleName(), "FormatterExpressionizer.Error.InvalidFunctionNameID.fmt.txt", new Object[]{functionNameID}));
        }
        return function;
    }

    private ExpressionInterface newFunction(ServerProperties serverProperties, Function function, List<? extends ExpressionInterface> expressions) {
        return new FunctionCall(function, expressions);
    }

    private ExpressionInterface newStringConstant(int type, String text) {
        ConstantExpression se = new ConstantExpression();
        se.setExpressionType(type);
        se.setValue(text);
        return se;
    }

    private ExpressionInterface newStringExpression(int type, String text) {
        StringExpression se = new StringExpression();
        se.setExpressionType(type);
        se.setText(text);
        return se;
    }

    static {
        _lookupMap.put("AVG,ALL,1", FunctionNameID.AVG);
        _lookupMap.put("SUM,ALL,1", FunctionNameID.SUM);
        _lookupMap.put("MEAN,ALL,1", FunctionNameID.MEAN);
        _lookupMap.put("FREQ,ALL,1", FunctionNameID.FREQ);
        _lookupMap.put("COUNT,ALL,1", FunctionNameID.COUNT);
        _lookupMap.put("N,ALL,1", FunctionNameID.N);
        _lookupMap.put("NMISS,ALL,1", FunctionNameID.NMISS);
        _lookupMap.put("MAX,ALL,1", FunctionNameID.MAX);
        _lookupMap.put("MIN,ALL,1", FunctionNameID.MIN);
        _lookupMap.put("CV,ALL,1", FunctionNameID.CV);
        _lookupMap.put("CSS,ALL,1", FunctionNameID.CSS);
        _lookupMap.put("PRT,ALL,1", FunctionNameID.PRT);
        _lookupMap.put("RANGE,ALL,1", FunctionNameID.RANGE);
        _lookupMap.put("STD,ALL,1", FunctionNameID.STD);
        _lookupMap.put("STDERR,ALL,1", FunctionNameID.STDERR);
        _lookupMap.put("T,ALL,1", FunctionNameID.T);
        _lookupMap.put("USS,ALL,1", FunctionNameID.USS);
        _lookupMap.put("VAR,ALL,1", FunctionNameID.VAR);
        _lookupMap.put("AVG,DISTINCT,1", FunctionNameID.AVG_DISTINCT);
        _lookupMap.put("SUM,DISTINCT,1", FunctionNameID.SUM_DISTINCT);
        _lookupMap.put("MEAN,DISTINCT,1", FunctionNameID.MEAN_DISTINCT);
        _lookupMap.put("FREQ,DISTINCT,1", FunctionNameID.FREQ_DISTINCT);
        _lookupMap.put("COUNT,DISTINCT,1", FunctionNameID.COUNT_DISTINCT);
        _lookupMap.put("N,DISTINCT,1", FunctionNameID.N_DISTINCT);
        _lookupMap.put("NMISS,DISTINCT,1", FunctionNameID.NMISS_DISTINCT);
        _lookupMap.put("MAX,DISTINCT,1", FunctionNameID.MAX_DISTINCT);
        _lookupMap.put("MIN,DISTINCT,1", FunctionNameID.MIN_DISTINCT);
        _lookupMap.put("CV,DISTINCT,1", FunctionNameID.CV_DISTINCT);
        _lookupMap.put("CSS,DISTINCT,1", FunctionNameID.CSS_DISTINCT);
        _lookupMap.put("PRT,DISTINCT,1", FunctionNameID.PRT_DISTINCT);
        _lookupMap.put("STD,DISTINCT,1", FunctionNameID.STD_DISTINCT);
        _lookupMap.put("RANGE,DISTINCT,1", FunctionNameID.RANGE_DISTINCT);
        _lookupMap.put("STDERR,DISTINCT,1", FunctionNameID.STDERR_DISTINCT);
        _lookupMap.put("T,DISTINCT,1", FunctionNameID.T_DISTINCT);
        _lookupMap.put("USS,DISTINCT,1", FunctionNameID.USS_DISTINCT);
        _lookupMap.put("VAR,DISTINCT,1", FunctionNameID.VAR_DISTINCT);
    }
}

