/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.serverprop.ConnectionType;
import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@SubjectToChange
public final class TimeValueExpression
extends AbstractTimeValueExpression {
    private static final String SAS_TIME_PATTERN = "''HH:mm:ss'''T'";
    private static final String SQL99_TIME_PATTERN = "'TIME '''HH:mm:ss''";
    private static final Logger _logger = LogManager.getLogger(TimeValueExpression.class);

    public TimeValueExpression() {
    }

    public TimeValueExpression(Time timeValue) {
        this.setTimeValue(timeValue);
    }

    public TimeValueExpression(Date value) {
        this.setValue(value);
    }

    public Time getTimeValue() {
        return (Time)this.getValue();
    }

    public void setTimeValue(Time timeValue) {
        this.setValue(timeValue);
    }

    @Override
    @SASScope
    protected SimpleDateFormat getFormatter() {
        SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getTimeInstance(2, Locale.ENGLISH);
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
        formatter.setTimeZone(gmtTimeZone);
        return formatter;
    }

    @Override
    @SASScope
    protected String getPattern(DataSelection dataSelection, ConnectionType connectionType) throws MetadataException {
        String pattern = connectionType == ConnectionType.IOM_TSSQL ? SQL99_TIME_PATTERN : SAS_TIME_PATTERN;
        return pattern;
    }

    @Override
    @SASScope
    Date newCoreObject(long value) {
        return new Time(value);
    }

    @Override
    public int getExpressionType() {
        return 5;
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "TimeValue";
    }

    @Override
    @SASScope
    public String toString() {
        String out = null;
        Date chronoValue = this.getValue();
        if (chronoValue == null) {
            out = "-";
        } else {
            chronoValue = TimeValueExpression.newTimeOnlyValue(chronoValue);
            out = chronoValue.toString();
        }
        if (this.getExplicitDoubleValue() != null) {
            out = out + "(";
            out = out + this.getExplicitDoubleValue().toString();
            out = out + ")";
        }
        return out;
    }

    public static Time newTimeOnlyValue(Date dateValue) {
        long maxAllowedLong;
        long value = dateValue.getTime();
        if (value > (maxAllowedLong = 86400000L) || value < 0L) {
            long newValue = value % maxAllowedLong;
            if (newValue < 0L) {
                newValue += maxAllowedLong;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("Time value provided " + value + " is greater than max allowed (" + maxAllowedLong + ").  Date milliseconds stripped.  New value=" + newValue);
            }
            value = newValue;
        }
        Time timeValue = new Time(value);
        return timeValue;
    }
}

