/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.ConnectionConfiguration;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.DataItemContainerExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.olap.BaseFilterExpression;
import com.sas.iquery.metadata.expr.parser.ExpressionIdentifier;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSet;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPUtilities;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.TupleElement;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope
public class OLAPResourceAwareStringExpression
extends ResourceAwareStringExpression
implements DataItemContainerExpression {
    private Dimension _dimension;
    private Hierarchy _hierarchy;
    private boolean _isInitialMeasure;
    private boolean _hasMultipleMembers;
    private boolean _isMeasure;
    private final String drillIndication = ".CHILDREN";
    private String _parentOfChild;
    private String _expressionText;
    private String _lowestCommonLevel;
    private boolean _isMemberQuery;
    private boolean _isSetQuery;
    private static final Logger _logger = LogManager.getLogger(OLAPResourceAwareStringExpression.class);

    @SASScope
    public OLAPResourceAwareStringExpression() {
        this._dimension = null;
        this._hierarchy = null;
        this._isInitialMeasure = false;
        this._hasMultipleMembers = true;
        this._isMeasure = false;
        this.drillIndication = ".CHILDREN";
        this._parentOfChild = "";
        this._expressionText = null;
        this._lowestCommonLevel = null;
        this._isMemberQuery = false;
        this._isSetQuery = false;
    }

    public OLAPResourceAwareStringExpression(BusinessModel businessModel, String expressionString, int expressionType, ResourceScope scope, Dimension dimension, Hierarchy hierarchy, boolean isMeasure, boolean hasMultipleMembers) throws MetadataException {
        super(businessModel, expressionString, expressionType, scope);
        this._dimension = null;
        this._hierarchy = null;
        this._isInitialMeasure = false;
        this._hasMultipleMembers = true;
        this._isMeasure = false;
        this.drillIndication = ".CHILDREN";
        this._parentOfChild = "";
        this._expressionText = null;
        this._lowestCommonLevel = null;
        this._isMemberQuery = false;
        this._isSetQuery = false;
        this._dimension = dimension;
        this._hierarchy = hierarchy;
        this._isMeasure = isMeasure;
        this._hasMultipleMembers = hasMultipleMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public OLAPResourceAwareStringExpression(BusinessModel businessModel, String expressionString, int expressionType, ResourceScope scope) throws MetadataException {
        IQMetadataInterface metaI;
        block24: {
            super(businessModel, expressionString, expressionType, scope);
            this._dimension = null;
            this._hierarchy = null;
            this._isInitialMeasure = false;
            this._hasMultipleMembers = true;
            this._isMeasure = false;
            this.drillIndication = ".CHILDREN";
            this._parentOfChild = "";
            this._expressionText = null;
            this._lowestCommonLevel = null;
            this._isMemberQuery = false;
            this._isSetQuery = false;
            if (expressionString.trim().length() == 0) {
                this._expressionText = "";
                return;
            }
            Preconditions.ensureNonNull(businessModel, "businessModel", _logger);
            RetrievalPolicy userSessionPolicy = new RetrievalPolicy();
            userSessionPolicy.setPolicyValue(0);
            ConnectionConfiguration connectionConfiguration = userSessionPolicy.getConnectionConfiguration();
            connectionConfiguration.setConnectionLifetime(1);
            String constructor = "DEFAULT_CONSTRUCTOR_BEHAVIOR";
            int contextType = 0;
            boolean disposeDataSelection = false;
            DataSelection dataSelection = OLAPUtilities.findDataSelection(null, businessModel);
            if (dataSelection == null) {
                disposeDataSelection = true;
                dataSelection = OLAPUtilities.createDataSelection(businessModel, null);
            }
            List<BusinessModelResource> resources = this.getResources(BusinessModelResource.class, 65535);
            metaI = null;
            try {
                String localMeasure;
                String memberDimension;
                ExpressionIdentifier exprIdent;
                String exprString;
                if (!dataSelection.getStructure().isOLAP()) {
                    MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoValidModel.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message, businessModel, dataSelection, expressionString);
                    throw new MetadataException(message);
                }
                String builtExpression = this.buildMDX(this, resources);
                if (builtExpression.trim().length() == 0) {
                    MetadataException ee = new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OLAPResourceAwareStringBadExprText.txt", new Object[0]));
                    throw ee;
                }
                List<ExpressionIdentifier> expressionIdentifierList = this.getExpressionIdentifiers();
                if (expressionIdentifierList.size() > 0 && expressionIdentifierList.size() == 1 && (exprString = (exprIdent = expressionIdentifierList.get(0)).getStringValue()) != null && exprString.indexOf(".") > 1 && (memberDimension = exprString.substring(0, exprString.indexOf("."))).equalsIgnoreCase(localMeasure = MDXGenerationUtil.getLocalMeasure(businessModel, metaI)) && expressionIdentifierList.size() == 1) {
                    this._isInitialMeasure = true;
                }
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.debug("Query expression generated for this OLAP item: " + builtExpression);
                }
                Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
                DataSourceCube cube = OLAPUtilities.findDataSourceCube(dataSelection);
                List<Dimension> dimensions = cube.getDimensions();
                Dimension measureInCube = this.getMeasureDimensionInCube(dimensions);
                _logger.info("Measure Dimension = " + measureInCube);
                String cubeName = OLAPUtilities.findCubeName(cube);
                SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(cube);
                LogicalServerInterface logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
                OLAPConnectionResource olapConnection = null;
                try {
                    olapConnection = OLAPConnectionInfoUtil.getOLAPConnectionResource(dataSelection, logicalServer, userSessionPolicy, computationalLocale);
                }
                catch (GenerationException e) {
                    MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoMetadata.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message, e, businessModel, olapConnection);
                    throw new MetadataException(message, (Throwable)e);
                }
                try {
                    metaI = olapConnection.createMetadataInterface(dataSelection, constructor, cube, true, true, null);
                }
                catch (GenerationException e) {
                    MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoMetadata.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message, e, businessModel, olapConnection);
                    throw new MetadataException(message, (Throwable)e);
                }
                catch (ExecutionException e) {
                    MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoMetadata.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message, e, businessModel, olapConnection);
                    throw new MetadataException(message, (Throwable)e);
                }
                IQOLAPDataSet olapDataSet = null;
                try {
                    olapDataSet = this.checkIfMemberOrSet(businessModel, contextType, metaI, olapConnection, resources, builtExpression, cubeName);
                    if (this._isMemberQuery) {
                        this.queryCubeForDimension(expressionString, olapDataSet, cubeName, dimensions, metaI, this._isMemberQuery);
                    } else if (this._isSetQuery) {
                        this.queryCubeForDimension(builtExpression, olapDataSet, cubeName, dimensions, metaI, this._isMemberQuery);
                    } else {
                        MDXGenerationUtil.applyDebugStatement("Nothing found for the value in this identifier, move on.", this.getClass());
                    }
                    if (this._dimension == null) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            Object[] msgArgs2 = new Object[]{builtExpression, IQMetadataResourceBundle.getStringResource("OLAPResourceAwareStringDimensionIsNull.txt")};
                            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                            _logger.error(msF.toString());
                        }
                        this._dimension = measureInCube;
                        this._isMeasure = true;
                    }
                }
                catch (Throwable throwable) {
                    ConnectionResources.close(olapDataSet);
                    throw throwable;
                }
                ConnectionResources.close(olapDataSet);
                if (dataSelection == null || !disposeDataSelection) break block24;
            }
            catch (Throwable throwable) {
                if (dataSelection != null && disposeDataSelection) {
                    dataSelection.dispose();
                }
                if (metaI != null) {
                    BusinessQueryOLAPUtil.releaseMetadataInterface(metaI);
                }
                throw throwable;
            }
            dataSelection.dispose();
        }
        if (metaI != null) {
            BusinessQueryOLAPUtil.releaseMetadataInterface(metaI);
        }
    }

    private IQOLAPDataSet newIQOLAPDataSet(BusinessModel businessModel, int contextType, IQMetadataInterface metaI, OLAPConnectionResource olapConnection) throws MetadataException {
        IQOLAPDataSet olapDataSet = null;
        try {
            olapDataSet = ConnectionUtil.newOLAPDataSet(businessModel, null, contextType, metaI, olapConnection);
        }
        catch (ExecutionException e) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoMetadata.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, e, businessModel, olapConnection);
            throw new MetadataException(message, (Throwable)e);
        }
        catch (OLAPException e) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoMetadata.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, new Object[]{e, businessModel, olapConnection});
            throw new MetadataException(message, (Throwable)e);
        }
        return olapDataSet;
    }

    private IQOLAPDataSet checkIfMemberOrSet(BusinessModel businessModel, int contextType, IQMetadataInterface metaI, OLAPConnectionResource olapConnection, List<BusinessModelResource> resources, String builtExpression, String cubeName) throws MetadataException {
        String message;
        IQOLAPDataSet olapDataSet = this.newIQOLAPDataSet(businessModel, contextType, metaI, olapConnection);
        String mdxMember = null;
        try {
            mdxMember = MDXGenerationUtil.buildMemberQuery(resources, builtExpression, cubeName, businessModel);
        }
        catch (GenerationException ge) {
            ArrayMessageFormatter msF5 = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, builtExpression, IQMetadataResourceBundle.getStringResource("OLAPResourceAwareStringBadQuery.txt"));
            throw new MetadataException((MessageFormatter)msF5, (Throwable)ge);
        }
        if (mdxMember == null) {
            mdxMember = "";
        }
        if (this._isInitialMeasure && mdxMember.trim().length() > 0) {
            try {
                olapDataSet.setQueryStatement(mdxMember, null);
                olapDataSet.executeQuery();
                this._isMemberQuery = true;
            }
            catch (OLAPException oe) {
                message = "An error was throw from this query but it was not necessary to report.";
                MDXGenerationUtil.applyDebugStatement(message, this.getClass());
                MDXGenerationUtil.applyDebugStatement(mdxMember, this.getClass());
                olapDataSet = this.newIQOLAPDataSet(businessModel, contextType, metaI, olapConnection);
            }
        }
        if (!this._isMemberQuery) {
            String mdxSet = MDXGenerationUtil.buildSetQuery(builtExpression, cubeName);
            if (mdxSet == null) {
                mdxSet = "";
            }
            if (mdxSet.trim().length() > 0) {
                try {
                    olapDataSet.setQueryStatement(mdxSet, null);
                    olapDataSet.executeQuery();
                    this._isSetQuery = true;
                }
                catch (OLAPException oe) {
                    String message2 = "An error was throw from this query but it was not necessary to report.";
                    MDXGenerationUtil.applyDebugStatement(message2, this.getClass());
                    MDXGenerationUtil.applyDebugStatement(mdxSet, this.getClass());
                    olapDataSet = this.newIQOLAPDataSet(businessModel, contextType, metaI, olapConnection);
                }
            }
        }
        if (!(this._isInitialMeasure || this._isMemberQuery || this._isSetQuery || mdxMember.trim().length() <= 0)) {
            try {
                olapDataSet.setQueryStatement(mdxMember, null);
                olapDataSet.executeQuery();
                this._isMemberQuery = true;
            }
            catch (OLAPException oe) {
                message = "An error was throw from this query but it was not necessary to report.";
                MDXGenerationUtil.applyDebugStatement(message, this.getClass());
                MDXGenerationUtil.applyDebugStatement(mdxMember, this.getClass());
                olapDataSet = this.newIQOLAPDataSet(businessModel, contextType, metaI, olapConnection);
            }
        }
        return olapDataSet;
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        intoList.add(this._dimension);
        intoList.add(this._hierarchy);
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._expressionText != null && this._expressionText.length() == 0) {
            return;
        }
        if (this._dimension == null) {
            reasons.add(new Reason((Object)this, 2, 0, "OLAPResourceAwareStringDimensionIsNull.txt", new Object[0]));
        }
    }

    private String buildDataItemExpression(DataItem dataItem) throws MetadataException {
        StringBuffer diExpression = new StringBuffer();
        ExpressionInterface expression = dataItem.getExpression();
        if (expression instanceof Dimension) {
            diExpression.append(((Dimension)expression).getUniqueName());
        } else if (expression instanceof Hierarchy) {
            diExpression.append(((Hierarchy)expression).getUniqueName());
        } else if (expression instanceof com.sas.iquery.metadata.physical.Level) {
            diExpression.append(((com.sas.iquery.metadata.physical.Level)expression).getLevelUniqueName());
        } else if (expression instanceof Measure) {
            diExpression.append(((Measure)expression).getUniqueName());
        } else if (expression instanceof ResourceAwareStringExpression) {
            diExpression.append(expression);
        }
        return diExpression.toString();
    }

    private String buildMDX(OLAPResourceAwareStringExpression resourceExp, List<BusinessModelResource> resources) throws MetadataException {
        StringBuffer mdxExpression = new StringBuffer();
        HashMap<BusinessModelResource, String> resourceToMDXMap = new HashMap<BusinessModelResource, String>();
        for (BusinessModelResource bmaResource : resources) {
            if (bmaResource instanceof DataItem) {
                DataItem di = (DataItem)bmaResource;
                resourceToMDXMap.put(di, this.buildDataItemExpression(di));
                continue;
            }
            if (bmaResource instanceof Dimension) {
                Dimension physDimension = (Dimension)bmaResource;
                String dimName = physDimension.getUniqueName();
                resourceToMDXMap.put(physDimension, dimName);
                continue;
            }
            if (bmaResource instanceof Hierarchy) {
                Hierarchy physHierarchy = (Hierarchy)bmaResource;
                String hierName = physHierarchy.getUniqueName();
                resourceToMDXMap.put(physHierarchy, hierName);
                continue;
            }
            if (bmaResource instanceof com.sas.iquery.metadata.physical.Level) {
                com.sas.iquery.metadata.physical.Level physLevel = (com.sas.iquery.metadata.physical.Level)bmaResource;
                String levelName = physLevel.getLevelUniqueName();
                resourceToMDXMap.put(physLevel, levelName);
                continue;
            }
            if (!(bmaResource instanceof Measure)) continue;
            Measure physMeasure = (Measure)bmaResource;
            this._isInitialMeasure = true;
            String measureName = physMeasure.getUniqueName();
            resourceToMDXMap.put(physMeasure, measureName);
        }
        String resourceMDX = resourceExp.getText(resourceToMDXMap);
        mdxExpression.append(resourceMDX);
        return mdxExpression.toString();
    }

    @SASScope
    public Hierarchy getHierarchy() {
        return this._hierarchy;
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        OLAPResourceAwareStringExpression clone = (OLAPResourceAwareStringExpression)super.clone();
        if (this._dimension != null) {
            clone._dimension = (Dimension)this._dimension.clone();
        }
        if (this._hierarchy != null) {
            clone._hierarchy = (Hierarchy)this._hierarchy.clone();
        }
        return clone;
    }

    private Dimension getMeasureDimensionInCube(List<Dimension> dimensions) throws MetadataException {
        for (Dimension dim : dimensions) {
            if (dim.isUnresolved() || dim.getDimensionType() != 1) continue;
            return dim;
        }
        return null;
    }

    private void convertDimensionInterfaceToDimension(List<Dimension> dimensions, DimensionInterface dimension, HierarchyInterface hierarchy) throws MetadataException {
        block5: {
            try {
                for (Dimension dim : dimensions) {
                    if (dim == null || dimension == null || !dim.getDimensionName().equalsIgnoreCase(dimension.getName())) continue;
                    this._dimension = dim;
                    if (hierarchy == null) break;
                    List<Hierarchy> hiers = dim.getHierarchies();
                    for (Hierarchy hier : hiers) {
                        if (hier == null || hierarchy == null || !hier.getHierarchyName().equalsIgnoreCase(hierarchy.getName())) continue;
                        this._hierarchy = hier;
                        break block5;
                    }
                    break;
                }
            }
            catch (OLAPException oe) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, dimension.toString(), IQMetadataResourceBundle.getStringResource("OLAPResourceAwareStringBadQuery.txt"));
                throw new MetadataException((MessageFormatter)msF, (Throwable)oe);
            }
            catch (IQueryServicesException ie) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, dimension.toString(), IQMetadataResourceBundle.getStringResource("OLAPResourceAwareStringBadQuery.txt"));
                throw new MetadataException((MessageFormatter)msF, (Throwable)ie);
            }
        }
    }

    @SASScope
    public boolean hasMultipleMembers() {
        return this._hasMultipleMembers;
    }

    @SASScope
    public String getParentOfChild() {
        return this._parentOfChild;
    }

    @SASScope
    public String getAllMember() throws MetadataException {
        if (this._expressionText != null && this._expressionText.length() == 0) {
            MDXGenerationUtil.applyDebugStatement("Expression Text length is zero. move on. ", this.getClass());
            return null;
        }
        if (this._dimension == null) {
            MetadataException ee = new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OLAPResourceAwareStringDimensionIsNull.txt", new Object[0]));
            throw ee;
        }
        return this._dimension.getUniqueNameWithHierarchyAllMember();
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "OlapResourceAwareStringExpr";
    }

    @SASScope
    public String getDimName() throws MetadataException {
        if (this._expressionText != null && this._expressionText.length() == 0) {
            return null;
        }
        if (this._dimension == null) {
            MetadataException ee = new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OLAPResourceAwareStringDimensionIsNull.txt", new Object[0]));
            throw ee;
        }
        return this._dimension.getDimensionName();
    }

    @SASScope
    public int getDimType() throws MetadataException {
        int dimType = 4;
        if (this._expressionText != null && this._expressionText.length() == 0) {
            return dimType;
        }
        if (this._dimension == null) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("OLAPResourceAwareStringDimensionIsNull.txt"));
            }
            return dimType;
        }
        if (this._dimension.isUnresolved()) {
            if (this._isMeasure) {
                dimType = 1;
            }
        } else {
            dimType = this._dimension.getDimensionType();
        }
        if (dimType == 1) {
            dimType = 2;
        } else if (dimType == 2) {
            dimType = 3;
        } else if (dimType == 0) {
            dimType = 1;
        } else if (dimType == 3) {
            dimType = 4;
        } else if (dimType == 4) {
            dimType = 3;
        } else {
            Object[] msgArgs2 = new Object[]{this._expressionText, IQMetadataResourceBundle.getStringResource("OLAPResourceAwareStringBadDimType.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            MetadataException ee = new MetadataException(msF);
            throw ee;
        }
        return dimType;
    }

    @SASScope
    public String getHierName(Locale locale, BusinessModel model) throws MetadataException {
        if (this._hierarchy == null) {
            if (this._isMeasure) {
                String localMeasure = MDXGenerationUtil.getLocalMeasure(model, null);
                return localMeasure;
            }
            MetadataException ee = new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OLAPResourceAwareStringHierarchyIsNull.txt", new Object[0]));
            throw ee;
        }
        return this._hierarchy.getUniqueName();
    }

    @SASScope
    public boolean isMeasure() {
        return this._isMeasure;
    }

    private void queryCubeForDimension(String exprText, IQOLAPDataSet olapDataSet, String cubeName, List<Dimension> dimensions, MetadataInterface metaI, boolean isMemberQuery) throws MetadataException {
        try {
            Filter filter;
            ResultSetMetadataInterface resultSetMeta = olapDataSet.getResultSetMetadata();
            AxisInterface[] axes = resultSetMeta.getAxes(0, -1);
            AxisInterface axis = axes[0];
            String[] uNames = axis.getDimensionNames();
            String[] unNames = axis.getUniqueLevelNames();
            String uName = null;
            String unName = null;
            if (uNames.length == 0 && axes.length > 1) {
                axis = axes[1];
                uNames = axis.getDimensionNames();
                unNames = axis.getUniqueLevelNames();
            }
            DimensionInterface dimension = null;
            HierarchyInterface hierarchy = null;
            if (uNames.length > 0) {
                uName = uNames[0];
                unName = unNames[0];
                filter = new Filter();
                filter.setCubeName(cubeName);
                filter.setDimensionName(uName);
                dimension = metaI.getDimension(filter);
                if (dimension.getType() == 2 && !isMemberQuery && axes.length > 1) {
                    axis = axes[1];
                    uNames = axis.getDimensionNames();
                    unNames = axis.getUniqueLevelNames();
                    if (uNames.length > 0) {
                        uName = uNames[0];
                        unName = unNames[0];
                        filter.setDimensionName(uName);
                        dimension = metaI.getDimension(filter);
                    }
                }
                if (dimension.getType() == 2) {
                    this._isMeasure = true;
                } else {
                    filter.setUniqueLevelName(unName);
                }
            } else {
                Object[] msgArgs2 = new Object[]{exprText, cubeName, IQMetadataResourceBundle.getStringResource("OLAPResourceAwareStringBadQuery.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                MetadataException ee = new MetadataException(msF);
                throw ee;
            }
            LevelInterface level = metaI.getLevel(filter);
            hierarchy = level.getHierarchy();
            if (dimension == null) {
                Object[] msgArgs2 = new Object[]{exprText, IQMetadataResourceBundle.getStringResource("OLAPResourceAwareStringDimensionIsNull.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                MetadataException ee = new MetadataException(msF);
                throw ee;
            }
            this.convertDimensionInterfaceToDimension(dimensions, dimension, hierarchy);
            if (!this._isMeasure) {
                int endOfDot;
                TupleInterface[] tuples = resultSetMeta.getTuples(0, 0, -1);
                ArrayList<TupleElement> returnList = new ArrayList<TupleElement>();
                int highLevelOfAncestor = 0;
                for (int i = 0; i < tuples.length; ++i) {
                    if (!this.isResourceOnly()) {
                        int depthi = tuples[i].getTupleDepth();
                        TupleElementInterface[] tupleElementi = tuples[i].getElements(depthi - 1, 1);
                        String uniqueLevelName = tupleElementi[0].getUniqueLevelName().trim();
                        if (depthi > highLevelOfAncestor) {
                            this._lowestCommonLevel = uniqueLevelName;
                            highLevelOfAncestor = depthi;
                        }
                    }
                    TupleElementInterface[] tupleElement = tuples[i].getElements(0, 1);
                    TupleElement emTupleElement = new TupleElement();
                    emTupleElement.setChildCount(tupleElement[0].getChildCount());
                    emTupleElement.setContinued(tupleElement[0].isContinued());
                    emTupleElement.setDrilledDown(tupleElement[0].isDrilledDown());
                    emTupleElement.setLabel(tupleElement[0].getLabel());
                    emTupleElement.setLevelDepth(tupleElement[0].getLevelDepth());
                    emTupleElement.setMaximumCoordinate(tupleElement[0].getMaximumCoordinate());
                    emTupleElement.setMinimumCoordinate(tupleElement[0].getMinimumCoordinate());
                    emTupleElement.setName(tupleElement[0].getName());
                    emTupleElement.setProperties(tupleElement[0].getProperties());
                    emTupleElement.setUniqueLevelName(tupleElement[0].getUniqueLevelName());
                    returnList.add(emTupleElement);
                }
                if (returnList.size() < 2) {
                    this._hasMultipleMembers = false;
                }
                int presenceOfComma = exprText.indexOf(",");
                if (this._hasMultipleMembers && presenceOfComma == -1 && (endOfDot = exprText.lastIndexOf(".")) > 0) {
                    String expText3;
                    int start = endOfDot;
                    int end = ".CHILDREN".length();
                    String expText2 = exprText.substring(start);
                    if (expText2.length() >= end && (expText3 = expText2.substring(0, end)).equalsIgnoreCase(".CHILDREN")) {
                        this._parentOfChild = exprText.substring(0, endOfDot);
                        this._parentOfChild = this._parentOfChild.replace('{', ' ');
                        this._hasMultipleMembers = false;
                    }
                }
            }
        }
        catch (OLAPException oe) {
            ArrayMessageFormatter msF2 = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, exprText, IQMetadataResourceBundle.getStringResource("OLAPResourceAwareStringBadQuery.txt"));
            throw new MetadataException((MessageFormatter)msF2, (Throwable)oe);
        }
    }

    private boolean isResourceOnly() {
        boolean returnValue = true;
        for (ExpressionIdentifier obj : this.getExpressionIdentifiers()) {
            if (!(obj instanceof ExpressionIdentifier) || !obj.isOlapMember()) continue;
            returnValue = false;
        }
        return returnValue;
    }

    private void replacePersistedHierarchyString(Object replacedObject, Object newObject) {
        block11: {
            try {
                if (newObject instanceof Hierarchy && replacedObject instanceof Hierarchy && ((Hierarchy)replacedObject).getHierarchyName().equals(((Hierarchy)newObject).getHierarchyName()) && !((Hierarchy)newObject).isUnresolved()) {
                    ConstantExpression conExp;
                    if (this._hierarchy != null && this._dimension != null && !this._hierarchy.getOwningDimension().getDimensionName().equals(this._dimension.getDimensionName())) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            String error = IQMetadataResourceBundle.getMessageString("OLAPResourceAwareStringDimensionBadReplacement.fmt.txt", this._hierarchy.toString(), this._dimension.toString());
                            _logger.error(error);
                        }
                        this._dimension = this._hierarchy.getOwningDimension();
                    }
                    if (this._lowestCommonLevel != null) {
                        if (this._lowestCommonLevel.length() > 0) {
                            conExp = BusinessQueryOLAPUtil.convertStringIntoExpression(this._lowestCommonLevel);
                            BusinessQueryOLAPUtil.replaceHierarchyInString(conExp, newObject);
                            MDXGenerationUtil.applyDebugStatement("Lowest common level replaced from " + this._lowestCommonLevel + " to " + conExp.getValue(), OLAPResourceAwareStringExpression.class);
                            this._lowestCommonLevel = conExp.getValue();
                        }
                    } else {
                        for (ExpressionIdentifier obj : this.getExpressionIdentifiers()) {
                            BusinessModelResource bmRes;
                            ExpressionIdentifier exp;
                            if (!(obj instanceof ExpressionIdentifier) || !(exp = obj).isResource() || !((bmRes = exp.getBusinessModelResource()) instanceof com.sas.iquery.metadata.physical.Level)) continue;
                            boolean found = false;
                            for (com.sas.iquery.metadata.physical.Level levell : ((Hierarchy)newObject).getLevels()) {
                                if (!((com.sas.iquery.metadata.physical.Level)bmRes).getLevelName().equalsIgnoreCase(levell.getLevelName())) continue;
                                found = true;
                                break;
                            }
                            if (!found || bmRes.isUnresolved()) continue;
                            this._lowestCommonLevel = ((com.sas.iquery.metadata.physical.Level)bmRes).getLevelUniqueName();
                        }
                    }
                    if (this._parentOfChild != null && this._parentOfChild.length() > 0 && this._hasMultipleMembers) {
                        conExp = BusinessQueryOLAPUtil.convertStringIntoExpression(this._parentOfChild);
                        BusinessQueryOLAPUtil.replaceHierarchyInString(conExp, newObject);
                        MDXGenerationUtil.applyDebugStatement("Definition of parent/child string is replaced from " + this._parentOfChild + " to " + conExp.getValue(), OLAPResourceAwareStringExpression.class);
                        this._parentOfChild = conExp.getValue();
                    }
                }
            }
            catch (MetadataException me) {
                if (!_logger.isEnabled(Level.ERROR)) break block11;
                _logger.error("Hierarchy name could not be aquired to fix lowest common level of this expression. " + me.getLocalizedMessage(), (Throwable)me);
            }
        }
    }

    private void replacePersistedDimensionString(Object replacedObject, Object newObject) {
        block7: {
            try {
                if (!Proxy.isProxyClass(replacedObject.getClass()) && replacedObject instanceof Dimension) {
                    if (this._hierarchy != null) {
                        boolean found = false;
                        List<Hierarchy> hiers = ((Dimension)replacedObject).getHierarchies();
                        for (Hierarchy hierDim : hiers) {
                            if (!hierDim.getHierarchyName().equals(this._hierarchy.getHierarchyName())) continue;
                            found = true;
                            break;
                        }
                        if (!found && hiers.size() > 0) {
                            this._hierarchy = hiers.get(0);
                        }
                    }
                    if (this._lowestCommonLevel != null && !this.isResourceOnly() && this._lowestCommonLevel.length() > 0) {
                        ConstantExpression conExp = BusinessQueryOLAPUtil.convertStringIntoExpression(this._lowestCommonLevel);
                        BusinessQueryOLAPUtil.replaceDimensionInString(conExp, newObject);
                        MDXGenerationUtil.applyDebugStatement("Lowest common level replaced from " + this._lowestCommonLevel + " to " + conExp.getValue(), OLAPResourceAwareStringExpression.class);
                        this._lowestCommonLevel = conExp.getValue();
                    }
                }
            }
            catch (MetadataException me) {
                if (!_logger.isEnabled(Level.ERROR)) break block7;
                _logger.error("Dimension name could not be aquired to fix lowest common level of this expression. " + me.getLocalizedMessage(), (Throwable)me);
            }
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        super.replaceDirectReferences(oldObject, newObject);
        this._dimension = (Dimension)OLAPResourceAwareStringExpression.replace(this._dimension, oldObject, newObject);
        this._hierarchy = (Hierarchy)OLAPResourceAwareStringExpression.replace(this._hierarchy, oldObject, newObject);
    }

    @Override
    @SASScope
    protected void replaceDirectReferencesDuringResourceReplacement(Object oldObject, Object newObject) {
        block17: {
            super.replaceDirectReferencesDuringResourceReplacement(oldObject, newObject);
            try {
                if (newObject instanceof Dimension) {
                    if (this._dimension != null && this._dimension instanceof Dimension) {
                        if (this._dimension.getDimensionName().equals(((Dimension)newObject).getDimensionName())) {
                            this.checkForOLAPRASEInFilter();
                            this.replacePersistedDimensionString(this._dimension, newObject);
                        }
                    } else if (_logger.isEnabled(Level.ERROR)) {
                        String error = IQMetadataResourceBundle.getMessageString("OLAPResourceAwareStringDimensionBadReplacementNull.fmt.txt", newObject.toString());
                        _logger.error(error);
                    }
                    break block17;
                }
                if (newObject instanceof Hierarchy) {
                    if (this._hierarchy != null && this._hierarchy instanceof Hierarchy) {
                        if (this._hierarchy.getHierarchyName().equals(((Hierarchy)newObject).getHierarchyName())) {
                            this.checkForOLAPRASEInFilter();
                            this.replacePersistedHierarchyString(this._hierarchy, newObject);
                        }
                    } else if (_logger.isEnabled(Level.ERROR)) {
                        String error = IQMetadataResourceBundle.getMessageString("OLAPResourceAwareStringHierarchyBadReplacementNull.fmt.txt", newObject.toString());
                        _logger.error(error);
                    }
                    break block17;
                }
                if (!(newObject instanceof com.sas.iquery.metadata.physical.Level)) break block17;
                if (((com.sas.iquery.metadata.physical.Level)newObject).isUnresolved()) {
                    MDXGenerationUtil.applyDebugStatement("New qualified Level is not resolved. " + ((com.sas.iquery.metadata.physical.Level)newObject).toString(), this.getClass());
                    break block17;
                }
                for (ExpressionIdentifier exp : this.getExpressionIdentifiers()) {
                    BusinessModelResource bmRes;
                    if (!exp.isResource() || !((bmRes = exp.getBusinessModelResource()) instanceof com.sas.iquery.metadata.physical.Level)) continue;
                    try {
                        this._lowestCommonLevel = ((com.sas.iquery.metadata.physical.Level)bmRes).getLevelUniqueName();
                        MDXGenerationUtil.applyDebugStatement("Getting new lowest common level. " + this._lowestCommonLevel, this.getClass());
                    }
                    catch (MetadataException me) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            _logger.error(me.getLocalizedMessage());
                        }
                        break;
                    }
                }
            }
            catch (MetadataException me) {
                if (!_logger.isEnabled(Level.ERROR)) break block17;
                _logger.error(me.getLocalizedMessage(), (Throwable)me);
            }
        }
    }

    private void checkForOLAPRASEInFilter() {
        BusinessModel businessModel = this.getBusinessModel();
        if (businessModel != null) {
            for (FilterItem filterItem : businessModel.getObjects(65535, FilterItem.class)) {
                OLAPResourceAwareStringExpression olapRASE;
                DataItem dataItemCompare;
                ExpressionInterface typeOfDataItem;
                BaseFilterExpression filter;
                ExpressionInterface compareItem;
                ExpressionInterface filterExpression = filterItem.getExpression();
                if (!(filterExpression instanceof BaseFilterExpression) || !((compareItem = (filter = (BaseFilterExpression)filterExpression).getWhatToCompare()) instanceof DataItem) || !((typeOfDataItem = (dataItemCompare = (DataItem)compareItem).getExpression()) instanceof OLAPResourceAwareStringExpression) || !(olapRASE = (OLAPResourceAwareStringExpression)typeOfDataItem).equals(this)) continue;
                filter.setToLookBackReplace(true);
            }
        }
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        super.replaceResource(oldResource, newResource, model);
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        super.replaceResource(oldResource, newResource, model, recursive);
        Dimension oldDimension = this._dimension;
        this._dimension = (Dimension)Utils.replaceResource(this._dimension, oldResource, newResource, model, recursive);
        if (oldDimension != this._dimension) {
            this.moveListeningTo(oldDimension, this._dimension);
        }
        Hierarchy oldHierarchy = this._hierarchy;
        this._hierarchy = (Hierarchy)Utils.replaceResource(this._hierarchy, oldResource, newResource, model, recursive);
        if (oldHierarchy != this._hierarchy) {
            this.moveListeningTo(oldHierarchy, this._hierarchy);
        }
        if (this._dimension == null) {
            MetadataException ee = new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OLAPResourceAwareStringDimensionIsNull.txt", new Object[0]));
            throw ee;
        }
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        if (this._isMeasure) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "isMeasureOLAPRASE", this._isMeasure);
        }
        IQModelImplUtilities.setAttr(thisElement, "memberLevelRoot", this._lowestCommonLevel);
        if (!this._hasMultipleMembers) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "hasMultiMembers", this._hasMultipleMembers);
        }
        OLAPResourceAwareStringExpression.writeRelatedObject(this._dimension, thisElement, writingContext, "Dimension");
        OLAPResourceAwareStringExpression.writeRelatedObject(this._hierarchy, thisElement, writingContext, "Hierarchy");
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._isMeasure = attrsProvider.consumeBooleanAttr("isMeasureOLAPRASE", false);
        this._lowestCommonLevel = attrsProvider.consumeAttr("memberLevelRoot");
        this._hasMultipleMembers = attrsProvider.consumeBooleanAttr("hasMultiMembers", true);
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._dimension = (Dimension)((Object)riHolder.consumeObject("Dimension"));
        this._hierarchy = (Hierarchy)((Object)riHolder.consumeObject("Hierarchy"));
    }
}

