/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.impl.ListUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope
public class OLAPMemberStringExpression
extends StringExpression {
    private String _displayLabel;
    private List _parentPathDisplayLabels = new ArrayList(5);
    public static final String EVENT_PARENT_PATH_LABELS_CHANGED = "The member's parent path display label is changed.";
    public static final String EVENT_MEMBER_DISPLAY_LABEL_CHANGED = "The member's display label is changed.";

    public String getDisplayLabel() {
        return this._displayLabel;
    }

    public void setDisplayLabel(String label) {
        this._displayLabel = label;
        this.fireChangeEvent(EVENT_MEMBER_DISPLAY_LABEL_CHANGED);
    }

    public List getParentPathDisplayLabels() {
        return ListUtils.newList(this._parentPathDisplayLabels);
    }

    public void setParentPathDisplayLabels(List parentPathLabels) {
        this.changeableCheck();
        parentPathLabels = ListUtils.newList(parentPathLabels);
        Utils.ensureProperArgumentTypes(parentPathLabels, new Class[]{String.class});
        this._parentPathDisplayLabels = parentPathLabels;
        this.fireChangeEvent(EVENT_PARENT_PATH_LABELS_CHANGED);
    }

    @Override
    protected String getDefinitionElementName() {
        return "MemberStringExpr";
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setAttr(thisElement, "label", this._displayLabel);
        IQModelImplUtilities.setCommaSeparatedStringAttr(thisElement, "parentPathDisplayLabels", this._parentPathDisplayLabels);
        IQModelImplUtilities.removeAttr(thisElement, "exprType");
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._displayLabel = attrsProvider.consumeAttr("label");
        this._parentPathDisplayLabels = attrsProvider.consumeCommaSeparatedStringAsList("parentPathDisplayLabels");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OLAPMemberStringExpression clone = (OLAPMemberStringExpression)super.clone();
        if (this._parentPathDisplayLabels != null) {
            clone._parentPathDisplayLabels = new ArrayList(this._parentPathDisplayLabels);
        }
        return clone;
    }

    @Override
    public int getExpressionType() {
        return 3;
    }

    @Override
    public void setExpressionType(int expressionType) {
        if (expressionType != 3) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("OLAPMemberStringExpression.InvalidArgExpressionType.fmt.txt", expressionType));
        }
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this._displayLabel == null ? 0 : this._displayLabel.hashCode());
        result = 31 * result + (this._parentPathDisplayLabels == null ? 0 : this._parentPathDisplayLabels.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        boolean returnValue = false;
        if (obj == this) {
            returnValue = true;
        } else if (obj instanceof OLAPMemberStringExpression && super.equals(obj)) {
            OLAPMemberStringExpression rhs = (OLAPMemberStringExpression)obj;
            if (IQModelImplUtilities.same(this._displayLabel, rhs._displayLabel) && IQModelImplUtilities.same(this._parentPathDisplayLabels, rhs._parentPathDisplayLabels)) {
                returnValue = true;
            }
        }
        return returnValue;
    }
}

