/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.CascadableFilter;
import com.sas.iquery.metadata.business.FilterCascadeContainer;
import com.sas.iquery.metadata.business.FilterCascadeContainerUpdater;
import com.sas.iquery.metadata.business.FilterCascadeInterface;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.impl.ListUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public class MultipleConditionalExpression
extends ConditionalExpression
implements FilterCascadeContainerUpdater,
CascadableFilter {
    public static final String EVENT_RELATION_TYPE_CHANGED = "Relation type changed";
    public static final String EVENT_AN_EXPRESSION_CHANGED = "An expression changed";
    public static final String EVENT_EXPRESSION_LIST_CHANGED = "Expression list changed";
    private List<ExpressionInterface> _theExpressions = new ArrayList<ExpressionInterface>(4);
    private ConditionalRelationType _relationType = null;
    private List _filterCascades;
    private static final Class[] VALID_EXPRESSIONS = VALID_TYPES_ANY_EXPRESSION;

    public ConditionalRelationType getRelationType() {
        return this._relationType;
    }

    public int getExpressionCount() {
        return this._theExpressions.size();
    }

    public void setRelationType(ConditionalRelationType relationType) {
        if (this._relationType != relationType) {
            ConditionalRelationType old = this._relationType;
            this._relationType = relationType;
            this.fireChangeEvent(EVENT_RELATION_TYPE_CHANGED, old, this._relationType);
        }
    }

    public void setExpression(int index, ExpressionInterface condExpr) {
        ExpressionInterface old = this.getExpression(index);
        if (old == condExpr) {
            return;
        }
        this.moveListeningTo(old, condExpr);
        this._theExpressions.set(index, condExpr);
        this.fireChangeEvent(EVENT_AN_EXPRESSION_CHANGED, old, condExpr);
    }

    public void addExpression(int index, ExpressionInterface condExpr) {
        this.listenTo(condExpr);
        this._theExpressions.add(index, condExpr);
        this.fireChangeEvent(EVENT_EXPRESSION_LIST_CHANGED);
    }

    public void addExpression(ExpressionInterface condExpr) {
        this.listenTo(condExpr);
        this._theExpressions.add(condExpr);
        this.fireChangeEvent(EVENT_EXPRESSION_LIST_CHANGED);
    }

    public void removeExpression(int index) {
        ExpressionInterface old = this.getExpression(index);
        this.removeListeningTo(old);
        this._theExpressions.remove(index);
        this.fireChangeEvent(EVENT_EXPRESSION_LIST_CHANGED);
    }

    public void clearExpressions() {
        this.removeListeningTo(this._theExpressions);
        this._theExpressions.clear();
        this.fireChangeEvent(EVENT_EXPRESSION_LIST_CHANGED);
    }

    public ExpressionInterface getExpression(int index) {
        return this._theExpressions.get(index);
    }

    public ExpressionInterface[] getExpressions() {
        int size = this.getExpressionCount();
        ExpressionInterface[] store = new ExpressionInterface[size];
        return this._theExpressions.toArray(store);
    }

    public List<ExpressionInterface> getExpressionList() {
        return ListUtils.newList(this._theExpressions);
    }

    @Override
    public void setCascades(List<? extends FilterCascadeInterface> filterCascades) {
        if (filterCascades != null) {
            IQModelImplUtilities.ensureProperArgumentTypes(filterCascades, new Class[]{FilterCascadeInterface.class});
        }
        this._filterCascades = filterCascades;
    }

    @Override
    public List<FilterCascadeInterface> getCascades(boolean recursive) {
        ArrayList<FilterCascadeInterface> cascades = new ArrayList<FilterCascadeInterface>();
        IQModelImplUtilities.addButNoDuplicates(cascades, this._filterCascades);
        if (recursive) {
            for (ExpressionInterface element : this._theExpressions) {
                if (!(element instanceof FilterCascadeContainer)) continue;
                IQModelImplUtilities.addButNoDuplicates(cascades, ((FilterCascadeContainer)((Object)element)).getCascades(recursive));
            }
        }
        return cascades;
    }

    public void setExpressionList(List<? extends ExpressionInterface> values) {
        values = ListUtils.newList(values);
        IQModelImplUtilities.ensureProperArgumentTypes(values, VALID_EXPRESSIONS);
        this.removeListeningTo(this._theExpressions);
        this.listenTo(values);
        this._theExpressions.clear();
        this._theExpressions.addAll(values);
        this.fireChangeEvent(EVENT_EXPRESSION_LIST_CHANGED);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        for (int i = 0; i < this.getExpressionCount(); ++i) {
            ExpressionInterface expr = this.getExpression(i);
            if (expr == null) continue;
            expr = this.singleReplaceResources(expr, oldResource, newResource, model, recursive);
            this.setExpression(i, expr);
        }
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        MultipleConditionalExpression clone = (MultipleConditionalExpression)super.clone();
        clone._theExpressions = ListUtils.newList(4);
        clone.setRelationType(this.getRelationType());
        clone.setIsNegated(this.isNegated());
        int count = this.getExpressionCount();
        for (int i = 0; i < count; ++i) {
            ExpressionInterface expr = this.getExpression(i);
            if (!(expr instanceof BusinessModelResource) && expr != null) {
                expr = (ExpressionInterface)expr.clone();
            }
            clone.addExpression(expr);
        }
        return clone;
    }

    @SASScope
    public String toString() {
        StringBuffer str = new StringBuffer();
        ConditionalRelationType type = this.getRelationType();
        int count = this.getExpressionCount();
        if (this.isNegated()) {
            str.append("NOT ");
        }
        if (count > 1) {
            str.append("(");
        }
        for (int i = 0; i < count; ++i) {
            ExpressionInterface expr = this.getExpression(i);
            str.append(IQModelImplUtilities.toString(expr));
            if (type == null || i + 1 >= count) continue;
            str.append(" " + IQModelImplUtilities.toString(type) + " ");
        }
        if (count > 1) {
            str.append(")");
        }
        return str.toString();
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this.getExpressionCount() > 1 && this.getRelationType() == null) {
            reasons.add(new Reason((Object)this, 2, 29, "MultipleConditionalExpression.HasNullRelationType.txt", new Object[0]));
        }
        if (this.getExpressionCount() == 0) {
            reasons.add(new Reason((Object)this, 2, 30, "MultipleConditionalExpression.HasNoSubExpressions.txt", new Object[0]));
        }
        if (this._theExpressions != null && this._theExpressions.contains(null)) {
            reasons.addAll(this.getReasonsExprIsUnusableAsExpressionArg(null, "Expression.ReferencesNullSubexpression.txt"));
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "MultipleConditionalExpr";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setEnumAttr(thisElement, "operator", this._relationType);
        MultipleConditionalExpression.writeRelatedObjects(this._theExpressions, thisElement, writingContext, "Exprs");
        MultipleConditionalExpression.writeRelatedObjects(this._filterCascades, thisElement, writingContext, "FilterCascades");
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._relationType = ConditionalRelationType.consumeValue(attrsProvider, "operator", null);
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._theExpressions = riHolder.consumeObjects("Exprs", ExpressionInterface.class);
        this._filterCascades = riHolder.consumeObjects("FilterCascades", FilterCascadeInterface.class);
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._relationType = ConditionalRelationType.fromPersistentForm(IQModelImplUtilities.getAttr(thisElement, "op"));
        this._theExpressions = MultipleConditionalExpression.v1_readItemListUnderSubelement(thisElement, readingContext, "Expressionsist", VALID_EXPRESSIONS);
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        if (this._theExpressions != null) {
            intoList.addAll(this._theExpressions);
        }
        if (this._filterCascades != null) {
            intoList.addAll(this._filterCascades);
        }
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        MultipleConditionalExpression.replaceInList(this._theExpressions, oldObject, newObject);
        MultipleConditionalExpression.replaceInList(this._filterCascades, oldObject, newObject);
    }

    @Override
    public ExpressionInterface getExpression() {
        return this;
    }
}

