/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.expr;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.impl.AbstractExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class FractionOfTotalExpression
extends AbstractExpression
implements ExpressionInterface {
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String EVENT_NUMERATOR_CHANGED = "Numerator changed";
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String EVENT_DENOMINATOR_CHANGED = "Denominator changed";
    @SASScope(value="ALL")
    @SubjectToChange
    public static final int DENOMINATOR_IS_SUBTOTAL_OF_CATEGORY_DATA_ITEM = 0;
    @SASScope(value="ALL")
    @SubjectToChange
    public static final int DENOMINATOR_IS_GRAND_TOTAL = 1;
    @SASScope(value="ALL")
    @SubjectToChange
    public static final int DENOMINATOR_IS_ROW_TOTAL = 2;
    @SASScope(value="ALL")
    @SubjectToChange
    public static final int DENOMINATOR_IS_COLUMN_TOTAL = 3;
    @SASScope(value="ALL")
    @SubjectToChange
    public static final int DENOMINATOR_IS_ROW_SUBTOTAL = 4;
    @SASScope(value="ALL")
    @SubjectToChange
    public static final int DENOMINATOR_IS_COLUMN_SUBTOTAL = 5;
    private DataItem _numerator;
    private DataItem _denominator;
    private int _denominatorType = 0;
    private static final String[] DENOMINATOR_TYPE_LITERALS = new String[]{"categoryDataItem", "grandTotal", "rowTotal", "columnTotal", "rowSubTotal", "columnSubTotal"};

    @SASScope(value="ALL")
    @SubjectToChange
    public FractionOfTotalExpression() {
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public DataItem getNumerator() {
        return this._numerator;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setNumerator(DataItem numerator) throws MetadataException {
        if (numerator != null && numerator.getExpressionType() != 2) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("FractionOfTotalExpression.NumeratorMustBeNumeric.txt", new Object[0]));
        }
        this._setNumerator(numerator);
    }

    @SASScope
    public void _setNumerator(DataItem numerator) {
        if (this._numerator != numerator) {
            this.moveListeningTo(this._numerator, numerator);
            this._numerator = numerator;
            this.fireChangeEvent(EVENT_NUMERATOR_CHANGED);
        }
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public DataItem getDenominator() {
        return this._denominator;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setDenominator(DataItem denominator) throws MetadataException {
        if (denominator != null && denominator.getUsage() != DataItemActionType.USAGE_CATEGORY) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessage("FractionOfTotalExpression.DenominatorMustBeCategory.txt", new Object[0]));
        }
        this._setDenominator(denominator);
    }

    @SASScope
    public void _setDenominator(DataItem denominator) {
        if (this._denominator != denominator) {
            this.moveListeningTo(this._denominator, denominator);
            this._denominator = denominator;
            if (denominator != null) {
                this._denominatorType = 0;
            }
            this.fireChangeEvent(EVENT_DENOMINATOR_CHANGED);
        }
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setDenominatorType(int denominatorType) {
        if (denominatorType != 0 && denominatorType != 4 && denominatorType != 5 && denominatorType != 1 && denominatorType != 2 && denominatorType != 3) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessage("FractionOfTotalExpression.InvalidArgDenominatorType.fmt.txt", denominatorType));
        }
        this._setDenominatorType(denominatorType);
    }

    @SASScope
    public void _setDenominatorType(int denominatorType) {
        if (denominatorType != this._denominatorType) {
            this._denominatorType = denominatorType;
            if (denominatorType != 0) {
                this._denominator = null;
            }
            this.fireChangeEvent(EVENT_DENOMINATOR_CHANGED);
        }
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public int getDenominatorType() {
        return this._denominatorType;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public int getExpressionType() {
        return 2;
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    @SASScope
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        DataItem oldNumerator = this._numerator;
        this._numerator = (DataItem)Utils.replaceResource(this._numerator, oldResource, newResource, model, recursive);
        if (oldNumerator != this._numerator) {
            this.moveListeningTo(oldNumerator, this._numerator);
        }
        DataItem oldDenominator = this._denominator;
        this._denominator = (DataItem)Utils.replaceResource(this._denominator, oldResource, newResource, model, recursive);
        if (oldDenominator != this._denominator) {
            this.moveListeningTo(oldDenominator, this._denominator);
        }
    }

    @Override
    @SASScope
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (this._numerator == null) {
            reasons.add(new Reason((Object)this, 2, 89, "FractionOfTotalExpression.NumeratorIsNull.txt", new Object[0]));
        } else if (this._numerator.getExpressionType() != 2) {
            reasons.add(new Reason((Object)this, 2, 90, "FractionOfTotalExpression.NumeratorMustBeNumeric.txt", new Object[0]));
        }
        if (this._denominatorType == 0) {
            if (this._denominator != null) {
                if (this._denominator.getUsage() != DataItemActionType.USAGE_CATEGORY) {
                    reasons.add(new Reason((Object)this, 2, 91, "FractionOfTotalExpression.DenominatorMustBeCategory.txt", new Object[0]));
                }
            } else {
                reasons.add(new Reason((Object)this, 2, 92, "FractionOfTotalExpression.DenominatorIsNull.txt", new Object[0]));
            }
        }
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "FractionOfTotal";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        FractionOfTotalExpression.writeRelatedObject(this._numerator, thisElement, writingContext, "Numerator");
        FractionOfTotalExpression.writeRelatedObject(this._denominator, thisElement, writingContext, "Denominator");
        if (this._denominatorType != 0) {
            if (this._denominatorType >= 0 && this._denominatorType < DENOMINATOR_TYPE_LITERALS.length) {
                IQModelImplUtilities.setAttr(thisElement, "denominatorType", DENOMINATOR_TYPE_LITERALS[this._denominatorType]);
            } else {
                IQModelImplUtilities.setIntAttr(thisElement, "denominatorType", this._denominatorType);
            }
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        String denomValue = attrsProvider.consumeAttr("denominatorType");
        if (denomValue != null) {
            boolean found = false;
            for (int i = 0; i < DENOMINATOR_TYPE_LITERALS.length && !found; ++i) {
                if (!denomValue.equals(DENOMINATOR_TYPE_LITERALS[i])) continue;
                this._denominatorType = i;
                found = true;
            }
            if (!found) {
                this._denominatorType = Integer.parseInt(denomValue);
            }
        } else {
            this._denominatorType = 0;
        }
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._numerator = (DataItem)((Object)riHolder.consumeObject("Numerator"));
        this._denominator = (DataItem)((Object)riHolder.consumeObject("Denominator"));
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._numerator = (DataItem)((Object)FractionOfTotalExpression.v1_readItemUnderSubelement(thisElement, readingContext, "Numerator", new Class[]{DataItem.class}));
        this._denominator = (DataItem)((Object)FractionOfTotalExpression.v1_readItemUnderSubelement(thisElement, readingContext, "Denominator", new Class[]{DataItem.class}));
        Element denominatorElement = IQModelImplUtilities.getSpecificKidElement(thisElement, "Denominator");
        if (denominatorElement != null) {
            String denomValue = IQModelImplUtilities.getAttr(denominatorElement, "denominatorType");
            if (denomValue != null) {
                boolean found = false;
                for (int i = 0; i < DENOMINATOR_TYPE_LITERALS.length && !found; ++i) {
                    if (!denomValue.equals(DENOMINATOR_TYPE_LITERALS[i])) continue;
                    this._denominatorType = i;
                    found = true;
                }
                if (!found) {
                    this._denominatorType = Integer.parseInt(denomValue);
                }
            } else {
                this._denominatorType = 0;
            }
        }
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        FractionOfTotalExpression clone = (FractionOfTotalExpression)super.clone();
        return clone;
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._numerator);
        intoList.add(this._denominator);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._numerator = (DataItem)FractionOfTotalExpression.replace(this._numerator, oldObject, newObject);
        this._denominator = (DataItem)FractionOfTotalExpression.replace(this._denominator, oldObject, newObject);
    }

    @SASScope
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("FractionOfTotal( ");
        String numText = null;
        try {
            numText = StringExpressionUtil.getInstance().getText(this._numerator, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, null);
        }
        catch (MetadataException e) {
            numText = Utils.toString(this._numerator);
        }
        buffer.append(numText).append(", ");
        switch (this._denominatorType) {
            case 0: {
                buffer.append("'Subtotal of Category'");
                break;
            }
            case 5: {
                buffer.append("'Column Subtotal'");
                break;
            }
            case 4: {
                buffer.append("'Row Subtotal'");
                break;
            }
            case 1: {
                buffer.append("'Grand Total'");
                break;
            }
            case 2: {
                buffer.append("'Row Total'");
                break;
            }
            case 3: {
                buffer.append("'Column Total'");
                break;
            }
            default: {
                buffer.append("'Unknown Denominator Type=[" + this._denominatorType + "]'");
            }
        }
        if (this._denominator != null) {
            buffer.append(", ");
            String demText = null;
            try {
                demText = StringExpressionUtil.getInstance().getText(this._denominator, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, null);
            }
            catch (MetadataException e) {
                demText = Utils.toString(this._denominator);
            }
            buffer.append(demText);
        }
        buffer.append(" )");
        return buffer.toString();
    }
}

